/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.impl.processor;

import com.jinfonet.webservice.security.impl.EncryptedKeyToken;
import com.jinfonet.webservice.security.impl.SToken;
import com.jinfonet.webservice.security.impl.SecurityData;
import com.jinfonet.webservice.security.impl.SecurityDataContext;
import com.jinfonet.webservice.security.impl.SecurityUtil;
import com.jinfonet.webservice.security.impl.processor.BindingProcessor;
import com.jinfonet.webservice.security.model.AlgorithmSuite;
import com.jinfonet.webservice.security.model.SupportingToken;
import com.jinfonet.webservice.security.model.Token;
import com.jinfonet.webservice.security.model.X509Token;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import jet.dataengine.api.DSException;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecDKEncrypt;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SymmetricBindingProcessor
extends BindingProcessor {
    public void build(SecurityDataContext securityDataContext) throws DSException {
        SecurityData securityData = securityDataContext.getSecData();
        if (securityData.isIncludeTimestamp()) {
            this.addTimestamp(securityDataContext);
        }
        if ("EncryptBeforeSigning".equals(securityData.getProtectionOrder())) {
            this.SEDU(securityDataContext);
        } else {
            this.add(securityDataContext);
        }
    }

    private void SEDU(SecurityDataContext securityDataContext) throws DSException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        SecurityData securityData = securityDataContext.getSecData();
        Vector vector = securityDataContext.getSignatureValues();
        Token token = securityData.getEncryptionToken();
        Vector vector2 = SecurityUtil.getEncryptedParts(securityDataContext);
        Vector vector3 = SecurityUtil.getSignedParts(securityDataContext);
        if (token == null && vector2.size() > 0) {
            throw new DSException(4191);
        }
        if (token != null && vector2.size() > 0) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String string = null;
            SToken sToken = null;
            if (token instanceof X509Token && securityDataContext.isInitiator()) {
                string = this.addSignatureParts(securityDataContext, token);
            }
            if (string == null || string.length() == 0) {
                throw new DSException(4203);
            }
            if (string.startsWith("#")) {
                string = string.substring(1);
            }
            sToken = this.getToken(securityDataContext, string);
            boolean bl = false;
            Element element = null;
            Element element2 = null;
            WSSecDKEncrypt wSSecDKEncrypt = null;
            WSSecEncrypt wSSecEncrypt = null;
            Element element3 = null;
            if (5 == token.getInclusion() || 2 == token.getInclusion() || securityDataContext.isInitiator() && 3 == token.getInclusion()) {
                element = SecurityUtil.appendChildToSecHeader(securityDataContext, sToken.getToken());
                bl = true;
            } else if (token instanceof X509Token && securityDataContext.isInitiator()) {
                element = SecurityUtil.appendChildToSecHeader(securityDataContext, sToken.getToken());
            }
            Document document = securityDataContext.getDocument();
            AlgorithmSuite algorithmSuite = securityData.getAlgorithmSuite();
            if (token.isDerivedKeys()) {
                wSSecDKEncrypt = new WSSecDKEncrypt();
                wSSecDKEncrypt.setExternalKey(sToken.getSecret(), sToken.getId());
                try {
                    wSSecDKEncrypt.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                    wSSecDKEncrypt.setDerivedKeyLength(algorithmSuite.getEncryptionDerivedKeyLength() / 8);
                    wSSecDKEncrypt.prepare(document);
                    element3 = wSSecDKEncrypt.getdktElement();
                    SecurityUtil.appendChildToSecHeader(securityDataContext, element3);
                    element2 = wSSecDKEncrypt.encryptForExternalRef(null, vector2);
                }
                catch (Exception exception) {
                    throw new DSException(4192, (Throwable)exception);
                }
            }
            wSSecEncrypt = new WSSecEncrypt();
            wSSecEncrypt.setEncKeyId(string);
            SecurityUtil.setEncryptionUser(securityDataContext, (WSSecEncryptedKey)wSSecEncrypt);
            wSSecEncrypt.setEphemeralKey(sToken.getSecret());
            wSSecEncrypt.setDocument(document);
            wSSecEncrypt.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
            wSSecEncrypt.setEncryptSymmKey(false);
            try {
                wSSecEncrypt.prepare(document, securityDataContext.getEncrypto());
                element2 = wSSecEncrypt.encryptForExternalRef(null, vector2);
            }
            catch (WSSecurityException wSSecurityException) {
                throw new DSException(4192, (Throwable)wSSecurityException);
            }
            this.mainRefListElement = SecurityUtil.appendChildToSecHeader(securityDataContext, element2);
            if (element != null) {
                this.setInsertionLocation(element);
            } else if (this.timestampElement != null) {
                this.setInsertionLocation(this.timestampElement);
            }
            SecurityUtil.handleEncryptedSignedHeaders(vector2, vector3, document);
            HashMap hashMap = null;
            HashMap hashMap2 = null;
            HashMap hashMap3 = null;
            HashMap hashMap4 = null;
            HashMap hashMap5 = null;
            HashMap hashMap6 = null;
            if (this.timestampElement != null) {
                vector3.add(new WSEncryptionPart(SecurityUtil.addWsuIdToElement(this.timestampElement)));
            }
            if (securityDataContext.isInitiator()) {
                object5 = securityData.getSignedSupportingTokens();
                hashMap = this.handleSupportingTokens(securityDataContext, (SupportingToken)object5);
                object4 = securityData.getEndorsingSupportingTokens();
                hashMap2 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object4);
                object3 = securityData.getSignedEndorsingSupportingTokens();
                hashMap3 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object3);
                SupportingToken supportingToken = securityData.getSignedEncryptedSupportingTokens();
                hashMap4 = this.handleSupportingTokens(securityDataContext, supportingToken);
                object2 = securityData.getEndorsingEncryptedSupportingTokens();
                hashMap5 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object2);
                object = securityData.getSignedEndorsingEncryptedSupportingTokens();
                hashMap6 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object);
                Vector vector4 = securityData.getSupportingTokensList();
                for (int i = 0; i < vector4.size(); ++i) {
                    this.handleSupportingTokens(securityDataContext, (SupportingToken)vector4.get(i));
                }
                SupportingToken supportingToken2 = securityData.getEncryptedSupportingTokens();
                this.handleSupportingTokens(securityDataContext, supportingToken2);
                vector3 = this.addSignatureParts(hashMap, vector3);
                vector3 = this.addSignatureParts(hashMap4, vector3);
                vector3 = this.addSignatureParts(hashMap3, vector3);
                vector3 = this.addSignatureParts(hashMap6, vector3);
            }
            if (vector3.size() > 0) {
                vector.add(this.doSymmSignature(securityDataContext, token, sToken, vector3));
                this.mainSigId = SecurityUtil.addWsuIdToElement(this.getInsertionLocation());
            }
            if (securityDataContext.isInitiator()) {
                hashMap2.putAll(hashMap5);
                object5 = this.doEndorsedSignatures(securityDataContext, hashMap2);
                object4 = ((Vector)object5).iterator();
                while (object4.hasNext()) {
                    vector.add(object4.next());
                }
                hashMap3.putAll(hashMap6);
                object4 = this.doEndorsedSignatures(securityDataContext, hashMap3);
                object3 = ((Vector)object4).iterator();
                while (object3.hasNext()) {
                    vector.add(object3.next());
                }
            }
            if (securityData.isSignatureProtection() && this.mainSigId != null || this.encryptedTokensIdList.size() > 0 && securityDataContext.isInitiator()) {
                long l4 = 0L;
                long l5 = 0L;
                object2 = new Vector<WSEncryptionPart>();
                if (securityData.isSignatureProtection()) {
                    ((Vector)object2).add(new WSEncryptionPart(this.mainSigId, "Element"));
                }
                if (securityDataContext.isInitiator()) {
                    for (int i = 0; i < this.encryptedTokensIdList.size(); ++i) {
                        ((Vector)object2).add(new WSEncryptionPart((String)this.encryptedTokensIdList.get(i), "Element"));
                    }
                }
                object = null;
                if (token.isDerivedKeys()) {
                    try {
                        object = wSSecDKEncrypt.encryptForExternalRef(null, (Vector)object2);
                        SecurityUtil.insertSiblingAfter(securityDataContext, element3, (Element)object);
                    }
                    catch (WSSecurityException wSSecurityException) {
                        throw new DSException(4192, (Throwable)wSSecurityException);
                    }
                } else {
                    try {
                        object = wSSecEncrypt.encryptForExternalRef(null, vector2);
                        SecurityUtil.insertSiblingAfter(securityDataContext, element, (Element)object);
                    }
                    catch (WSSecurityException wSSecurityException) {
                        throw new DSException(4192, (Throwable)wSSecurityException);
                    }
                }
            }
        } else {
            throw new DSException(4191);
        }
    }

    private void add(SecurityDataContext securityDataContext) throws DSException {
        Object object;
        SupportingToken supportingToken;
        Object object2;
        Iterator<WSEncryptionPart> iterator;
        Object object3;
        Object object4;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        SecurityData securityData = securityDataContext.getSecData();
        Document document = securityDataContext.getDocument();
        Token token = securityData.getSignatureToken();
        String string = null;
        String string2 = null;
        SToken sToken = null;
        SToken sToken2 = null;
        Element element = null;
        Vector vector = securityDataContext.getSignatureValues();
        if (token != null) {
            if (token instanceof X509Token && securityDataContext.isInitiator()) {
                string2 = this.addSignatureParts(securityDataContext, token);
            }
        } else {
            throw new DSException(4204);
        }
        if (string2 == null || string2.length() == 0) {
            throw new DSException(4203);
        }
        sToken2 = this.getToken(securityDataContext, string2);
        if (5 == token.getInclusion() || 2 == token.getInclusion() || securityDataContext.isInitiator() && 3 == token.getInclusion()) {
            element = SecurityUtil.appendChildToSecHeader(securityDataContext, sToken2.getToken());
            this.setInsertionLocation(element);
        } else if (securityDataContext.isInitiator() && token instanceof X509Token) {
            element = SecurityUtil.appendChildToSecHeader(securityDataContext, sToken2.getToken());
            this.setInsertionLocation(element);
        }
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        HashMap hashMap3 = null;
        HashMap hashMap4 = null;
        HashMap hashMap5 = null;
        HashMap hashMap6 = null;
        Vector vector2 = SecurityUtil.getSignedParts(securityDataContext);
        if (this.timestampElement != null) {
            vector2.add(new WSEncryptionPart(SecurityUtil.addWsuIdToElement(this.timestampElement)));
        }
        if (securityDataContext.isInitiator()) {
            object4 = securityData.getSignedSupportingTokens();
            hashMap = this.handleSupportingTokens(securityDataContext, (SupportingToken)object4);
            object3 = securityData.getEndorsingSupportingTokens();
            hashMap2 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object3);
            iterator = securityData.getSignedEndorsingSupportingTokens();
            hashMap3 = this.handleSupportingTokens(securityDataContext, (SupportingToken)((Object)iterator));
            object2 = securityData.getSignedEncryptedSupportingTokens();
            hashMap4 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object2);
            supportingToken = securityData.getEndorsingEncryptedSupportingTokens();
            hashMap5 = this.handleSupportingTokens(securityDataContext, supportingToken);
            object = securityData.getSignedEndorsingEncryptedSupportingTokens();
            hashMap6 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object);
            Vector vector3 = securityData.getSupportingTokensList();
            for (int i = 0; i < vector3.size(); ++i) {
                this.handleSupportingTokens(securityDataContext, (SupportingToken)vector3.get(i));
            }
            SupportingToken supportingToken2 = securityData.getEncryptedSupportingTokens();
            this.handleSupportingTokens(securityDataContext, supportingToken2);
            vector2 = this.addSignatureParts(hashMap, vector2);
            vector2 = this.addSignatureParts(hashMap4, vector2);
            vector2 = this.addSignatureParts(hashMap3, vector2);
            vector2 = this.addSignatureParts(hashMap6, vector2);
        }
        if (vector2.size() > 0) {
            vector.add(this.doSymmSignature(securityDataContext, token, sToken2, vector2));
            this.mainSigId = SecurityUtil.addWsuIdToElement(this.getInsertionLocation());
        }
        if (securityDataContext.isInitiator()) {
            hashMap2.putAll(hashMap5);
            object4 = this.doEndorsedSignatures(securityDataContext, hashMap2);
            object3 = ((Vector)object4).iterator();
            while (object3.hasNext()) {
                vector.add(object3.next());
            }
            hashMap3.putAll(hashMap6);
            object3 = this.doEndorsedSignatures(securityDataContext, hashMap3);
            iterator = ((Vector)object3).iterator();
            while (iterator.hasNext()) {
                vector.add(iterator.next());
            }
        }
        object4 = securityData.getEncryptionToken();
        object3 = null;
        if (token.equals(object4)) {
            string = string2;
            sToken = sToken2;
            object3 = element;
        }
        iterator = SecurityUtil.getEncryptedParts(securityDataContext);
        if (securityData.isSignatureProtection() && this.mainSigId != null) {
            ((Vector)((Object)iterator)).add(new WSEncryptionPart(this.mainSigId, "Element"));
        }
        if (securityDataContext.isInitiator()) {
            for (int i = 0; i < this.encryptedTokensIdList.size(); ++i) {
                ((Vector)((Object)iterator)).add(new WSEncryptionPart((String)this.encryptedTokensIdList.get(i), "Element"));
            }
        }
        object2 = null;
        if (((Vector)((Object)iterator)).size() > 0) {
            if (((Token)object4).isDerivedKeys()) {
                try {
                    supportingToken = new WSSecDKEncrypt();
                    supportingToken.setWscVersion(2);
                    if (object3 != null && sToken.getAttachedReference() != null) {
                        supportingToken.setExternalKey(sToken.getSecret(), (Element)document.importNode(sToken.getAttachedReference(), true));
                    } else if (sToken.getUnattachedReference() != null) {
                        supportingToken.setExternalKey(sToken.getSecret(), (Element)document.importNode(sToken.getUnattachedReference(), true));
                    } else if (!securityDataContext.isInitiator() && ((Token)object4).isDerivedKeys()) {
                        object = new SecurityTokenReference(document);
                        if (sToken instanceof EncryptedKeyToken) {
                            object.setKeyIdentifierEncKeySHA1(((EncryptedKeyToken)sToken).getSHA1());
                        }
                        supportingToken.setExternalKey(sToken.getSecret(), object.getElement());
                    } else {
                        supportingToken.setExternalKey(sToken.getSecret(), sToken.getId());
                    }
                    if (sToken instanceof EncryptedKeyToken) {
                        supportingToken.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    }
                    supportingToken.setSymmetricEncAlgorithm(securityData.getAlgorithmSuite().getEncryption());
                    supportingToken.setDerivedKeyLength(securityData.getAlgorithmSuite().getEncryptionDerivedKeyLength() / 8);
                    supportingToken.prepare(document);
                    object = null;
                    object = supportingToken.getdktElement();
                    if (object3 != null) {
                        SecurityUtil.insertSiblingAfter(securityDataContext, (Element)object3, (Element)object);
                    } else if (this.timestampElement != null) {
                        SecurityUtil.insertSiblingAfter(securityDataContext, this.timestampElement, (Element)object);
                    } else {
                        SecurityUtil.insertSiblingBefore(securityDataContext, this.getInsertionLocation(), (Element)object);
                    }
                    object2 = supportingToken.encryptForExternalRef(null, (Vector)((Object)iterator));
                    SecurityUtil.insertSiblingAfter(securityDataContext, (Element)object, (Element)object2);
                }
                catch (Exception exception) {
                    throw new DSException(4192, (Throwable)exception);
                }
            }
            try {
                supportingToken = new WSSecEncrypt();
                if (string.startsWith("#")) {
                    string = string.substring(1);
                }
                supportingToken.setEncKeyId(string);
                supportingToken.setEphemeralKey(sToken.getSecret());
                SecurityUtil.setEncryptionUser(securityDataContext, (WSSecEncryptedKey)supportingToken);
                supportingToken.setDocument(document);
                supportingToken.setEncryptSymmKey(false);
                supportingToken.setSymmetricEncAlgorithm(securityData.getAlgorithmSuite().getEncryption());
                if (!securityDataContext.isInitiator() && sToken instanceof EncryptedKeyToken) {
                    supportingToken.setUseKeyIdentifier(true);
                    supportingToken.setCustomReferenceValue(((EncryptedKeyToken)sToken).getSHA1());
                    supportingToken.setKeyIdentifierType(10);
                }
                supportingToken.prepare(document, securityDataContext.getEncrypto());
                object2 = supportingToken.encryptForExternalRef(null, (Vector)((Object)iterator));
                if (object3 != null) {
                    SecurityUtil.insertSiblingAfter(securityDataContext, (Element)object3, (Element)object2);
                } else {
                    SecurityUtil.insertSiblingBeforeOrPrepend(securityDataContext, this.getInsertionLocation(), (Element)object2);
                }
            }
            catch (WSSecurityException wSSecurityException) {
                throw new DSException(4192, (Throwable)wSSecurityException);
            }
        }
    }

    private String addSignatureParts(SecurityDataContext securityDataContext, Token token) throws DSException {
        try {
            WSSecEncryptedKey wSSecEncryptedKey = this.getEncryptedKeyBuilder(securityDataContext, token);
            String string = wSSecEncryptedKey.getId();
            byte[] byArray = wSSecEncryptedKey.getEphemeralKey();
            Date date = new Date();
            Date date2 = new Date();
            date2.setTime(System.currentTimeMillis() + 300000L);
            EncryptedKeyToken encryptedKeyToken = new EncryptedKeyToken(string, wSSecEncryptedKey.getEncryptedKeyElement(), date, date2);
            encryptedKeyToken.setSecret(byArray);
            encryptedKeyToken.setSHA1(this.addTimestamp(wSSecEncryptedKey.getEncryptedEphemeralKey()));
            securityDataContext.getTokenStorage().add(encryptedKeyToken);
            String string2 = wSSecEncryptedKey.getBSTTokenId();
            if (string2 != null && string2.length() > 0) {
                SecurityUtil.appendChildToSecHeader(securityDataContext, wSSecEncryptedKey.getBinarySecurityTokenElement());
            }
            return string;
        }
        catch (Exception exception) {
            throw new DSException(4196, (Throwable)exception);
        }
    }

    private String addTimestamp(byte[] byArray) throws DSException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new DSException(4205, (Throwable)noSuchAlgorithmException);
        }
        messageDigest.reset();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        return Base64.encode((byte[])byArray2);
    }
}

