/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.impl.processor;

import com.jinfonet.webservice.security.impl.SecurityData;
import com.jinfonet.webservice.security.impl.SecurityDataContext;
import com.jinfonet.webservice.security.impl.SecurityUtil;
import com.jinfonet.webservice.security.impl.processor.BindingProcessor;
import com.jinfonet.webservice.security.model.AbstractSecurityAssertion;
import com.jinfonet.webservice.security.model.Header;
import com.jinfonet.webservice.security.model.SignedEncryptedParts;
import com.jinfonet.webservice.security.model.SupportingToken;
import com.jinfonet.webservice.security.model.Token;
import com.jinfonet.webservice.security.model.UsernameToken;
import com.jinfonet.webservice.security.model.X509Token;
import java.util.ArrayList;
import java.util.Vector;
import jet.dataengine.api.DSException;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecDKSign;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransportBindingProcessor
extends BindingProcessor {
    public void build(SecurityDataContext securityDataContext) throws DSException {
        SecurityData securityData = securityDataContext.getSecData();
        if (securityData.isIncludeTimestamp()) {
            this.addTimestamp(securityDataContext);
        }
        if (securityDataContext.isInitiator()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Vector vector = securityDataContext.getSignatureValues();
            SupportingToken supportingToken = securityData.getSignedSupportingTokens();
            if (supportingToken != null && supportingToken.getTokens() != null && supportingToken.getTokens().size() > 0) {
                object5 = supportingToken.getTokens();
                object4 = ((ArrayList)object5).iterator();
                while (object4.hasNext()) {
                    object3 = (Token)object4.next();
                    if (object3 instanceof UsernameToken) {
                        object2 = this.addUsernameToken(securityDataContext, (UsernameToken)object3);
                        object2.prepare(securityDataContext.getDocument());
                        object2.appendToHeader(securityDataContext.getSecHeader());
                        continue;
                    }
                    throw new DSException(4201, new String[]{"{" + ((AbstractSecurityAssertion)object3).getName().getNamespaceURI() + "}" + ((AbstractSecurityAssertion)object3).getName().getLocalPart()});
                }
            }
            if ((object5 = securityData.getSignedEndorsingSupportingTokens()) != null && ((SupportingToken)object5).getTokens() != null && ((SupportingToken)object5).getTokens().size() > 0) {
                object4 = ((SupportingToken)object5).getTokens();
                object3 = ((SupportingToken)object5).getSignedParts();
                object2 = ((ArrayList)object4).iterator();
                while (object2.hasNext()) {
                    object = (Token)object2.next();
                    if (!(object instanceof X509Token)) continue;
                    vector.add(this.SEDU(securityDataContext, (Token)object, (SignedEncryptedParts)object3));
                }
            }
            if ((object4 = securityData.getEndorsingSupportingTokens()) != null && ((SupportingToken)object4).getTokens() != null && ((SupportingToken)object4).getTokens().size() > 0) {
                object3 = ((SupportingToken)object4).getTokens();
                object2 = ((SupportingToken)object4).getSignedParts();
                object = ((ArrayList)object3).iterator();
                while (object.hasNext()) {
                    Token token = (Token)object.next();
                    if (!(token instanceof X509Token)) continue;
                    vector.add(this.SEDU(securityDataContext, token, (SignedEncryptedParts)object2));
                }
            }
            object3 = securityData.getSupportingTokensList();
            for (int i = 0; i < ((Vector)object3).size(); ++i) {
                this.handleSupportingTokens(securityDataContext, (SupportingToken)((Vector)object3).get(i));
            }
        }
    }

    private byte[] SEDU(SecurityDataContext securityDataContext, Token token, SignedEncryptedParts signedEncryptedParts) throws DSException {
        Object object;
        Object object2;
        Object object3;
        SecurityData securityData = securityDataContext.getSecData();
        Document document = securityDataContext.getDocument();
        Vector<WSEncryptionPart> vector = new Vector<WSEncryptionPart>();
        if (this.timestampElement != null) {
            vector.add(new WSEncryptionPart(securityDataContext.getTimestampId()));
        }
        if (signedEncryptedParts != null) {
            if (signedEncryptedParts.isBody()) {
                object3 = securityDataContext.getDocument().getDocumentElement();
                object2 = object3.getElementsByTagNameNS(object3.getNamespaceURI(), "Body");
                object = null;
                if (object2.getLength() <= 0) {
                    throw new DSException(4206);
                }
                object = (Element)object2.item(0);
                vector.add(new WSEncryptionPart(SecurityUtil.addWsuIdToElement((Element)object)));
            }
            object3 = signedEncryptedParts.getHeaders();
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                object = (Header)object2.next();
                WSEncryptionPart wSEncryptionPart = new WSEncryptionPart(((Header)object).getName(), ((Header)object).getNamespace(), "Content");
                vector.add(wSEncryptionPart);
            }
        }
        if (token.isDerivedKeys()) {
            try {
                object3 = this.getEncryptedKeyBuilder(securityDataContext, token);
                object2 = object3.getBinarySecurityTokenElement();
                if (object2 != null) {
                    SecurityUtil.appendChildToSecHeader(securityDataContext, (Element)object2);
                }
                object3.appendToHeader(securityDataContext.getSecHeader());
                object = new WSSecDKSign();
                object.setSigCanonicalization(securityData.getAlgorithmSuite().getInclusiveC14n());
                object.setSignatureAlgorithm(securityData.getAlgorithmSuite().getSymmetricSignature());
                object.setDerivedKeyLength(securityData.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
                object.setExternalKey(object3.getEphemeralKey(), object3.getId());
                object.prepare(document, securityDataContext.getSecHeader());
                if (securityData.isTokenProtection()) {
                    vector.add(new WSEncryptionPart(object3.getBSTTokenId()));
                }
                object.setParts(vector);
                object.addReferencesToSign(vector, securityDataContext.getSecHeader());
                object.computeSignature();
                object.appendDKElementToHeader(securityDataContext.getSecHeader());
                object.appendSigToHeader(securityDataContext.getSecHeader());
                return object.getSignatureValue();
            }
            catch (Exception exception) {
                throw new DSException(4193, (Throwable)exception);
            }
        }
        try {
            object3 = this.getSignatureBuider(securityDataContext, token);
            object3.appendBSTElementToHeader(securityDataContext.getSecHeader());
            if (securityData.isTokenProtection() && 1 != token.getInclusion()) {
                vector.add(new WSEncryptionPart(object3.getBSTTokenId()));
            }
            object3.addReferencesToSign(vector, securityDataContext.getSecHeader());
            object3.appendToHeader(securityDataContext.getSecHeader());
            object3.computeSignature();
            return object3.getSignatureValue();
        }
        catch (WSSecurityException wSSecurityException) {
            throw new DSException(4193, (Throwable)wSSecurityException);
        }
    }
}

