/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model;

import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.AbstractSecurityAssertion;
import com.jinfonet.webservice.security.model.AlgorithmSuite;
import com.jinfonet.webservice.security.model.AlgorithmWrapper;
import com.jinfonet.webservice.security.model.SignedEncryptedElements;
import com.jinfonet.webservice.security.model.SignedEncryptedParts;
import com.jinfonet.webservice.security.model.Token;
import com.jinfonet.webservice.security.model.TokenWrapper;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class SupportingToken
extends AbstractSecurityAssertion
implements AlgorithmWrapper,
TokenWrapper {
    private int ENCRYPTED_SUPPORTING_TOKENS;
    private AlgorithmSuite ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
    private ArrayList ENDORSING_SUPPORTING_TOKENS = new ArrayList();
    private SignedEncryptedElements S;
    private SignedEncryptedElements SEDU;
    private SignedEncryptedParts SIGNED_ENCRYPTED_SUPPORTING_TOKENS;
    private SignedEncryptedParts SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;

    public SupportingToken(int n) {
        this.ENCRYPTED_SUPPORTING_TOKENS = n;
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return this.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
    }

    @Override
    public void setAlgorithmSuite(AlgorithmSuite algorithmSuite) {
        this.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS = algorithmSuite;
    }

    public ArrayList getTokens() {
        return this.ENDORSING_SUPPORTING_TOKENS;
    }

    public void addToken(Token token) {
        this.ENDORSING_SUPPORTING_TOKENS.add(token);
    }

    public int getTokenType() {
        return this.ENCRYPTED_SUPPORTING_TOKENS;
    }

    public void setTokenType(int n) {
        this.ENCRYPTED_SUPPORTING_TOKENS = n;
    }

    public SignedEncryptedElements getEncryptedElements() {
        return this.SEDU;
    }

    public void setEncryptedElements(SignedEncryptedElements signedEncryptedElements) {
        this.SEDU = signedEncryptedElements;
    }

    public SignedEncryptedParts getEncryptedParts() {
        return this.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
    }

    public void setEncryptedParts(SignedEncryptedParts signedEncryptedParts) {
        this.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS = signedEncryptedParts;
    }

    public SignedEncryptedElements getSignedElements() {
        return this.S;
    }

    public void setSignedElements(SignedEncryptedElements signedEncryptedElements) {
        this.S = signedEncryptedElements;
    }

    public SignedEncryptedParts getSignedParts() {
        return this.SIGNED_ENCRYPTED_SUPPORTING_TOKENS;
    }

    public void setSignedParts(SignedEncryptedParts signedEncryptedParts) {
        this.SIGNED_ENCRYPTED_SUPPORTING_TOKENS = signedEncryptedParts;
    }

    @Override
    public void setToken(Token token) {
        this.addToken(token);
    }

    @Override
    public QName getName() {
        switch (this.ENCRYPTED_SUPPORTING_TOKENS) {
            case 1: {
                return SP13Constants.SUPPORTING_TOKENS;
            }
            case 3: {
                return SP13Constants.SIGNED_SUPPORTING_TOKENS;
            }
            case 2: {
                return SP13Constants.ENDORSING_SUPPORTING_TOKENS;
            }
            case 4: {
                return SP13Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS;
            }
            case 6: {
                return SP13Constants.ENCRYPTED_SUPPORTING_TOKENS;
            }
            case 5: {
                return SP13Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS;
            }
            case 7: {
                return SP13Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
            }
            case 8: {
                return SP13Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
            }
        }
        return null;
    }

    public boolean isEncryptedToken() {
        switch (this.ENCRYPTED_SUPPORTING_TOKENS) {
            case 1: {
                return false;
            }
            case 3: {
                return false;
            }
            case 2: {
                return false;
            }
            case 4: {
                return false;
            }
            case 6: {
                return true;
            }
            case 5: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public short getType() {
        return TYPE_ASSERTION;
    }
}

