/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model.builders;

import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.AsymmetricBinding;
import com.jinfonet.webservice.security.model.builders.AlgorithmSuiteBuilder;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import com.jinfonet.webservice.security.model.builders.InitiatorTokenBuilder;
import com.jinfonet.webservice.security.model.builders.LayoutBuilder;
import com.jinfonet.webservice.security.model.builders.RecipientTokenBuilder;
import java.util.List;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;

public class AsymmetricBindingBuilder
implements AssertionModelBuilder {
    @Override
    public AsymmetricBinding build(WSSecurityPolicyAssertion wSSecurityPolicyAssertion) throws DSException {
        AsymmetricBinding asymmetricBinding = new AsymmetricBinding();
        if (wSSecurityPolicyAssertion.getSubAssertions() != null) {
            this.ALGORITHM_SUITE(wSSecurityPolicyAssertion.getSubAssertions(), asymmetricBinding);
        }
        return asymmetricBinding;
    }

    private void ALGORITHM_SUITE(List list, AsymmetricBinding asymmetricBinding) throws DSException {
        for (WSSecurityPolicyAssertion wSSecurityPolicyAssertion : list) {
            AssertionModelBuilder assertionModelBuilder;
            QName qName = wSSecurityPolicyAssertion.getName();
            if (SP13Constants.INITIATOR_TOKEN.equals(qName)) {
                assertionModelBuilder = new InitiatorTokenBuilder();
                asymmetricBinding.setInitiatorToken(((InitiatorTokenBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion));
                continue;
            }
            if (SP13Constants.RECIPIENT_TOKEN.equals(qName)) {
                assertionModelBuilder = new RecipientTokenBuilder();
                asymmetricBinding.setRecipientToken(((RecipientTokenBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion));
                continue;
            }
            if (SP13Constants.ALGORITHM_SUITE.equals(qName)) {
                assertionModelBuilder = new AlgorithmSuiteBuilder();
                asymmetricBinding.setAlgorithmSuite(((AlgorithmSuiteBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion));
                continue;
            }
            if (SP13Constants.LAYOUT.equals(qName)) {
                assertionModelBuilder = new LayoutBuilder();
                asymmetricBinding.setLayout(((LayoutBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion));
                continue;
            }
            if (SP13Constants.INCLUDE_TIMESTAMP.equals(qName)) {
                asymmetricBinding.setIncludeTimestamp(true);
                continue;
            }
            if (SP13Constants.ENCRYPT_BEFORE_SIGNING.equals(qName)) {
                asymmetricBinding.setProtectionOrder("EncryptBeforeSigning");
                continue;
            }
            if (SP13Constants.SIGN_BEFORE_ENCRYPTING.equals(qName)) {
                asymmetricBinding.setProtectionOrder("SignBeforeEncrypting");
                continue;
            }
            if (SP13Constants.ENCRYPT_SIGNATURE.equals(qName)) {
                asymmetricBinding.setSignatureProtection(true);
                continue;
            }
            if (SP13Constants.PROTECT_TOKENS.equals(qName)) {
                asymmetricBinding.setTokenProtection(true);
                continue;
            }
            if ("OnlySignEntireHeadersAndBody".equals(qName.getLocalPart())) {
                asymmetricBinding.setEntireHeadersAndBodySignatures(true);
                continue;
            }
            throw new DSException(4243, new String[]{qName.toString()});
        }
    }
}

