/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model.builders;

import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.RecipientToken;
import com.jinfonet.webservice.security.model.Token;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import com.jinfonet.webservice.security.model.builders.SecurityContextTokenBuilder;
import com.jinfonet.webservice.security.model.builders.UsernameTokenBuilder;
import com.jinfonet.webservice.security.model.builders.X509TokenBuilder;
import java.util.List;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;

public class RecipientTokenBuilder
implements AssertionModelBuilder {
    @Override
    public RecipientToken build(WSSecurityPolicyAssertion wSSecurityPolicyAssertion) throws DSException {
        RecipientToken recipientToken = new RecipientToken();
        if (wSSecurityPolicyAssertion.getSubAssertions() != null) {
            this.SECURITY_CONTEXT_TOKEN(wSSecurityPolicyAssertion.getSubAssertions(), recipientToken);
        }
        return recipientToken;
    }

    private void SECURITY_CONTEXT_TOKEN(List list, RecipientToken recipientToken) throws DSException {
        for (WSSecurityPolicyAssertion wSSecurityPolicyAssertion : list) {
            Token token;
            AssertionModelBuilder assertionModelBuilder;
            QName qName = wSSecurityPolicyAssertion.getName();
            if (SP13Constants.USERNAME_TOKEN.equals(qName)) {
                assertionModelBuilder = new UsernameTokenBuilder();
                token = ((UsernameTokenBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                recipientToken.setReceipientToken(token);
                continue;
            }
            if (SP13Constants.X509_TOKEN.equals(qName)) {
                assertionModelBuilder = new X509TokenBuilder();
                token = ((X509TokenBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                recipientToken.setReceipientToken(token);
                continue;
            }
            if (SP13Constants.SECURITY_CONTEXT_TOKEN.equals(qName)) {
                assertionModelBuilder = new SecurityContextTokenBuilder();
                token = ((SecurityContextTokenBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                recipientToken.setReceipientToken(token);
                continue;
            }
            throw new DSException(4243, new String[]{qName.toString()});
        }
    }
}

