/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model.builders;

import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.SecurityContextToken;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import java.util.List;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;

public class SecurityContextTokenBuilder
implements AssertionModelBuilder {
    @Override
    public SecurityContextToken build(WSSecurityPolicyAssertion wSSecurityPolicyAssertion) throws DSException {
        SecurityContextToken securityContextToken = new SecurityContextToken();
        String string = wSSecurityPolicyAssertion.getAttValueByQName(SP13Constants.INCLUDE_TOKEN);
        if (string != null) {
            int n = SP13Constants.getInclusionFromAttributeValue(string);
            securityContextToken.setInclusion(n);
        }
        if (wSSecurityPolicyAssertion.getSubAssertions() != null) {
            this.INCLUDE_TOKEN(wSSecurityPolicyAssertion.getSubAssertions(), securityContextToken);
        }
        return securityContextToken;
    }

    private void INCLUDE_TOKEN(List list, SecurityContextToken securityContextToken) throws DSException {
        for (WSSecurityPolicyAssertion wSSecurityPolicyAssertion : list) {
            QName qName = wSSecurityPolicyAssertion.getName();
            if (qName.equals(SP13Constants.REQUIRE_DERIVED_KEYS)) {
                securityContextToken.setDerivedKeys(true);
                continue;
            }
            if (qName.equals(SP13Constants.REQUIRE_EXTERNAL_URI_REFERNCE)) {
                securityContextToken.setRequireExternalUriRef(true);
                continue;
            }
            if (qName.equals(SP13Constants.SC10_SECURITY_CONTEXT_TOKEN)) {
                securityContextToken.setSc10SecurityContextToken(true);
                continue;
            }
            throw new DSException(4243, new String[]{qName.toString()});
        }
    }
}

