/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model.builders;

import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.AbstractSecurityAssertion;
import com.jinfonet.webservice.security.model.AlgorithmSuite;
import com.jinfonet.webservice.security.model.SignedEncryptedElements;
import com.jinfonet.webservice.security.model.SignedEncryptedParts;
import com.jinfonet.webservice.security.model.SupportingToken;
import com.jinfonet.webservice.security.model.Token;
import com.jinfonet.webservice.security.model.builders.AlgorithmSuiteBuilder;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import com.jinfonet.webservice.security.model.builders.EncryptedElementsBuilder;
import com.jinfonet.webservice.security.model.builders.EncryptedPartsBuilder;
import com.jinfonet.webservice.security.model.builders.HttpsTokenBuilder;
import com.jinfonet.webservice.security.model.builders.SecurityContextTokenBuilder;
import com.jinfonet.webservice.security.model.builders.SignedElementsBuilder;
import com.jinfonet.webservice.security.model.builders.SignedPartsBuilder;
import com.jinfonet.webservice.security.model.builders.UsernameTokenBuilder;
import com.jinfonet.webservice.security.model.builders.X509TokenBuilder;
import java.util.List;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;

public class SupportingTokensBuilder
implements AssertionModelBuilder {
    @Override
    public SupportingToken build(WSSecurityPolicyAssertion wSSecurityPolicyAssertion) throws DSException {
        QName qName = wSSecurityPolicyAssertion.getName();
        SupportingToken supportingToken = null;
        if (SP13Constants.SUPPORTING_TOKENS.equals(qName)) {
            supportingToken = new SupportingToken(1);
        } else if (SP13Constants.SIGNED_SUPPORTING_TOKENS.equals(qName)) {
            supportingToken = new SupportingToken(3);
        } else if (SP13Constants.ENDORSING_SUPPORTING_TOKENS.equals(qName)) {
            supportingToken = new SupportingToken(2);
        } else if (SP13Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS.equals(qName)) {
            supportingToken = new SupportingToken(4);
        } else if (SP13Constants.ENCRYPTED_SUPPORTING_TOKENS.equals(qName)) {
            supportingToken = new SupportingToken(6);
        } else if (SP13Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS.equals(qName)) {
            supportingToken = new SupportingToken(5);
        } else if (SP13Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS.equals(qName)) {
            supportingToken = new SupportingToken(7);
        } else if (SP13Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS.equals(qName)) {
            supportingToken = new SupportingToken(8);
        }
        if (wSSecurityPolicyAssertion.getSubAssertions() != null) {
            this.ALGORITHM_SUITE(wSSecurityPolicyAssertion.getSubAssertions(), supportingToken);
        }
        return supportingToken;
    }

    private void ALGORITHM_SUITE(List list, SupportingToken supportingToken) throws DSException {
        for (WSSecurityPolicyAssertion wSSecurityPolicyAssertion : list) {
            AbstractSecurityAssertion abstractSecurityAssertion;
            AssertionModelBuilder assertionModelBuilder;
            QName qName = wSSecurityPolicyAssertion.getName();
            if (SP13Constants.ALGORITHM_SUITE.equals(qName)) {
                assertionModelBuilder = new AlgorithmSuiteBuilder();
                abstractSecurityAssertion = ((AlgorithmSuiteBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                supportingToken.setAlgorithmSuite((AlgorithmSuite)abstractSecurityAssertion);
                continue;
            }
            if (SP13Constants.SIGNED_PARTS.equals(qName)) {
                assertionModelBuilder = new SignedPartsBuilder();
                abstractSecurityAssertion = ((SignedPartsBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                supportingToken.setSignedParts((SignedEncryptedParts)abstractSecurityAssertion);
                continue;
            }
            if (SP13Constants.SIGNED_ELEMENTS.equals(qName)) {
                assertionModelBuilder = new SignedElementsBuilder();
                abstractSecurityAssertion = ((SignedElementsBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                supportingToken.setSignedElements((SignedEncryptedElements)abstractSecurityAssertion);
                continue;
            }
            if (SP13Constants.ENCRYPTED_PARTS.equals(qName)) {
                assertionModelBuilder = new EncryptedPartsBuilder();
                abstractSecurityAssertion = ((EncryptedPartsBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                supportingToken.setEncryptedParts((SignedEncryptedParts)abstractSecurityAssertion);
                continue;
            }
            if (SP13Constants.ENCRYPTED_ELEMENTS.equals(qName)) {
                assertionModelBuilder = new EncryptedElementsBuilder();
                abstractSecurityAssertion = ((EncryptedElementsBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                supportingToken.setEncryptedElements((SignedEncryptedElements)abstractSecurityAssertion);
                continue;
            }
            if (SP13Constants.USERNAME_TOKEN.equals(qName)) {
                assertionModelBuilder = new UsernameTokenBuilder();
                abstractSecurityAssertion = ((UsernameTokenBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                supportingToken.addToken((Token)abstractSecurityAssertion);
                continue;
            }
            if (SP13Constants.X509_TOKEN.equals(qName)) {
                assertionModelBuilder = new X509TokenBuilder();
                abstractSecurityAssertion = ((X509TokenBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                supportingToken.addToken((Token)abstractSecurityAssertion);
                continue;
            }
            if (SP13Constants.SECURITY_CONTEXT_TOKEN.equals(qName)) {
                assertionModelBuilder = new SecurityContextTokenBuilder();
                abstractSecurityAssertion = ((SecurityContextTokenBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                supportingToken.addToken((Token)abstractSecurityAssertion);
                continue;
            }
            if (SP13Constants.HTTPS_TOKEN.equals(qName)) {
                assertionModelBuilder = new HttpsTokenBuilder();
                abstractSecurityAssertion = ((HttpsTokenBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                supportingToken.addToken((Token)abstractSecurityAssertion);
                continue;
            }
            throw new DSException(4243, new String[]{qName.toString()});
        }
    }
}

