/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model.builders;

import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.AbstractSecurityAssertion;
import com.jinfonet.webservice.security.model.AlgorithmSuite;
import com.jinfonet.webservice.security.model.ProtectionToken;
import com.jinfonet.webservice.security.model.SymmetricBinding;
import com.jinfonet.webservice.security.model.builders.AlgorithmSuiteBuilder;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import com.jinfonet.webservice.security.model.builders.ProtectionTokenBuilder;
import java.util.List;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;

public class SymmetricBindingBuilder
implements AssertionModelBuilder {
    @Override
    public SymmetricBinding build(WSSecurityPolicyAssertion wSSecurityPolicyAssertion) throws DSException {
        SymmetricBinding symmetricBinding = new SymmetricBinding();
        if (wSSecurityPolicyAssertion.getSubAssertions() != null) {
            this.ALGORITHM_SUITE(wSSecurityPolicyAssertion.getSubAssertions(), symmetricBinding);
        }
        return symmetricBinding;
    }

    private void ALGORITHM_SUITE(List list, SymmetricBinding symmetricBinding) throws DSException {
        for (WSSecurityPolicyAssertion wSSecurityPolicyAssertion : list) {
            AbstractSecurityAssertion abstractSecurityAssertion;
            AssertionModelBuilder assertionModelBuilder;
            QName qName = wSSecurityPolicyAssertion.getName();
            if (SP13Constants.ALGORITHM_SUITE.equals(qName)) {
                assertionModelBuilder = new AlgorithmSuiteBuilder();
                abstractSecurityAssertion = ((AlgorithmSuiteBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                symmetricBinding.setAlgorithmSuite((AlgorithmSuite)abstractSecurityAssertion);
                continue;
            }
            if (SP13Constants.INCLUDE_TIMESTAMP.equals(qName)) {
                symmetricBinding.setIncludeTimestamp(true);
                continue;
            }
            if (SP13Constants.PROTECTION_TOKEN.equals(qName)) {
                assertionModelBuilder = new ProtectionTokenBuilder();
                abstractSecurityAssertion = ((ProtectionTokenBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                symmetricBinding.setProtectionToken((ProtectionToken)abstractSecurityAssertion);
                continue;
            }
            if (SP13Constants.ENCRYPT_BEFORE_SIGNING.equals(qName)) {
                symmetricBinding.setProtectionOrder("EncryptBeforeSigning");
                continue;
            }
            if (SP13Constants.SIGN_BEFORE_ENCRYPTING.equals(qName)) {
                symmetricBinding.setProtectionOrder("SignBeforeEncrypting");
                continue;
            }
            if (SP13Constants.ONLY_SIGN_ENTIRE_HEADERS_AND_BODY.equals(qName)) {
                symmetricBinding.setEntireHeadersAndBodySignatures(true);
                continue;
            }
            if (SP13Constants.ENCRYPT_SIGNATURE.equals(qName)) {
                symmetricBinding.setSignatureProtection(true);
                continue;
            }
            if (SP13Constants.PROTECT_TOKENS.equals(qName)) {
                symmetricBinding.setTokenProtection(true);
                continue;
            }
            throw new DSException(4243, new String[]{qName.toString()});
        }
    }
}

