/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model.builders;

import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.TransportBinding;
import com.jinfonet.webservice.security.model.builders.AlgorithmSuiteBuilder;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import com.jinfonet.webservice.security.model.builders.TransportTokenBuilder;
import java.util.List;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;

public class TransportBindingBuilder
implements AssertionModelBuilder {
    @Override
    public TransportBinding build(WSSecurityPolicyAssertion wSSecurityPolicyAssertion) throws DSException {
        TransportBinding transportBinding = new TransportBinding();
        if (wSSecurityPolicyAssertion.getSubAssertions() != null) {
            this.ALGORITHM_SUITE(wSSecurityPolicyAssertion.getSubAssertions(), transportBinding);
        }
        return transportBinding;
    }

    private void ALGORITHM_SUITE(List list, TransportBinding transportBinding) throws DSException {
        for (WSSecurityPolicyAssertion wSSecurityPolicyAssertion : list) {
            AssertionModelBuilder assertionModelBuilder;
            QName qName = wSSecurityPolicyAssertion.getName();
            if (qName.equals(SP13Constants.ALGORITHM_SUITE)) {
                assertionModelBuilder = new AlgorithmSuiteBuilder();
                transportBinding.setAlgorithmSuite(((AlgorithmSuiteBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion));
                continue;
            }
            if (qName.equals(SP13Constants.TRANSPORT_TOKEN)) {
                assertionModelBuilder = new TransportTokenBuilder();
                transportBinding.setTransportToken(((TransportTokenBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion));
                continue;
            }
            if (qName.equals(SP13Constants.INCLUDE_TIMESTAMP)) {
                transportBinding.setIncludeTimestamp(true);
                continue;
            }
            throw new DSException(4243, new String[]{qName.toString()});
        }
    }
}

