/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model.builders;

import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.Trust13;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import java.util.List;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;

public class Trust13Builder
implements AssertionModelBuilder {
    @Override
    public Trust13 build(WSSecurityPolicyAssertion wSSecurityPolicyAssertion) throws DSException {
        if (wSSecurityPolicyAssertion.getSubAssertions() == null) {
            throw new DSException("Trust13 assertion doesn't contain any Policy");
        }
        Trust13 trust13 = new Trust13();
        if (wSSecurityPolicyAssertion.getSubAssertions() != null) {
            this.MUST_SUPPORT_CLIENT_CHALLENGE(wSSecurityPolicyAssertion.getSubAssertions(), trust13);
        }
        return trust13;
    }

    private void MUST_SUPPORT_CLIENT_CHALLENGE(List list, Trust13 trust13) {
        for (WSSecurityPolicyAssertion wSSecurityPolicyAssertion : list) {
            QName qName = wSSecurityPolicyAssertion.getName();
            if (qName.equals(SP13Constants.MUST_SUPPORT_CLIENT_CHALLENGE)) {
                trust13.setMustSupportClientChallenge(true);
            }
            if (qName.equals(SP13Constants.MUST_SUPPORT_SERVER_CHALLENGE)) {
                trust13.setMustSupportServerChallenge(true);
            }
            if (qName.equals(SP13Constants.REQUIRE_CLIENT_ENTROPY)) {
                trust13.setRequireClientEntropy(true);
            }
            if (qName.equals(SP13Constants.REQUIRE_SERVER_ENTROPY)) {
                trust13.setRequireServerEntropy(true);
            }
            if (qName.equals(SP13Constants.MUST_SUPPORT_ISSUED_TOKENS)) {
                trust13.setMustSupportIssuedTokens(true);
            }
            if (qName.equals(SP13Constants.REQUIRE_REQUEST_SECURITY_TOKEN_COLLECTION)) {
                trust13.setRequireRequestSecurityTokenCollection(true);
            }
            if (!qName.equals(SP13Constants.REQUIRE_APPLIES_TO)) continue;
            trust13.setRequireAppliesTo(true);
        }
    }
}

