/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model.builders;

import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.UsernameToken;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import java.util.List;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;

public class UsernameTokenBuilder
implements AssertionModelBuilder {
    @Override
    public UsernameToken build(WSSecurityPolicyAssertion wSSecurityPolicyAssertion) throws DSException {
        UsernameToken usernameToken = new UsernameToken();
        String string = wSSecurityPolicyAssertion.getAttValueByQName(SP13Constants.INCLUDE_TOKEN);
        if (string != null) {
            int n = SP13Constants.getInclusionFromAttributeValue(string);
            usernameToken.setInclusion(n);
        }
        if (wSSecurityPolicyAssertion.getSubAssertions() != null) {
            this.processSubAssertion(wSSecurityPolicyAssertion.getSubAssertions(), usernameToken);
        }
        return usernameToken;
    }

    public void processSubAssertion(List list, UsernameToken usernameToken) throws DSException {
        for (WSSecurityPolicyAssertion wSSecurityPolicyAssertion : list) {
            QName qName = wSSecurityPolicyAssertion.getName();
            if (SP13Constants.WSS_USERNAME_TOKEN10.equals(qName)) {
                usernameToken.setUseUTProfile10(true);
                continue;
            }
            if (SP13Constants.WSS_USERNAME_TOKEN11.equals(qName)) {
                usernameToken.setUseUTProfile11(true);
                continue;
            }
            if (SP13Constants.NO_PASSWORD.equals(qName)) {
                usernameToken.setNoPassword(true);
                continue;
            }
            if (SP13Constants.HASH_PASSWORD.equals(qName)) {
                usernameToken.setHashPassword(true);
                continue;
            }
            if (SP13Constants.REQUIRE_DERIVED_KEYS.equals(qName)) {
                usernameToken.setDerivedKeys(true);
                continue;
            }
            throw new DSException(4243, new String[]{qName.toString()});
        }
    }
}

