/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model.builders;

import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.Wss10;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import java.util.List;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;

public class WSS10Builder
implements AssertionModelBuilder {
    @Override
    public Wss10 build(WSSecurityPolicyAssertion wSSecurityPolicyAssertion) throws DSException {
        Wss10 wss10 = new Wss10();
        if (wSSecurityPolicyAssertion.getSubAssertions() != null) {
            this.MUST_SUPPORT_REF_ISSUER_SERIAL(wSSecurityPolicyAssertion.getSubAssertions(), wss10);
        }
        return wss10;
    }

    private void MUST_SUPPORT_REF_ISSUER_SERIAL(List list, Wss10 wss10) throws DSException {
        for (WSSecurityPolicyAssertion wSSecurityPolicyAssertion : list) {
            QName qName = wSSecurityPolicyAssertion.getName();
            if (SP13Constants.MUST_SUPPORT_REF_KEY_IDENTIFIER.equals(qName)) {
                wss10.setMustSupportRefKeyIdentifier(true);
                continue;
            }
            if (SP13Constants.MUST_SUPPORT_REF_ISSUER_SERIAL.equals(qName)) {
                wss10.setMustSupportRefIssuerSerial(true);
                continue;
            }
            throw new DSException(4243, new String[]{qName.toString()});
        }
    }
}

