/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model.builders;

import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.Wss11;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import java.util.List;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;

public class WSS11Builder
implements AssertionModelBuilder {
    @Override
    public Wss11 build(WSSecurityPolicyAssertion wSSecurityPolicyAssertion) throws DSException {
        Wss11 wss11 = new Wss11();
        if (wSSecurityPolicyAssertion.getSubAssertions() != null) {
            this.MUST_SUPPORT_REF_ISSUER_SERIAL(wSSecurityPolicyAssertion.getSubAssertions(), wss11);
        }
        return wss11;
    }

    private void MUST_SUPPORT_REF_ISSUER_SERIAL(List list, Wss11 wss11) throws DSException {
        for (WSSecurityPolicyAssertion wSSecurityPolicyAssertion : list) {
            QName qName = wSSecurityPolicyAssertion.getName();
            if (SP13Constants.MUST_SUPPORT_REF_KEY_IDENTIFIER.equals(qName)) {
                wss11.setMustSupportRefKeyIdentifier(true);
                continue;
            }
            if (SP13Constants.MUST_SUPPORT_REF_ISSUER_SERIAL.equals(qName)) {
                wss11.setMustSupportRefIssuerSerial(true);
                continue;
            }
            if (SP13Constants.MUST_SUPPORT_REF_THUMBPRINT.equals(qName)) {
                wss11.setMustSupportRefThumbprint(true);
                continue;
            }
            if (SP13Constants.REQUIRE_SIGNATURE_CONFIRMATION.equals(qName)) {
                wss11.setRequireSignatureConfirmation(true);
                continue;
            }
            throw new DSException(4243, new String[]{qName.toString()});
        }
    }
}

