/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.model.builders;

import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.model.X509Token;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import java.util.List;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;

public class X509TokenBuilder
implements AssertionModelBuilder {
    @Override
    public X509Token build(WSSecurityPolicyAssertion wSSecurityPolicyAssertion) throws DSException {
        X509Token x509Token = new X509Token();
        String string = wSSecurityPolicyAssertion.getAttValueByQName(SP13Constants.INCLUDE_TOKEN);
        if (string != null) {
            int n = SP13Constants.getInclusionFromAttributeValue(string);
            x509Token.setInclusion(n);
        }
        if (wSSecurityPolicyAssertion.getSubAssertions() != null) {
            this.INCLUDE_TOKEN(wSSecurityPolicyAssertion.getSubAssertions(), x509Token);
        }
        return x509Token;
    }

    private void INCLUDE_TOKEN(List list, X509Token x509Token) throws DSException {
        for (WSSecurityPolicyAssertion wSSecurityPolicyAssertion : list) {
            QName qName = wSSecurityPolicyAssertion.getName();
            if (SP13Constants.REQUIRE_DERIVED_KEYS.equals(qName)) {
                x509Token.setDerivedKeys(true);
                continue;
            }
            if (SP13Constants.REQUIRE_KEY_IDENTIFIRE_REFERENCE.equals(qName)) {
                x509Token.setRequireKeyIdentifierReference(true);
                continue;
            }
            if (SP13Constants.REQUIRE_ISSUER_SERIAL_REFERENCE.equals(qName)) {
                x509Token.setRequireIssuerSerialReference(true);
                continue;
            }
            if (SP13Constants.REQUIRE_EMBEDDED_TOKEN_REFERENCE.equals(qName)) {
                x509Token.setRequireEmbeddedTokenReference(true);
                continue;
            }
            if (SP13Constants.REQUIRE_THUMBPRINT_REFERENCE.equals(qName)) {
                x509Token.setRequireThumbprintReference(true);
                continue;
            }
            if (SP13Constants.WSS_X509_V1_TOKEN_10.equals(qName)) {
                x509Token.setTokenVersionAndType("WssX509V1Token10");
                continue;
            }
            if (SP13Constants.WSS_X509_V1_TOKEN_11.equals(qName)) {
                x509Token.setTokenVersionAndType("WssX509V1Token11");
                continue;
            }
            if (SP13Constants.WSS_X509_V3_TOKEN_10.equals(qName)) {
                x509Token.setTokenVersionAndType("WssX509V3Token10");
                continue;
            }
            if (SP13Constants.WSS_X509_V3_TOKEN_11.equals(qName)) {
                x509Token.setTokenVersionAndType("WssX509V3Token11");
                continue;
            }
            if (SP13Constants.WSS_X509_PKCS7_TOKEN_10.equals(qName)) {
                x509Token.setTokenVersionAndType("WssX509Pkcs7Token10");
                continue;
            }
            if (SP13Constants.WSS_X509_PKCS7_TOKEN_11.equals(qName)) {
                x509Token.setTokenVersionAndType("WssX509Pkcs7Token11");
                continue;
            }
            if (SP13Constants.WSS_X509_PKI_PATH_V1_TOKEN_10.equals(qName)) {
                x509Token.setTokenVersionAndType("WssX509PkiPathV1Token10");
                continue;
            }
            if (SP13Constants.WSS_X509_PKI_PATH_V1_TOKEN_11.equals(qName)) {
                x509Token.setTokenVersionAndType("WssX509PkiPathV1Token11");
                continue;
            }
            throw new DSException(4243, new String[]{qName.toString()});
        }
    }
}

