/*
 * Decompiled with CFR 0.152.
 */
package guistreamutil;

import guistreamutil.GUIError;
import guistreamutil.Reader;
import guistreamutil.Register;
import guitools.DialogLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class ComponentReg
implements Register {
    public static boolean bRecordReg = false;
    private static Vector I = null;

    @Override
    public Component readComp(Container container, DataInputStream dataInputStream) throws IOException {
        Component component = this.instComp(dataInputStream);
        if (component != null) {
            this.setExtraInfo(component, container, dataInputStream);
        }
        return component;
    }

    protected Component instComp(DataInputStream dataInputStream) throws IOException {
        String string = ComponentReg.readString(dataInputStream);
        Component component = null;
        try {
            component = (Component)ComponentReg.findClass(string).newInstance();
        }
        catch (Exception exception) {
            GUIError.classifyError(exception, string);
        }
        return component;
    }

    protected void setExtraInfo(Component component, Container container, DataInputStream dataInputStream) throws IOException {
        component.setName(ComponentReg.readString(dataInputStream));
        component.setVisible(dataInputStream.readBoolean());
        component.setEnabled(dataInputStream.readBoolean());
        ComponentReg.readBounds(component, container, dataInputStream);
        if (dataInputStream.readBoolean()) {
            component.setForeground(ComponentReg.readColor(dataInputStream));
        }
        if (dataInputStream.readBoolean()) {
            component.setBackground(ComponentReg.readColor(dataInputStream));
        }
        if (dataInputStream.readBoolean()) {
            component.setFont(ComponentReg.readFont(dataInputStream));
        }
    }

    protected static String readString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray, 0, n);
        return new String(byArray, "8859_1");
    }

    protected static String readPropText(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readBoolean()) {
            return Reader.getTextProp(ComponentReg.readString(dataInputStream));
        }
        return "";
    }

    protected static Color readColor(DataInputStream dataInputStream) throws IOException {
        return new Color(dataInputStream.readInt());
    }

    protected static Font readFont(DataInputStream dataInputStream) throws IOException {
        return new Font(ComponentReg.readString(dataInputStream), dataInputStream.readInt(), dataInputStream.readInt());
    }

    public static void clearReg() {
        if (I != null) {
            I.removeAllElements();
        }
    }

    protected static Register readRegister(DataInputStream dataInputStream) throws IOException {
        String string = ComponentReg.readString(dataInputStream);
        try {
            Register register = (Register)ComponentReg.findClass("guistreamutil." + string).newInstance();
            return register;
        }
        catch (Exception exception) {
            GUIError.classifyError(exception, string);
            return null;
        }
    }

    protected static void readBounds(Component component, Container container, DataInputStream dataInputStream) throws IOException {
        ComponentReg.setBounds(component, container, ComponentReg.readRectangle(dataInputStream));
    }

    static void setBounds(Component component, Container container, Rectangle rectangle) {
        LayoutManager layoutManager;
        LayoutManager layoutManager2 = layoutManager = container == null ? null : container.getLayout();
        if (layoutManager instanceof DialogLayout) {
            ((DialogLayout)layoutManager).setShape(component, rectangle);
            if (container.isShowing()) {
                container.doLayout();
            }
        } else if (component instanceof Container) {
            layoutManager = ((Container)component).getLayout();
            if (layoutManager instanceof DialogLayout) {
                ((DialogLayout)layoutManager).setLayoutSize(rectangle.width, rectangle.height);
                component.setSize(((DialogLayout)layoutManager).preferredLayoutSize((Container)component));
            } else {
                component.setBounds(rectangle);
            }
        } else {
            component.setBounds(rectangle);
        }
    }

    protected static Rectangle readRectangle(DataInputStream dataInputStream) throws IOException {
        return Reader.getBoundsProp(ComponentReg.readString(dataInputStream));
    }

    public static Vector getRegs() {
        return I;
    }

    protected static Class findClass(String string) throws ClassNotFoundException {
        if (bRecordReg) {
            if (I == null) {
                I = new Vector();
            }
            if (!I.contains(string) && !string.startsWith("java.awt.")) {
                I.addElement(string);
            }
        }
        return Class.forName(string);
    }
}

