/*
 * Decompiled with CFR 0.152.
 */
package guitools;

import guitools.AbstractButton;
import guitools.DisableFilter;
import guitools.Painter;
import guitools.PainterConstants;
import guitools.UIResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;

public class DefaultButton
extends AbstractButton
implements PainterConstants {
    private static final int SEDU = 2;
    private static final int addImage = 4;
    private static final int drawImage = 8;
    private Image drawText = null;
    private Image equals = null;
    private String getActionCommand = null;
    private int getBackground = 8;
    private int getFont = 8;
    private int getForeground = 5;

    public DefaultButton() {
        this(null, null);
    }

    public DefaultButton(String string) {
        this(string, null);
    }

    public DefaultButton(Image image) {
        this(null, image);
    }

    public DefaultButton(String string, Image image) {
        this.setLabel(string);
        this.setImage(image);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = null;
        if (this.drawText != null) {
            dimension = new Dimension(this.drawText.getWidth(this), this.drawText.getHeight(this));
        }
        if (this.getActionCommand != null) {
            Font font = this.getFont();
            Font font2 = font = font == null ? UIResource.getFont("Control Font") : font;
            if (font != null) {
                Dimension dimension2 = Painter.layoutText(null, this.getActionCommand, 2, Integer.MAX_VALUE, font);
                if (dimension != null) {
                    switch (this.getFont) {
                        case 1: {
                            dimension.width += dimension2.width + this.getBackground;
                            dimension.height += dimension2.height + this.getBackground;
                            break;
                        }
                        case 2: {
                            dimension.width = Math.max(dimension2.width, dimension.width);
                            dimension.height += dimension2.height + this.getBackground;
                            break;
                        }
                        case 3: {
                            dimension.width += dimension2.width + this.getBackground;
                            dimension.height += dimension2.height + this.getBackground;
                            break;
                        }
                        case 4: {
                            dimension.width += dimension2.width + this.getBackground;
                            dimension.height = Math.max(dimension2.height, dimension.height);
                            break;
                        }
                        case 5: {
                            dimension.width = Math.max(dimension2.width, dimension.width);
                            dimension.height = Math.max(dimension2.height, dimension.height);
                            break;
                        }
                        case 6: {
                            dimension.width += dimension2.width + this.getBackground;
                            dimension.height = Math.max(dimension2.height, dimension.height);
                            break;
                        }
                        case 7: {
                            dimension.width += dimension2.width + this.getBackground;
                            dimension.height += dimension2.height + this.getBackground;
                            break;
                        }
                        case 8: {
                            dimension.width = Math.max(dimension2.width, dimension.width);
                            dimension.height += dimension2.height + this.getBackground;
                            break;
                        }
                        case 9: {
                            dimension.width += dimension2.width + this.getBackground;
                            dimension.height += dimension2.height + this.getBackground;
                        }
                    }
                } else {
                    dimension = dimension2;
                }
            }
        }
        if (dimension != null) {
            dimension.width += 8;
            dimension.height += 8;
        }
        return dimension == null ? this.getSize() : dimension;
    }

    @Override
    public String getActionCommand() {
        String string = super.getActionCommand();
        return string == null ? this.getActionCommand : string;
    }

    public void setImage(Image image) {
        this.drawText = image;
        this.equals = null;
        this.repaint();
    }

    public Image getImage() {
        return this.drawText;
    }

    public void setLabel(String string) {
        if (string == null || !string.equals(this.getActionCommand)) {
            this.getActionCommand = string;
            this.repaint();
        }
    }

    public String getLabel() {
        return this.getActionCommand;
    }

    public void setLabelPosition(int n) {
        if (this.getFont != n && (n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 6 || n == 7 || n == 8 || n == 9)) {
            this.getFont = n;
            this.repaint();
        }
    }

    public int getLabelPosition() {
        return this.getFont;
    }

    public void setLabelAlignment(int n) {
        if (this.getForeground != n && (n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 6 || n == 7 || n == 8 || n == 9)) {
            this.getForeground = n;
            this.repaint();
        }
    }

    public int getLabelAlignment() {
        return this.getForeground;
    }

    public void setImageLabelGap(int n) {
        if (n >= 0 && n != this.getBackground) {
            this.getBackground = n;
            this.repaint();
        }
    }

    public int getImageLabelGap() {
        return this.getBackground;
    }

    @Override
    public void paintInterior(Graphics graphics) {
        Image image = this.drawText;
        if (!this.isEnabled()) {
            if (this.equals == null && this.drawText != null) {
                int n = this.drawText.getWidth(this);
                int n2 = this.drawText.getHeight(this);
                FilteredImageSource filteredImageSource = new FilteredImageSource(this.drawText.getSource(), new CropImageFilter(0, 0, n, n2));
                this.equals = this.createImage(new FilteredImageSource(filteredImageSource, new DisableFilter(n, n2, this.getBackground())));
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(this.equals, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (mediaTracker.isErrorID(0)) {
                    this.equals = null;
                }
                mediaTracker.removeImage(this.equals);
            }
            image = this.equals;
        }
        if (image != null || this.getActionCommand != null) {
            Rectangle[] rectangleArray = DefaultButton.SEDU(this.getSize(), image, this.getActionCommand, this.getFont(), this.getBackground, this.getFont);
            if (rectangleArray[0] != null) {
                this.paintImage(graphics, image, rectangleArray[0]);
            }
            if (rectangleArray[1] != null) {
                this.paintLabel(graphics, this.getActionCommand, rectangleArray[1]);
            }
        }
    }

    public void paintImage(Graphics graphics, Image image, Rectangle rectangle) {
        int n = this.isToggled() ? 1 : 0;
        rectangle.x += n;
        rectangle.y += n;
        graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
    }

    public void paintLabel(Graphics graphics, String string, Rectangle rectangle) {
        int n = this.isToggled() ? 1 : 0;
        rectangle.x += n;
        rectangle.y += n;
        Painter.drawText(graphics, rectangle, string, this.getFont(), this.getForeground(), true, false, false, this.getForeground);
    }

    private static Rectangle[] SEDU(Dimension dimension, Image image, String string, Font font, int n, int n2) {
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        Rectangle rectangle3 = null;
        if (image != null) {
            Component component = new Component(){};
            rectangle = new Rectangle();
            rectangle.width = image.getWidth(component);
            rectangle.height = image.getHeight(component);
        }
        if (string != null && string.length() > 0) {
            int n3 = dimension.width - 8;
            if (image != null && n2 != 2 && n2 != 5 && n2 != 8) {
                n3 -= rectangle.width - n;
            }
            if (n3 > 0) {
                rectangle2 = new Rectangle(Painter.layoutText(null, string, 2, n3, font));
            }
        }
        if (rectangle != null && rectangle2 != null) {
            rectangle3 = new Rectangle();
            switch (n2) {
                case 1: {
                    rectangle3.width = rectangle.width + rectangle2.width + n;
                    rectangle3.height = rectangle.height + rectangle2.height + n;
                    break;
                }
                case 2: {
                    rectangle3.width = Math.max(rectangle.width, rectangle2.width);
                    rectangle3.height = rectangle.height + rectangle2.height + n;
                    break;
                }
                case 3: {
                    rectangle3.width = rectangle.width + rectangle2.width + n;
                    rectangle3.height = rectangle.height + rectangle2.height + n;
                    break;
                }
                case 4: {
                    rectangle3.width = rectangle.width + rectangle2.width + n;
                    rectangle3.height = Math.max(rectangle.height, rectangle2.height);
                    break;
                }
                case 5: {
                    rectangle3.width = Math.max(rectangle.width, rectangle2.width);
                    rectangle3.height = Math.max(rectangle.height, rectangle2.height);
                    break;
                }
                case 6: {
                    rectangle3.width = rectangle.width + rectangle2.width + n;
                    rectangle3.height = Math.max(rectangle.height, rectangle2.height);
                    break;
                }
                case 7: {
                    rectangle3.width = rectangle.width + rectangle2.width + n;
                    rectangle3.height = rectangle.height + rectangle2.height + n;
                    break;
                }
                case 8: {
                    rectangle3.width = Math.max(rectangle.width, rectangle2.width);
                    rectangle3.height = rectangle.height + rectangle2.height + n;
                    break;
                }
                case 9: {
                    rectangle3.width = rectangle.width + rectangle2.width + n;
                    rectangle3.height = rectangle.height + rectangle2.height + n;
                }
            }
        } else if (rectangle != null) {
            rectangle3 = new Rectangle(rectangle);
        } else if (rectangle2 != null) {
            rectangle3 = new Rectangle(rectangle2);
        }
        if (rectangle3 != null) {
            rectangle3.x = (dimension.width - rectangle3.width) / 2;
            rectangle3.y = (dimension.height - rectangle3.height) / 2;
            switch (n2) {
                case 1: {
                    if (rectangle2 != null) {
                        rectangle2.x = rectangle3.x;
                        rectangle2.y = rectangle3.y;
                    }
                    if (rectangle == null) break;
                    rectangle.x = rectangle3.x + rectangle3.width - rectangle.width;
                    rectangle.y = rectangle3.y + rectangle3.height - rectangle.height;
                    break;
                }
                case 2: {
                    if (rectangle2 != null) {
                        rectangle2.x = rectangle3.x + (rectangle3.width - rectangle2.width) / 2;
                        rectangle2.y = rectangle3.y;
                    }
                    if (rectangle == null) break;
                    rectangle.x = rectangle3.x + (rectangle3.width - rectangle.width) / 2;
                    rectangle.y = rectangle3.y + rectangle3.height - rectangle.height;
                    break;
                }
                case 3: {
                    if (rectangle2 != null) {
                        rectangle2.x = rectangle3.x + rectangle3.width - rectangle2.width;
                        rectangle2.y = rectangle3.y;
                    }
                    if (rectangle == null) break;
                    rectangle.x = rectangle3.x;
                    rectangle.y = rectangle3.y + rectangle3.height - rectangle.height;
                    break;
                }
                case 4: {
                    if (rectangle2 != null) {
                        rectangle2.x = rectangle3.x;
                        rectangle2.y = rectangle3.y + (rectangle3.height - rectangle2.height) / 2;
                    }
                    if (rectangle == null) break;
                    rectangle.x = rectangle3.x + rectangle3.width - rectangle.width;
                    rectangle.y = rectangle3.y + (rectangle3.height - rectangle.height) / 2;
                    break;
                }
                case 5: {
                    if (rectangle2 != null) {
                        rectangle2.x = rectangle3.x + (rectangle3.width - rectangle2.width) / 2;
                        rectangle2.y = rectangle3.y + (rectangle3.height - rectangle2.height) / 2;
                    }
                    if (rectangle == null) break;
                    rectangle.x = rectangle3.x + (rectangle3.width - rectangle.width) / 2;
                    rectangle.y = rectangle3.y + (rectangle3.height - rectangle.height) / 2;
                    break;
                }
                case 6: {
                    if (rectangle2 != null) {
                        rectangle2.x = rectangle3.x + rectangle3.width - rectangle2.width;
                        rectangle2.y = rectangle3.y + (rectangle3.height - rectangle2.height) / 2;
                    }
                    if (rectangle == null) break;
                    rectangle.x = rectangle3.x;
                    rectangle.y = rectangle3.y + (rectangle3.height - rectangle.height) / 2;
                    break;
                }
                case 7: {
                    if (rectangle2 != null) {
                        rectangle2.x = rectangle3.x;
                        rectangle2.y = rectangle3.y + rectangle3.height - rectangle2.height;
                    }
                    if (rectangle == null) break;
                    rectangle.x = rectangle3.x + rectangle3.width - rectangle.width;
                    rectangle.y = rectangle3.y;
                    break;
                }
                case 8: {
                    if (rectangle2 != null) {
                        rectangle2.x = rectangle3.x + (rectangle3.width - rectangle2.width) / 2;
                        rectangle2.y = rectangle3.y + rectangle3.height - rectangle2.height;
                    }
                    if (rectangle == null) break;
                    rectangle.x = rectangle3.x + (rectangle3.width - rectangle.width) / 2;
                    rectangle.y = rectangle3.y;
                    break;
                }
                case 9: {
                    if (rectangle2 != null) {
                        rectangle2.x = rectangle3.x + rectangle3.width - rectangle2.width;
                        rectangle2.y = rectangle3.y + rectangle3.height - rectangle2.height;
                    }
                    if (rectangle == null) break;
                    rectangle.x = rectangle3.x;
                    rectangle.y = rectangle3.y;
                }
            }
        }
        return new Rectangle[]{rectangle, rectangle2, rectangle3};
    }
}

