/*
 * Decompiled with CFR 0.152.
 */
package guitools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Hashtable;

public class DialogLayout
implements LayoutManager {
    private static final String SEDU = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private Hashtable get = new Hashtable();
    private int getComponent;
    private int getComponentCount;

    public DialogLayout(int n, int n2) {
        this.setLayoutSize(n, n2);
    }

    public DialogLayout(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public void setLayoutSize(int n, int n2) {
        this.getComponent = n;
        this.getComponentCount = n2;
    }

    public Dimension getLayoutSize() {
        return new Dimension(this.getComponent, this.getComponentCount);
    }

    public void setShape(Component component, int n, int n2, int n3, int n4) {
        this.get.put(component, new Rectangle(n, n2, n3, n4));
    }

    public void setShape(Component component, Rectangle rectangle) {
        this.get.put(component, new Rectangle(rectangle));
    }

    public Rectangle getShape(Component component) {
        Rectangle rectangle = (Rectangle)this.get.get(component);
        return rectangle != null ? new Rectangle(rectangle) : null;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (container.getFont() != null) {
            Rectangle rectangle = new Rectangle(0, 0, this.getComponent, this.getComponentCount);
            this.getComponent(rectangle, this.SEDU(container), this.get(container));
            return new Dimension(rectangle.width, rectangle.height);
        }
        return container.getSize();
    }

    public Dimension preferredLayoutSize(Container container, Component component) {
        if (container.getFont() != null) {
            Rectangle rectangle = this.getShape(component);
            this.getComponent(rectangle, this.SEDU(container), this.get(container));
            return new Dimension(rectangle.width, rectangle.height);
        }
        return component.getSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        int n = container.getComponentCount();
        if (n > 0) {
            float f = this.SEDU(container);
            float f2 = this.get(container);
            Insets insets = container.getInsets();
            Rectangle rectangle = new Rectangle();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Rectangle rectangle2 = (Rectangle)this.get.get(component);
                if (rectangle2 == null) continue;
                rectangle.x = rectangle2.x;
                rectangle.y = rectangle2.y;
                rectangle.height = rectangle2.height;
                rectangle.width = rectangle2.width;
                this.getComponent(rectangle, f, f2);
                component.setBounds(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width, rectangle.height);
            }
        }
    }

    private float SEDU(Container container) {
        FontMetrics fontMetrics = container.getFontMetrics(container.getFont());
        return (float)fontMetrics.stringWidth(SEDU) / (float)SEDU.length();
    }

    private float get(Container container) {
        FontMetrics fontMetrics = container.getFontMetrics(container.getFont());
        float f = (float)fontMetrics.getMaxAscent() + (float)fontMetrics.getMaxDescent();
        f = Math.max(f, this.SEDU(container) * 12.0f / 5.0f);
        return f;
    }

    private void getComponent(Rectangle rectangle, float f, float f2) {
        rectangle.x = (int)((float)rectangle.x * f / 4.0f);
        rectangle.y = (int)((float)rectangle.y * f2 / 8.0f);
        rectangle.width = (int)((float)rectangle.width * f / 4.0f);
        rectangle.height = (int)((float)rectangle.height * f2 / 8.0f);
    }
}

