/*
 * Decompiled with CFR 0.152.
 */
package guitools;

import com.jinfonet.awt.JFont;
import guitools.Painter2D;
import guitools.PainterConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Vector;
import jet.util.JavaEnv;
import jet.util.TextBreaker;

public class Painter
implements PainterConstants {
    public static char WRAPCHAR = (char)10;
    private static final int KEY_FRACTIONALMETRICS = 1;
    private static final int SEDU = 2;
    private static final int VALUE_FRACTIONALMETRICS_OFF = 3;

    public static String adjustString(String string) {
        if (string.indexOf(9) >= 0 || string.indexOf(13) >= 0) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            while ((n = string.indexOf(13)) >= 0) {
                stringBuffer.append(string.substring(0, n));
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
            string = stringBuffer.toString();
            stringBuffer.setLength(0);
            while ((n = string.indexOf(9)) >= 0) {
                stringBuffer.append(string.substring(0, n) + "    ");
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
            string = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        return string;
    }

    public static Dimension layoutText(Vector vector, String string, int n, Font font, char c) {
        return Painter.layoutText(vector, string, 0, n, font, c);
    }

    public static Dimension layoutText(Vector vector, String string, int n, Font font) {
        return Painter.layoutText(vector, string, 0, n, font, WRAPCHAR);
    }

    public static Dimension layoutText(Vector vector, String string, int n, int n2, Font font) {
        return Painter.layoutText(vector, string, n, n2, font, WRAPCHAR);
    }

    public static Dimension layoutText(Vector vector, String string, int n, int n2, Font font, char c) {
        return Painter.KEY_FRACTIONALMETRICS(vector, string, n, n2, font, c);
    }

    private static Dimension KEY_FRACTIONALMETRICS(Vector vector, String string, int n, int n2, Font font, char c) {
        return Painter.charsWidth(vector, string, n, n2, font, c, true);
    }

    public static Vector lineBreaker(String string, int n, Font font) {
        TextBreaker textBreaker = new TextBreaker();
        textBreaker.setText(string);
        textBreaker.setFont(font);
        textBreaker.setMaxWidth(n);
        return textBreaker.process();
    }

    public static Vector lineBreaker(String string, int n, Font font, boolean bl) {
        TextBreaker textBreaker = new TextBreaker();
        textBreaker.setText(string);
        textBreaker.setFont(font);
        textBreaker.setMaxWidth(n);
        return textBreaker.process(bl);
    }

    public static Vector lineBreaker(String string, int n, FontMetrics fontMetrics) {
        Vector<String> vector = new Vector<String>();
        if (string.length() > 1 && fontMetrics.stringWidth(string) > n) {
            int n2;
            int n3;
            int[] nArray = fontMetrics.getWidths();
            int n4 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n4 += nArray[n3];
            }
            n3 = (int)((double)n / (double)(n4 / 256));
            do {
                int n5;
                int n6;
                int n7 = n6 = n3 >= (n5 = string.length()) ? n5 : n3;
                while (fontMetrics.stringWidth(string.substring(0, n6)) < n && n6 < n5) {
                    ++n6;
                }
                while (fontMetrics.stringWidth(string.substring(0, n6)) > n && n6 > 0) {
                    --n6;
                }
                for (n2 = n6; n2 > 0 && !Painter.VALUE_FRACTIONALMETRICS_OFF(string.charAt(n2 - 1)); --n2) {
                }
                n2 = n2 == 0 ? n6 : n2;
                boolean bl = true;
                int n8 = n2;
                int n9 = string.length();
                while (n8 < n9 && Painter.SEDU(string.charAt(n8))) {
                    if (fontMetrics.stringWidth(string.substring(0, ++n8)) <= n || Character.isWhitespace(string.charAt(n8 - 1))) continue;
                    --n8;
                    bl = false;
                    break;
                }
                if (!bl) {
                    int n10;
                    for (n10 = n2; n10 > 0 && !Painter.VALUE_FRACTIONALMETRICS_OFF(string.charAt(n10)); --n10) {
                    }
                    if (n10 > 0) {
                        n2 = n10;
                    }
                } else {
                    n2 = n8;
                }
                if (n2 == 0) {
                    n2 = 1;
                }
                String string2 = string.substring(0, n2);
                vector.addElement(string2);
            } while (fontMetrics.stringWidth(string = string.substring(n2)) > n && string.length() > 1);
            if (string.length() > 0) {
                vector.addElement(string);
            }
        } else {
            vector.addElement(string);
        }
        return vector;
    }

    private static boolean SEDU(char c) {
        int n = Character.getType(c);
        return Character.isWhitespace(c) || n == 20 || n == 22 || n == 24 || n == 14;
    }

    private static boolean VALUE_FRACTIONALMETRICS_OFF(char c) {
        int n = Character.getType(c);
        return Character.isWhitespace(c) || n == 14 || c > '\u4e00' && c < '\u9fff';
    }

    public static void drawText(Graphics graphics, String string, int n, int n2) {
        if (string.length() > 0) {
            if (!(graphics.getFont() instanceof JFont) && JavaEnv.is2D(graphics)) {
                Painter2D.drawText(graphics, string, n, n2);
            } else if (graphics instanceof Graphics2D) {
                RenderingHints renderingHints = ((Graphics2D)graphics).getRenderingHints();
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics.drawString(string, n, n2);
                ((Graphics2D)graphics).setRenderingHints(renderingHints);
            } else {
                graphics.drawString(string, n, n2);
            }
        }
    }

    public static void drawText(Graphics graphics, String string, int n, int n2, boolean bl) {
        if (string.length() > 0) {
            if (!(graphics.getFont() instanceof JFont) && JavaEnv.is2D(graphics)) {
                Painter2D.drawText(graphics, string, n, n2, bl);
            } else if (graphics instanceof Graphics2D) {
                RenderingHints renderingHints = ((Graphics2D)graphics).getRenderingHints();
                if (bl) {
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                } else {
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                }
                graphics.drawString(string, n, n2);
                ((Graphics2D)graphics).setRenderingHints(renderingHints);
            } else {
                graphics.drawString(string, n, n2);
            }
        }
    }

    private static void VALUE_FRACTIONALMETRICS_ON(Graphics graphics, Rectangle rectangle, int n, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n2, int n3, char c, boolean bl4) {
        if (string != null && string.length() > 0 && color != null) {
            Dimension dimension;
            n = n > 0 ? n : 0;
            RenderingHints renderingHints = null;
            if (graphics instanceof Graphics2D) {
                renderingHints = ((Graphics2D)graphics).getRenderingHints();
                if (bl4) {
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                } else {
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                }
            }
            graphics.setFont(font);
            FontMetrics fontMetrics = font instanceof JFont ? ((JFont)((Object)font)).getFontMetrics() : graphics.getFontMetrics();
            Vector<String> vector = new Vector<String>();
            if (bl) {
                dimension = Painter.layoutText(vector, string, n, rectangle.width, font, c);
            } else {
                String string2 = Painter.adjustString(string);
                vector.addElement(string2);
                dimension = new Dimension(fontMetrics.stringWidth(string2), fontMetrics.getAscent() + fontMetrics.getDescent());
            }
            if (dimension.width > rectangle.width || dimension.height > rectangle.height) {
                n2 = n3;
            }
            int n4 = rectangle.y;
            switch (n2) {
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    n4 += (rectangle.height - dimension.height) / 2;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    n4 += rectangle.height - dimension.height;
                }
            }
            int n5 = fontMetrics.getAscent();
            int n6 = fontMetrics.getHeight() + n;
            graphics.setColor(color);
            for (int i = 0; i < vector.size() && n4 < rectangle.y + rectangle.height; n4 += n6 - n5, ++i) {
                int n7;
                String string3;
                if ((n4 += n5) <= 0 || (string3 = (String)vector.elementAt(i)).length() <= 0) continue;
                int n8 = fontMetrics.stringWidth(string3);
                int n9 = rectangle.x + (font.isItalic() ? 1 : 0);
                switch (n2) {
                    case 2: 
                    case 5: 
                    case 8: {
                        n9 += (rectangle.width - n8) / 2;
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 9: {
                        n9 += rectangle.width - n8 - 1;
                    }
                }
                if (vector.size() > 1 && n2 > 9) {
                    n7 = 1;
                    char[] cArray = string3.toCharArray();
                    for (int j = 0; n7 != 0 && j < cArray.length; n7 &= cArray[j] == ' ' || cArray[j] == '\n' ? 1 : 0, ++j) {
                    }
                    if (i == vector.size() - 1) {
                        n7 = 1;
                    }
                    if (n7 == 0) {
                        int n10;
                        while ((n10 = string3.length()) > 0 && string3.charAt(n10 - 1) == ' ') {
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                        while ((n10 = string3.length()) > 0 && string3.charAt(0) == ' ') {
                            string3 = string3.substring(1);
                        }
                        n8 = fontMetrics.stringWidth(string3);
                        int n11 = string3.indexOf(32);
                        if (n11 > 0 && n11 < n10 - 1) {
                            int n12 = fontMetrics.charWidth(' ');
                            while ((n8 = fontMetrics.stringWidth(string3)) < rectangle.width - n12) {
                                int n13 = (rectangle.width - n8) / n12;
                                string3 = Painter.adjustJustifyString(string3, n13);
                            }
                        }
                    }
                }
                graphics.drawString(string3, n9 + 1, n4);
                n7 = Math.max((font.getSize() + (font.isBold() ? 2 : 0)) / 10, 1);
                n8 += 2;
                if (bl2) {
                    if (n4 + 2 + n7 <= rectangle.height + rectangle.y) {
                        graphics.fillRect(n9, n4 + 2, n8, n7);
                    } else {
                        graphics.fillRect(n9, rectangle.height + rectangle.y - n7, n8, n7);
                    }
                }
                if (!bl3) continue;
                graphics.fillRect(n9, n4 - fontMetrics.getAscent() / 2 + 1, n8, n7);
            }
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHints(renderingHints);
            }
        }
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Painter.drawText(graphics, rectangle, 0, string, font, color, bl, bl2, bl3, n, n, WRAPCHAR, bl4);
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n, char c, boolean bl4) {
        Painter.drawText(graphics, rectangle, 0, string, font, color, bl, bl2, bl3, n, n, c, bl4);
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, int n, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        Painter.drawText(graphics, rectangle, n, string, font, color, bl, bl2, bl3, n2, n2, WRAPCHAR, bl4);
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, int n, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n2, char c, boolean bl4) {
        Painter.drawText(graphics, rectangle, n, string, font, color, bl, bl2, bl3, n2, n2, c, bl4);
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, int n, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n2, int n3, char c, boolean bl4) {
        if (!(font instanceof JFont) && JavaEnv.is2D(graphics)) {
            Painter2D.drawText(graphics, rectangle, n, string, font, color, bl, bl2, bl3, n2, n3, c, bl4);
        } else {
            Painter.VALUE_FRACTIONALMETRICS_ON(graphics, rectangle, n, string, font, color, bl, bl2, bl3, n2, n3, c, bl4);
        }
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n) {
        Painter.drawText(graphics, rectangle, 0, string, font, color, bl, bl2, bl3, n, n, WRAPCHAR);
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n, char c) {
        Painter.drawText(graphics, rectangle, 0, string, font, color, bl, bl2, bl3, n, n, c);
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, int n, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n2) {
        Painter.drawText(graphics, rectangle, n, string, font, color, bl, bl2, bl3, n2, n2, WRAPCHAR);
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, int n, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n2, char c) {
        Painter.drawText(graphics, rectangle, n, string, font, color, bl, bl2, bl3, n2, n2, c);
    }

    public static void drawText(Graphics graphics, Rectangle rectangle, int n, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n2, int n3, char c) {
        if (!(font instanceof JFont) && JavaEnv.is2D(graphics)) {
            Painter2D.drawText(graphics, rectangle, n, string, font, color, bl, bl2, bl3, n2, n3, c);
        } else {
            Painter.WRAPCHAR(graphics, rectangle, n, string, font, color, bl, bl2, bl3, n2, n3, c);
        }
    }

    private static void WRAPCHAR(Graphics graphics, Rectangle rectangle, int n, String string, Font font, Color color, boolean bl, boolean bl2, boolean bl3, int n2, int n3, char c) {
        Painter.VALUE_FRACTIONALMETRICS_ON(graphics, rectangle, n, string, font, color, bl, bl2, bl3, n2, n3, c, true);
    }

    public static void drawBorder(Graphics graphics, Dimension dimension, Color color, Color color2, int n, int n2, int n3, int n4, int n5, boolean bl, Color color3, int n6) {
        Painter.drawBorder(graphics, dimension, color, color2, n, n2, n3, n4, n5, bl, bl, bl, bl, color3, n6);
    }

    public static void drawBorder(Graphics graphics, Dimension dimension, Color color, Color color2, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color3, int n6) {
        int n7 = dimension.width;
        int n8 = dimension.height;
        if (bl) {
            n8 -= n6;
        }
        if (bl2) {
            n7 -= n6;
        }
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n7, n8);
        }
        if (n > 0 && color2 != null && !color2.equals(color)) {
            if (n2 != 0) {
                if (n2 != 5) {
                    Painter.drawLine(graphics, 0, (n - 1) / 2, n7 - 1, (n - 1) / 2, color2, n, n2);
                } else {
                    Painter.drawLine(graphics, 0, (n - 1) / 2, n7 - 1, (n - 1) / 2, color2, n, 1);
                    Painter.drawLine(graphics, 0, n * 2 + (n - 1) / 2, n7 - 1, n * 2 + (n - 1) / 2, color2, n, 1);
                }
            }
            if (n3 != 0) {
                if (n3 != 5) {
                    Painter.drawLine(graphics, 0, n8 - 1 - n / 2, n7 - 1, n8 - 1 - n / 2, color2, n, n3);
                } else {
                    Painter.drawLine(graphics, 0, n8 - 1 - n / 2, n7 - 1, n8 - 1 - n / 2, color2, n, 1);
                    Painter.drawLine(graphics, 0, n8 - 1 - n * 2 - n / 2, n7 - 1, n8 - 1 - n * 2 - n / 2, color2, n, 1);
                }
            }
            if (n4 != 0) {
                if (n4 != 5) {
                    Painter.drawLine(graphics, (n - 1) / 2, 0, (n - 1) / 2, n8 - 1, color2, n, n4);
                } else {
                    Painter.drawLine(graphics, (n - 1) / 2, 0, (n - 1) / 2, n8 - 1, color2, n, 1);
                    Painter.drawLine(graphics, n * 2 + (n - 1) / 2, 0, n * 2 + (n - 1) / 2, n8 - 1, color2, n, 1);
                }
            }
            if (n5 != 0) {
                if (n5 != 5) {
                    Painter.drawLine(graphics, n7 - 1 - n / 2, 0, n7 - 1 - n / 2, n8 - 1, color2, n, n5);
                } else {
                    Painter.drawLine(graphics, n7 - 1 - n / 2, 0, n7 - 1 - n / 2, n8 - 1, color2, n, 1);
                    Painter.drawLine(graphics, n7 - 1 - n * 2 - n / 2, 0, n7 - 1 - n * 2 - n / 2, n8 - 1, color2, n, 1);
                }
            }
        }
        if ((bl || bl2) && color3 != null && n6 > 0) {
            int n9;
            graphics.setColor(color3);
            if (bl) {
                n9 = bl3 ? n6 : 0;
                graphics.fillRect(n9, dimension.height - n6, dimension.width - n9, n6);
            }
            if (bl2) {
                n9 = bl4 ? n6 : 0;
                graphics.fillRect(dimension.width - n6, n9, n6, dimension.height - n9);
            }
        }
    }

    public static void drawPattern(Graphics graphics, Rectangle rectangle, Color color, int n) {
        if (color != null) {
            graphics.setColor(color);
            switch (n) {
                case 1: {
                    Painter.abs(graphics, rectangle, 2);
                    break;
                }
                case 5: {
                    Painter.abs(graphics, rectangle, 6);
                    break;
                }
                case 2: {
                    Painter.addElement(graphics, rectangle, 6, 1);
                    break;
                }
                case 3: {
                    Painter.addElement(graphics, rectangle, 6, 2);
                    break;
                }
                case 4: {
                    Painter.addElement(graphics, rectangle, 6, 3);
                }
            }
        }
    }

    private static void abs(Graphics graphics, Rectangle rectangle, int n) {
        int n2;
        int n3;
        int n4 = n3 = rectangle.x;
        int n5 = n2 = rectangle.y;
        int n6 = rectangle.width + n3;
        int n7 = rectangle.height + n2;
        graphics.drawLine(n3, n2, n3, n2);
        if (rectangle.width > rectangle.height) {
            while (n2 + n < n7) {
                graphics.drawLine(n3 + n, n5, n4, n2 + n);
                n3 += n;
                n2 += n;
            }
            n4 = n2 + n - n7 + n4;
            while (n3 + n < n6) {
                graphics.drawLine(n3 + n, n5, n4, n7);
                n3 += n;
                n4 += n;
            }
            for (n5 = n3 + n - n6 + n5; n5 <= n7; n5 += n) {
                graphics.drawLine(n6, n5, n4, n7);
                n4 += n;
            }
        } else {
            while (n3 + n < n6) {
                graphics.drawLine(n3 + n, n5, n4, n2 + n);
                n3 += n;
                n2 += n;
            }
            n5 = n3 + n - n6 + n5;
            while (n2 + n < n7) {
                graphics.drawLine(n6, n5, n4, n2 + n);
                n2 += n;
                n5 += n;
            }
            n4 = n2 + n - n7 + n4;
            while (n4 <= n6) {
                graphics.drawLine(n6, n5, n4, n7);
                n4 += n;
                n5 += n;
            }
        }
    }

    private static void addElement(Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3;
        int n4 = rectangle.x;
        int n5 = rectangle.x + rectangle.width;
        int n6 = rectangle.y;
        int n7 = rectangle.y + rectangle.height;
        if ((n2 & 1) != 0) {
            for (n3 = n6 + n - 1; n3 < n7 + 1; n3 += n) {
                graphics.drawLine(n4, n3, n5, n3);
            }
        }
        if ((n2 & 2) != 0) {
            for (n3 = n4 + n - 1; n3 < n5 + 1; n3 += n) {
                graphics.drawLine(n3, n6, n3, n7);
            }
        }
    }

    private static void adjustJustifyString(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, int n5, int n6, int n7, int n8) {
        if (color != null) {
            graphics.setColor(color);
            graphics.fillArc(n, n2, n3, n4, n7, n8);
        }
        if (n6 != 0 && color2 != null && !color2.equals(color)) {
            graphics.setColor(color2);
            for (int i = 0; i < n5; ++i) {
                graphics.drawArc(n + i, n2 + i, n3 - 2 * i - 1, n4 - 2 * i - 1, n7, n8);
            }
        }
    }

    private static void adjustString(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, int n5, int n6) {
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(n, n2, n3, n4);
        }
        if (n6 != 0 && color2 != null && !color2.equals(color)) {
            graphics.setColor(color2);
            int n7 = 10;
            int n8 = 5;
            switch (n6) {
                case 1: {
                    for (int i = 0; i < n5; ++i) {
                        graphics.drawRect(n + i, n2 + i, n3 - 1 - 2 * i, n4 - 1 - 2 * i);
                    }
                    break;
                }
                case 2: {
                    int n9;
                    for (n9 = 0; n9 < n3; n9 += n7 + n8) {
                        graphics.fillRect(n + n9, n2, n7, n5);
                        graphics.fillRect(n + n9, n4 - n5, n7, n5);
                    }
                    for (n9 = 0; n9 < n4; n9 += n7 + n8) {
                        graphics.fillRect(n, n2 + n9, n5, n7);
                        graphics.fillRect(n3 - n5, n2 + n9, n5, n7);
                    }
                    break;
                }
                case 3: {
                    int n10;
                    for (n10 = 0; n10 < n3; n10 += n8 + n5) {
                        graphics.fillRect(n + n10, n2, n5, n5);
                        graphics.fillRect(n + n10, n4 - n5, n5, n5);
                    }
                    for (n10 = 0; n10 < n4; n10 += n8 + n5) {
                        graphics.fillRect(n, n2 + n10, n5, n5);
                        graphics.fillRect(n3 - n5, n2 + n10, n5, n5);
                    }
                    break;
                }
                case 4: {
                    int n11;
                    int n12 = n7 + n8 * 2 + n5;
                    for (n11 = 0; n11 < n3; n11 += n12) {
                        graphics.fillRect(n + n11, n2, n7, n5);
                        graphics.fillRect(n + n11 + n7 + n8, n2, n5, n5);
                        graphics.fillRect(n + n11, n4 - n5, n7, n5);
                        graphics.fillRect(n + n11 + n7 + n8, n4 - n5, n5, n5);
                    }
                    for (n11 = 0; n11 < n4; n11 += n12) {
                        graphics.fillRect(n, n2 + n11, n5, n7);
                        graphics.fillRect(n, n2 + n11 + n7 + n8, n5, n5);
                        graphics.fillRect(n3 - n5, n2 + n11, n5, n7);
                        graphics.fillRect(n3 - n5, n2 + n11 + n7 + n8, n5, n5);
                    }
                    break;
                }
            }
        }
    }

    private static void append(Graphics graphics, int n, int n2, int n3, int n4, Color color, int n5, int n6) {
        if (color != null) {
            Shape shape = graphics.getClip();
            graphics.setColor(color);
            int n7 = Math.abs(n - n3) + 1;
            int n8 = Math.abs(n2 - n4) + 1;
            if (n7 > n8 && n8 <= n5) {
                n2 = n4;
                n8 = 0;
            } else if (n7 < n8 && n7 <= n5) {
                n = n3;
                n7 = 0;
            }
            if (n6 == 1) {
                for (int i = 1; i <= n5; ++i) {
                    boolean bl = i % 2 == 0;
                    int n9 = i / 2;
                    if (n7 > n8) {
                        graphics.drawLine(n, n2 + (bl ? n9 : -n9), n3, n4 + (bl ? n9 : -n9));
                        continue;
                    }
                    graphics.drawLine(n + (bl ? n9 : -n9), n2, n3 + (bl ? n9 : -n9), n4);
                }
            } else {
                int n10 = 10;
                int n11 = 5;
                int n12 = 0;
                boolean bl = n < n3;
                boolean bl2 = n2 < n4;
                switch (n6) {
                    case 2: {
                        n12 = n10 + n11;
                        for (int i = 1; i <= n5; ++i) {
                            int n13;
                            int n14;
                            int n15;
                            boolean bl3 = i % 2 == 0;
                            int n16 = i / 2;
                            if (n7 > n8) {
                                for (n15 = bl ? n : n3; n15 < (bl ? n3 : n); n15 += n12) {
                                    if (bl) {
                                        n14 = n2 + n15 * n8 / n7 * (bl2 ? 1 : -1);
                                        n13 = n2 + (n15 + n10) * n8 / n7 * (bl2 ? 1 : -1);
                                    } else {
                                        n14 = n4 + n15 * n8 / n7 * (bl2 ? -1 : 1);
                                        n13 = n4 + (n15 + n10) * n8 / n7 * (bl2 ? -1 : 1);
                                    }
                                    graphics.drawLine(n15, n14 + (bl3 ? n16 : -n16), n15 + n10, n13 + (bl3 ? n16 : -n16));
                                }
                                continue;
                            }
                            for (n15 = bl2 ? n2 : n4; n15 < (bl2 ? n4 : n2); n15 += n12) {
                                if (bl2) {
                                    n14 = n + n15 * n7 / n8 * (bl ? 1 : -1);
                                    n13 = n + (n15 + n10) * n7 / n8 * (bl ? 1 : -1);
                                } else {
                                    n14 = n3 + n15 * n7 / n8 * (bl ? -1 : 1);
                                    n13 = n3 + (n15 + n10) * n7 / n8 * (bl ? -1 : 1);
                                }
                                graphics.drawLine(n14 + (bl3 ? n16 : -n16), n15, n13 + (bl3 ? n16 : -n16), n15 + n10);
                            }
                        }
                        break;
                    }
                    case 3: {
                        n12 = n5 + n11;
                        for (int i = 1; i <= n5; ++i) {
                            int n17;
                            int n18;
                            int n19;
                            boolean bl4 = i % 2 == 0;
                            int n20 = i / 2;
                            if (n7 > n8) {
                                for (n19 = bl ? n : n3; n19 < (bl ? n3 : n); n19 += n12) {
                                    if (bl) {
                                        n18 = n2 + n19 * n8 / n7 * (bl2 ? 1 : -1);
                                        n17 = n2 + (n19 + n5) * n8 / n7 * (bl2 ? 1 : -1);
                                    } else {
                                        n18 = n4 + n19 * n8 / n7 * (bl2 ? -1 : 1);
                                        n17 = n4 + (n19 + n5) * n8 / n7 * (bl2 ? -1 : 1);
                                    }
                                    graphics.drawLine(n19, n18 + (bl4 ? n20 : -n20), n19 + n5, n17 + (bl4 ? n20 : -n20));
                                }
                                continue;
                            }
                            for (n19 = bl2 ? n2 : n4; n19 < (bl2 ? n4 : n2); n19 += n12) {
                                if (bl2) {
                                    n18 = n + n19 * n7 / n8 * (bl ? 1 : -1);
                                    n17 = n + (n19 + n5) * n7 / n8 * (bl ? 1 : -1);
                                } else {
                                    n18 = n3 + n19 * n7 / n8 * (bl ? -1 : 1);
                                    n17 = n3 + (n19 + n5) * n7 / n8 * (bl ? -1 : 1);
                                }
                                graphics.drawLine(n18 + (bl4 ? n20 : -n20), n19, n17 + (bl4 ? n20 : -n20), n19 + n5);
                            }
                        }
                        break;
                    }
                    case 4: {
                        n12 = n10 + 2 * n11 + n5;
                        for (int i = 1; i <= n5; ++i) {
                            int n21;
                            int n22;
                            int n23;
                            boolean bl5 = i % 2 == 0;
                            int n24 = i / 2;
                            if (n7 > n8) {
                                for (n23 = bl ? n : n3; n23 < (bl ? n3 : n); n23 += n12) {
                                    if (bl) {
                                        n22 = n2 + n23 * n8 / n7 * (bl2 ? 1 : -1);
                                        n21 = n2 + (n23 + n10) * n8 / n7 * (bl2 ? 1 : -1);
                                    } else {
                                        n22 = n4 + n23 * n8 / n7 * (bl2 ? -1 : 1);
                                        n21 = n4 + (n23 + n10) * n8 / n7 * (bl2 ? -1 : 1);
                                    }
                                    graphics.drawLine(n23, n22 + (bl5 ? n24 : -n24), n23 + n10, n21 + (bl5 ? n24 : -n24));
                                    if (bl) {
                                        n22 = n2 + (n23 + n10 + n11) * n8 / n7 * (bl2 ? 1 : -1);
                                        n21 = n2 + (n23 + n10 + n11 + n5) * n8 / n7 * (bl2 ? 1 : -1);
                                    } else {
                                        n22 = n4 + (n23 + n10 + n11) * n8 / n7 * (bl2 ? -1 : 1);
                                        n21 = n4 + (n23 + n10 + n11 + n5) * n8 / n7 * (bl2 ? -1 : 1);
                                    }
                                    graphics.drawLine(n23 + n10 + n11, n22 + (bl5 ? n24 : -n24), n23 + n10 + n11 + n5, n21 + (bl5 ? n24 : -n24));
                                }
                                continue;
                            }
                            for (n23 = bl2 ? n2 : n4; n23 < (bl2 ? n4 : n2); n23 += n12) {
                                if (bl2) {
                                    n22 = n + n23 * n7 / n8 * (bl ? 1 : -1);
                                    n21 = n + (n23 + n10) * n7 / n8 * (bl ? 1 : -1);
                                } else {
                                    n22 = n3 + n23 * n7 / n8 * (n3 < n ? 1 : -1);
                                    n21 = n3 + (n23 + n10) * n7 / n8 * (n3 < n ? 1 : -1);
                                }
                                graphics.drawLine(n22 + (bl5 ? n24 : -n24), n23, n21 + (bl5 ? n24 : -n24), n23 + n10);
                                if (bl2) {
                                    n22 = n + (n23 + n10 + n11) * n7 / n8 * (bl ? 1 : -1);
                                    n21 = n + (n23 + n10 + n11 + n5) * n7 / n8 * (bl ? 1 : -1);
                                } else {
                                    n22 = n3 + (n23 + n10 + n11) * n7 / n8 * (bl ? -1 : 1);
                                    n21 = n3 + (n23 + n10 + n11 + n5) * n7 / n8 * (bl ? -1 : 1);
                                }
                                graphics.drawLine(n22 + (bl5 ? n24 : -n24), n23 + n10 + n11, n21 + (bl5 ? n24 : -n24), n23 + n10 + n11 + n5);
                            }
                        }
                        break;
                    }
                }
            }
            graphics.setClip(shape);
        }
    }

    private static void charAt(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, int n5, int n6) {
        if (color != null) {
            graphics.setColor(color);
            graphics.fillOval(n, n2, n3, n4);
        }
        if (n6 != 0 && color2 != null && !color2.equals(color)) {
            graphics.setColor(color2);
            for (int i = 0; i < n5; ++i) {
                graphics.drawOval(n + i, n2 + i, n3 - 2 * i - 1, n4 - 2 * i - 1);
            }
        }
    }

    private static void charWidth(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, int n5, int n6, int n7) {
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRoundRect(n, n2, n3, n4, n7, n7);
        }
        if (n6 != 0 && color2 != null && !color2.equals(color)) {
            graphics.setColor(color2);
            for (int i = 0; i < n5; ++i) {
                graphics.drawRoundRect(n + i, n2 + i, n3 - 2 * i - 1, n4 - 2 * i - 1, n7 - i, n7 - i);
            }
        }
    }

    public static void drawArc(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, int n5, int n6, int n7, int n8) {
        if (JavaEnv.is2D(graphics)) {
            Painter2D.drawArc(graphics, n, n2, n3, n4, color, color2, n5, n6, n7, n8);
        } else {
            Painter.adjustJustifyString(graphics, n, n2, n3, n4, color, color2, n5, n6, n7, n8);
        }
    }

    public static void drawBox(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, int n5, int n6) {
        if (JavaEnv.is2D(graphics)) {
            Painter2D.drawBox(graphics, n, n2, n3, n4, color, color2, n5, n6);
        } else {
            Painter.adjustString(graphics, n, n2, n3, n4, color, color2, n5, n6);
        }
    }

    public static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, Color color, int n5, int n6) {
        if (JavaEnv.is2D(graphics)) {
            Painter2D.drawLine(graphics, n, n2, n3, n4, color, n5, n6);
        } else {
            Painter.append(graphics, n, n2, n3, n4, color, n5, n6);
        }
    }

    public static void drawOval(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, int n5, int n6) {
        if (JavaEnv.is2D(graphics)) {
            Painter2D.drawOval(graphics, n, n2, n3, n4, color, color2, n5, n6);
        } else {
            Painter.charAt(graphics, n, n2, n3, n4, color, color2, n5, n6);
        }
    }

    public static void drawRoundBox(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, int n5, int n6, int n7) {
        if (JavaEnv.is2D(graphics)) {
            Painter2D.drawRoundBox(graphics, n, n2, n3, n4, color, color2, n5, n6, n7);
        } else {
            Painter.charWidth(graphics, n, n2, n3, n4, color, color2, n5, n6, n7);
        }
    }

    public static Image mergeImage(Image image, Image image2) {
        Object object;
        Component component = new Component(){};
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        int n3 = image2.getWidth(component);
        int n4 = image2.getHeight(component);
        int n5 = Math.min(n, n3);
        int n6 = Math.min(n2, n4);
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[n5 * n6];
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
            pixelGrabber.grabPixels();
            object = new PixelGrabber(image2, 0, 0, n5, n6, nArray2, 0, n5);
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                int n7 = nArray2[i * n5 + j];
                if ((n7 >> 24 & 0xFF) == 0) continue;
                nArray[i * n + j] = n7;
            }
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        object = toolkit.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        return object;
    }

    public static String adjustJustifyString(String string, int n) {
        if (n > 0) {
            char[] cArray = string.toCharArray();
            Vector<Integer> vector = new Vector<Integer>();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != ' ') continue;
                vector.addElement(new Integer(i));
            }
            int[] nArray = new int[vector.size()];
            if (vector.size() == 1) {
                int n2 = string.indexOf(32);
                StringBuffer stringBuffer = new StringBuffer(string);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.insert(n2++, ' ');
                }
                string = stringBuffer.toString();
            } else {
                int n3;
                for (n3 = 0; n3 < vector.size(); ++n3) {
                    nArray[n3] = (Integer)vector.elementAt(n3);
                }
                if (nArray.length < n) {
                    n3 = n % nArray.length;
                    int n4 = n / nArray.length;
                    cArray = new char[n4];
                    for (int i = 0; i < n4; ++i) {
                        cArray[i] = 32;
                    }
                    string = Painter.charsHeight(string, nArray, cArray, nArray.length);
                    if (n3 > 0) {
                        int n5;
                        char[] cArray2 = string.toCharArray();
                        vector = new Vector();
                        for (n5 = 0; n5 < cArray2.length; ++n5) {
                            if (cArray2[n5] != ' ') continue;
                            vector.addElement(new Integer(n5));
                        }
                        nArray = new int[vector.size()];
                        for (n5 = 0; n5 < vector.size(); ++n5) {
                            nArray[n5] = (Integer)vector.elementAt(n5);
                        }
                        cArray = new char[]{' '};
                        string = Painter.charsHeight(string, nArray, cArray, n3);
                    }
                } else if (nArray.length >= n) {
                    cArray = new char[]{' '};
                    string = Painter.charsHeight(string, nArray, cArray, n);
                }
            }
        }
        return string;
    }

    private static String charsHeight(String string, int[] nArray, char[] cArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            stringBuffer.insert(nArray[i] + n2, cArray);
            n2 += cArray.length;
        }
        return stringBuffer.toString();
    }

    public static Dimension layoutText(Vector vector, String string, int n, Font font, boolean bl) {
        return Painter.layoutText(vector, string, 0, n, font, WRAPCHAR, bl);
    }

    public static Dimension layoutText(Vector vector, String string, int n, int n2, Font font, char c, boolean bl) {
        return Painter.charsWidth(vector, string, n, n2, font, c, bl);
    }

    private static Dimension charsWidth(Vector vector, String string, int n, int n2, Font font, char c, boolean bl) {
        boolean bl2;
        Dimension dimension = new Dimension(n2, 0);
        boolean bl3 = bl2 = !Character.isISOControl(c);
        if (string != null) {
            string = Painter.adjustString(string);
            Vector<String> vector2 = new Vector<String>();
            if (vector == null) {
                vector = new Vector<String>();
            }
            int n3 = -1;
            do {
                int n4;
                if ((n3 = string.indexOf(c, n4 = n3 + 1)) >= 0) {
                    if (bl2) {
                        vector2.addElement(string.substring(n4, n3 + 1));
                        continue;
                    }
                    vector2.addElement(string.substring(n4, n3));
                    continue;
                }
                if (n4 == string.length()) continue;
                vector2.addElement(string.substring(n4));
            } while (n3 >= 0);
            FontMetrics fontMetrics = null;
            float f = 0.0f;
            if (bl) {
                f = TextBreaker.charsHeight("j", font, bl);
            } else {
                if (font instanceof JFont) {
                    fontMetrics = ((JFont)((Object)font)).getFontMetrics();
                } else {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    fontMetrics = toolkit.getFontMetrics(font);
                }
                f = fontMetrics.getHeight() + (n > 0 ? n : 0);
            }
            int n5 = 0;
            int n6 = vector2.size();
            for (int i = 0; i < n6; ++i) {
                Vector vector3 = Painter.lineBreaker((String)vector2.elementAt(i), n2, font, bl);
                for (int j = 0; j < vector3.size(); ++j) {
                    String string2 = (String)vector3.elementAt(j);
                    int n7 = TextBreaker.charsWidth(string2, font, bl);
                    if (n7 <= n2) {
                        n5 = Math.max(n7, n5);
                    }
                    vector.addElement(string2);
                }
            }
            n3 = vector.size();
            if (bl) {
                dimension = new Dimension(n5, (int)(f * (float)n3));
            } else {
                n6 = fontMetrics.getLeading();
                dimension = new Dimension(n5, (int)f * n3 - n - n6 + (n3 > 1 ? (n6 < 1 ? 4 : 2 * n6) : 0));
            }
        }
        return dimension;
    }
}

