/*
 * Decompiled with CFR 0.152.
 */
package guitools;

import guitools.ParentFrameStatus;
import guitools.TopableComp;
import guitools.TopableContainerLayout;
import guitools.TopableContainerListener;
import guitools.UIResource;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import jet.JViewResource;

public class TopableContainer
implements WindowListener,
MouseListener,
ActionListener,
ItemListener {
    Checkbox chkboxOnTop = new Checkbox(JViewResource.getDlgText("TopableContainer", "AlwaysOnTop"));
    Frame parentFrame;
    TopableComp comp;
    private String I;
    private Window SEDU = null;
    private Vector add;
    private boolean addElement = false;
    private boolean addItemListener = false;
    private ParentFrameStatus addMouseListener = new ParentFrameStatus();
    private PopupMenu addWindowListener = new PopupMenu();
    private CheckboxMenuItem alwaysOnTopChanged = new CheckboxMenuItem(JViewResource.getDlgText("TopableContainer", "AlwaysOnTop"));

    public TopableContainer(Frame frame, Rectangle rectangle, boolean bl, String string, TopableComp topableComp) {
        this.addElement = bl;
        this.parentFrame = frame;
        this.comp = topableComp;
        this.I = string;
        Font font = UIResource.getFont("Control Font");
        FontMetrics fontMetrics = this.chkboxOnTop.getFontMetrics(font);
        this.chkboxOnTop.setSize(fontMetrics.stringWidth(this.chkboxOnTop.getLabel()) + 25, fontMetrics.getHeight() + 2);
        this.chkboxOnTop.setFont(font);
        this.chkboxOnTop.addItemListener(this);
        this.chkboxOnTop.setState(bl);
        if (TopableContainer.I()) {
            this.chkboxOnTop.setVisible(false);
        }
        if (!TopableContainer.I()) {
            this.addMouseListener();
        }
        if (bl) {
            this.SEDU = new Dialog(frame, string, false);
            ((Dialog)this.SEDU).setResizable(true);
        } else {
            this.SEDU = new Frame(string);
        }
        this.addWindowListener(rectangle);
        this.SEDU.setVisible(true);
        this.addItemListener = true;
    }

    private static boolean I() {
        return System.getProperty("os.name").equals("Solaris");
    }

    public Frame getParent() {
        return this.parentFrame;
    }

    public void setTitle(String string) {
        if (this.SEDU != null) {
            this.SEDU.setName(string);
        }
        this.I = string;
    }

    public void contentChanged(Frame frame) {
        if (this.addItemListener) {
            if (this.parentFrame == frame) {
                this.addElement();
            }
        } else {
            this.addMouseListener.parentContentChanged(frame);
        }
    }

    public void setParent(Frame frame) {
        if (this.addItemListener) {
            if (this.parentFrame != frame) {
                this.SEDU(frame);
            }
        } else {
            this.addMouseListener.setParent(frame);
            this.parentFrame = frame;
        }
    }

    public void setAlwaysOnTop(boolean bl) {
        if (this.addItemListener) {
            if (this.addElement != bl) {
                this.add(bl);
            }
        } else {
            this.addElement = bl;
        }
    }

    private void SEDU(Frame frame) {
        if (this.addElement) {
            Rectangle rectangle = this.SEDU.getBounds();
            this.SEDU.setVisible(false);
            this.SEDU.remove((Component)((Object)this.comp));
            this.SEDU.remove(this.addWindowListener);
            this.SEDU.remove(this.chkboxOnTop);
            this.SEDU.dispose();
            this.SEDU = new Dialog(frame, this.I, false);
            this.addWindowListener(rectangle);
            ((Dialog)this.SEDU).setResizable(true);
            this.SEDU.setVisible(this.addItemListener);
            if (this.addItemListener) {
                this.SEDU.invalidate();
                this.SEDU.validate();
            }
        }
        this.parentFrame = frame;
        this.addElement();
    }

    private void add(boolean bl) {
        Rectangle rectangle = this.SEDU.getBounds();
        this.SEDU.setVisible(false);
        this.SEDU.remove((Component)((Object)this.comp));
        this.SEDU.remove(this.addWindowListener);
        this.SEDU.remove(this.chkboxOnTop);
        this.SEDU.dispose();
        if (bl) {
            this.SEDU = new Dialog(this.parentFrame, this.I, false);
            ((Dialog)this.SEDU).setResizable(true);
        } else {
            this.SEDU = new Frame(this.I);
        }
        this.addWindowListener(rectangle);
        this.SEDU.setVisible(this.addItemListener);
        this.addElement = bl;
        this.alwaysOnTopChanged.setState(bl);
        this.chkboxOnTop.setState(bl);
    }

    private void addElement() {
        this.comp.update(this.parentFrame);
    }

    private void addItemListener() {
        if (!this.addMouseListener.cleared()) {
            if (this.addMouseListener.parentChanged()) {
                this.SEDU(this.parentFrame);
            } else {
                if (this.addMouseListener.alwaysOnTopChanged(this.addElement)) {
                    this.add(this.addElement);
                }
                if (this.addMouseListener.contentChanged()) {
                    this.addElement();
                }
            }
            this.addMouseListener.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerListener(TopableContainerListener topableContainerListener) {
        if (this.add == null) {
            this.add = new Vector(1);
        }
        Vector vector = this.add;
        synchronized (vector) {
            if (!this.add.contains(topableContainerListener)) {
                this.add.addElement(topableContainerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainerListener(TopableContainerListener topableContainerListener) {
        if (this.add != null) {
            Vector vector = this.add;
            synchronized (vector) {
                if (this.add.contains(topableContainerListener)) {
                    this.add.removeElement(topableContainerListener);
                }
            }
        }
    }

    public boolean isAlwaysOnTop() {
        return this.addElement;
    }

    public void setVisible(boolean bl) {
        if (bl != this.SEDU.isVisible()) {
            if (bl) {
                this.addItemListener();
                this.addMouseListener.clear();
            } else {
                this.addMouseListener.init(this.parentFrame, this.addElement);
            }
            this.SEDU.setVisible(bl);
        }
        this.addItemListener = bl;
    }

    public boolean isVisible() {
        return this.addItemListener;
    }

    public void dispose() {
        this.SEDU.dispose();
    }

    public Rectangle getBounds() {
        return this.SEDU.getBounds();
    }

    private void addMouseListener() {
        this.addWindowListener.add(this.alwaysOnTopChanged);
        this.alwaysOnTopChanged.addItemListener(this);
    }

    private void addWindowListener(Rectangle rectangle) {
        this.SEDU.setBackground(UIResource.getColor("Control Background"));
        this.SEDU.setLayout(new TopableContainerLayout(this));
        this.SEDU.setBounds(rectangle);
        this.SEDU.addWindowListener(this);
        this.SEDU.addMouseListener(this);
        this.SEDU.add((Component)((Object)this.comp), "");
        this.SEDU.add((Component)this.chkboxOnTop, "");
        this.SEDU.add(this.addWindowListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.add != null) {
            Vector vector = this.add;
            synchronized (vector) {
                int n = this.add.size();
                for (int i = 0; i < n; ++i) {
                    ((TopableContainerListener)this.add.elementAt(i)).closing(this);
                }
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (mouseEvent.isPopupTrigger()) {
            this.alwaysOnTopChanged.setState(this.addElement);
            if (component instanceof Container) {
                Insets insets = ((Container)component).getInsets();
                this.addWindowListener.show(component, mouseEvent.getX() - insets.left, mouseEvent.getY() - insets.top);
            } else {
                this.addWindowListener.show(component, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        this.setAlwaysOnTop(bl);
        if (this.add != null) {
            Vector vector = this.add;
            synchronized (vector) {
                int n = this.add == null ? 0 : this.add.size();
                for (int i = 0; i < n; ++i) {
                    ((TopableContainerListener)this.add.elementAt(i)).alwaysOnTopChanged(this, bl);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
    }
}

