/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.Editable;
import guitools.toolkit.EditablePaintBoard;
import guitools.toolkit.EditablePeer;
import guitools.toolkit.Grid;
import guitools.toolkit.TComponent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import jet.controls.editor.PropertyAtomicDoAction;

public class EComponent
extends TComponent
implements EditablePeer {
    protected int status = 0;
    protected int curPos = 15;
    protected Editable editable;

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int n) {
        if (this.tpb != null && this.canBeSelected()) {
            ((EditablePaintBoard)this.tpb).setStatus(this, n);
            this.status = n;
        }
    }

    @Override
    public Editable getEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(Editable editable) {
        this.editable = editable;
    }

    @Override
    public void updateEditableBounds() {
        if (this.editable != null && this.tpb != null) {
            if (this.canBeEdited()) {
                this.editable.setBounds(this.mapBoundsToBoard());
            } else {
                this.editable.setSize(0, 0);
                this.editable.setVisible(false);
            }
        }
    }

    @Override
    public int getEdCtrls() {
        return this.status == 4 ? 0 : 511;
    }

    @Override
    public int getCurPosMarks() {
        return this.curPos;
    }

    @Override
    public void setCurPosMarks(int n) {
        this.curPos = n & 0xF;
    }

    @Override
    public void paintExterior(Graphics graphics, int n, int n2, int n3) {
        int n4 = n / 2 - 2;
        int n5 = n2 / 2 - 2;
        int n6 = n - 5;
        int n7 = n2 - 5;
        --n;
        --n2;
        switch (this.status) {
            case 0: {
                break;
            }
            case 1: {
                this.drawSlashSide(graphics, 0, 0, n, n2, 8);
                break;
            }
            case 2: {
                boolean bl = this.eraser;
                this.eraser = false;
                if (bl) {
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, n, n2);
                }
                this.drawSlashPattern(graphics, 0, 0, n, n2, 8);
                this.paint(graphics);
                this.eraser = bl;
                break;
            }
            case 3: {
                graphics.setColor(Color.green);
                graphics.drawRect(0, 0, n, n2);
                graphics.setColor(Color.blue);
                if ((n3 & 0x1FF) == 0) break;
                if ((n3 & 1) != 0) {
                    graphics.fillRect(0, 0, 5, 5);
                }
                if ((n3 & 2) != 0) {
                    graphics.fillRect(n4, 0, 5, 5);
                }
                if ((n3 & 4) != 0) {
                    graphics.fillRect(n6, 0, 5, 5);
                }
                if ((n3 & 8) != 0) {
                    graphics.fillRect(0, n5, 5, 5);
                }
                if ((n3 & 0x10) != 0) {
                    graphics.fillRect(n6, n5, 5, 5);
                }
                if ((n3 & 0x20) != 0) {
                    graphics.fillRect(0, n7, 5, 5);
                }
                if ((n3 & 0x40) != 0) {
                    graphics.fillRect(n4, n7, 5, 5);
                }
                if ((n3 & 0x80) == 0) break;
                graphics.fillRect(n6, n7, 5, 5);
                break;
            }
            case 4: {
                this.paint(graphics);
            }
        }
    }

    @Override
    public void paintMarks(Graphics graphics) {
        Dimension dimension = this.getSize();
        --dimension.width;
        --dimension.height;
        if ((this.curPos & 0xF) != 0) {
            graphics.setColor(Color.black);
            if ((this.curPos & 1) != 0) {
                graphics.drawLine(0, 0, 2, 0);
                graphics.drawLine(0, 1, 0, 2);
            }
            if ((this.curPos & 2) != 0) {
                graphics.drawLine(dimension.width - 2, 0, dimension.width, 0);
                graphics.drawLine(dimension.width, 1, dimension.width, 2);
            }
            if ((this.curPos & 4) != 0) {
                graphics.drawLine(0, dimension.height - 2, 0, dimension.height);
                graphics.drawLine(1, dimension.height, 2, dimension.height);
            }
            if ((this.curPos & 8) != 0) {
                graphics.drawLine(dimension.width, dimension.height - 2, dimension.width, dimension.height);
                graphics.drawLine(dimension.width - 2, dimension.height, dimension.width - 1, dimension.height);
            }
        }
    }

    @Override
    public int inBlackBlock(int n, int n2, int n3) {
        Dimension dimension = this.getSize();
        int n4 = dimension.width / 2 - 2;
        int n5 = dimension.height / 2 - 2;
        int n6 = dimension.width - 5;
        int n7 = dimension.height - 5;
        if ((n3 & 0x1FF) != 0) {
            if ((n3 & 1) != 0 && n >= 0 && n < 5 && n2 >= 0 && n2 < 5) {
                return 1;
            }
            if ((n3 & 2) != 0 && n >= n4 && n < n4 + 5 && n2 >= 0 && n2 < 5) {
                return 2;
            }
            if ((n3 & 4) != 0 && n >= n6 && n < n6 + 5 && n2 >= 0 && n2 < 5) {
                return 4;
            }
            if ((n3 & 8) != 0 && n >= 0 && n < 5 && n2 >= n5 && n2 < n5 + 5) {
                return 8;
            }
            if ((n3 & 0x10) != 0 && n >= n6 && n < n6 + 5 && n2 >= n5 && n2 < n5 + 5) {
                return 16;
            }
            if ((n3 & 0x20) != 0 && n >= 0 && n < 5 && n2 >= n7 && n2 < n7 + 5) {
                return 32;
            }
            if ((n3 & 0x40) != 0 && n >= n4 && n < n4 + 5 && n2 >= n7 && n2 < n7 + 5) {
                return 64;
            }
            if ((n3 & 0x80) != 0 && n >= n6 && n < n6 + 5 && n2 >= n7 && n2 < n7 + 5) {
                return 128;
            }
            if ((n3 & 0x100) != 0) {
                return 256;
            }
        }
        return 0;
    }

    @Override
    public Cursor getEditorCursor(int n) {
        switch (n) {
            case 256: {
                return Cursor.getPredefinedCursor(13);
            }
            case 1: {
                return Cursor.getPredefinedCursor(6);
            }
            case 2: {
                return Cursor.getPredefinedCursor(8);
            }
            case 4: {
                return Cursor.getPredefinedCursor(7);
            }
            case 8: {
                return Cursor.getPredefinedCursor(10);
            }
            case 16: {
                return Cursor.getPredefinedCursor(11);
            }
            case 32: {
                return Cursor.getPredefinedCursor(4);
            }
            case 64: {
                return Cursor.getPredefinedCursor(9);
            }
            case 128: {
                return Cursor.getPredefinedCursor(5);
            }
        }
        return this.getCursor();
    }

    public void updateBoundsWithGrid() {
        Container container = this.getParent();
        if (container instanceof Grid) {
            Rectangle rectangle = this.getBounds();
            ((Grid)((Object)container)).alignRect(rectangle);
            this.setBounds(rectangle);
        }
    }

    @Override
    public boolean canBeSelected() {
        return this.canBeEdited();
    }

    @Override
    public boolean canBeMultiSelect() {
        return true;
    }

    @Override
    public boolean canBeEdited() {
        return (this.getEdCtrls() & 0x1FF) != 0;
    }

    @Override
    public boolean canBeEditedContent() {
        return false;
    }

    @Override
    public Object getOwner() {
        return null;
    }

    protected void drawSlashPattern(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.getForeground());
        n3 += n;
        n4 += n2;
        int n6 = n;
        int n7 = n2;
        int n8 = n;
        int n9 = n2;
        while (n6 < n3 || n8 < n3 || n7 < n4 || n9 < n4) {
            if ((n6 += n5) > n3) {
                n7 += n7 == n2 ? n6 - n3 : (n7 + n5 > n4 ? n4 - n7 : n5);
                n6 = n3;
            }
            if ((n9 += n5) > n4) {
                n8 += n8 == n ? n9 - n4 : (n8 + n5 > n3 ? n3 - n8 : n5);
                n9 = n4;
            }
            graphics.drawLine(n6, n7, n8, n9);
        }
    }

    protected void drawSlashSide(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.getForeground());
        int n6 = n5 >> 1;
        n3 += n;
        n4 += n2;
        int n7 = n;
        int n8 = n2;
        int n9 = n;
        int n10 = n2;
        while (n7 < n3 || n9 < n3 || n8 < n4 || n10 < n4) {
            if ((n7 += n5) > n3) {
                n8 += n8 == n2 ? n7 - n3 : (n8 + n5 > n4 ? n4 - n8 : n5);
                n7 = n3;
            }
            if ((n10 += n5) > n4) {
                n9 += n9 == n ? n10 - n4 : (n9 + n5 > n3 ? n3 - n9 : n5);
                n10 = n4;
            }
            graphics.drawLine(n7, n8, n7 - n6, n8 + n6);
            graphics.drawLine(n9 + n6, n10 - n6, n9, n10);
        }
    }

    @Override
    public void propertiesChanged(PropertyAtomicDoAction propertyAtomicDoAction) {
    }
}

