/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.Painter;
import guitools.toolkit.EditableFigure;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class EditableLine
extends EditableFigure {
    public static final int POSITIVESLOPE = 292;
    public static final int NEGATIVESLOPE = 385;
    public static final int RIGHTOBLIQUE = 0;
    public static final int HORIZONTAL = 1;
    public static final int LEFTOBLIQUE = 2;
    public static final int VERTICAL = 3;
    int lineStyle;
    int lineWidth;
    int x1;
    int y1;
    int x2;
    int y2;
    int tx1;
    int ty1;
    int tx2;
    int ty2;
    private Polygon SEDU;

    public EditableLine() {
        this.eraser = false;
    }

    public boolean isHorizntal() {
        return this.y1 == this.y2;
    }

    public boolean isVertical() {
        return this.x1 == this.x2;
    }

    public boolean isPositiveSlope() {
        return this.x1 > this.x2 && this.y1 < this.y2 || this.x1 < this.x2 && this.y1 > this.y2;
    }

    public boolean isNegativeSlope() {
        return this.x1 > this.x2 && this.y1 > this.y2 || this.x1 < this.x2 && this.y1 < this.y2;
    }

    public Point getPoint1() {
        return new Point(this.x1, this.y1);
    }

    public Point getPoint2() {
        return new Point(this.x2, this.y2);
    }

    void resetBoundary() {
        int n = (this.y1 - this.y2) * (this.x1 - this.x2);
        int n2 = Math.max(5, this.lineWidth);
        Rectangle rectangle = this.getBounds();
        this.SEDU = new Polygon();
        if (n > 0) {
            this.SEDU.addPoint(n2 / 2, 0);
            this.SEDU.addPoint(0, 0);
            this.SEDU.addPoint(0, n2 / 2);
            this.SEDU.addPoint(rectangle.width - n2 / 2 - 1, rectangle.height - 1);
            this.SEDU.addPoint(rectangle.width - 1, rectangle.height - 1);
            this.SEDU.addPoint(rectangle.width - 1, rectangle.height - n2 / 2 - 1);
        } else if (n < 0) {
            this.SEDU.addPoint(0, rectangle.height - n2 / 2 - 1);
            this.SEDU.addPoint(0, rectangle.height - 1);
            this.SEDU.addPoint(n2 / 2, rectangle.height - 1);
            this.SEDU.addPoint(rectangle.width - 1, n2 / 2);
            this.SEDU.addPoint(rectangle.width - 1, 0);
            this.SEDU.addPoint(rectangle.width - n2 / 2 - 1, 0);
        } else if (this.x1 == this.x2) {
            int n3 = Math.max(0, Math.abs((rectangle.width - n2) / 2));
            this.SEDU.addPoint(-n3, 0);
            this.SEDU.addPoint(-n3, Math.max(n2, rectangle.height) - 1);
            this.SEDU.addPoint(rectangle.width + n3, Math.max(n2, rectangle.height) - 1);
            this.SEDU.addPoint(rectangle.width + n3, 0);
        } else {
            int n4 = Math.max(0, Math.abs((rectangle.height - n2) / 2));
            this.SEDU.addPoint(0, -n4);
            this.SEDU.addPoint(0, rectangle.height + n4);
            this.SEDU.addPoint(Math.max(n2, rectangle.width) - 1, rectangle.height + n4);
            this.SEDU.addPoint(Math.max(n2, rectangle.width) - 1, -n4);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        if (this.SEDU == null) {
            this.resetBoundary();
        }
        if (this.isVisible() && this.SEDU != null) {
            return this.SEDU.contains(n, n2);
        }
        return false;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    @Override
    public void setCoordinates(int n, int n2, int n3, int n4) {
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
        this.SEDU();
    }

    @Override
    public Rectangle getCoordinates() {
        return new Rectangle(this.x1, this.y1, this.x2, this.y2);
    }

    public void setLineWidth(int n) {
        if (n > 0 && this.lineWidth != n) {
            this.lineWidth = n;
            this.SEDU();
        }
    }

    protected int getSlope(int n, int n2, int n3, int n4) {
        n = (n3 > n ? n3 - n : n - n3) > (this.lineWidth < 5 ? 5 : this.lineWidth) << 1 ? n : n3;
        int n5 = n2 = (n4 > n2 ? n4 - n2 : n2 - n4) > (this.lineWidth < 5 ? 5 : this.lineWidth) << 1 ? n2 : n4;
        return n == n3 ? 3 : (n2 == n4 ? 1 : (n > n3 ? (n2 > n4 ? 0 : 2) : (n2 > n4 ? 2 : 0)));
    }

    private void SEDU() {
        this.setBounds(this.adjustBounds(this.x1, this.y1, this.x2, this.y2));
        this.resetBoundary();
    }

    public Rectangle adjustBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n3 < n ? n3 : n, n4 < n2 ? n4 : n2, n3 > n ? n3 - n + 1 : n - n3 + 1, n4 > n2 ? n4 - n2 + 1 : n2 - n4 + 1);
        if (this.lineWidth > 1) {
            if (Math.abs(n3 - n) < this.lineWidth) {
                rectangle.x -= this.lineWidth / 2;
                rectangle.width = this.lineWidth;
            }
            if (Math.abs(n4 - n2) < this.lineWidth) {
                rectangle.y -= this.lineWidth / 2;
                rectangle.height = this.lineWidth;
            }
        }
        return rectangle;
    }

    @Override
    public void updateEditableBounds() {
        if (this.editable != null) {
            Rectangle rectangle = this.mapBoundsToBoard();
            this.adjustEditableBounds(rectangle);
            this.editable.setBounds(rectangle);
        }
    }

    public void adjustEditableBounds(Rectangle rectangle) {
        if (rectangle.height < 5) {
            rectangle.y -= (5 - rectangle.height) / 2;
            rectangle.height = 5;
        }
        if (rectangle.width < 5) {
            rectangle.x -= (5 - rectangle.width) / 2;
            rectangle.width = 5;
        }
    }

    @Override
    public void paintExterior(Graphics graphics, int n, int n2, int n3) {
        if (this.canBeEdited() && this.editable != null && (this.status == 1 || this.status == 3)) {
            Dimension dimension = this.getSize();
            Point point = this.getLocation();
            point.x = point.x - (this.isVertical() ? 2 : 0);
            point.y = point.y - (this.isHorizntal() ? 2 : 0);
            graphics.setColor(this.status == 3 ? Color.blue : Color.black);
            if ((n3 & 0x1FF) != 0) {
                if ((n3 & 1) != 0) {
                    graphics.fillRect(0, 0, 5, 5);
                    graphics.fillRect(n - 5, n2 - 5, 5, 5);
                } else if ((n3 & 4) != 0) {
                    graphics.fillRect(n - 5, 0, 5, 5);
                    graphics.fillRect(0, n2 - 5, 5, 5);
                }
            }
        }
    }

    @Override
    public int inBlackBlock(int n, int n2, int n3) {
        Rectangle rectangle = this.getBounds();
        rectangle.setBounds(rectangle.width < 5 ? rectangle.x - 2 : rectangle.x, rectangle.height < 5 ? rectangle.y - 2 : rectangle.y, rectangle.width < 5 ? 5 : rectangle.width, rectangle.height < 5 ? 5 : rectangle.height);
        int n4 = rectangle.width - 5;
        int n5 = rectangle.height - 5;
        if ((n3 & 0x1FF) != 0) {
            if ((n3 & 1) != 0 && n >= 0 && n <= 5 && n2 >= 0 && n2 <= 5) {
                return 1;
            }
            if ((n3 & 4) != 0 && n >= n4 && n <= n4 + 5 && n2 >= 0 && n2 <= 5) {
                return 4;
            }
            if ((n3 & 0x20) != 0 && n >= 0 && n <= 5 && n2 >= n5 && n2 <= n5 + 5) {
                return 32;
            }
            if ((n3 & 0x80) != 0 && n >= n4 && n <= n4 + 5 && n2 >= n5 && n2 <= n5 + 5) {
                return 128;
            }
            if ((n3 & 0x100) != 0) {
                return 256;
            }
        }
        return 0;
    }

    @Override
    public Cursor getEditorCursor(int n) {
        switch (n) {
            case 256: {
                return Cursor.getPredefinedCursor(13);
            }
            case 1: 
            case 4: 
            case 32: 
            case 128: {
                return Cursor.getPredefinedCursor(1);
            }
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public void getRealBounds(Rectangle rectangle, int n) {
        if (n != 12) {
            if (this.isHorizntal()) {
                rectangle.y += rectangle.height / 2;
                rectangle.height = 1;
            } else if (this.isVertical()) {
                rectangle.x += rectangle.width / 2;
                rectangle.width = 1;
            }
        }
    }

    @Override
    public void getLogBounds(Rectangle rectangle, int n) {
        this.checkCoordinate(rectangle, n);
        this.checkCoordinate(this.tx1, this.ty1, this.tx2, this.ty2, n);
        rectangle.setBounds(this.tx1, this.ty1, this.tx2, this.ty2);
    }

    @Override
    public void paintFigure(Graphics graphics, Rectangle rectangle, int n) {
        this.checkCoordinate(rectangle, n);
        this.checkCoordinate(this.tx1, this.ty1, this.tx2, this.ty2, n);
        graphics.drawLine(this.tx1, this.ty1, this.tx2, this.ty2);
    }

    protected void checkCoordinate(Rectangle rectangle, int n) {
        switch (n) {
            case 1: 
            case 12: {
                if (this.isHorizntal()) {
                    this.tx1 = rectangle.x;
                    this.ty1 = rectangle.y;
                    this.tx2 = this.tx1 + rectangle.width - (rectangle.width > 0 ? 1 : 0);
                    this.ty2 = this.ty1;
                    break;
                }
                if (this.isVertical()) {
                    this.tx1 = rectangle.x;
                    this.ty1 = rectangle.y;
                    this.tx2 = this.tx1;
                    this.ty2 = this.ty1 + rectangle.height - (rectangle.height > 0 ? 1 : 0);
                    break;
                }
                if (this.isPositiveSlope()) {
                    this.tx1 = rectangle.x;
                    this.ty1 = rectangle.y + rectangle.height - (rectangle.height > 0 ? 1 : 0);
                    this.tx2 = rectangle.x + rectangle.width - (rectangle.width > 0 ? 1 : 0);
                    this.ty2 = rectangle.y;
                    break;
                }
                if (!this.isNegativeSlope()) break;
                this.tx1 = rectangle.x;
                this.ty1 = rectangle.y;
                this.tx2 = rectangle.x + rectangle.width - (rectangle.width > 0 ? 1 : 0);
                this.ty2 = rectangle.y + rectangle.height - (rectangle.height > 0 ? 1 : 0);
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                this.tx1 = rectangle.x;
                this.ty1 = rectangle.y;
                this.tx2 = rectangle.x + rectangle.width - (rectangle.width > 0 ? 1 : 0);
                this.ty2 = rectangle.y + rectangle.height - (rectangle.height > 0 ? 1 : 0);
                break;
            }
            case 4: 
            case 7: {
                this.tx1 = rectangle.x;
                this.ty1 = rectangle.y + rectangle.height - (rectangle.height > 0 ? 1 : 0);
                this.tx2 = rectangle.x + rectangle.width - (rectangle.width > 0 ? 1 : 0);
                this.ty2 = rectangle.y;
            }
        }
    }

    protected void checkCoordinate(int n, int n2, int n3, int n4, int n5) {
        if ((n3 > n ? n3 - n : n - n3) < (this.lineWidth > 5 ? this.lineWidth : 5)) {
            if (n5 == 4 || n5 == 9 || n5 == 10) {
                n3 = n;
            } else if (n5 == 2 || n5 == 7) {
                n = n3;
            }
        }
        if ((n4 > n2 ? n4 - n2 : n2 - n4) <= (this.lineWidth > 5 ? this.lineWidth : 5)) {
            if (n5 == 2 || n5 == 7) {
                n2 = n4;
            } else if (n5 == 9 || n5 == 10 || n5 == 4) {
                n4 = n2;
            }
        }
        this.tx1 = n;
        this.ty1 = n2;
        this.tx2 = n3;
        this.ty2 = n4;
    }

    @Override
    public final void paintShape(Graphics graphics) {
        Point point = this.getLocation();
        Painter.drawLine(graphics, this.x1 - point.x, this.y1 - point.y, this.x2 - point.x, this.y2 - point.y, this.getForeground(), this.lineWidth, this.lineStyle);
    }

    @Override
    public final void paintInterior(Graphics graphics) {
    }

    @Override
    public int getEdCtrls() {
        return this.isNegativeSlope() ? 385 : 292;
    }
}

