/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.ActivatedListener;
import guitools.toolkit.AttachPeer;
import guitools.toolkit.DrawDragInsertListener;
import guitools.toolkit.DrawDragSelectionListener;
import guitools.toolkit.EdContainerPeer;
import guitools.toolkit.Editable;
import guitools.toolkit.EditableFigurePeer;
import guitools.toolkit.EditableLine;
import guitools.toolkit.EditablePeer;
import guitools.toolkit.Editor;
import guitools.toolkit.GlContainerPeer;
import guitools.toolkit.GridContainer;
import guitools.toolkit.Guideline;
import guitools.toolkit.ParagraphRuler;
import guitools.toolkit.Ruler;
import guitools.toolkit.RulerActionListener;
import guitools.toolkit.RulerAgent;
import guitools.toolkit.RulerCursor;
import guitools.toolkit.RulerMarginListener;
import guitools.toolkit.ScrollsListener;
import guitools.toolkit.SelectionInfo;
import guitools.toolkit.SplitterContainer;
import guitools.toolkit.Splitterbar;
import guitools.toolkit.TPaintBoard;
import guitools.toolkit.TransparentPeer;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Stack;
import java.util.Vector;

public class EditablePaintBoard
extends TPaintBoard
implements MouseListener,
MouseMotionListener,
ActivatedListener,
RulerActionListener,
RulerMarginListener,
DrawDragSelectionListener {
    public static final int NOEDITOR = 0;
    public static final int MOVEMENT = 1;
    public static final int TOPLEFT = 2;
    public static final int TOP = 3;
    public static final int TOPRIGHT = 4;
    public static final int LEFT = 5;
    public static final int RIGHT = 6;
    public static final int BOTTOMLEFT = 7;
    public static final int BOTTOM = 8;
    public static final int BOTTOMRIGHT = 9;
    public static final int INSFIGURE = 10;
    public static final int INSERT = 11;
    public static final int PASTE = 12;
    public static final int MULTISEL = 13;
    public static final int SPLITTERBAR = 14;
    public static final int RULERCURSOR = 15;
    public static final int MARGIN = 16;
    public static final int NOFIELD = 0;
    public static final int LOCX = 1;
    public static final int LOCY = 2;
    public static final int WIDTH = 4;
    public static final int HEIGHT = 8;
    public static final int NEGWIDTH = 16;
    public static final int NEGHEIGHT = 32;
    public static final int ALLFIELDS = 47;
    protected boolean activated;
    protected boolean visibleGrid = true;
    protected boolean gridSnap = true;
    protected int grid = Unit.convertUnitToPixel(Unit.GRID);
    protected final Editable activeObj = new Editable();
    protected Stack unselections = new Stack();
    protected Vector selections = new Vector();
    protected Vector gridComps;
    protected Vector hsbs;
    protected Vector vsbs;
    protected Vector gridBounds;
    protected Vector hsbsBounds;
    protected Vector vsbsBounds;
    protected Vector editedComps = new Vector();
    protected Vector editedBounds = new Vector();
    protected Vector oldBounds = new Vector();
    protected Rectangle markArea = new Rectangle();
    protected Rectangle selectedArea = new Rectangle();
    protected int editorState;
    protected int editorField;
    protected int edCtrls;
    protected int moreTop = Short.MIN_VALUE;
    protected int moreLeft = Short.MIN_VALUE;
    protected int moreBottom = Short.MAX_VALUE;
    protected int moreRight = Short.MAX_VALUE;
    protected int curTop;
    protected int curLeft;
    protected int curBottom;
    protected int curRight;
    protected int lastx;
    protected int lasty;
    protected int offsetx;
    protected int offsety;
    protected int osx;
    protected int osy;
    protected int dx;
    protected int dy;
    protected int minTopLeft;
    protected int gridIndex;
    protected int orientation;
    protected boolean limitx;
    protected boolean limity;
    protected boolean keyEditor;
    protected boolean sameParent;
    protected boolean hasFigure;
    protected Splitterbar curBar;
    protected EditablePeer edpeer;
    protected Vector guidelines = new Vector();
    protected int x1;
    protected int x2;
    protected int y1;
    protected int y2;
    protected boolean glVisible = true;
    protected Guideline edGl;
    protected Ruler hRuler;
    protected Ruler vRuler;
    protected boolean drawDragIns;
    protected DrawDragInsertListener ddInsListener;
    protected ScrollsListener scrollsListener;
    protected EdContainerPeer currentContainer;
    protected boolean displayCurCon;
    protected Frame frame;
    protected ParagraphRuler hruler;
    protected Ruler vruler;

    public EditablePaintBoard() {
        this.enableEvents(8L);
        this.activeObj.setVisible(false);
        this.selections.addElement(this.activeObj);
        this.add(this.activeObj);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public Component getComponentAt(int n, int n2) {
        int n3 = this.getComponentCount();
        if (n3 > 0) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < n3; ++i) {
                Component component = componentArray[i];
                if (component == null || component == this.activeObj || !component.isVisible() || !(component instanceof EditablePeer)) continue;
                Point point = component.getLocation();
                if ((component = component.getComponentAt(n - point.x, n2 - point.y)) == null) continue;
                return component;
            }
        }
        return this;
    }

    protected void setRulersVisible(boolean bl) {
        this.lockUpdate();
        this.getHRuler().setVisible(bl);
        this.getVRuler().setVisible(bl);
        this.unlockUpdate();
    }

    public ParagraphRuler getHRuler() {
        if (this.hruler == null) {
            this.hruler = new ParagraphRuler();
            this.add((Component)this.hruler, 1);
        }
        return this.hruler;
    }

    public Ruler getVRuler() {
        if (this.vruler == null) {
            this.vruler = new Ruler(1);
            this.add((Component)this.vruler, 2);
        }
        return this.vruler;
    }

    public int getEditorState() {
        return this.editorState;
    }

    public void setDrawDragInsertListenr(DrawDragInsertListener drawDragInsertListener) {
        this.ddInsListener = drawDragInsertListener;
    }

    public void setScrollsListener(ScrollsListener scrollsListener) {
        this.scrollsListener = scrollsListener;
    }

    public void startPaste(Vector vector, Vector vector2, EditablePeer editablePeer) {
        this.startInsert(vector, vector2, editablePeer, false, false, 0, false, 12);
    }

    public void startInsert(Vector vector, Vector vector2, EditablePeer editablePeer) {
        this.startInsert(vector, vector2, editablePeer, false, false, 0, false, 11);
    }

    protected void restartInsert(Vector vector, Vector vector2, EditablePeer editablePeer) {
        this.startInsert(vector, vector2, editablePeer, false, false, 0, false, 12);
    }

    public void startInsert(Vector vector, Vector vector2, EditablePeer editablePeer, boolean bl, boolean bl2, int n, boolean bl3) {
        this.startInsert(vector, vector2, editablePeer, bl, bl2, n, bl3, 11);
    }

    public void startInsert(Vector vector, Vector vector2, EditablePeer editablePeer, boolean bl, boolean bl2, int n, boolean bl3, int n2) {
        this.requestFocus();
        this.cancelInsertion();
        this.limitx = true;
        this.limity = true;
        this.editorState = n2 == 12 ? 12 : 11;
        this.editorField = 3;
        this.curLeft = Short.MAX_VALUE;
        this.curTop = Short.MAX_VALUE;
        this.curRight = Short.MIN_VALUE;
        this.curBottom = Short.MIN_VALUE;
        this.editedComps.removeAllElements();
        this.editedBounds.removeAllElements();
        this.oldBounds.removeAllElements();
        Rectangle rectangle = (Rectangle)vector2.elementAt(0);
        int n3 = bl ? rectangle.y : rectangle.x;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = bl ? this.moreRight - this.moreLeft : this.moreBottom - this.moreTop;
        int n9 = bl ? this.moreBottom - this.moreTop : this.moreRight - this.moreLeft;
        this.hasFigure = false;
        for (int i = 0; i < vector.size(); ++i) {
            EditablePeer editablePeer2 = (EditablePeer)vector.elementAt(i);
            rectangle = (Rectangle)vector2.elementAt(i);
            if (bl2) {
                int n10 = bl ? rectangle.x + rectangle.width - n6 : rectangle.y + rectangle.height - n6;
                int n11 = n5 = n5 < n10 ? n10 : n5;
                int n12 = bl ? (n4 < rectangle.height ? rectangle.height : n4) : (n4 = n4 < rectangle.width ? rectangle.width : n4);
                if (++n7 > 1 && n5 >= n8) {
                    n3 = (n3 += n4 + n) > n9 ? 0 : n3;
                    n4 = 0;
                    n7 = 0;
                    n5 = 0;
                    int n13 = n6 = bl ? rectangle.x : rectangle.y;
                }
                if (bl) {
                    rectangle.x -= n6;
                    rectangle.y = n3;
                } else {
                    rectangle.x = n3;
                    rectangle.y -= n6;
                }
            }
            if (editablePeer2 == editablePeer) {
                this.editedComps.insertElementAt(editablePeer2, 0);
                this.editedBounds.insertElementAt(rectangle, 0);
            } else {
                this.editedComps.addElement(editablePeer2);
                this.editedBounds.addElement(rectangle);
            }
            this.oldBounds.addElement(new Rectangle());
            this.curLeft = rectangle.x < this.curLeft ? rectangle.x : this.curLeft;
            int n14 = this.curTop = rectangle.y < this.curTop ? rectangle.y : this.curTop;
            if (editablePeer2 instanceof EditableFigurePeer) {
                this.hasFigure = true;
                this.curRight = rectangle.x + rectangle.width > this.curRight ? rectangle.x + rectangle.width : this.curRight;
                this.curBottom = rectangle.y + rectangle.height > this.curBottom ? rectangle.y + rectangle.height : this.curBottom;
                continue;
            }
            this.curRight = rectangle.x > this.curRight ? rectangle.x : this.curRight;
            this.curBottom = rectangle.y > this.curBottom ? rectangle.y : this.curBottom;
        }
        if (this.editorState == 12) {
            this.turnToRealBounds();
        }
        this.initBounds();
        this.edpeer = editablePeer;
        if (editablePeer instanceof EditableFigurePeer) {
            this.lockCursor(Cursor.getPredefinedCursor(1));
        } else {
            this.lockCursor(Cursor.getPredefinedCursor(12));
        }
        this.sameParent = bl3;
    }

    protected void cancelInsertion() {
        if (this.hasXorFigure) {
            this.drawXorRect(this.editedComps, this.editedBounds);
            this.hasXorFigure = false;
        }
        this.normalState();
        this.releasCursorLock();
    }

    public void updateEditablePosition() {
        EditablePeer editablePeer;
        this.lockUpdate();
        for (int i = this.selections.size() - 1; i >= 0; --i) {
            Editable editable = (Editable)this.selections.elementAt(i);
            Rectangle rectangle = editable.getBounds();
            editable.updatePosition();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.activeObj.isVisible() && (editablePeer = this.activeObj.getOwner()) instanceof RulerAgent && editablePeer.getStatus() == 4) {
            ((RulerAgent)((Object)editablePeer)).adjustRulerBounds();
        }
        this.unlockUpdate();
    }

    public void clearSelecteds() {
        EditablePeer editablePeer;
        this.lockUpdate();
        for (int i = this.selections.size() - 1; i >= 0; --i) {
            EditablePeer editablePeer2 = ((Editable)this.selections.elementAt(i)).getOwner();
            editablePeer2.setStatus(0);
        }
        if (this.currentContainer != null) {
            this.currentContainer.setStatus(0);
        }
        if ((editablePeer = this.activeObj.getOwner()) != null) {
            editablePeer.setStatus(0);
        }
        this.unlockUpdate();
    }

    public Rectangle getUpdateEditablePeerArea(Vector vector) {
        Rectangle rectangle;
        int n = vector.size();
        if (n != 0) {
            Vector<Rectangle> vector2 = new Vector<Rectangle>();
            for (int i = n - 1; i >= 0; --i) {
                vector2.addElement(((EditablePeer)vector.elementAt(i)).mapBoundsToBoard());
            }
            rectangle = this.getRectanglesArea(vector2);
        } else {
            rectangle = new Rectangle();
        }
        return rectangle;
    }

    public Container getCurrentEditableParent(int n, int n2) {
        int n3 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < n3; ++i) {
            Component component = componentArray[i];
            if (component == null || !component.isVisible() || !(component instanceof Container) || !(component instanceof EditablePeer) || !((EdContainerPeer)((Object)component)).canBeThrownIn()) continue;
            Point point = component.getLocation();
            if (!component.contains(n - point.x, n2 - point.y)) continue;
            return ((EdContainerPeer)((Object)component)).getCurrentEditableParent(n -= point.x, n2 -= point.y, this.editorState);
        }
        return this;
    }

    public Container getCurrentEditableParent(EditablePeer editablePeer, int n, int n2) {
        int n3 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < n3; ++i) {
            Component component = componentArray[i];
            if (component == null || !component.isVisible() || !(component instanceof Container) || !(component instanceof EditablePeer) || editablePeer == (EditablePeer)((Object)component) || !((EdContainerPeer)((Object)component)).canBeThrownIn()) continue;
            Point point = component.getLocation();
            if (!component.contains(n - point.x, n2 - point.y)) continue;
            return ((EdContainerPeer)((Object)component)).getCurrentEditableParent(editablePeer, n -= point.x, n2 -= point.y, this.editorState);
        }
        return this;
    }

    public Rectangle calculateValidArea(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        if (rectangle.width < 0) {
            rectangle2.x = rectangle.x + rectangle.width;
            rectangle2.width = -rectangle.width;
        } else {
            rectangle2.x = rectangle.x;
            rectangle2.width = rectangle.width;
        }
        if (rectangle.height < 0) {
            rectangle2.y = rectangle.y + rectangle.height;
            rectangle2.height = -rectangle.height;
        } else {
            rectangle2.y = rectangle.y;
            rectangle2.height = rectangle.height;
        }
        return rectangle2;
    }

    public void updateAttachedGuideline(AttachPeer attachPeer, Rectangle rectangle) {
        int n;
        for (n = 5; n >= 0; --n) {
            attachPeer.setAttachment(null, n);
        }
        for (n = this.guidelines.size() - 1; n >= 0; --n) {
            Guideline guideline = (Guideline)this.guidelines.elementAt(n);
            int n2 = guideline.canBeAttached(attachPeer, rectangle);
            if (n2 <= -1 || n2 >= 6) continue;
            attachPeer.setAttachment(guideline, n2);
        }
    }

    public void updateBoundsWithGuideline(AttachPeer attachPeer, Rectangle rectangle) {
        Point point;
        Point point2;
        Point point3;
        Guideline guideline = attachPeer.getGuideline(0);
        Guideline guideline2 = attachPeer.getGuideline(1);
        Guideline guideline3 = attachPeer.getGuideline(2);
        if (guideline != null) {
            point3 = guideline.mapPositionToBoard();
            rectangle.x = point3.x;
            if (guideline3 != null) {
                point2 = guideline3.mapPositionToBoard();
                rectangle.width = point2.x - point3.x + 1;
            } else if (guideline2 != null) {
                point = guideline2.mapPositionToBoard();
                rectangle.width = point.x - point3.x << 1;
            }
        } else if (guideline3 != null) {
            point2 = guideline3.mapPositionToBoard();
            if (guideline2 != null) {
                point = guideline2.mapPositionToBoard();
                rectangle.width = point2.x - point.x << 1;
            }
            rectangle.x = point2.x - rectangle.width + 1;
        } else if (guideline2 != null) {
            point = guideline2.mapPositionToBoard();
            rectangle.x = point.x - (rectangle.width >> 1);
        }
        guideline = attachPeer.getGuideline(3);
        guideline2 = attachPeer.getGuideline(4);
        guideline3 = attachPeer.getGuideline(5);
        if (guideline != null) {
            point3 = guideline.mapPositionToBoard();
            rectangle.y = point3.y;
            if (guideline3 != null) {
                point2 = guideline3.mapPositionToBoard();
                rectangle.height = point2.y - point3.y + 1;
            } else if (guideline2 != null) {
                point = guideline2.mapPositionToBoard();
                rectangle.height = point.y - point3.y << 1;
            }
        } else if (guideline3 != null) {
            point2 = guideline3.mapPositionToBoard();
            if (guideline2 != null) {
                point = guideline2.mapPositionToBoard();
                rectangle.height = point2.y - point.y << 1;
            }
            rectangle.y = point2.y - rectangle.height + 1;
        } else if (guideline2 != null) {
            point = guideline2.mapPositionToBoard();
            rectangle.y = point.y - (rectangle.height >> 1);
        }
    }

    public boolean isGridVisible() {
        return this.visibleGrid;
    }

    public void showGrid(boolean bl) {
        if (bl != this.visibleGrid) {
            this.visibleGrid = bl;
            this.repaint();
        }
    }

    public void setGridLength(int n) {
        if (this.grid != n && n > 4) {
            this.grid = n;
            this.repaint();
        }
    }

    public int getGridLength() {
        return this.grid;
    }

    @Override
    public boolean setActivated(boolean bl) {
        this.activated = bl;
        if (this.activated && this.isShowing()) {
            EditablePeer editablePeer = this.activeObj.getOwner();
            if (editablePeer != null && editablePeer.getStatus() == 4) {
                ((Component)((Object)editablePeer)).requestFocus();
                return this.frame.getFocusOwner() == editablePeer;
            }
            this.requestFocus();
            return this.frame.getFocusOwner() == this;
        }
        return true;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    protected void setStatus(EditablePeer editablePeer, int n) {
        Editable editable = editablePeer.getEditable();
        switch (n) {
            case 0: {
                if (editable == null) break;
                if (editable == this.activeObj) {
                    EditablePeer editablePeer2 = this.activeObj.getOwner();
                    this.activeObj.setOwner(null);
                    if (editablePeer instanceof MouseListener) {
                        this.activeObj.removeMouseListener((MouseListener)((Object)editablePeer));
                    }
                    if (editablePeer instanceof MouseMotionListener) {
                        this.activeObj.removeMouseMotionListener((MouseMotionListener)((Object)editablePeer));
                    }
                    this.setRulersVisible(false);
                    break;
                }
                this.abandonSelectedTarget(editable);
                break;
            }
            case 1: {
                if (editable != null) {
                    if (editable != this.activeObj) break;
                    EditablePeer editablePeer3 = this.activeObj.getOwner();
                    this.activeObj.setOwner(null);
                    if (editablePeer instanceof MouseListener) {
                        this.activeObj.removeMouseListener((MouseListener)((Object)editablePeer));
                    }
                    if (editablePeer instanceof MouseMotionListener) {
                        this.activeObj.removeMouseMotionListener((MouseMotionListener)((Object)editablePeer));
                    }
                    this.setRulersVisible(false);
                    editable = this.getSelectedTarget();
                    editable.setOwner(editablePeer);
                    break;
                }
                editable = this.getSelectedTarget();
                editable.setOwner(editablePeer);
                break;
            }
            case 3: {
                if (editable != null) {
                    if (editable != this.activeObj) {
                        this.abandonSelectedTarget(editable);
                        this.activeObj.setOwner(editablePeer);
                        break;
                    }
                    this.setRulersVisible(false);
                    break;
                }
                this.activeObj.setOwner(editablePeer);
                break;
            }
            case 4: {
                if (editable != null) {
                    if (editable != this.activeObj) {
                        this.abandonSelectedTarget(editable);
                        this.activeObj.setOwner(editablePeer);
                    }
                } else {
                    this.activeObj.setOwner(editablePeer);
                }
                ((Component)((Object)editablePeer)).requestFocus();
                if (editablePeer instanceof MouseListener) {
                    this.activeObj.addMouseListener((MouseListener)((Object)editablePeer));
                }
                if (editablePeer instanceof MouseMotionListener) {
                    this.activeObj.addMouseMotionListener((MouseMotionListener)((Object)editablePeer));
                }
                if (!(editablePeer instanceof RulerAgent)) break;
                this.setRulersVisible(true);
            }
        }
        ((Component)((Object)editablePeer)).repaint();
    }

    public EditablePeer getActiveEditablePeer() {
        return this.activeObj.getOwner();
    }

    protected int checkEditorialState(EditablePeer editablePeer, int n, int n2) {
        Point point = editablePeer.mapToComp(n, n2);
        switch (editablePeer.inBlackBlock(point.x, point.y, this.edCtrls)) {
            case 256: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 16: {
                return 6;
            }
            case 32: {
                return 7;
            }
            case 64: {
                return 8;
            }
            case 128: {
                return 9;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintFace(Graphics graphics) {
        int n = this.guidelines.size();
        if (this.glVisible && n > 0) {
            Rectangle rectangle = graphics.getClipBounds();
            for (int i = n - 1; i >= 0; --i) {
                Guideline guideline = (Guideline)this.guidelines.elementAt(i);
                Rectangle rectangle2 = guideline.getBounds();
                if (!rectangle.intersects(rectangle2)) continue;
                Graphics graphics2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                try {
                    guideline.paint(graphics2);
                    continue;
                }
                finally {
                    graphics2.dispose();
                }
            }
        }
    }

    public void showGuidelines(boolean bl) {
        if (this.glVisible != bl) {
            this.glVisible = bl;
            this.repaint();
        }
    }

    public boolean isVisibleGl() {
        return this.glVisible;
    }

    public Guideline getGuideline(RulerCursor rulerCursor) {
        for (int i = this.guidelines.size() - 1; i >= 0; --i) {
            Guideline guideline = (Guideline)this.guidelines.elementAt(i);
            if (!guideline.cursorIn(rulerCursor)) continue;
            return guideline;
        }
        return null;
    }

    public void setRulers(Ruler ruler, Ruler ruler2) {
        this.hRuler = ruler;
        this.vRuler = ruler2;
    }

    @Override
    public boolean catchInRulerCursor(Ruler ruler, RulerCursor rulerCursor, int n) {
        Point point = ruler.mapToBoard(n, n);
        this.orientation = ruler.getOrientation();
        if (this.orientation == 0) {
            this.limitx = true;
        } else {
            this.limity = true;
        }
        if (!this.checkRulerCursorPos(point)) {
            return false;
        }
        if (this.displayCurCon) {
            if (this.currentContainer != null) {
                this.selectedArea = this.currentContainer.mapBoundsToBoard();
                this.selectedArea.width += this.selectedArea.x;
                this.selectedArea.height += this.selectedArea.y;
                if (this.orientation == 0 ? point.x < this.selectedArea.x || point.x > this.selectedArea.width : this.orientation == 1 && (point.y < this.selectedArea.y || point.y > this.selectedArea.height)) {
                    return false;
                }
                return this.prepareDragRulerCursor(ruler, rulerCursor, n);
            }
            return false;
        }
        return this.prepareDragRulerCursor(ruler, rulerCursor, n);
    }

    @Override
    public boolean throwOutRulerCursor(Ruler ruler, RulerCursor rulerCursor, int n) {
        if (this.edGl != null) {
            for (int i = this.edGl.attachedObjects() - 1; i >= 0; --i) {
                this.edGl.getAttachObjs(i).deattachGl();
            }
            Rectangle rectangle = this.edGl.getBounds();
            this.edGl.getParent().removeGl(this.edGl);
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        this.hasXorFigure = false;
        this.editorState = 0;
        return false;
    }

    @Override
    public boolean unionRulerCursor(Ruler ruler, RulerCursor rulerCursor, RulerCursor rulerCursor2, int n) {
        return true;
    }

    @Override
    public boolean prepareDragRulerCursor(Ruler ruler, RulerCursor rulerCursor, int n) {
        Dimension dimension = this.getSize();
        Point point = ruler.mapToBoard(n, n);
        this.orientation = ruler.getOrientation();
        if (this.orientation == 0) {
            this.limitx = true;
        } else {
            this.limity = true;
        }
        if (!this.checkRulerCursorPos(point)) {
            return false;
        }
        if (this.displayCurCon && this.currentContainer != null) {
            this.selectedArea = this.currentContainer.mapBoundsToBoard();
            this.selectedArea.width += this.selectedArea.x;
            this.selectedArea.height += this.selectedArea.y;
        }
        if (this.orientation == 0) {
            this.x2 = this.x1 = point.x;
            this.y1 = 0;
            this.y2 = dimension.height - 1;
        } else if (this.orientation == 1) {
            this.x1 = 0;
            this.x2 = dimension.width - 1;
            this.y2 = this.y1 = point.y;
        }
        this.editorState = 15;
        this.editorField = 0;
        this.edGl = this.getGuideline(rulerCursor);
        this.initBounds();
        this.hasXorFigure = true;
        this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        return true;
    }

    @Override
    public boolean dragRulerCursor(Ruler ruler, RulerCursor rulerCursor, int n) {
        Point point = ruler.mapToBoard(n, n);
        if (!this.checkRulerCursorPos(point)) {
            return true;
        }
        if (this.displayCurCon && this.currentContainer != null && (this.orientation == 0 ? point.x < this.selectedArea.x || point.x > this.selectedArea.width : this.orientation == 1 && (point.y < this.selectedArea.y || point.y > this.selectedArea.height))) {
            return true;
        }
        if (this.orientation == 0) {
            if (this.x1 != point.x) {
                int n2 = this.x1;
                this.x2 = this.x1 = point.x;
                ruler.mapToComp(point);
                ruler.updatePosition(rulerCursor, point.x);
                this.drawXorDotsline(n2, this.y1, n2, this.y2);
                this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
            }
        } else if (this.orientation == 1 && this.y1 != point.y) {
            int n3 = this.y1;
            this.y2 = this.y1 = point.y;
            ruler.mapToComp(point);
            ruler.updatePosition(rulerCursor, point.y);
            this.drawXorDotsline(this.x1, n3, this.x2, n3);
            this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        }
        return true;
    }

    @Override
    public boolean overDragRulerCursor(Ruler ruler, RulerCursor rulerCursor, int n) {
        this.lockUpdate();
        Point point = ruler.mapToBoard(n, n);
        GlContainerPeer glContainerPeer = this.updateGlParent(this.orientation, point);
        if (glContainerPeer != null) {
            glContainerPeer.mapToComp(point);
            if (this.orientation == 0) {
                n = point.x;
            } else if (this.orientation == 1) {
                n = point.y;
            }
            if (this.edGl == null) {
                this.overHandleCreateGuideline(glContainerPeer, rulerCursor, n);
            } else {
                this.overHandleRulerCursorMoving(glContainerPeer, n);
            }
        }
        this.editorState = 0;
        this.editorField = 0;
        this.limitx = false;
        this.limity = false;
        this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        this.hasXorFigure = false;
        this.unlockUpdate();
        return true;
    }

    protected boolean checkRulerCursorPos(Point point) {
        boolean bl = true;
        if (this.orientation == 0) {
            Point point2 = this.updatePointWithGrid(point.x, this.moreTop);
            point.x = point2 == null ? point.x : point2.x;
            point2 = this.checkPoint(point.x, this.moreTop);
            if (point.x == point2.x) {
                point2 = this.updatePointWithSplitterbar(point.x, this.moreTop);
            }
            bl = point.x == point2.x;
        } else if (this.orientation == 1) {
            Point point3 = this.updatePointWithGrid(this.moreLeft, point.y);
            point.y = point3 == null ? point.y : point3.y;
            point3 = this.checkPoint(this.moreLeft, point.y);
            if (point.y == point3.x) {
                point3 = this.updatePointWithSplitterbar(this.moreLeft, point.y);
            }
            bl = point.y == point3.y;
        }
        return bl;
    }

    protected void overHandleCreateGuideline(GlContainerPeer glContainerPeer, RulerCursor rulerCursor, int n) {
        Guideline guideline = new Guideline(rulerCursor, n);
        glContainerPeer.addGl(guideline);
        guideline.repaint();
    }

    protected int updateAttachedObjPos(GlContainerPeer glContainerPeer, GlContainerPeer glContainerPeer2, int n) {
        this.editedBounds.removeAllElements();
        block10: for (int i = 0; i < this.edGl.attachedObjects(); ++i) {
            int n2;
            Point point;
            Guideline guideline;
            AttachPeer attachPeer = this.edGl.getAttachObjs(i);
            int n3 = attachPeer.getAttachment(this.edGl);
            Rectangle rectangle = attachPeer.mapBoundsToBoard();
            this.editedBounds.addElement(rectangle);
            if (this.orientation == 0) {
                switch (n3) {
                    case 0: {
                        rectangle.x = n;
                        if (glContainerPeer2 != glContainerPeer || (guideline = attachPeer.getGuideline(2)) == null) break;
                        point = guideline.mapPositionToBoard();
                        n2 = point.x - n;
                        if (n2 < 0) {
                            rectangle.width = (n2 = -n2) < 0 ? 0 : n2;
                            rectangle.x -= rectangle.width;
                            break;
                        }
                        rectangle.width = n2 < 0 ? 0 : n2;
                        break;
                    }
                    case 1: {
                        rectangle.x = n - rectangle.width / 2;
                        break;
                    }
                    case 2: {
                        if (glContainerPeer2 == glContainerPeer) {
                            guideline = attachPeer.getGuideline(0);
                            if (guideline == null) break;
                            n2 = n - rectangle.x;
                            if (n2 < 0) {
                                rectangle.width = (n2 = -n2) < 0 ? 0 : n2;
                                rectangle.x = n;
                                break;
                            }
                            rectangle.width = n2 < 0 ? 0 : n2;
                            rectangle.x = n - rectangle.width;
                            break;
                        }
                        rectangle.x = n - rectangle.width;
                    }
                }
                continue;
            }
            if (this.orientation != 1) continue;
            switch (n3) {
                case 3: {
                    rectangle.y = n;
                    if (glContainerPeer2 != glContainerPeer || (guideline = attachPeer.getGuideline(5)) == null) continue block10;
                    point = guideline.mapPositionToBoard();
                    n2 = point.y - n;
                    if (n2 < 0) {
                        rectangle.height = (n2 = -n2) < 0 ? 0 : n2;
                        rectangle.y -= rectangle.height;
                        continue block10;
                    }
                    rectangle.height = n2 < 0 ? 0 : n2;
                    continue block10;
                }
                case 4: {
                    rectangle.y = n - rectangle.height / 2;
                    continue block10;
                }
                case 5: {
                    if (glContainerPeer2 == glContainerPeer) {
                        guideline = attachPeer.getGuideline(3);
                        if (guideline == null) continue block10;
                        n2 = n - rectangle.y;
                        if (n2 < 0) {
                            rectangle.height = (n2 = -n2) < 0 ? 0 : n2;
                            rectangle.y = n;
                            continue block10;
                        }
                        rectangle.height = n2 < 0 ? 0 : n2;
                        rectangle.y = n - rectangle.height;
                        continue block10;
                    }
                    rectangle.y = n - rectangle.height;
                }
            }
        }
        return n;
    }

    protected void overHandleRulerCursorMoving(GlContainerPeer glContainerPeer, int n) {
        GlContainerPeer glContainerPeer2 = this.edGl.getParent();
        if (glContainerPeer2 == glContainerPeer && n == this.edGl.getPosition()) {
            return;
        }
        n = this.updateAttachedObjPos(glContainerPeer, glContainerPeer2, n);
        this.lockUpdate();
        this.edGl.setPosition(n);
        if (glContainerPeer != glContainerPeer2) {
            glContainerPeer.addGl(this.edGl);
        }
        for (int i = this.edGl.attachedObjects() - 1; i >= 0; --i) {
            int n2;
            Point point;
            Guideline guideline;
            Guideline guideline2;
            Container container;
            AttachPeer attachPeer = this.edGl.getAttachObjs(i);
            int n3 = attachPeer.getAttachment(this.edGl);
            Rectangle rectangle = attachPeer.mapBoundsToBoard();
            if (glContainerPeer != glContainerPeer2) {
                ((Container)((Object)glContainerPeer)).add((Component)((Object)attachPeer));
                container = (Container)((Object)glContainerPeer);
            } else {
                container = ((Component)((Object)attachPeer)).getParent();
            }
            if (this.orientation == 0) {
                switch (n3) {
                    case 0: {
                        guideline2 = attachPeer.getGuideline(2);
                        guideline = attachPeer.getGuideline(1);
                        if (guideline2 != null) {
                            point = guideline2.mapPositionToBoard();
                            n2 = n < point.x ? point.x - n : n - point.x;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.x = n < point.x ? n : point.x;
                            rectangle.width = n2 + 1;
                        } else if (guideline != null) {
                            point = guideline.mapPositionToBoard();
                            n2 = n < point.x ? point.x - n << 1 : n - point.x << 1;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.x = n <= point.x ? n : n - n2 + 1;
                            rectangle.width = n2;
                        } else {
                            rectangle.x = n;
                        }
                        attachPeer.setAttachment(null, 0);
                        attachPeer.setAttachment(null, 1);
                        attachPeer.setAttachment(null, 2);
                        if (guideline != null && (n3 = guideline.canBeAttached(attachPeer, rectangle)) >= 0 && n3 <= 2) {
                            attachPeer.setAttachment(guideline, n3);
                        }
                        if (guideline2 != null && (n3 = guideline2.canBeAttached(attachPeer, rectangle)) >= 0 && n3 <= 2) {
                            attachPeer.setAttachment(guideline2, n3);
                        }
                        if ((n3 = this.edGl.canBeAttached(attachPeer, rectangle)) < 0 || n3 > 2) break;
                        attachPeer.setAttachment(this.edGl, n3);
                        break;
                    }
                    case 1: {
                        guideline2 = attachPeer.getGuideline(0);
                        guideline = attachPeer.getGuideline(2);
                        if (guideline2 != null && guideline != null || guideline2 == null && guideline == null) {
                            rectangle.x = n - (rectangle.width >> 1);
                        } else if (guideline2 != null) {
                            point = guideline2.mapPositionToBoard();
                            n2 = n > point.x ? n - point.x << 1 : point.x - n << 1;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.x = n >= point.x ? point.x : point.x - n2 + 1;
                            rectangle.width = n2;
                        } else if (guideline != null) {
                            point = guideline.mapPositionToBoard();
                            n2 = n < point.x ? point.x - n << 1 : n - point.x << 1;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.x = n <= point.x ? point.x - n2 + 1 : point.x;
                            rectangle.width = n2;
                        }
                        attachPeer.setAttachment(null, 0);
                        attachPeer.setAttachment(null, 1);
                        attachPeer.setAttachment(null, 2);
                        if (guideline != null && (n3 = guideline.canBeAttached(attachPeer, rectangle)) >= 0 && n3 <= 2) {
                            attachPeer.setAttachment(guideline, n3);
                        }
                        if (guideline2 != null && (n3 = guideline2.canBeAttached(attachPeer, rectangle)) >= 0 && n3 <= 2) {
                            attachPeer.setAttachment(guideline2, n3);
                        }
                        if ((n3 = this.edGl.canBeAttached(attachPeer, rectangle)) < 0 || n3 > 2) break;
                        attachPeer.setAttachment(this.edGl, n3);
                        break;
                    }
                    case 2: {
                        guideline2 = attachPeer.getGuideline(0);
                        guideline = attachPeer.getGuideline(1);
                        if (guideline2 != null) {
                            point = guideline2.mapPositionToBoard();
                            n2 = n > point.x ? n - point.x : point.x - n;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.x = n > point.x ? point.x : n;
                            rectangle.width = n2 + 1;
                        } else if (guideline != null) {
                            point = guideline.mapPositionToBoard();
                            n2 = n > point.x ? n - point.x << 1 : point.x - n << 1;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.x = n >= point.x ? n - n2 + 1 : n;
                            rectangle.width = n2;
                        } else {
                            rectangle.x = n - rectangle.width + 1;
                        }
                        attachPeer.setAttachment(null, 0);
                        attachPeer.setAttachment(null, 1);
                        attachPeer.setAttachment(null, 2);
                        if (guideline != null && (n3 = guideline.canBeAttached(attachPeer, rectangle)) >= 0 && n3 <= 2) {
                            attachPeer.setAttachment(guideline, n3);
                        }
                        if (guideline2 != null && (n3 = guideline2.canBeAttached(attachPeer, rectangle)) >= 0 && n3 <= 2) {
                            attachPeer.setAttachment(guideline2, n3);
                        }
                        if ((n3 = this.edGl.canBeAttached(attachPeer, rectangle)) < 0 || n3 > 2) break;
                        attachPeer.setAttachment(this.edGl, n3);
                    }
                }
            } else if (this.orientation == 1) {
                switch (n3) {
                    case 3: {
                        guideline2 = attachPeer.getGuideline(5);
                        guideline = attachPeer.getGuideline(4);
                        if (guideline2 != null) {
                            point = guideline2.mapPositionToBoard();
                            n2 = n < point.y ? point.y - n : n - point.y;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.y = n < point.y ? n : point.y;
                            rectangle.height = n2 + 1;
                        } else if (guideline != null) {
                            point = guideline.mapPositionToBoard();
                            n2 = n < point.y ? point.y - n << 1 : n - point.y << 1;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.y = n <= point.y ? n : n - n2 + 1;
                            rectangle.height = n2;
                        } else {
                            rectangle.y = n;
                        }
                        attachPeer.setAttachment(null, 3);
                        attachPeer.setAttachment(null, 4);
                        attachPeer.setAttachment(null, 5);
                        if (guideline != null && (n3 = guideline.canBeAttached(attachPeer, rectangle)) >= 3 && n3 <= 5) {
                            attachPeer.setAttachment(guideline, n3);
                        }
                        if (guideline2 != null && (n3 = guideline2.canBeAttached(attachPeer, rectangle)) >= 3 && n3 <= 5) {
                            attachPeer.setAttachment(guideline2, n3);
                        }
                        if ((n3 = this.edGl.canBeAttached(attachPeer, rectangle)) < 3 || n3 > 5) break;
                        attachPeer.setAttachment(this.edGl, n3);
                        break;
                    }
                    case 4: {
                        guideline2 = attachPeer.getGuideline(3);
                        guideline = attachPeer.getGuideline(5);
                        if (guideline2 != null && guideline != null || guideline2 == null && guideline == null) {
                            rectangle.y = n - (rectangle.height >> 1);
                        } else if (guideline2 != null) {
                            point = guideline2.mapPositionToBoard();
                            n2 = n > point.y ? n - point.y << 1 : point.y - n << 1;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.y = n >= point.y ? point.y : point.y - n2 + 1;
                            rectangle.height = n2;
                        } else if (guideline != null) {
                            point = guideline.mapPositionToBoard();
                            n2 = n < point.y ? point.y - n << 1 : n - point.y << 1;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.y = n <= point.y ? point.y - n2 + 1 : point.y;
                            rectangle.height = n2;
                        }
                        attachPeer.setAttachment(null, 3);
                        attachPeer.setAttachment(null, 4);
                        attachPeer.setAttachment(null, 5);
                        if (guideline != null && (n3 = guideline.canBeAttached(attachPeer, rectangle)) >= 3 && n3 <= 5) {
                            attachPeer.setAttachment(guideline, n3);
                        }
                        if (guideline2 != null && (n3 = guideline2.canBeAttached(attachPeer, rectangle)) >= 3 && n3 <= 5) {
                            attachPeer.setAttachment(guideline2, n3);
                        }
                        if ((n3 = this.edGl.canBeAttached(attachPeer, rectangle)) < 3 || n3 > 5) break;
                        attachPeer.setAttachment(this.edGl, n3);
                        break;
                    }
                    case 5: {
                        guideline2 = attachPeer.getGuideline(3);
                        guideline = attachPeer.getGuideline(4);
                        if (guideline2 != null) {
                            point = guideline2.mapPositionToBoard();
                            n2 = n > point.y ? n - point.y : point.y - n;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.y = n > point.y ? point.y : n;
                            rectangle.height = n2 + 1;
                        } else if (guideline != null) {
                            point = guideline.mapPositionToBoard();
                            n2 = n > point.y ? n - point.y << 1 : point.y - n << 1;
                            n2 = n2 < 0 ? 0 : n2;
                            rectangle.y = n >= point.y ? n - n2 + 1 : n;
                            rectangle.height = n2;
                        } else {
                            rectangle.y = n - rectangle.height + 1;
                        }
                        attachPeer.setAttachment(null, 3);
                        attachPeer.setAttachment(null, 4);
                        attachPeer.setAttachment(null, 5);
                        if (guideline != null && (n3 = guideline.canBeAttached(attachPeer, rectangle)) >= 3 && n3 <= 5) {
                            attachPeer.setAttachment(guideline, n3);
                        }
                        if (guideline2 != null && (n3 = guideline2.canBeAttached(attachPeer, rectangle)) >= 3 && n3 <= 5) {
                            attachPeer.setAttachment(guideline2, n3);
                        }
                        if ((n3 = this.edGl.canBeAttached(attachPeer, rectangle)) < 3 || n3 > 5) break;
                        attachPeer.setAttachment(this.edGl, n3);
                    }
                }
            }
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (container instanceof EdContainerPeer) {
                ((EditablePeer)((Object)container)).mapToComp(rectangle2);
            }
            ((Component)((Object)attachPeer)).setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        this.unlockUpdate();
    }

    protected GlContainerPeer updateGlParent(int n, Point point) {
        if (n == 1) {
            point.x = this.moreLeft < 0 ? 0 : this.moreLeft;
        } else {
            point.y = this.moreTop < 0 ? 0 : this.moreTop;
        }
        Container container = this.getCurrentEditableParent(point.x, point.y);
        return container instanceof GlContainerPeer ? (GlContainerPeer)((Object)container) : null;
    }

    @Override
    public boolean prepareDragTopMargin(int n) {
        Dimension dimension = this.getSize();
        Point point = this.vRuler.mapToBoard(n, n);
        this.limity = true;
        this.x1 = 0;
        this.x2 = dimension.width - 1;
        this.y2 = this.y1 = point.y;
        this.editorState = 16;
        this.editorField = 0;
        this.hasXorFigure = true;
        this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        return true;
    }

    @Override
    public boolean dragTopMargin(int n) {
        if (n >= 0) {
            Point point = this.vRuler.mapToBoard(n, n);
            if (this.y1 != point.y) {
                int n2 = this.y1;
                this.y2 = this.y1 = point.y;
                this.drawXorDotsline(this.x1, n2, this.x2, n2);
                this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean overDragTopMargin(int n) {
        Point point = this.vRuler.mapToBoard(n, n);
        this.editorState = 0;
        this.editorField = 0;
        this.limitx = false;
        this.limity = false;
        this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        this.hasXorFigure = false;
        return true;
    }

    @Override
    public boolean prepareDragLeftMargin(int n) {
        Dimension dimension = this.getSize();
        Point point = this.hRuler.mapToBoard(n, n);
        this.limitx = true;
        this.x2 = this.x1 = point.x;
        this.y1 = 0;
        this.y2 = dimension.height - 1;
        this.editorState = 16;
        this.editorField = 0;
        this.hasXorFigure = true;
        this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        return true;
    }

    @Override
    public boolean dragLeftMargin(int n) {
        if (n >= 0) {
            Point point = this.hRuler.mapToBoard(n, n);
            if (this.x1 != point.x) {
                int n2 = this.x1;
                this.x2 = this.x1 = point.x;
                this.drawXorDotsline(n2, this.y1, n2, this.y2);
                this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean overDragLeftMargin(int n) {
        Point point = this.hRuler.mapToBoard(n, n);
        this.editorState = 0;
        this.editorField = 0;
        this.limitx = false;
        this.limity = false;
        this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        this.hasXorFigure = false;
        return true;
    }

    @Override
    public boolean prepareDragBottomMargin(int n) {
        Dimension dimension = this.getSize();
        n = this.vRuler.getSize().height - n;
        Point point = this.vRuler.mapToBoard(n, n);
        this.limity = true;
        this.x1 = 0;
        this.x2 = dimension.width - 1;
        this.y2 = this.y1 = point.y;
        this.editorState = 16;
        this.editorField = 0;
        this.hasXorFigure = true;
        this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        return true;
    }

    @Override
    public boolean dragBottomMargin(int n) {
        if (n >= 0) {
            n = this.vRuler.getSize().height - n;
            Point point = this.vRuler.mapToBoard(n, n);
            if (this.y1 != point.y) {
                int n2 = this.y1;
                this.y2 = this.y1 = point.y;
                this.drawXorDotsline(this.x1, n2, this.x2, n2);
                this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean overDragBottomMargin(int n) {
        Point point = this.vRuler.mapToBoard(n, n);
        this.editorState = 0;
        this.editorField = 0;
        this.limitx = false;
        this.limity = false;
        this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        this.hasXorFigure = false;
        return true;
    }

    @Override
    public boolean prepareDragRightMargin(int n) {
        Dimension dimension = this.getSize();
        n = this.hRuler.getSize().width - n;
        Point point = this.hRuler.mapToBoard(n, n);
        this.limitx = true;
        this.x2 = this.x1 = point.x;
        this.y1 = 0;
        this.y2 = dimension.height - 1;
        this.editorState = 16;
        this.editorField = 0;
        this.hasXorFigure = true;
        this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        return true;
    }

    @Override
    public boolean dragRightMargin(int n) {
        if (n >= 0) {
            n = this.hRuler.getSize().width - n;
            Point point = this.hRuler.mapToBoard(n, n);
            if (this.x1 != point.x) {
                int n2 = this.x1;
                this.x2 = this.x1 = point.x;
                this.drawXorDotsline(n2, this.y1, n2, this.y2);
                this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean overDragRightMargin(int n) {
        Point point = this.hRuler.mapToBoard(n, n);
        this.editorState = 0;
        this.editorField = 0;
        this.limitx = false;
        this.limity = false;
        this.drawXorDotsline(this.x1, this.y1, this.x2, this.y2);
        this.hasXorFigure = false;
        return true;
    }

    public Editable getEditable() {
        return this.activeObj;
    }

    public void setEditableArea(Rectangle rectangle) {
        this.setEditableArea(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
    }

    public void setEditableAreaLeft(int n) {
        this.moreLeft = n;
    }

    public void setEditableAreaTop(int n) {
        this.moreTop = n;
    }

    public void setEditableAreaRight(int n) {
        this.moreRight = n;
    }

    public void setEditableAreaBottom(int n) {
        this.moreBottom = n;
    }

    public void setEditableArea(int n, int n2, int n3, int n4) {
        this.moreLeft = n;
        this.moreTop = n2;
        this.moreRight = n3;
        this.moreBottom = n4;
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        if (n == 401) {
            int n2 = keyEvent.getKeyCode();
            boolean bl = keyEvent.isShiftDown();
            boolean bl2 = keyEvent.isControlDown();
            if (n2 == 112 && !bl && !bl2) {
                this.help();
            } else if (this.activeObj.isVisible()) {
                EditablePeer editablePeer = this.activeObj.getOwner();
                if (editablePeer != null && editablePeer.canBeEdited()) {
                    if (this.editorState == 0) {
                        Rectangle rectangle = ((Component)((Object)editablePeer)).getBounds();
                        this.offsetx = rectangle.x;
                        this.offsety = rectangle.y;
                        if (n2 == 37 || n2 == 38 || n2 == 39 || n2 == 40) {
                            if (bl && !bl2) {
                                this.x1 = rectangle.width - 1;
                                this.y1 = rectangle.height - 1;
                                this.keyEditor = true;
                            } else if (bl2 && !bl) {
                                this.x1 = rectangle.width >> 1;
                                this.y1 = rectangle.height >> 1;
                                this.keyEditor = true;
                            }
                        }
                        if (this.keyEditor) {
                            this.lastx = this.x1 + this.offsetx;
                            this.lasty = this.y1 + this.offsety;
                            this.startEditor(this.x1, this.y1);
                        }
                    }
                    if (this.editorState >= 1 && this.editorState <= 9 && this.keyEditor && (bl || bl2)) {
                        int n3 = this.gridSnap ? this.grid : 1;
                        switch (n2) {
                            case 37: {
                                this.x1 -= n3;
                                break;
                            }
                            case 39: {
                                this.x1 += n3;
                                break;
                            }
                            case 38: {
                                this.y1 -= n3;
                                break;
                            }
                            case 40: {
                                this.y1 += n3;
                            }
                        }
                        int n4 = this.x1 + this.offsetx;
                        int n5 = this.y1 + this.offsety;
                        Point point = this.updatePointWithGrid(n4, n5);
                        if (point != null) {
                            n4 = point.x;
                            n5 = point.y;
                        }
                        this.dx = n4 - this.lastx;
                        this.dy = n5 - this.lasty;
                        this.handleBounds();
                    }
                    if (!this.keyEditor) {
                        this.keyboardScrolls(keyEvent);
                    }
                } else {
                    this.keyboardScrolls(keyEvent);
                }
            } else {
                this.keyboardScrolls(keyEvent);
            }
        } else if (n == 402) {
            int n6 = keyEvent.getModifiers();
            if (this.editorState >= 1 && this.editorState <= 9 && this.keyEditor && n6 != 1 && n6 != 2) {
                this.geometryDo();
                this.keyEditor = false;
            } else if (keyEvent.getKeyChar() == '\u001b' && this.editorState == 11 || this.editorState == 12) {
                this.cancelInsertion();
            }
        }
        super.processKeyEvent(keyEvent);
    }

    void keyboardScrolls(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 33: {
                if (keyEvent.isControlDown()) {
                    if (this.scrollsListener == null) break;
                    this.scrollsListener.leftBlock();
                    break;
                }
                if (this.scrollsListener == null) break;
                this.scrollsListener.upBlock();
                break;
            }
            case 34: {
                if (keyEvent.isControlDown()) {
                    if (this.scrollsListener == null) break;
                    this.scrollsListener.rightBlock();
                    break;
                }
                if (this.scrollsListener == null) break;
                this.scrollsListener.downBlock();
                break;
            }
            case 35: {
                if (keyEvent.isControlDown()) {
                    if (this.scrollsListener == null) break;
                    this.scrollsListener.rightDownEnd();
                    break;
                }
                if (this.scrollsListener == null) break;
                this.scrollsListener.rightEnd();
                break;
            }
            case 36: {
                if (keyEvent.isControlDown()) {
                    if (this.scrollsListener == null) break;
                    this.scrollsListener.leftUpHome();
                    break;
                }
                if (this.scrollsListener == null) break;
                this.scrollsListener.leftHome();
                break;
            }
            case 37: {
                if (this.scrollsListener == null) break;
                this.scrollsListener.leftUnit();
                break;
            }
            case 38: {
                if (this.scrollsListener == null) break;
                this.scrollsListener.upUnit();
                break;
            }
            case 39: {
                if (this.scrollsListener == null) break;
                this.scrollsListener.rightUnit();
                break;
            }
            case 40: {
                if (this.scrollsListener == null) break;
                this.scrollsListener.downUnit();
                break;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (mouseEvent.isControlDown() && (component == this.activeObj || component instanceof Editable || component instanceof EditablePeer)) {
            this.multipSelection(component, mouseEvent.getX(), mouseEvent.getY());
        }
        if (component == this.activeObj && (component = (Component)((Object)((Editable)component).getOwner())) instanceof MouseListener) {
            ((MouseListener)((Object)component)).mouseClicked(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (this.frame != null) {
            Component component2 = this.frame.getFocusOwner();
            if (component != this.activeObj && component2 instanceof EditablePeer && ((EditablePeer)((Object)component2)).getStatus() == 4) {
                this.getParent().requestFocus();
            }
            this.requestFocus();
        }
        if (mouseEvent.isPopupTrigger() && System.getProperty("os.name").equals("Solaris")) {
            if (component == this.activeObj || component instanceof Editable) {
                if (((EditablePeer)((Object)(component = (Component)((Object)((Editable)component).getOwner())))).getStatus() != 4) {
                    this.showPopupMenu(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                }
            } else if (component instanceof EditablePeer) {
                this.showPopupMenu(mouseEvent);
            }
        } else if (mouseEvent.isAltDown() || mouseEvent.isMetaDown()) {
            if (this.editorState == 11 || this.editorState == 12) {
                this.cancelInsertion();
            }
        } else if (mouseEvent.getX() >= 0 && mouseEvent.getY() >= 0) {
            if (this.editorState == 0 && !mouseEvent.isControlDown()) {
                if (component == this.activeObj || component instanceof Editable) {
                    EditablePeer editablePeer = ((Editable)component).getOwner();
                    if (editablePeer != null && editablePeer.getStatus() != 4) {
                        Point point = editablePeer instanceof EditableFigurePeer ? editablePeer.mapLocToBoard() : component.getLocation();
                        this.offsetx = point.x;
                        this.offsety = point.y;
                        int n = mouseEvent.getX();
                        int n2 = mouseEvent.getY();
                        this.lastx = n + this.offsetx;
                        this.lasty = n2 + this.offsety;
                        if (component == this.activeObj && component.contains(n, n2) && editablePeer.canBeEdited() && editablePeer.inBlackBlock(n, n2, editablePeer.getEdCtrls()) != 0 && mouseEvent.getClickCount() == 1) {
                            this.startEditor(n, n2);
                        } else {
                            this.startMultipSelection();
                        }
                    }
                } else if (component == this) {
                    this.offsetx = 0;
                    this.offsety = 0;
                    this.lastx = mouseEvent.getX();
                    this.lasty = mouseEvent.getY();
                    this.startMultipSelection();
                } else if (component instanceof EditablePeer) {
                    Point point = ((EditablePeer)((Object)component)).mapLocToBoard();
                    this.offsetx = point.x;
                    this.offsety = point.y;
                    this.lastx = mouseEvent.getX() + this.offsetx;
                    this.lasty = mouseEvent.getY() + this.offsety;
                    this.startMultipSelection();
                } else if (component instanceof Splitterbar) {
                    Point point = component.getLocation();
                    this.offsetx = point.x;
                    this.offsety = point.y;
                    this.lastx = mouseEvent.getX() + this.offsetx;
                    this.lasty = mouseEvent.getY() + this.offsety;
                    this.startDragSplitterbar((Splitterbar)component);
                }
            } else if (this.editorState == 11 || this.editorState == 12) {
                this.mouseMoved(mouseEvent);
                if (this.editorState == 11 && this.hasFigure) {
                    component = mouseEvent.getComponent();
                    if (component == this) {
                        this.offsetx = 0;
                        this.offsety = 0;
                    } else if (component instanceof Editable || component instanceof Splitterbar) {
                        Point point = component.getLocation();
                        this.offsetx = point.x;
                        this.offsety = point.y;
                    } else if (component instanceof EditablePeer) {
                        Point point = ((EditablePeer)((Object)component)).mapLocToBoard();
                        this.offsetx = point.x;
                        this.offsety = point.y;
                    }
                    this.startInsertFigure();
                } else {
                    this.insertDo();
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        this.mouseDragged(mouseEvent);
        boolean bl2 = bl = !this.hasXorFigure;
        if (this.editorState == 10) {
            if (this.hasXorFigure) {
                this.insertDo();
            } else {
                this.cancelInsertion();
            }
        } else if (this.editorState >= 1 && this.editorState <= 9) {
            this.geometryDo();
        } else if (this.editorState == 13) {
            this.multipSelectionDo(mouseEvent.getClickCount(), mouseEvent.getComponent());
        } else if (this.editorState == 14) {
            this.splitterbarDragDo();
        }
        if (bl && mouseEvent.isPopupTrigger() && mouseEvent.getX() >= 0 && mouseEvent.getY() >= 0 && !System.getProperty("os.name").equals("Solaris")) {
            Component component = mouseEvent.getComponent();
            if (component == this.activeObj || component instanceof Editable) {
                if ((component = (Component)((Object)((Editable)component).getOwner())) != null && ((EditablePeer)((Object)component)).getStatus() != 4) {
                    this.showPopupMenu(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                }
            } else if (component instanceof EditablePeer) {
                this.showPopupMenu(mouseEvent);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Component component;
        if (this.editorState == 0 && (component = mouseEvent.getComponent()) == this.activeObj) {
            this.activeObj.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() + this.offsetx;
        int n2 = mouseEvent.getY() + this.offsety;
        if (this.editorState >= 1 && this.editorState <= 9 || this.editorState == 10) {
            Point point = this.updatePointWithGrid(n, n2);
            if (point != null) {
                n = point.x;
                n2 = point.y;
            }
            this.dx = n - this.lastx;
            this.dy = n2 - this.lasty;
            this.handleBounds();
        } else if (this.editorState == 13) {
            this.dx = n - this.lastx;
            this.dy = n2 - this.lasty;
            this.handleMarkArea();
        } else if (this.editorState == 14) {
            if (this.orientation == 0) {
                this.dy = mouseEvent.getY() + this.offsety - this.lasty;
            } else {
                this.dx = mouseEvent.getX() + this.offsetx - this.lastx;
            }
            this.handleSplitterbar();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.editorState == 0) {
            Component component = mouseEvent.getComponent();
            if (component == this.activeObj) {
                this.activeObj.mouseMoving(mouseEvent.getX(), mouseEvent.getY(), this.edCtrls);
            } else if (component == this) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (this.editorState == 11 || this.editorState == 12) {
            Point point;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Component component = mouseEvent.getComponent();
            if (component instanceof Editable || component instanceof EditablePeer || component instanceof Splitterbar) {
                if (component instanceof EditablePeer) {
                    point = ((EditablePeer)((Object)component)).mapLocToBoard();
                    n += point.x;
                    n2 += point.y;
                } else {
                    point = component.getLocation();
                    n += point.x;
                    n2 += point.y;
                }
            }
            if ((point = this.updatePointWithGrid(n, n2)) != null) {
                n = point.x;
                n2 = point.y;
            }
            point = this.updatePointWithSplitterbar(n, n2);
            point = this.checkPoint(point.x, point.y);
            n = point.x;
            n2 = point.y;
            if (!this.hasXorFigure) {
                this.startInsert();
            }
            this.dx = n - this.lastx;
            this.dy = n2 - this.lasty;
            this.handleBounds();
        }
    }

    protected boolean isInsertPaste() {
        int n = this.editedComps.size();
        if (n != this.selections.size()) {
            return false;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (((Editable)this.selections.elementAt(i)).getOwner() == this.editedComps.elementAt(i)) continue;
            return false;
        }
        return true;
    }

    protected void startEditor(int n, int n2) {
        this.editorState = this.checkCursorPos(n, n2);
        this.curLeft = Short.MAX_VALUE;
        this.curTop = Short.MAX_VALUE;
        this.curRight = Short.MIN_VALUE;
        this.curBottom = Short.MIN_VALUE;
        this.editedComps.removeAllElements();
        this.editedBounds.removeAllElements();
        this.oldBounds.removeAllElements();
        this.hasFigure = false;
        for (int i = 0; i < this.selections.size(); ++i) {
            int n3;
            Rectangle rectangle;
            Editable editable = (Editable)this.selections.elementAt(i);
            EditablePeer editablePeer = editable.getOwner();
            this.editedComps.addElement(editablePeer);
            if (editablePeer instanceof EditableFigurePeer) {
                rectangle = editablePeer.mapBoundsToBoard();
                ((EditableFigurePeer)editablePeer).getRealBounds(rectangle, this.editorState);
            } else {
                rectangle = editable.getBounds();
            }
            this.curLeft = rectangle.x < this.curLeft ? rectangle.x : this.curLeft;
            int n4 = this.curTop = rectangle.y < this.curTop ? rectangle.y : this.curTop;
            if (editablePeer instanceof EditableFigurePeer) {
                this.hasFigure = true;
                n3 = rectangle.x + rectangle.width - 1;
                this.curRight = n3 > this.curRight ? n3 : this.curRight;
                n3 = rectangle.y + rectangle.height - 1;
                this.curBottom = n3 > this.curBottom ? n3 : this.curBottom;
            } else {
                n3 = rectangle.x + rectangle.width - 1;
                this.curRight = (this.editorField & 4) == 4 ? (n3 > this.curRight ? n3 : this.curRight) : (rectangle.x > this.curRight ? rectangle.x : this.curRight);
                n3 = rectangle.y + rectangle.height - 1;
                this.curBottom = (this.editorField & 8) == 8 ? (n3 > this.curBottom ? n3 : this.curBottom) : (rectangle.y > this.curBottom ? rectangle.y : this.curBottom);
            }
            this.editedBounds.addElement(rectangle);
            this.oldBounds.addElement(new Rectangle());
        }
        if (this.hasFigure) {
            this.limitx = true;
            this.limity = true;
        }
        this.initBounds();
    }

    protected void startMultipSelection() {
        if (this.lastx >= this.moreLeft && this.lastx <= this.moreRight && this.lasty >= this.moreTop && this.lasty <= this.moreBottom) {
            this.limitx = true;
            this.limity = true;
            Point point = this.checkPoint(this.lastx, this.lasty);
            this.lastx = point.x;
            this.lasty = point.y;
            this.markArea.setBounds(this.lastx, this.lasty, 0, 0);
            this.selectedArea.setBounds(this.markArea);
            this.curLeft = this.lastx;
            this.curTop = this.lasty;
            this.curRight = this.lastx;
            this.curBottom = this.lasty;
            this.editorState = 13;
            this.hasXorFigure = false;
        }
    }

    protected void startDragSplitterbar(Splitterbar splitterbar) {
        Rectangle rectangle;
        this.limitx = false;
        this.limity = false;
        this.orientation = splitterbar.orientation;
        SplitterContainer splitterContainer = splitterbar.getTopLeftSplitterContainer(0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        int n = splitterContainer.getComponentCount();
        Component[] componentArray = splitterContainer.getComponents();
        for (int i = n - 1; i >= 0; --i) {
            Component component = componentArray[i];
            rectangle = component.getBounds();
            rectangle2 = rectangle2.union(rectangle);
        }
        this.markArea = splitterbar.getBounds();
        rectangle = splitterContainer.mapBoundsToBoard();
        if (this.orientation == 0) {
            this.minTopLeft = rectangle2.y + rectangle2.height;
            this.minTopLeft = this.minTopLeft <= 0 ? rectangle.y + 1 : rectangle.y + this.minTopLeft;
            --this.markArea.y;
            this.markArea.height -= 2;
        } else {
            this.minTopLeft = rectangle2.width + rectangle2.x;
            this.minTopLeft = this.minTopLeft <= 0 ? rectangle.x + 1 : rectangle.x + this.minTopLeft;
            --this.markArea.x;
            this.markArea.width -= 2;
        }
        this.curBar = splitterbar;
        this.editorState = 14;
        this.hasXorFigure = false;
    }

    protected void startInsertFigure() {
        Rectangle rectangle = (Rectangle)this.editedBounds.elementAt(0);
        this.lastx = rectangle.x;
        this.lasty = rectangle.y;
        this.editorState = 10;
        this.editorField = 12;
        this.hasXorFigure = false;
        this.osx = 0;
        this.osy = 0;
    }

    protected void startDrawDragInsert(int n, int n2) {
        this.lastx = this.markArea.x;
        this.lasty = this.markArea.y;
    }

    protected void startInsert() {
        EditablePeer editablePeer;
        Rectangle rectangle = (Rectangle)this.editedBounds.elementAt(0);
        this.lastx = this.editorState == 12 && this.hasFigure ? ((editablePeer = (EditablePeer)this.editedComps.elementAt(0)) instanceof EditableLine && ((EditableLine)editablePeer).isPositiveSlope() ? rectangle.x + rectangle.width : rectangle.x) : rectangle.x;
        this.lasty = rectangle.y;
    }

    protected void handleMarkArea() {
        if (this.dx != 0 || this.dy != 0) {
            int n = this.markArea.x + this.markArea.width + this.dx;
            int n2 = this.markArea.y + this.markArea.height + this.dy;
            this.checkIncrement(n, n2, n, n2);
            if (this.dx != 0 || this.dy != 0) {
                this.markArea.setSize(this.markArea.width + this.dx, this.markArea.height + this.dy);
                this.lastx += this.dx;
                this.lasty += this.dy;
                if (this.scrollsListener != null) {
                    Dimension dimension = this.getSize();
                    n = this.markArea.x + this.markArea.width;
                    n2 = this.markArea.y + this.markArea.height;
                    this.dx = n > dimension.width || n < 0 ? this.dx : 0;
                    int n3 = this.dy = n2 > dimension.height || n2 < 0 ? this.dy : 0;
                    if (this.dx != 0 || this.dy != 0) {
                        if (this.hasXorFigure) {
                            this.drawXorRect(this.selectedArea);
                            this.hasXorFigure = false;
                        }
                        Point point = this.scrollsListener.autoScrolls(this.dx, this.dy);
                        if (point.x != 0 || point.y != 0) {
                            this.markArea.translate(-point.x, -point.y);
                            this.selectedArea.translate(-point.x, -point.y);
                        }
                    }
                }
                if (this.hasXorFigure) {
                    this.drawXorRect(this.selectedArea);
                } else {
                    this.hasXorFigure = true;
                }
                this.calculateValidArea(this.selectedArea, this.markArea);
                this.drawXorRect(this.selectedArea);
            }
        }
    }

    protected void handleSplitterbar() {
        if (this.orientation == 0) {
            int n = this.dy < 0 ? (this.markArea.y + this.dy < this.minTopLeft ? this.minTopLeft - this.markArea.y : this.dy) : (this.dy = this.dy);
            if (this.dy != 0) {
                if (this.hasXorFigure) {
                    this.drawXorBar(this.markArea);
                } else {
                    this.hasXorFigure = true;
                }
                this.markArea.y += this.dy;
                this.drawXorBar(this.markArea);
                this.lasty += this.dy;
            }
        } else {
            int n = this.dx < 0 ? (this.markArea.x + this.dx < this.minTopLeft ? this.minTopLeft - this.markArea.x : this.dx) : (this.dx = this.dx);
            if (this.dx != 0) {
                if (this.hasXorFigure) {
                    this.drawXorBar(this.markArea);
                } else {
                    this.hasXorFigure = true;
                }
                this.markArea.x += this.dx;
                this.drawXorBar(this.markArea);
                this.lastx += this.dx;
            }
        }
    }

    protected void handleBounds() {
        if (this.dx != 0 || this.dy != 0) {
            Rectangle rectangle;
            int n;
            boolean bl = (this.editorField & 4) == 4;
            boolean bl2 = (this.editorField & 8) == 8;
            boolean bl3 = (this.editorField & 0x10) == 16;
            boolean bl4 = (this.editorField & 0x20) == 32;
            boolean bl5 = (this.editorField & 1) == 1;
            boolean bl6 = (this.editorField & 2) == 2;
            boolean bl7 = bl || this.editorState == 1 || this.editorState == 11 || this.editorState == 12;
            boolean bl8 = bl2 || this.editorState == 1 || this.editorState == 11 || this.editorState == 12;
            this.checkIncrement(bl5 ? this.curLeft + this.dx : this.moreLeft, bl6 ? this.curTop + this.dy : this.moreTop, bl7 ? this.curRight + this.dx : this.moreRight, bl8 ? this.curBottom + this.dy : this.moreBottom);
            if (this.dx != 0 || this.dy != 0) {
                Rectangle rectangle2;
                int n2 = this.dx;
                int n3 = this.dy;
                int n4 = this.editedBounds.size();
                Rectangle rectangle3 = this.hasFigure ? new Rectangle() : null;
                for (n = n4 - 1; n >= 0 && (this.dx != 0 || this.dy != 0); --n) {
                    boolean bl9;
                    rectangle = (Rectangle)this.editedBounds.elementAt(n);
                    rectangle2 = (Rectangle)this.oldBounds.elementAt(n);
                    rectangle2.setBounds(bl5 ? rectangle.x + this.dx : rectangle.x, bl6 ? rectangle.y + this.dy : rectangle.y, bl ? rectangle.width + this.dx : (bl3 ? rectangle.width - this.dx : rectangle.width), bl2 ? rectangle.height + this.dy : (bl4 ? rectangle.height - this.dy : rectangle.height));
                    EditablePeer editablePeer = (EditablePeer)this.editedComps.elementAt(n);
                    boolean bl10 = bl9 = this.hasFigure && editablePeer instanceof EditableFigurePeer && (this.editorState != 11 || !this.hasFigure);
                    if (bl9) {
                        rectangle3.setBounds(rectangle2);
                        ((EditableFigurePeer)editablePeer).getLogBounds(rectangle3, this.editorState);
                        if (!(editablePeer instanceof EditableLine)) {
                            rectangle3.width += rectangle3.x - 1;
                            rectangle3.height += rectangle3.y - 1;
                        }
                        int n5 = rectangle3.x < this.moreLeft ? rectangle3.x - this.moreLeft : (rectangle3.x > this.moreRight ? rectangle3.x - this.moreRight : (rectangle3.width < this.moreLeft ? rectangle3.width - this.moreLeft : (this.dx = rectangle3.width > this.moreRight ? rectangle3.width - this.moreRight : this.dx)));
                        this.dy = rectangle3.y < this.moreTop ? rectangle3.x - this.moreTop : (rectangle3.y > this.moreBottom ? rectangle3.y - this.moreBottom : (rectangle3.height < this.moreTop ? rectangle3.height - this.moreBottom : (rectangle3.height > this.moreBottom ? rectangle3.width - this.moreRight : this.dy)));
                    }
                    this.checkBound(rectangle2, bl9);
                    this.dx = this.dx != n2 ? 0 : this.dx;
                    this.dy = this.dy != n3 ? 0 : this.dy;
                }
                if (this.dx != 0 || this.dy != 0) {
                    if (this.dx != n2 || this.dy != n3) {
                        for (n = n4 - 1; n >= 0 && (this.dx != 0 || this.dy != 0); --n) {
                            rectangle = (Rectangle)this.editedBounds.elementAt(n);
                            rectangle2 = (Rectangle)this.oldBounds.elementAt(n);
                            rectangle2.setBounds(bl5 ? rectangle.x + this.dx : rectangle.x, bl6 ? rectangle.y + this.dy : rectangle.y, bl ? rectangle.width + this.dx : (bl3 ? rectangle.width - this.dx : rectangle.width), bl2 ? rectangle.height + this.dy : (bl4 ? rectangle.height - this.dy : rectangle.height));
                        }
                    }
                    if (this.dx != 0 || this.dy != 0) {
                        this.curLeft += bl5 ? this.dx : 0;
                        this.curTop += bl6 ? this.dy : 0;
                        this.curRight += bl7 ? this.dx : 0;
                        this.curBottom += bl8 ? this.dy : 0;
                    }
                }
            }
            if (this.dx != 0 || this.dy != 0) {
                this.lastx += this.dx;
                this.lasty += this.dy;
                if (this.scrollsListener != null && this.editorState != 11 && this.editorState != 12) {
                    int n6;
                    int n7;
                    Dimension dimension = this.getSize();
                    --dimension.width;
                    --dimension.height;
                    int n8 = this.curRight - this.curLeft;
                    n8 = n8 < 0 ? -n8 : n8;
                    int n9 = this.curBottom - this.curTop;
                    n9 = n9 < 0 ? -n9 : n9;
                    rectangle = (Rectangle)this.oldBounds.elementAt(0);
                    int n10 = bl5 ? rectangle.x + this.osx : (n7 = bl ? rectangle.x + rectangle.width + this.osx : 0);
                    int n11 = bl6 ? rectangle.y + this.osy : (n6 = bl2 ? rectangle.y + rectangle.height + this.osx : 0);
                    int n12 = this.dx < 0 ? (n7 < 0 ? n7 : (n8 < dimension.width ? (this.curLeft < 0 && bl5 ? this.curLeft : (this.curRight < 0 ? this.curRight : 0)) : 0)) : (n7 > dimension.width ? n7 - dimension.width : (n8 < dimension.width ? (this.curLeft > dimension.width ? this.curLeft - dimension.width : (this.curRight > dimension.width ? this.curRight - dimension.width : 0)) : (this.dx = 0)));
                    int n13 = this.dy < 0 ? (n6 < 0 ? n6 : (n9 < dimension.height ? (this.curTop < 0 && bl6 ? this.curTop : (this.curBottom < 0 ? this.curBottom : 0)) : 0)) : (n6 > dimension.height ? n6 - dimension.height : (n9 < dimension.height ? (this.curTop > dimension.height ? this.curTop - dimension.height : (this.curBottom > dimension.height ? this.curBottom - dimension.height : 0)) : (this.dy = 0)));
                    if (this.dx != 0 || this.dy != 0) {
                        if (this.hasXorFigure) {
                            if (this.hasFigure) {
                                this.drawXorRect(this.editedComps, this.editedBounds);
                            } else {
                                this.drawXorRect(this.editedBounds);
                            }
                            this.hasXorFigure = false;
                        }
                        Point point = this.scrollsListener.autoScrolls(this.dx, this.dy);
                        if (point.x != 0 || point.y != 0) {
                            this.curLeft -= point.x;
                            this.curRight -= point.x;
                            this.curTop -= point.y;
                            this.curBottom -= point.y;
                            for (n = this.oldBounds.size() - 1; n >= 0; --n) {
                                ((Rectangle)this.oldBounds.elementAt(n)).translate(-point.x, -point.y);
                            }
                        }
                    }
                }
                this.drawXorEditorBounds();
            }
        }
    }

    void drawXorEditorBounds() {
        Vector vector = this.oldBounds;
        this.oldBounds = this.editedBounds;
        this.editedBounds = vector;
        if (!this.hasFigure || this.editorState != 11) {
            if (this.hasXorFigure) {
                if (this.hasFigure) {
                    this.drawXorRect(this.editedComps, this.oldBounds);
                } else {
                    this.drawXorRect(this.oldBounds);
                }
            } else {
                this.hasXorFigure = true;
            }
            if (this.hasFigure) {
                this.drawXorRect(this.editedComps, this.editedBounds);
            } else {
                this.drawXorRect(this.editedBounds);
            }
        }
    }

    protected Point checkPoint(int n, int n2) {
        return new Point(this.limitx ? (n < this.moreLeft ? this.moreLeft : (n > this.moreRight ? this.moreRight : n)) : n, this.limity ? (n2 < this.moreTop ? this.moreTop : (n2 > this.moreBottom ? this.moreBottom : n2)) : n2);
    }

    protected void checkIncrement(int n, int n2, int n3, int n4) {
        this.dx += this.curRight - this.curLeft > this.moreRight - this.moreLeft ? (this.dx > 0 ? -this.dx : 0) : (this.limitx ? (this.dx > 0 ? (n3 > this.moreRight ? this.moreRight - n3 : (n > this.moreRight ? this.moreRight - n : 0)) : (this.dx < 0 ? (n < this.moreLeft ? this.moreLeft - n : (n3 < this.moreLeft ? this.moreLeft - n3 : 0)) : 0)) : 0);
        this.dy += this.curBottom - this.curTop > this.moreBottom - this.moreTop ? (this.dy > 0 ? -this.dy : 0) : (this.limity ? (this.dy > 0 ? (n4 > this.moreBottom ? this.moreBottom - n4 : (n2 > this.moreBottom ? this.moreBottom - n2 : 0)) : (this.dy < 0 ? (n2 < this.moreTop ? this.moreTop - n2 : (n4 < this.moreTop ? this.moreTop - n4 : 0)) : 0)) : 0);
    }

    protected void checkBound(Rectangle rectangle, boolean bl) {
        if (this.gridComps != null) {
            int n;
            int n2;
            int n3;
            Rectangle rectangle2;
            Splitterbar splitterbar;
            int n4;
            boolean bl2;
            boolean bl3;
            boolean bl4 = bl3 = this.gridSnap && this.gridComps.size() > 0;
            if (this.hsbs != null) {
                bl2 = false;
                for (n4 = this.hsbsBounds.size() - 1; n4 >= 0 && this.dy != 0; --n4) {
                    splitterbar = (Splitterbar)this.hsbs.elementAt(n4);
                    if (!splitterbar.isVisible()) continue;
                    rectangle2 = (Rectangle)this.hsbsBounds.elementAt(n4);
                    n3 = rectangle2.height;
                    if ((this.editorField & 2) == 2) {
                        n2 = rectangle.y;
                        n = n2 - rectangle2.y;
                        if (n2 >= rectangle2.y && n < n3) {
                            int n5 = n = this.dy > 0 ? rectangle2.y - n2 - 1 : n3 - n + 1;
                            this.dy = bl ? this.dy + n : (bl3 ? 0 : this.dy + n);
                            bl2 = true;
                        }
                    }
                    if ((this.editorField & 8) == 8 || bl) {
                        n2 = rectangle.y + rectangle.height - 1;
                        n = n2 - rectangle2.y;
                        if (n2 >= rectangle2.y && n < n3) {
                            if (bl && bl2) {
                                this.dy = 0;
                            } else {
                                int n6 = n = this.dy > 0 ? rectangle2.y - n2 - 1 : n3 - n + 1;
                                this.dy = bl ? this.dy + n : (bl3 ? 0 : this.dy + n);
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) break;
                }
            }
            if (this.vsbs != null) {
                bl2 = false;
                for (n4 = this.vsbsBounds.size() - 1; n4 >= 0 && this.dx != 0; --n4) {
                    splitterbar = (Splitterbar)this.vsbs.elementAt(n4);
                    if (!splitterbar.isVisible()) continue;
                    rectangle2 = (Rectangle)this.vsbsBounds.elementAt(n4);
                    n3 = rectangle2.width;
                    if ((this.editorField & 1) == 1) {
                        n2 = rectangle.x;
                        n = n2 - rectangle2.x;
                        if (n2 >= rectangle2.x && n < n3) {
                            int n7 = n = this.dx > 0 ? rectangle2.x - n2 - 1 : n3 - n + 1;
                            this.dx = bl ? this.dx + n : (bl3 ? 0 : this.dx + n);
                            bl2 = true;
                        }
                    }
                    if ((this.editorField & 4) == 4 || bl) {
                        n2 = rectangle.x + rectangle.width - 1;
                        n = n2 - rectangle2.x;
                        if (n2 >= rectangle2.x && n < n3) {
                            if (bl && bl2) {
                                this.dx = 0;
                            } else {
                                int n8 = n = this.dx > 0 ? rectangle2.x - n2 - 1 : n3 - n + 1;
                                int n9 = bl ? this.dx + n : (this.dx = bl3 ? 0 : this.dx + n);
                            }
                        }
                    }
                    if (bl2) break;
                }
            }
        }
    }

    protected Point updatePointWithSplitterbar(int n, int n2) {
        Rectangle rectangle;
        Splitterbar splitterbar;
        int n3;
        Point point = new Point(n, n2);
        int n4 = 2;
        if (this.hsbs != null) {
            for (n3 = this.hsbsBounds.size() - 1; n3 >= 0; --n3) {
                splitterbar = (Splitterbar)this.hsbs.elementAt(n3);
                if (!splitterbar.isVisible()) continue;
                rectangle = (Rectangle)this.hsbsBounds.elementAt(n3);
                if (n2 < rectangle.y || n2 >= rectangle.y + rectangle.height) continue;
                point.y = point.y - rectangle.y > n4 ? rectangle.y + rectangle.height : rectangle.y - 1;
                break;
            }
        }
        if (this.vsbs != null) {
            for (n3 = this.vsbsBounds.size() - 1; n3 >= 0; --n3) {
                splitterbar = (Splitterbar)this.vsbs.elementAt(n3);
                if (!splitterbar.isVisible()) continue;
                rectangle = (Rectangle)this.vsbsBounds.elementAt(n3);
                if (n < rectangle.x || n >= rectangle.x + rectangle.width) continue;
                point.x = point.x - rectangle.x > n4 ? rectangle.x + rectangle.width : rectangle.x - 1;
                break;
            }
        }
        return point;
    }

    protected Point updatePointWithGrid(int n, int n2) {
        Point point = null;
        if (this.gridSnap && this.gridComps != null && this.editorState != 14) {
            int n3 = this.gridBounds.size();
            if (n3 > 0) {
                if (this.gridIndex >= 0 && this.gridIndex < n3) {
                    point = this.updatePointWithGrid(n, n2, (Rectangle)this.gridBounds.elementAt(this.gridIndex), (GridContainer)this.gridComps.elementAt(this.gridIndex));
                    if (point == null) {
                        this.gridIndex = n3 - 1;
                        while (this.gridIndex >= 0 && point == null) {
                            point = this.updatePointWithGrid(n, n2, (Rectangle)this.gridBounds.elementAt(this.gridIndex), (GridContainer)this.gridComps.elementAt(this.gridIndex));
                            --this.gridIndex;
                        }
                    }
                } else {
                    this.gridIndex = n3 - 1;
                    while (this.gridIndex >= 0 && point == null) {
                        point = this.updatePointWithGrid(n, n2, (Rectangle)this.gridBounds.elementAt(this.gridIndex), (GridContainer)this.gridComps.elementAt(this.gridIndex));
                        --this.gridIndex;
                    }
                }
            } else {
                this.gridIndex = -1;
            }
        } else {
            this.gridIndex = -1;
        }
        return point;
    }

    protected Point updatePointWithGrid(int n, int n2, Rectangle rectangle, GridContainer gridContainer) {
        Point point;
        if (rectangle.contains(n, n2) && gridContainer.isVisible()) {
            Point point2 = gridContainer.mapLocToBoard();
            point = gridContainer.alignPoint(n -= point2.x, n2 -= point2.y);
            point.translate(point2.x, point2.y);
        } else {
            point = null;
        }
        return point;
    }

    protected int checkCursorPos(int n, int n2) {
        this.limitx = false;
        this.limity = false;
        this.editorField = 0;
        int n3 = 0;
        Dimension dimension = this.activeObj.getSize();
        --dimension.width;
        --dimension.height;
        switch (this.activeObj.inEditorArea(n, n2, this.edCtrls)) {
            case 1: {
                this.editorField = 51;
                this.limitx = true;
                this.limity = true;
                this.lastx = this.offsetx;
                this.lasty = this.offsety;
                this.offsetx -= n;
                this.offsety -= n2;
                n3 = 2;
                break;
            }
            case 2: {
                this.editorField = 34;
                this.limity = true;
                this.lasty = this.offsety;
                this.offsety -= n2;
                n3 = 3;
                break;
            }
            case 4: {
                this.editorField = 38;
                this.limity = true;
                this.lastx = this.offsetx + dimension.width;
                this.lasty = this.offsety;
                this.offsetx += dimension.width - n;
                this.offsety -= n2;
                n3 = 4;
                break;
            }
            case 8: {
                this.editorField = 17;
                this.limitx = true;
                this.lastx = this.offsetx;
                this.offsetx -= n;
                n3 = 5;
                break;
            }
            case 16: {
                this.editorField = 4;
                this.lastx = this.offsetx + dimension.width;
                this.offsetx += dimension.width - n;
                n3 = 6;
                break;
            }
            case 32: {
                this.editorField = 25;
                this.limitx = true;
                this.lastx = this.offsetx;
                this.lasty = this.offsety + dimension.height;
                this.offsetx -= n;
                this.offsety += dimension.height - n2;
                n3 = 7;
                break;
            }
            case 64: {
                this.editorField = 8;
                this.lasty = this.offsety + dimension.height;
                this.offsety += dimension.height - n2;
                n3 = 8;
                break;
            }
            case 128: {
                this.editorField = 12;
                this.lastx = this.offsetx + dimension.width;
                this.lasty = this.offsety + dimension.height;
                this.offsetx += dimension.width - n;
                this.offsety += dimension.height - n2;
                n3 = 9;
                break;
            }
            case 256: {
                this.editorField = 3;
                this.limitx = true;
                this.limity = true;
                this.lastx = this.offsetx;
                this.lasty = this.offsety;
                this.offsetx -= n;
                this.offsety -= n2;
                n3 = 1;
            }
        }
        int n4 = (this.editorField & 1) == 1 ? n : (this.osx = (this.editorField & 4) == 4 ? n - dimension.width : 0);
        this.osy = (this.editorField & 2) == 2 ? n2 : ((this.editorField & 8) == 8 ? n2 - dimension.height : 0);
        return n3;
    }

    protected void calculateValidArea(Rectangle rectangle, Rectangle rectangle2) {
        rectangle.x = rectangle2.width < 0 ? rectangle2.x + rectangle2.width : rectangle2.x;
        rectangle.width = rectangle2.width < 0 ? -rectangle2.width : rectangle2.width;
        rectangle.y = rectangle2.height < 0 ? rectangle2.y + rectangle2.height : rectangle2.y;
        rectangle.height = rectangle2.height < 0 ? -rectangle2.height : rectangle2.height;
    }

    protected Editable getSelectedTarget() {
        Editable editable;
        if (this.unselections.empty()) {
            editable = new Editable();
            this.add((Component)editable, 1);
        } else {
            editable = (Editable)this.unselections.pop();
        }
        this.selections.addElement(editable);
        return editable;
    }

    protected void abandonSelectedTarget(Editable editable) {
        editable.setOwner(null);
        this.unselections.push(editable);
        this.selections.removeElement(editable);
    }

    protected void initBounds() {
        int n;
        if (this.gridBounds != null) {
            this.gridBounds.removeAllElements();
            for (n = 0; this.gridComps != null && n < this.gridComps.size(); ++n) {
                this.gridBounds.addElement(((TransparentPeer)this.gridComps.elementAt(n)).mapBoundsToBoard());
            }
        }
        if (this.hsbsBounds != null) {
            this.hsbsBounds.removeAllElements();
            for (n = 0; this.hsbs != null && n < this.hsbs.size(); ++n) {
                this.hsbsBounds.addElement(((Component)this.hsbs.elementAt(n)).getBounds());
            }
        }
        if (this.vsbsBounds != null) {
            this.vsbsBounds.removeAllElements();
            for (n = 0; this.vsbs != null && n < this.vsbs.size(); ++n) {
                this.vsbsBounds.addElement(((Component)this.vsbs.elementAt(n)).getBounds());
            }
        }
        this.hasXorFigure = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawXorDotsline(int n, int n2, int n3, int n4) {
        Graphics graphics = this.getGraphics();
        try {
            this.drawXorDotsline(graphics, n, n2, n3, n4);
        }
        finally {
            graphics.dispose();
        }
    }

    protected void drawXorDotsline(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setXORMode(new Color(this.getBackground().getRGB()));
        graphics.setColor(this.getForeground());
        if (n == n3) {
            while (n2 <= n4) {
                graphics.drawLine(n, n2, n3, n2 + 2);
                n2 += 6;
            }
        } else if (n2 == n4) {
            while (n <= n3) {
                graphics.drawLine(n, n2, n + 2, n4);
                n += 6;
            }
        }
        graphics.setPaintMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawXorBar(Rectangle rectangle) {
        Graphics graphics = this.getGraphics();
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            this.drawXorBar(graphics, rectangle);
        }
        finally {
            graphics.dispose();
        }
    }

    protected void drawXorBar(Graphics graphics, Rectangle rectangle) {
        Color color = this.getBackground();
        color = color.getRGB() == -8355712 ? color : Color.gray;
        graphics.setXORMode(color);
        graphics.setColor(this.getForeground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setPaintMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawXorRect(Rectangle rectangle) {
        Graphics graphics = this.getGraphics();
        try {
            this.drawXorRect(graphics, rectangle);
        }
        finally {
            graphics.dispose();
        }
    }

    protected void drawXorRect(Graphics graphics, Rectangle rectangle) {
        graphics.setXORMode(new Color(this.getBackground().getRGB()));
        graphics.setColor(this.getForeground());
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics.setPaintMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawXorRect(Vector vector) {
        Graphics graphics = this.getGraphics();
        try {
            this.drawXorRect(graphics, vector);
        }
        finally {
            graphics.dispose();
        }
    }

    protected void drawXorRect(Graphics graphics, Vector vector) {
        graphics.setXORMode(new Color(this.getBackground().getRGB()));
        graphics.setColor(this.getForeground());
        for (int i = vector.size() - 1; i >= 0; --i) {
            Rectangle rectangle = (Rectangle)vector.elementAt(i);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.setPaintMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawXorRect(Vector vector, Vector vector2) {
        Graphics graphics = this.getGraphics();
        try {
            this.drawXorRect(graphics, vector, vector2);
        }
        finally {
            graphics.dispose();
        }
    }

    protected void drawXorRect(Graphics graphics, Vector vector, Vector vector2) {
        graphics.setXORMode(new Color(this.getBackground().getRGB()));
        graphics.setColor(this.getForeground());
        for (int i = vector.size() - 1; i >= 0; --i) {
            Rectangle rectangle = (Rectangle)vector2.elementAt(i);
            EditablePeer editablePeer = (EditablePeer)vector.elementAt(i);
            if (editablePeer instanceof EditableFigurePeer) {
                ((EditableFigurePeer)editablePeer).paintFigure(graphics, rectangle, this.editorState);
                continue;
            }
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.setPaintMode();
    }

    @Override
    protected void paintXorFigure(Graphics graphics) {
        switch (this.editorState) {
            case 13: {
                this.drawXorRect(graphics, this.selectedArea);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.drawXorRect(graphics, this.editedComps, this.editedBounds);
                break;
            }
            case 14: {
                this.drawXorBar(graphics, this.markArea);
                break;
            }
            case 15: {
                this.drawXorDotsline(graphics, this.x1, this.x2, this.y1, this.y2);
            }
        }
    }

    void addSplitterbar(Splitterbar splitterbar) {
        if (splitterbar.getOrientation() == 0) {
            if (this.hsbs == null) {
                this.hsbs = new Vector();
                this.hsbsBounds = new Vector();
            }
            this.hsbs.addElement(splitterbar);
        } else {
            if (this.vsbs == null) {
                this.vsbs = new Vector();
                this.vsbsBounds = new Vector();
            }
            this.vsbs.addElement(splitterbar);
        }
    }

    void removeSplitterbar(Splitterbar splitterbar) {
        if (splitterbar.getOrientation() == 0) {
            this.hsbs.removeElement(splitterbar);
        } else {
            this.vsbs.removeElement(splitterbar);
        }
    }

    void addGridContainer(GridContainer gridContainer) {
        if (this.gridComps == null) {
            this.gridComps = new Vector();
            this.gridBounds = new Vector();
        }
        this.gridComps.addElement(gridContainer);
    }

    void removeGridContainer(GridContainer gridContainer) {
        this.gridComps.removeElement(gridContainer);
    }

    void addGuideline(Guideline guideline) {
        this.guidelines.addElement(guideline);
    }

    void removeGuideline(Guideline guideline) {
        this.guidelines.removeElement(guideline);
    }

    @Override
    public void selectDrawDrag(int n) {
        this.drawDragIns = true;
        this.lockCursor(Cursor.getPredefinedCursor(n));
        this.markArea.setBounds(0, 0, 50, 30);
        this.hasXorFigure = false;
    }

    @Override
    public void unselectDrawDrag() {
        this.drawDragIns = false;
        this.releasCursorLock();
    }

    public Vector getInvalidSelectedObject() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = this.selections.size() - 1; i >= 0; --i) {
            Editable editable = (Editable)this.selections.elementAt(i);
            Rectangle rectangle = editable.getBounds();
            EditablePeer editablePeer = editable.getOwner();
            if (editablePeer == null) continue;
            rectangle = editable.getBounds();
            if (rectangle.x >= this.moreLeft && rectangle.x <= this.moreRight && rectangle.y >= this.moreTop && rectangle.x <= this.moreBottom) continue;
            vector.addElement(editablePeer.getOwner());
        }
        return vector;
    }

    @Override
    public TransparentPeer getTransparentPeerAt(int n, int n2) {
        int n3 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < n3; ++i) {
            Component component = componentArray[i];
            if (component == null || !(component instanceof TransparentPeer) || !component.isVisible() || component == this.activeObj && !this.activeObj.getOwner().canBeEdited()) continue;
            Point point = component.getLocation();
            point.x = n - point.x;
            point.y = n2 - point.y;
            if (!component.contains(point)) continue;
            return (TransparentPeer)((Object)component);
        }
        return null;
    }

    protected void insertDo() {
        this.lockUpdate();
        for (int i = this.editedBounds.size() - 1; i >= 0; --i) {
            ((Rectangle)this.oldBounds.elementAt(i)).setBounds((Rectangle)this.editedBounds.elementAt(i));
        }
        if (this.editorState == 10 || this.hasFigure && this.editorState == 12) {
            this.turnToLogBounds();
        }
        boolean bl = this.overInsertEditor(this.editedComps, this.editedBounds);
        if (this.drawDragIns) {
            this.unselectDrawDrag();
            if (this.ddInsListener != null) {
                this.ddInsListener.overDrawDrag();
            }
        }
        if (this.hasXorFigure) {
            if (this.hasFigure) {
                this.drawXorRect(this.editedComps, this.oldBounds);
            } else {
                this.drawXorRect(this.oldBounds);
            }
            this.hasXorFigure = false;
        }
        if (bl) {
            this.normalState();
        }
        this.releasCursorLock();
        this.unlockUpdate();
    }

    protected void geometryDo() {
        if (this.hasXorFigure) {
            this.lockUpdate();
            for (int i = this.editedBounds.size() - 1; i >= 0; --i) {
                ((Rectangle)this.oldBounds.elementAt(i)).setBounds((Rectangle)this.editedBounds.elementAt(i));
            }
            if (this.hasFigure) {
                this.turnToLogBounds();
            }
            this.overGeometrySizeEditor(this.editedComps, this.editedBounds);
            if (this.hasFigure) {
                this.drawXorRect(this.editedComps, this.oldBounds);
            } else {
                this.drawXorRect(this.oldBounds);
            }
            this.hasXorFigure = false;
            this.unlockUpdate();
        }
        this.normalState();
    }

    protected void turnToRealBounds() {
        for (int i = this.editedComps.size() - 1; i >= 0; --i) {
            EditablePeer editablePeer = (EditablePeer)this.editedComps.elementAt(i);
            if (!(editablePeer instanceof EditableFigurePeer)) continue;
            ((EditableFigurePeer)editablePeer).getRealBounds((Rectangle)this.editedBounds.elementAt(i), this.editorState);
        }
    }

    protected void turnToLogBounds() {
        for (int i = this.editedComps.size() - 1; i >= 0; --i) {
            EditablePeer editablePeer = (EditablePeer)this.editedComps.elementAt(i);
            if (!(editablePeer instanceof EditableFigurePeer)) continue;
            ((EditableFigurePeer)editablePeer).getLogBounds((Rectangle)this.editedBounds.elementAt(i), this.editorState);
        }
    }

    protected void splitterbarDragDo() {
        if (this.hasXorFigure) {
            this.lockUpdate();
            Rectangle rectangle = this.curBar.getBounds();
            int n = this.orientation == 0 ? this.markArea.y - rectangle.y : this.markArea.x - rectangle.x;
            this.overSplitterbarMoving(this.curBar, this.orientation, n);
            this.drawXorBar(this.markArea);
            this.hasXorFigure = false;
            this.unlockUpdate();
        }
        this.normalState();
    }

    protected void multipSelectionDo(int n, Component component) {
        this.lockUpdate();
        if (component != this) {
            if (this.selectedArea.isEmpty()) {
                int n2 = this.selectedArea.x;
                int n3 = this.selectedArea.y;
                component = component != this.activeObj && component.contains(n2, n3) ? component : this.getComponentAt(n2, n3);
                Component component2 = component = component instanceof Editable ? (Component)((Object)((Editable)component).getOwner()) : component;
                if (component instanceof EditablePeer) {
                    EditablePeer editablePeer = (EditablePeer)((Object)component);
                    int n4 = n > 1 && editablePeer.canBeEditedContent() || editablePeer.getStatus() == 4 ? 4 : 3;
                    Vector<SelectionInfo> vector = new Vector<SelectionInfo>();
                    SelectionInfo selectionInfo = new SelectionInfo();
                    selectionInfo.target = editablePeer;
                    selectionInfo.state = n4;
                    vector.addElement(selectionInfo);
                    n4 = editablePeer.getStatus();
                    if (n4 == 1 || n4 == 2) {
                        for (int i = this.selections.size() - 1; i >= 0; --i) {
                            EditablePeer editablePeer2 = ((Editable)this.selections.elementAt(i)).getOwner();
                            if (editablePeer2 == editablePeer) continue;
                            SelectionInfo selectionInfo2 = new SelectionInfo();
                            selectionInfo2.target = editablePeer2;
                            selectionInfo2.state = 1;
                            vector.addElement(selectionInfo2);
                        }
                    }
                    this.selectObjects(vector, selectionInfo);
                }
            } else {
                this.markArea.setBounds(this.selectedArea);
                this.selectChildren(1, this.markArea);
            }
        }
        if (this.hasXorFigure) {
            this.drawXorRect(this.selectedArea);
            this.hasXorFigure = false;
        }
        this.unlockUpdate();
        this.normalState();
    }

    protected void normalState() {
        this.editorState = 0;
        this.editorField = 0;
        this.limitx = false;
        this.limity = false;
    }

    protected boolean overInsertEditor(Vector vector, Vector vector2) {
        return true;
    }

    protected void overMultipselected() {
        this.lockUpdate();
        this.selectChildren(1, new Rectangle(this.selectedArea));
        if (this.hasXorFigure) {
            this.drawXorRect(this.selectedArea);
        }
        this.selectedArea.setSize(0, 0);
        this.editorState = 0;
        this.unlockUpdate();
    }

    protected void multipSelection(Component component, int n, int n2) {
        component = component.contains(n, n2) ? component : this.getComponentAt(n, n2);
        Vector<SelectionInfo> vector = new Vector<SelectionInfo>();
        SelectionInfo selectionInfo = null;
        if (component == this.activeObj || component instanceof EditablePeer && ((EditablePeer)((Object)component)).getStatus() == 3) {
            SelectionInfo selectionInfo2;
            if (this.selections.size() > 1) {
                selectionInfo = new SelectionInfo();
                selectionInfo.target = ((Editable)this.selections.elementAt(1)).getOwner();
                selectionInfo.state = 3;
                vector.addElement(selectionInfo);
                for (int i = this.selections.size() - 1; i > 1; --i) {
                    EditablePeer editablePeer = ((Editable)this.selections.elementAt(i)).getOwner();
                    selectionInfo2 = new SelectionInfo();
                    selectionInfo2.target = editablePeer;
                    selectionInfo2.state = 1;
                    vector.addElement(selectionInfo2);
                }
            }
            selectionInfo2 = new SelectionInfo();
            selectionInfo2.target = this.activeObj.getOwner();
            selectionInfo2.state = 0;
            vector.addElement(selectionInfo2);
        } else if (component instanceof Editable) {
            selectionInfo = new SelectionInfo();
            selectionInfo.target = this.activeObj.getOwner();
            selectionInfo.state = 3;
            vector.addElement(selectionInfo);
            EditablePeer editablePeer = ((Editable)component).getOwner();
            SelectionInfo selectionInfo3 = new SelectionInfo();
            selectionInfo3.target = editablePeer;
            selectionInfo3.state = 0;
            vector.addElement(selectionInfo3);
            for (int i = this.selections.size() - 1; i > 0; --i) {
                EditablePeer editablePeer2 = ((Editable)this.selections.elementAt(i)).getOwner();
                if (editablePeer2 == editablePeer) continue;
                selectionInfo3 = new SelectionInfo();
                selectionInfo3.target = editablePeer2;
                selectionInfo3.state = 1;
                vector.addElement(selectionInfo3);
            }
        } else if (component instanceof EditablePeer && ((EditablePeer)((Object)component)).canBeEdited() && ((Editor)((Object)component)).canBeSelected() && (this.selections.size() == 0 || this.selections.size() > 0 && ((Editor)((Object)component)).canBeMultiSelect())) {
            EditablePeer editablePeer = this.activeObj.getOwner();
            if (editablePeer == null || !editablePeer.canBeEdited()) {
                selectionInfo = new SelectionInfo();
                selectionInfo.target = (EditablePeer)((Object)component);
                selectionInfo.state = 3;
                vector.addElement(selectionInfo);
            } else {
                SelectionInfo selectionInfo4;
                selectionInfo = new SelectionInfo();
                selectionInfo.target = this.activeObj.getOwner();
                selectionInfo.state = 3;
                vector.addElement(selectionInfo);
                for (int i = this.selections.size() - 1; i > 0; --i) {
                    editablePeer = ((Editable)this.selections.elementAt(i)).getOwner();
                    selectionInfo4 = new SelectionInfo();
                    selectionInfo4.target = editablePeer;
                    selectionInfo4.state = 1;
                    vector.addElement(selectionInfo4);
                }
                selectionInfo4 = new SelectionInfo();
                selectionInfo4.target = (EditablePeer)((Object)component);
                selectionInfo4.state = 1;
                vector.addElement(selectionInfo4);
            }
        }
        if (vector.size() > 0) {
            this.lockUpdate();
            this.selectObjects(vector, selectionInfo);
            this.unlockUpdate();
        }
    }

    protected void selectChildren(int n, Rectangle rectangle) {
        int n2;
        Component[] componentArray = this.getComponents();
        int n3 = this.getComponentCount();
        Vector<SelectionInfo> vector = new Vector<SelectionInfo>();
        for (int i = 0; i < n3; ++i) {
            Rectangle rectangle2;
            Component component = componentArray[i];
            if (component == null || !component.isVisible() || !(component instanceof EditablePeer) || !rectangle.intersects(rectangle2 = component.getBounds())) continue;
            if (component instanceof Container) {
                ((EdContainerPeer)((Object)component)).selectChildren(vector, rectangle);
                continue;
            }
            if (!(component instanceof Component)) continue;
            n2 = vector.size();
            if (!((EditablePeer)((Object)component)).canBeSelected() || n2 != 0 && (n2 <= 0 || !((Editor)((Object)component)).canBeMultiSelect())) continue;
            SelectionInfo selectionInfo = new SelectionInfo();
            selectionInfo.target = (EditablePeer)((Object)component);
            selectionInfo.state = 1;
            vector.addElement(selectionInfo);
        }
        n2 = vector.size();
        if (n2 > 0) {
            SelectionInfo selectionInfo = (SelectionInfo)vector.elementAt(0);
            if (n2 > 1 && !selectionInfo.target.canBeMultiSelect()) {
                vector.removeElementAt(0);
                selectionInfo = (SelectionInfo)vector.elementAt(0);
            }
            selectionInfo.state = n2 == 1 && selectionInfo.target.getStatus() == 4 ? 4 : 3;
            this.selectObjects(vector, selectionInfo);
        } else {
            this.selectObjects(vector, null);
        }
    }

    protected void selectObjects(Vector vector, SelectionInfo selectionInfo) {
        if (selectionInfo != null) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                SelectionInfo selectionInfo2 = (SelectionInfo)vector.elementAt(i);
                selectionInfo2.target.setStatus(selectionInfo2.state);
            }
        } else {
            this.clearSelecteds();
        }
        this.updateEdCtrls();
    }

    protected void updateEdCtrls() {
        EditablePeer editablePeer = this.activeObj.getOwner();
        if (editablePeer != null) {
            this.edCtrls = editablePeer.getEdCtrls() & 0x1FF;
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                Editable editable = (Editable)this.selections.elementAt(i);
                if (editable == this.activeObj || (editablePeer = editable.getOwner()) == null) continue;
                this.edCtrls &= editablePeer.getEdCtrls();
            }
            if (this.scrollsListener != null) {
                Rectangle rectangle = this.getBounds();
                rectangle.setLocation(0, 0);
                Rectangle rectangle2 = this.activeObj.getBounds();
                if (rectangle2.isEmpty()) {
                    rectangle2 = this.activeObj.owner.mapBoundsToBoard();
                }
                if (!rectangle.intersects(rectangle2)) {
                    int n;
                    rectangle2.width += rectangle2.x;
                    int n2 = rectangle2.x < 0 || rectangle2.x >= 0 && rectangle2.x <= rectangle.width && rectangle2.width > rectangle.width ? rectangle2.x : (rectangle2.width > rectangle.width ? rectangle2.width - rectangle.width : 0);
                    rectangle2.height += rectangle2.y;
                    int n3 = rectangle2.y < 0 || rectangle2.y >= 0 && rectangle2.y <= rectangle.height && rectangle2.height > rectangle.height ? rectangle2.y : (n = rectangle2.height > rectangle.height ? rectangle2.height - rectangle.height : 0);
                    if (n2 != 0 || n != 0) {
                        this.scrollsListener.autoScrolls(n2, n);
                    }
                }
            }
        }
    }

    protected void overGeometrySizeEditor(Vector vector, Vector vector2) {
    }

    protected void overSplitterbarMoving(Splitterbar splitterbar, int n, int n2) {
    }

    protected void showPopupMenu(MouseEvent mouseEvent) {
    }

    @Override
    protected void scrolling(int n, int n2) {
        Rectangle rectangle;
        int n3;
        if (n != 0 && this.vsbsBounds != null) {
            for (n3 = this.vsbsBounds.size() - 1; n3 >= 0; --n3) {
                rectangle = (Rectangle)this.vsbsBounds.elementAt(n3);
                rectangle.x += n;
            }
        }
        if (n2 != 0 && this.hsbsBounds != null) {
            for (n3 = this.hsbsBounds.size() - 1; n3 >= 0; --n3) {
                rectangle = (Rectangle)this.hsbsBounds.elementAt(n3);
                rectangle.y += n2;
            }
        }
        if (this.gridBounds != null) {
            for (n3 = this.gridBounds.size() - 1; n3 >= 0; --n3) {
                rectangle = (Rectangle)this.gridBounds.elementAt(n3);
                rectangle.x += n;
                rectangle.y += n2;
            }
        }
    }

    protected void help() {
    }
}

