/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.Toolbar;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;

class FloatToolbar
extends Dialog {
    public FloatToolbar(Frame frame, Toolbar toolbar) {
        super(frame, toolbar.getName(), false);
        this.add(toolbar);
        this.setLocation(toolbar.floatx, toolbar.floaty);
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        this.setVisible(true);
        this.enableEvents(65L);
    }

    @Override
    public Dimension getPreferredSize() {
        Toolbar toolbar = (Toolbar)this.getComponent(0);
        Dimension dimension = toolbar.getPreferredSize();
        dimension.width += 6;
        dimension.height += 25;
        return dimension;
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (this.getComponentCount() > 0) {
            int n = componentEvent.getID();
            Insets insets = this.getInsets();
            Dimension dimension = this.getSize();
            Toolbar toolbar = (Toolbar)this.getComponent(0);
            Dimension dimension2 = toolbar.getPreferredSize();
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            if (n == 100) {
                Point point = this.getLocation();
                toolbar.floatx = point.x;
                toolbar.floaty = point.y;
                toolbar.stdWin.floatMoved(toolbar, point.x, point.y);
            }
        }
        super.processComponentEvent(componentEvent);
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        if (n == 201) {
            Toolbar toolbar = (Toolbar)this.getComponent(0);
            toolbar.stdWin.setVisible(toolbar, false);
            this.remove(toolbar);
            this.dispose();
        } else if (n == 203) {
            Toolbar toolbar = (Toolbar)this.getComponent(0);
            toolbar.stdWin.setFloat(toolbar, false);
        }
        super.processWindowEvent(windowEvent);
    }
}

