/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.ActionTrigger;
import guitools.toolkit.GifControl;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jet.log.JRLogger;

public class GifButton
extends GifControl
implements ActionTrigger,
Runnable {
    protected Method method;
    protected Object obj;
    protected Object[] args;
    String prompt;
    String microHelp;
    transient ActionListener actionListener;
    private static JRLogger I = JRLogger.getLogger(GifButton.class.getName());
    ActionEvent ae;

    public GifButton() {
        this("");
    }

    public GifButton(String string) {
        super(string);
        this.enableEvents(48L);
    }

    public GifButton(String string, Object object, Object[] objectArray, String string2, String string3) {
        this(string);
        this.obj = object;
        this.args = objectArray;
        this.prompt = string3;
        this.microHelp = string2;
    }

    public GifButton(Image image) {
        super(image);
        this.enableEvents(48L);
    }

    public GifButton(Image image, Object object, Object[] objectArray, String string, String string2) {
        this(image);
        this.obj = object;
        this.args = objectArray;
        this.prompt = string2;
        this.microHelp = string;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            graphics.setColor(SystemColor.control);
            graphics.fillRect(1, 1, dimension.width - 1, dimension.height - 1);
            if (this.imgs != null && this.imgs[0] != null) {
                int n = this.imgs[0].getHeight(this);
                this.drawImage(graphics, 3 + (this.pressed ? 1 : 0), (dimension.height - n) / 2 + (this.pressed ? 1 : 0));
            }
            --dimension.width;
            --dimension.height;
            graphics.setColor(this.pressed ? SystemColor.controlDkShadow : SystemColor.controlLtHighlight);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.drawLine(0, 1, 0, dimension.height - 1);
            graphics.setColor(this.pressed ? SystemColor.controlLtHighlight : SystemColor.controlDkShadow);
            graphics.drawLine(0, dimension.height, dimension.width, dimension.height);
            graphics.drawLine(dimension.width, 0, dimension.width, dimension.height - 1);
        }
    }

    @Override
    public void setMethod(Method method) {
        this.method = method;
    }

    @Override
    public void setObject(Object object) {
        this.obj = object;
    }

    @Override
    public void setArguments(Object[] objectArray) {
        this.args = objectArray;
    }

    @Override
    public Object[] getArguments() {
        return this.args;
    }

    @Override
    public Object invoke() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.method.invoke(this.obj, this.args);
    }

    @Override
    public void setPrompt(String string) {
        this.prompt = string;
    }

    @Override
    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public void setMicroHelp(String string) {
        this.microHelp = string;
    }

    @Override
    public String getMicroHelp() {
        return this.microHelp;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        }
        super.processEvent(aWTEvent);
    }

    @Override
    public void run() {
        this.processActionEvent(this.ae);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        block8: {
            if (this.method != null && this.obj != null && this.args != null) {
                this.args[0] = actionEvent;
                try {
                    this.method.invoke(this.obj, this.args);
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (I.isErrorEnabled()) {
                        I.error("", illegalAccessException);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (I.isErrorEnabled()) {
                        I.error("", illegalArgumentException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!I.isErrorEnabled()) break block8;
                    I.error("", invocationTargetException.getTargetException());
                }
            }
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled() && !mouseEvent.isMetaDown() && !mouseEvent.isAltDown()) {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.current = true;
                    this.pressed(this.current);
                    break;
                }
                case 502: {
                    this.current = false;
                    if (!this.pressed) break;
                    this.pressed(this.current);
                    this.processEvent(new ActionEvent(this, 1001, this.actionCommand, mouseEvent.getModifiers()));
                    break;
                }
                case 505: {
                    this.pressed(false);
                    break;
                }
                case 504: {
                    this.pressed(this.current);
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.isEnabled() && !mouseEvent.isMetaDown() && !mouseEvent.isAltDown() && mouseEvent.getID() == 506) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Dimension dimension = this.getSize();
            this.pressed(n > 0 && n < dimension.width && n2 > 0 && n2 < dimension.height);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    protected void pressed(boolean bl) {
        if (this.pressed != bl) {
            this.pressed = bl;
            this.repaint();
        }
    }
}

