/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.DisableFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.util.Hashtable;
import jet.log.JRLogger;

public abstract class GifControl
extends Component {
    public static final int ENABLE = 0;
    public static final int DISABLE = 1;
    public static final int IMAGECOUNT = 2;
    protected static Hashtable gifImgs = new Hashtable();
    String name;
    Image[] imgs;
    boolean pressed;
    boolean current;
    String actionCommand;
    private static JRLogger SEDU = JRLogger.getLogger(GifControl.class.getName());

    public GifControl() {
        this("");
    }

    public GifControl(String string) {
        this.setGif(string);
    }

    public GifControl(Image image) {
        this.setImage(image);
    }

    @Override
    public Dimension getPreferredSize() {
        return GifControl.layoutControl(this.imgs, null, null, 0, 3);
    }

    static Dimension layoutControl(Image[] imageArray, String string, Font font, int n, int n2) {
        Serializable serializable;
        Dimension dimension = new Dimension();
        if (imageArray != null) {
            serializable = new Component(){};
            dimension.width = imageArray[0].getWidth((ImageObserver)((Object)serializable));
            dimension.height = imageArray[0].getHeight((ImageObserver)((Object)serializable));
        }
        if (font != null && string != null && string.length() > 0) {
            serializable = Toolkit.getDefaultToolkit().getFontMetrics(font);
            dimension.width = dimension.width + ((imageArray != null ? n : 0) + ((FontMetrics)serializable).stringWidth(string));
            dimension.height = Math.max(dimension.height, ((FontMetrics)serializable).getAscent() + ((FontMetrics)serializable).getDescent());
        }
        dimension.width += 2 * n2;
        dimension.height += 2 * n2;
        return dimension;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (!this.isEnabled() || !bl) {
            super.setEnabled(bl);
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            graphics.setColor(SystemColor.control);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (this.imgs != null && this.imgs[0] != null) {
                this.drawImage(graphics, (dimension.width - this.imgs[0].getWidth(this)) / 2, (dimension.height - this.imgs[0].getHeight(this)) / 2);
            }
        }
    }

    protected void drawImage(Graphics graphics, int n, int n2) {
        if (this.imgs != null) {
            Image image;
            if (!this.isEnabled() && this.imgs[1] == null && this.imgs[0] != null) {
                MediaTracker mediaTracker;
                block6: {
                    int n3 = this.imgs[0].getWidth(this);
                    int n4 = this.imgs[0].getHeight(this);
                    this.imgs[1] = this.createImage(new FilteredImageSource(new FilteredImageSource(this.imgs[0].getSource(), new CropImageFilter(0, 0, n3, n4)), new DisableFilter(n3, n4, this.getBackground())));
                    mediaTracker = new MediaTracker(this);
                    mediaTracker.addImage(this.imgs[1], 1);
                    try {
                        mediaTracker.waitForID(1);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!SEDU.isErrorEnabled()) break block6;
                        SEDU.error("", interruptedException);
                    }
                }
                if (mediaTracker.isErrorID(1)) {
                    this.imgs[1] = null;
                }
            }
            if ((image = this.imgs[this.isEnabled() ? 0 : 1]) != null) {
                graphics.drawImage(this.imgs[this.isEnabled() ? 0 : 1], n, n2, this);
            }
        }
    }

    public synchronized void setGif(String string) {
        if (string == null || string.equals("")) {
            string = "Default";
        }
        this.name = string;
        this.imgs = (Image[])gifImgs.get(string);
        if (this.imgs == null && !string.equals("Default")) {
            block6: {
                this.imgs = new Image[2];
                this.imgs[0] = this.getToolkit().getImage(string);
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(this.imgs[0], 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    if (!SEDU.isErrorEnabled()) break block6;
                    SEDU.error("", interruptedException);
                }
            }
            int n = this.imgs[0].getWidth(this);
            int n2 = this.imgs[0].getHeight(this);
            if (n == -1 || n2 == -1) {
                this.setImage(null);
                return;
            }
        } else {
            this.setImage(null);
            return;
        }
        this.finished();
        this.repaint();
    }

    public void setImage(Image image) {
        if (image != null) {
            this.imgs = new Image[2];
            this.imgs[0] = image;
            int n = this.imgs[0].getWidth(this);
            int n2 = this.imgs[0].getHeight(this);
            if (n == -1 || n2 == -1) {
                this.imgs = (Image[])gifImgs.get("Default");
                if (this.imgs == null) {
                    this.imgs = new Image[2];
                    this.imgs[0] = this.getDefaultImage();
                    gifImgs.put("Default", this.imgs);
                }
            }
        }
        this.finished();
        this.repaint();
    }

    public Image getImage() {
        return this.imgs == null ? this.getDefaultImage() : this.imgs[0];
    }

    public void setImages(Image[] imageArray) {
        if (imageArray != null && imageArray.length == 2) {
            this.imgs = imageArray;
        }
        this.finished();
        this.repaint();
    }

    public String getGif() {
        return this.name;
    }

    public boolean isImageOk() {
        return this.imgs != null;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected void finished() {
        this.setSize(this.getPreferredSize());
    }

    protected abstract void pressed(boolean var1);

    protected Image getDefaultImage() {
        Image image = null;
        int[] nArray = new int[256];
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        image = toolkit.createImage(new MemoryImageSource(16, 16, nArray, 0, 16));
        return image;
    }
}

