/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.EditablePaintBoard;
import guitools.toolkit.Grid;
import guitools.toolkit.GuidelineContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class GridContainer
extends GuidelineContainer
implements Grid {
    @Override
    public void addNotify() {
        super.addNotify();
        ((EditablePaintBoard)this.tpb).addGridContainer(this);
    }

    @Override
    public void removeNotify() {
        ((EditablePaintBoard)this.tpb).removeGridContainer(this);
        super.removeNotify();
    }

    @Override
    public void paintGrid(Graphics graphics) {
        EditablePaintBoard editablePaintBoard = (EditablePaintBoard)this.tpb;
        if (editablePaintBoard != null && editablePaintBoard.visibleGrid) {
            Rectangle rectangle = graphics.getClipBounds();
            rectangle.width += rectangle.x;
            rectangle.height += rectangle.y;
            rectangle.x += editablePaintBoard.grid - rectangle.x % editablePaintBoard.grid - 1;
            rectangle.y += editablePaintBoard.grid - rectangle.y % editablePaintBoard.grid - 1;
            rectangle.width -= rectangle.width % editablePaintBoard.grid;
            rectangle.height -= rectangle.height % editablePaintBoard.grid;
            graphics.setColor(new Color(180));
            while (rectangle.y <= rectangle.height) {
                for (int i = rectangle.x; i <= rectangle.width; i += editablePaintBoard.grid) {
                    graphics.drawLine(i, rectangle.y, i, rectangle.y);
                }
                rectangle.y += editablePaintBoard.grid;
            }
        }
    }

    @Override
    public boolean isVisibleGrid() {
        return this.tpb == null ? false : ((EditablePaintBoard)this.tpb).visibleGrid;
    }

    @Override
    public boolean isSnapGrid() {
        return this.tpb == null ? false : ((EditablePaintBoard)this.tpb).gridSnap;
    }

    @Override
    public void alignChildrenBounds() {
        EditablePaintBoard editablePaintBoard = (EditablePaintBoard)this.tpb;
        if (editablePaintBoard != null && editablePaintBoard.gridSnap) {
            int n = this.getComponentCount();
            Component[] componentArray = this.getComponents();
            for (int i = n - 1; i >= 0; --i) {
                Component component = componentArray[i];
                Rectangle rectangle = component.getBounds();
                this.alignRect(rectangle);
                component.setBounds(rectangle);
            }
        }
    }

    @Override
    public Point alignPoint(int n, int n2) {
        Point point = new Point(n, n2);
        this.alignPoint(point);
        return point;
    }

    @Override
    public void alignPoint(Point point) {
        EditablePaintBoard editablePaintBoard = (EditablePaintBoard)this.tpb;
        if (editablePaintBoard != null && editablePaintBoard.gridSnap) {
            int n = editablePaintBoard.grid >> 1;
            int n2 = point.x % editablePaintBoard.grid;
            point.x = point.x + (point.x == 0 ? 0 : (n2 < n ? -n2 : editablePaintBoard.grid - n2));
            n2 = point.y % editablePaintBoard.grid;
            point.y = point.y + (point.y == 0 ? 0 : (n2 < n ? -n2 : editablePaintBoard.grid - n2));
            point.x = point.x - (point.x > 0 ? 1 : 0);
            point.y = point.y - (point.y > 0 ? 1 : 0);
        }
    }

    @Override
    public Dimension alignSize(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        this.alignSize(dimension);
        return dimension;
    }

    @Override
    public void alignSize(Dimension dimension) {
        EditablePaintBoard editablePaintBoard = (EditablePaintBoard)this.tpb;
        if (editablePaintBoard != null && editablePaintBoard.gridSnap) {
            int n = editablePaintBoard.grid >> 1;
            int n2 = dimension.width % editablePaintBoard.grid;
            dimension.width = dimension.width + (n2 < n ? -(n2 - 1) : editablePaintBoard.grid - n2 - 1);
            n2 = dimension.height % editablePaintBoard.grid;
            dimension.height = dimension.height + (n2 < n ? -(n2 - 1) : editablePaintBoard.grid - n2 - 1);
        }
    }

    @Override
    public Rectangle alignRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.alignRect(rectangle);
        return rectangle;
    }

    @Override
    public void alignRect(Rectangle rectangle) {
        Point point = this.alignPoint(rectangle.x, rectangle.y);
        Dimension dimension = this.alignSize(rectangle.width, rectangle.height);
        rectangle.setBounds(point.x, point.y, dimension.width, dimension.height);
    }
}

