/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.AttachPeer;
import guitools.toolkit.EditablePaintBoard;
import guitools.toolkit.GlContainerPeer;
import guitools.toolkit.Ruler;
import guitools.toolkit.RulerCursor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class Guideline {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    GlContainerPeer parent;
    private int SEDU;
    private Vector addGuideline = new Vector();
    private RulerCursor black;
    private boolean canBeAttached = true;
    private Object drawLine;
    protected EditablePaintBoard epb;

    public Guideline() {
    }

    public Guideline(RulerCursor rulerCursor, int n) {
        this.parent = this.parent;
        this.black = rulerCursor;
        this.SEDU = n;
    }

    public Guideline(RulerCursor rulerCursor, int n, Object object) {
        this.parent = this.parent;
        this.black = rulerCursor;
        this.SEDU = n;
        this.drawLine = object;
    }

    public void addNotify(EditablePaintBoard editablePaintBoard) {
        this.epb = editablePaintBoard;
        editablePaintBoard.addGuideline(this);
    }

    public void removeNotify() {
        this.epb.removeGuideline(this);
        this.epb = null;
        Container container = this.black.getParent();
        container.remove(this.black);
    }

    public Object getOwner() {
        return this.drawLine;
    }

    public GlContainerPeer getParent() {
        return this.parent;
    }

    public RulerCursor getCursor() {
        return this.black;
    }

    public void setCursor(RulerCursor rulerCursor) {
        this.black = rulerCursor;
    }

    public boolean cursorIn(RulerCursor rulerCursor) {
        return this.black == rulerCursor;
    }

    public Ruler getRuler() {
        return (Ruler)this.black.getParent();
    }

    public boolean isShowing() {
        return this.canBeAttached && this.parent != null && ((Component)((Object)this.parent)).isShowing() && this.black != null && this.black.isShowing();
    }

    public boolean isVisible() {
        return this.canBeAttached;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        if (!this.canBeAttached) {
            this.canBeAttached = true;
            this.black.setVisible(this.canBeAttached);
            this.repaint();
        }
    }

    public void hide() {
        if (this.canBeAttached) {
            boolean bl = this.isShowing();
            this.canBeAttached = false;
            this.black.setVisible(this.canBeAttached);
            if (bl) {
                Rectangle rectangle = this.getBounds();
                this.epb.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public int getOrientation() {
        return ((Ruler)this.black.getParent()).getOrientation();
    }

    public int getPosition() {
        return this.SEDU;
    }

    public void setPosition(int n) {
        if (this.SEDU != n) {
            Rectangle rectangle = this.getBounds();
            this.SEDU = n;
            this.epb.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.repaint();
        }
    }

    public Point mapPositionToBoard() {
        return ((Ruler)this.black.getParent()).getOrientation() == 0 ? this.parent.mapToBoard(this.SEDU, 0) : this.parent.mapToBoard(0, this.SEDU);
    }

    public Point mapBoardPointToParent(int n, int n2) {
        return this.parent.mapToComp(n, n2);
    }

    public void updateCursor() {
        this.updateCursor(this.getRuler(), this.black, this.SEDU);
    }

    public void updateCursor(Ruler ruler, RulerCursor rulerCursor, int n) {
        int n2 = ruler.getOrientation();
        Point point = this.parent.mapToBoard(n, n);
        ruler.mapToComp(point);
        if (n2 == 0) {
            ruler.updatePosition(rulerCursor, point.x);
        } else if (n2 == 1) {
            ruler.updatePosition(rulerCursor, point.y);
        }
    }

    public int attachedObjects() {
        return this.addGuideline.size();
    }

    public AttachPeer getAttachObjs(int n) {
        return (AttachPeer)this.addGuideline.elementAt(n);
    }

    public boolean containsObj(AttachPeer attachPeer) {
        return this.addGuideline.indexOf(attachPeer) != -1;
    }

    public Vector getAttachObjs() {
        return this.addGuideline;
    }

    public int canBeAttached(AttachPeer attachPeer) {
        Rectangle rectangle = attachPeer.mapBoundsToBoard();
        int n = this.canBeAttached(attachPeer, rectangle);
        return n;
    }

    public int canBeAttached(AttachPeer attachPeer, Rectangle rectangle) {
        int n = -1;
        if (this.epb != null) {
            Point point = this.mapPositionToBoard();
            int n2 = this.getOrientation();
            if (n2 == 0) {
                int n3 = rectangle.x + rectangle.width / 2;
                int n4 = rectangle.x + rectangle.width;
                if (rectangle.x > point.x - 3 && rectangle.x < point.x + 3) {
                    n = 0;
                } else if (n3 > point.x - 3 && n3 < point.x + 3) {
                    n = 1;
                } else if (n4 > point.x - 3 && n4 < point.x + 3) {
                    n = 2;
                }
            } else if (n2 == 1) {
                int n5 = rectangle.y + rectangle.height / 2;
                int n6 = rectangle.y + rectangle.height;
                if (rectangle.y > point.y - 3 && rectangle.y < point.y + 3) {
                    n = 3;
                } else if (n5 > point.y - 3 && n5 < point.y + 3) {
                    n = 4;
                } else if (n6 > point.y - 3 && n6 < point.y + 3) {
                    n = 5;
                }
            }
        }
        return n;
    }

    public void paint(Graphics graphics) {
        block8: {
            if (!this.isShowing()) break block8;
            Rectangle rectangle = graphics.getClipBounds();
            if (this.getOrientation() == 0) {
                int n;
                graphics.setColor(Color.black);
                int n2 = 6 * (rectangle.y / 6);
                int n3 = rectangle.y + rectangle.height;
                int n4 = n3;
                for (n = n2; n <= n4; n += 6) {
                    graphics.drawLine(1, n, 1, n + 2);
                }
                graphics.setColor(Color.red);
                for (int i = this.addGuideline.size() - 1; i >= 0; --i) {
                    AttachPeer attachPeer = (AttachPeer)this.addGuideline.elementAt(i);
                    Rectangle rectangle2 = attachPeer.mapBoundsToBoard();
                    if (!((Component)((Object)attachPeer)).isShowing() || rectangle2.y <= n2 || rectangle2.y >= n3) continue;
                    rectangle2.height += rectangle2.y - 1;
                    n += (n = 6 * (rectangle2.y / 6)) + 2 <= rectangle2.y ? 6 : 0;
                    int n5 = n4 = rectangle2.height < n3 ? rectangle2.height : n3;
                    while (n <= n4) {
                        graphics.drawLine(1, n < rectangle2.y ? rectangle2.y : n, 1, n + 2 < n4 ? n + 2 : n4);
                        n += 6;
                    }
                }
            } else {
                int n;
                graphics.setColor(Color.black);
                int n6 = 6 * (rectangle.x / 6);
                int n7 = rectangle.x + rectangle.width;
                int n8 = n7;
                for (n = n6; n <= n8; n += 6) {
                    graphics.drawLine(n, 1, n + 2, 1);
                }
                graphics.setColor(Color.red);
                for (int i = this.addGuideline.size() - 1; i >= 0; --i) {
                    AttachPeer attachPeer = (AttachPeer)this.addGuideline.elementAt(i);
                    Rectangle rectangle3 = attachPeer.mapBoundsToBoard();
                    if (!((Component)((Object)attachPeer)).isShowing() || rectangle3.y <= n6 || rectangle3.y >= n7) continue;
                    rectangle3.width += rectangle3.x - 1;
                    n += (n = 6 * (rectangle3.x / 6)) + 2 <= rectangle3.x ? 6 : 0;
                    int n9 = n8 = rectangle3.width < n7 ? rectangle3.width : n7;
                    while (n <= n8) {
                        graphics.drawLine(n < rectangle3.x ? rectangle3.x : n, 1, n + 2 < n8 ? n + 2 : n8, 1);
                        n += 6;
                    }
                }
            }
        }
    }

    public void repaint() {
        if (this.isShowing()) {
            Rectangle rectangle = this.getBounds();
            this.epb.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Rectangle getBounds() {
        int n = this.getOrientation();
        Point point = this.mapPositionToBoard();
        Rectangle rectangle = this.epb.getBounds();
        if (n == 0) {
            rectangle.x = point.x - 1;
            rectangle.width = 3;
            rectangle.y = 0;
        } else if (n == 1) {
            rectangle.x = 0;
            rectangle.y = point.y - 1;
            rectangle.height = 3;
        }
        return rectangle;
    }
}

