/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.GuiComponent;
import guitools.Painter;
import guitools.PainterConstants;
import guitools.toolkit.HyperLinkExecutable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public class HyperLinkField
extends GuiComponent
implements PainterConstants,
Externalizable {
    private String SEDU;
    private String blue;
    private HyperLinkExecutable drawImage;
    private Image drawText;
    private boolean execute = false;
    private boolean fillRect = false;
    private int getBackground = 4;
    private boolean getForeground = true;
    private boolean getHeight = true;
    private boolean getID = true;

    public HyperLinkField() {
        this.enableEvents(16L);
        this.setFont(new Font("Dialog", 0, 12));
        this.setBackground(Color.white);
        this.setForeground(Color.blue);
    }

    public void setDisplayValue(String string) {
        this.SEDU = string;
    }

    public String getDisplayValue() {
        return this.SEDU;
    }

    public void setDisplayImage(Image image) {
        this.drawText = image;
    }

    public Image getDisplayImage() {
        return this.drawText;
    }

    public void setAutoFit(boolean bl) {
        this.execute = bl;
    }

    public boolean getAutoFit() {
        return this.execute;
    }

    public void setURL(String string) {
        this.blue = string;
        this.setToolTipText(string);
    }

    public String getURL() {
        return this.blue;
    }

    public int getAlignment() {
        return this.getBackground;
    }

    public void setAlignment(int n) {
        this.getBackground = n;
    }

    public void setEnableHyperlinkOnPDF(boolean bl) {
        this.getForeground = bl;
    }

    public boolean getEnableHyperlinkOnPDF(boolean bl) {
        return this.getForeground;
    }

    public void setWordwrap(boolean bl) {
        this.fillRect = bl;
    }

    public void setEnableHyperlinkOnExcel(boolean bl) {
        this.getHeight = bl;
    }

    public boolean getEnableHyperlinkOnExcel(boolean bl) {
        return this.getHeight;
    }

    public void setEnableHyperlinkOnHTML(boolean bl) {
        this.getID = bl;
    }

    public boolean getEnableHyperlinkOnHTML(boolean bl) {
        return this.getID;
    }

    public void setHyperLinkExecutable(HyperLinkExecutable hyperLinkExecutable) {
        this.drawImage = hyperLinkExecutable;
    }

    @Override
    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        if (this.drawText != null) {
            graphics.drawImage(this.drawText, rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1, this);
        } else {
            Color color = this.getBackground();
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            }
            Painter.drawText(graphics, rectangle, this.SEDU, this.getFont(), this.getForeground(), this.fillRect, true, false, this.getBackground);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.execute) {
            return this.getSize();
        }
        if (this.drawText != null) {
            Dimension dimension = new Dimension();
            dimension.width = this.drawText.getWidth(this);
            dimension.height = this.drawText.getHeight(this);
            return dimension;
        }
        Vector vector = new Vector(1);
        return Painter.layoutText(vector, this.SEDU, 10000, this.getFont(), '\uffff');
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 502: {
                String string;
                if (this.drawImage == null || (string = this.drawImage.execute(this, this.SEDU, this.blue)) != null) break;
                break;
            }
            case 505: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                break;
            }
            case 504: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Integer(this.getSize().width));
        objectOutput.writeObject(new Integer(this.getSize().height));
        objectOutput.writeObject(this.SEDU);
        objectOutput.writeObject(this.blue);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = (Integer)objectInput.readObject();
        int n2 = (Integer)objectInput.readObject();
        this.setSize(n, n2);
        this.SEDU = (String)objectInput.readObject();
        this.blue = (String)objectInput.readObject();
    }
}

