/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import java.util.EmptyStackException;

public class IntStack
implements Cloneable {
    int[] value = new int[8];
    int index = -1;

    public final int push(int n) {
        this.SEDU(false);
        this.value[++this.index] = n;
        return n;
    }

    public final synchronized int pop() {
        if (this.index == -1) {
            throw new EmptyStackException();
        }
        this.SEDU(true);
        return this.index > -1 ? this.value[this.index--] : this.value[0];
    }

    public final synchronized void pop(int n) {
        if (n > this.index + 1) {
            throw new EmptyStackException();
        }
        this.index -= n;
        this.SEDU(true);
    }

    public final synchronized int peek() {
        if (this.index == -1) {
            throw new EmptyStackException();
        }
        return this.value[this.index];
    }

    public final void clear() {
        this.index = -1;
    }

    public final boolean empty() {
        return this.index == -1;
    }

    public final int getSize() {
        return this.index + 1;
    }

    public final synchronized int elementAt(int n) {
        if (n > this.index) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.index);
        }
        try {
            return this.value[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final synchronized void setElementAt(int n, int n2) {
        if (n2 > this.index) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.index);
        }
        this.value[n2] = n;
    }

    public final synchronized void removeElementAt(int n) {
        if (n > this.index) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.index);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.index - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.value, n + 1, this.value, n, n2);
        }
        --this.index;
        this.value[this.index] = 0;
        this.SEDU(true);
    }

    public final synchronized void insertElementAt(int n, int n2) {
        if (n2 > this.index + 1) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.index);
        }
        this.SEDU(false);
        System.arraycopy(this.value, n2, this.value, n2 + 1, this.index - n2);
        this.value[n2] = n;
        ++this.index;
    }

    public synchronized Object clone() {
        try {
            IntStack intStack = (IntStack)super.clone();
            intStack.value = new int[this.value.length];
            if (this.index >= 0) {
                System.arraycopy(this.value, 0, intStack.value, 0, this.index + 1);
            }
            return intStack;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof IntStack) {
            if (this.index != -1 || ((IntStack)object).index != -1) {
                boolean bl3 = bl = this.index == ((IntStack)object).index;
                if (bl) {
                    for (int i = this.index; i >= 0; --i) {
                        if (this.value[i] == ((IntStack)object).value[i]) continue;
                        bl = false;
                        break;
                    }
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private void SEDU(boolean bl) {
        if (bl) {
            if (this.index < this.value.length / 2 - 1 && this.value.length > 8) {
                int[] nArray = new int[this.value.length / 2];
                System.arraycopy(this.value, 0, nArray, 0, this.value.length / 2);
            }
        } else if (this.index == this.value.length - 1) {
            int[] nArray = new int[this.value.length * 2];
            System.arraycopy(this.value, 0, nArray, 0, this.value.length);
            this.value = nArray;
        }
    }

    public String toString() {
        String string = "size = " + (this.index + 1) + ", {";
        for (int i = 0; i <= this.index; ++i) {
            string = string + this.value[i] + (i == this.index ? "}" : ",");
        }
        string = string + '\n';
        return string;
    }
}

