/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.AlignButton;
import guitools.toolkit.AlignListener;
import guitools.toolkit.FirstLineIndent;
import guitools.toolkit.IndentListener;
import guitools.toolkit.LeftIndent;
import guitools.toolkit.ParagraphRulerLayout;
import guitools.toolkit.RightIndent;
import guitools.toolkit.RulerActionListener;
import guitools.toolkit.RulerMarginListener;
import guitools.toolkit.TContainer;
import guitools.toolkit.TabButton;
import guitools.toolkit.TabCursor;
import guitools.toolkit.TabRuler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ParagraphRuler
extends TContainer
implements MouseListener,
MouseMotionListener,
RulerMarginListener {
    final TabButton tab = new TabButton();
    final AlignButton align = new AlignButton();
    final TabRuler ruler = new TabRuler();
    final FirstLineIndent flIndent = new FirstLineIndent();
    final LeftIndent lIndent = new LeftIndent();
    final RightIndent rIndent = new RightIndent();
    RulerMarginListener marginListener;
    IndentListener indentListener;
    int lastx;
    int fliPos;
    int lPos;
    int rPos;
    int ipos;
    int margin;
    boolean unionMotion;
    Dimension repSize;

    public ParagraphRuler() {
        this.setBackground(Color.lightGray);
        this.tab.setTabListener(this.ruler);
        this.add(this.flIndent);
        this.add(this.lIndent);
        this.add(this.rIndent);
        this.add(this.tab);
        this.add(this.align);
        this.add(this.ruler);
        this.ruler.setMarginListener(this);
        this.setLayout(new ParagraphRulerLayout());
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        --dimension.width;
        --dimension.height;
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension.width, dimension.height);
        --dimension.height;
        int n = this.ruler.unit() * (this.ruler.unitType() == 0 ? 4 : 5);
        Rectangle rectangle = this.ruler.getBounds();
        int n2 = rectangle.x + rectangle.width - this.ruler.getBRMargin() - 1;
        for (int i = rectangle.x + this.ruler.getTLMargin(); i < n2; i += n) {
            graphics.drawLine(i, dimension.height - 2, i, dimension.height - 1);
        }
        super.paint(graphics);
        graphics.setColor(Color.black);
        ++dimension.height;
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.drawLine(dimension.width, 0, dimension.width, dimension.height);
    }

    public int getTabStatus() {
        return this.tab.getStatus();
    }

    public void setTabStatus(int n) {
        if (n >= 0 && n < 4) {
            this.tab.setStatus(n);
            this.ruler.tab = n;
        }
    }

    public int getTabButtonWidth() {
        return this.tab.getSize().width;
    }

    public int getFLIndentPos() {
        Rectangle rectangle = this.flIndent.getBounds();
        return rectangle.x + (rectangle.width >> 1);
    }

    public void setFLIndentPos(int n) {
        Rectangle rectangle = this.flIndent.getBounds();
        this.flIndent.setBounds(n - (rectangle.width >> 1), rectangle.y, rectangle.width, rectangle.height);
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getLIndentPos() {
        Rectangle rectangle = this.lIndent.getBounds();
        return rectangle.x + (rectangle.width >> 1);
    }

    public void setLIndentPos(int n) {
        Rectangle rectangle = this.lIndent.getBounds();
        this.lIndent.setBounds(n - (rectangle.width >> 1), rectangle.y, rectangle.width, rectangle.height);
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getRIndentPos() {
        Rectangle rectangle = this.rIndent.getBounds();
        return rectangle.x + (rectangle.width >> 1);
    }

    public void setRIndentPos(int n) {
        Rectangle rectangle = this.rIndent.getBounds();
        this.rIndent.setBounds(n - (rectangle.width >> 1), rectangle.y, rectangle.width, rectangle.height);
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setIndentListener(IndentListener indentListener) {
        this.indentListener = indentListener;
    }

    public int getRulerPos() {
        return this.ruler.getLocation().x;
    }

    public int getRulerWidth() {
        return this.ruler.getSize().width;
    }

    public void setRulerPos(int n) {
        Point point = this.ruler.getLocation();
        point.x = n;
        this.ruler.setLocation(point);
    }

    public void setRulerWidth(int n) {
        Dimension dimension = this.ruler.getSize();
        dimension.width = n;
        this.ruler.setSize(dimension);
    }

    public int getLeftMargin() {
        return this.ruler.getTLMargin();
    }

    public int getRightMargin() {
        return this.ruler.getBRMargin();
    }

    public void setMarginsWidth(int n, int n2) {
        this.ruler.setMargins(n, n2);
    }

    public void setLeftMargin(int n) {
        this.ruler.setMargins(n, this.ruler.getBRMargin());
    }

    public void setRightMargin(int n) {
        this.ruler.setMargins(this.ruler.getTLMargin(), n);
    }

    public void setMarginListener(RulerMarginListener rulerMarginListener) {
        this.marginListener = rulerMarginListener;
    }

    public void setActionListener(RulerActionListener rulerActionListener) {
        this.ruler.setActionListener(rulerActionListener);
    }

    public int getAlignStatus() {
        return this.align.getAlign();
    }

    public void setAlignStatus(int n) {
        this.align.setAlign(n);
    }

    public void setAlignListener(AlignListener alignListener) {
        this.align.setAlignListener(alignListener);
    }

    public int getAlignButtonWidth() {
        return this.align.getSize().width;
    }

    public TabCursor createTabCursor(int n) {
        return this.ruler.createTabCursor(n);
    }

    public void addTabCursor(TabCursor tabCursor) {
        this.ruler.add(tabCursor);
    }

    public void addTabCursor(TabCursor tabCursor, int n) {
        this.ruler.add(tabCursor);
        this.ruler.updatePosition(tabCursor, n);
    }

    public void setTabCursorPosition(TabCursor tabCursor, int n) {
        this.ruler.updatePosition(tabCursor, n);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.lastx = mouseEvent.getX();
        this.fliPos = this.getFLIndentPos();
        this.lPos = this.getLIndentPos();
        this.rPos = this.getRIndentPos();
        Component component = mouseEvent.getComponent();
        if (component == this.flIndent) {
            if (this.indentListener != null) {
                this.indentListener.prepareFLIndent(this.fliPos);
            }
        } else if (component == this.lIndent) {
            this.unionMotion = this.lIndent.isUnionMotion(mouseEvent.getX(), mouseEvent.getY());
            if (this.indentListener != null) {
                this.indentListener.prepareLIndent(this.lPos);
            }
        } else if (component == this.rIndent && this.indentListener != null) {
            this.indentListener.prepareRIndent(this.rPos);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
        Component component = mouseEvent.getComponent();
        if (component == this.flIndent) {
            if (this.indentListener != null) {
                this.indentListener.overDragFLIndent(this.fliPos);
            }
        } else if (component == this.lIndent) {
            if (this.indentListener != null) {
                this.indentListener.overDragLIndent(this.lPos, this.fliPos);
            }
        } else if (component == this.rIndent && this.indentListener != null) {
            this.indentListener.overDragRIndent(this.rPos);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.tpb.lockUpdate();
        int n = mouseEvent.getX() - this.lastx;
        Component component = mouseEvent.getComponent();
        if (component == this.flIndent) {
            n = this.fliPos + n > this.rPos ? this.rPos - this.fliPos : n;
            int n2 = this.fliPos + n;
            if (this.indentListener == null || this.indentListener.dragFLIndent(n2)) {
                this.setFLIndentPos(n2);
                this.fliPos += n;
            } else {
                n = 0;
            }
        } else if (component == this.lIndent) {
            int n3 = this.unionMotion ? (this.fliPos > this.lPos ? this.fliPos : this.lPos) : this.lPos;
            n = n3 + n > this.rPos ? this.rPos - n3 : n;
            n3 = this.lPos + n;
            if (this.indentListener == null || this.indentListener.dragLIndent(n3)) {
                this.lPos += n;
                this.setLIndentPos(n3);
                if (this.unionMotion) {
                    this.fliPos += n;
                    this.setFLIndentPos(this.fliPos);
                }
            } else {
                n = 0;
            }
        } else if (component == this.rIndent) {
            int n4 = this.fliPos > this.lPos ? this.fliPos : this.lPos;
            n = this.rPos + n < n4 ? n4 - this.rPos : n;
            n4 = this.rPos + n;
            if (this.indentListener == null || this.indentListener.dragRIndent(n4)) {
                this.setRIndentPos(n4);
                this.rPos += n;
            } else {
                n = 0;
            }
        }
        this.tpb.unlockUpdate();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public boolean prepareDragTopMargin(int n) {
        return false;
    }

    @Override
    public boolean dragTopMargin(int n) {
        return false;
    }

    @Override
    public boolean overDragTopMargin(int n) {
        return false;
    }

    @Override
    public boolean prepareDragLeftMargin(int n) {
        this.repSize = this.getSize();
        this.fliPos = this.getFLIndentPos();
        this.lPos = this.getLIndentPos();
        this.rPos = this.getRIndentPos();
        this.ipos = this.fliPos > this.lPos ? this.fliPos : this.lPos;
        this.margin = n;
        return this.marginListener != null ? this.marginListener.prepareDragLeftMargin(n) : true;
    }

    @Override
    public boolean dragLeftMargin(int n) {
        boolean bl;
        this.tpb.lockUpdate();
        int n2 = n - this.margin;
        int n3 = n2 = this.ipos + n2 > this.rPos ? this.rPos - this.ipos : n2;
        if (n2 != 0) {
            n = this.margin + n2;
            boolean bl2 = bl = this.marginListener != null ? this.marginListener.dragLeftMargin(n) : true;
            if (bl) {
                this.margin += n2;
                this.fliPos += n2;
                this.lPos += n2;
                this.ipos += n2;
                this.setFLIndentPos(this.fliPos);
                this.setLIndentPos(this.lPos);
                this.repaint(1, this.repSize.height - 4, this.repSize.width - 2, this.repSize.height - 1);
            }
        } else {
            bl = false;
        }
        this.tpb.unlockUpdate();
        return bl;
    }

    @Override
    public boolean overDragLeftMargin(int n) {
        this.dragLeftMargin(n);
        return this.marginListener != null ? this.marginListener.overDragLeftMargin(n) : true;
    }

    @Override
    public boolean prepareDragBottomMargin(int n) {
        return false;
    }

    @Override
    public boolean dragBottomMargin(int n) {
        return false;
    }

    @Override
    public boolean overDragBottomMargin(int n) {
        return false;
    }

    @Override
    public boolean prepareDragRightMargin(int n) {
        this.repSize = this.getSize();
        this.fliPos = this.getFLIndentPos();
        this.lPos = this.getLIndentPos();
        this.rPos = this.getRIndentPos();
        this.ipos = this.fliPos > this.lPos ? this.fliPos : this.lPos;
        this.margin = n;
        return this.marginListener != null ? this.marginListener.prepareDragRightMargin(n) : true;
    }

    @Override
    public boolean dragRightMargin(int n) {
        boolean bl;
        this.tpb.lockUpdate();
        int n2 = n - this.margin;
        int n3 = n2 = this.rPos - n2 < this.ipos ? this.rPos - this.ipos : n2;
        if (n2 != 0) {
            n = this.margin + n2;
            boolean bl2 = bl = this.marginListener != null ? this.marginListener.dragRightMargin(n) : true;
            if (bl) {
                this.margin += n2;
                this.rPos -= n2;
                this.setRIndentPos(this.rPos);
                this.repaint(1, this.repSize.height - 4, this.repSize.width - 2, this.repSize.height - 1);
            }
        } else {
            bl = false;
        }
        this.tpb.unlockUpdate();
        return bl;
    }

    @Override
    public boolean overDragRightMargin(int n) {
        this.dragRightMargin(n);
        return this.marginListener != null ? this.marginListener.overDragRightMargin(n) : true;
    }

    public void removeAllTabs() {
        this.ruler.removeAll();
        this.ruler.repaint();
    }
}

