/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.UIResource;
import guitools.toolkit.RulerActionListener;
import guitools.toolkit.RulerCursor;
import guitools.toolkit.RulerLayout;
import guitools.toolkit.RulerMarginListener;
import guitools.toolkit.TContainer;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Ruler
extends TContainer
implements MouseListener,
MouseMotionListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int INCH = 0;
    public static final int CENTIMETER = 1;
    public static final int NORMAL = 0;
    public static final int TOPMGN = 1;
    public static final int LEFTMGN = 2;
    public static final int BOTMMGN = 3;
    public static final int RITMGN = 4;
    public static final int CURSOR = 5;
    protected int orientation = 0;
    int unitType = 0;
    int tlMargin;
    int brMargin;
    boolean enableMargin = false;
    protected RulerActionListener actionListener;
    protected RulerMarginListener marginListener;
    protected int editorState = 0;
    int lastxy;
    int lastPos;
    int resolution = Unit.getResolution();
    RulerCursor catchIn;

    public Ruler() {
        this(0);
    }

    public Ruler(int n) {
        this(n, 0);
    }

    public Ruler(int n, int n2) {
        this.setFont(UIResource.getFont("Tip Font"));
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.orientation = n;
        this.unitType = n2;
        this.setLayout(new RulerLayout());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setResolution(int n) {
        this.resolution = n;
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Dimension dimension = this.getSize();
        --dimension.width;
        --dimension.height;
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.drawLine(0, 1, dimension.width - 1, 1);
        graphics.drawLine(0, 2, 0, dimension.height);
        graphics.drawLine(1, 2, 1, dimension.height - 1);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(2, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 2, dimension.width - 1, dimension.height - 1);
        graphics.setColor(Color.white);
        graphics.drawLine(1, dimension.height, dimension.width, dimension.height);
        graphics.drawLine(dimension.width, 1, dimension.width, dimension.height);
        if (this.orientation == 0) {
            n7 = this.tlMargin > 2 ? this.tlMargin : 2;
            n6 = this.brMargin > 2 ? this.brMargin : 2;
            n5 = dimension.height - 3;
            graphics.setColor(UIResource.getColor("Window Background"));
            graphics.fillRect(n7, 2, dimension.width - n7 - n6, n5);
            if (n7 > 2 || n6 > 2) {
                if (n7 > 2) {
                    graphics.setColor(Color.gray);
                    graphics.fillRect(2, 2, n7 - 2, n5);
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(2, 2, n7 - 1, 2);
                    graphics.drawLine(2, 2, 2, dimension.height - 2);
                }
                if (n6 > 2) {
                    graphics.setColor(Color.gray);
                    graphics.fillRect(dimension.width - n6, 2, n6 - 1, n5);
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(dimension.width - n6, 2, dimension.width - 2, 2);
                }
            }
        } else {
            n7 = this.tlMargin > 2 ? this.tlMargin : 2;
            n6 = this.brMargin > 2 ? this.brMargin : 2;
            n5 = dimension.width - 3;
            graphics.setColor(UIResource.getColor("Window Background"));
            graphics.fillRect(2, n7, n5, dimension.height - n7 - n6);
            if (n7 > 2 || n6 > 2) {
                if (n7 > 2) {
                    graphics.setColor(Color.gray);
                    graphics.fillRect(2, 2, n5, n7 - 2);
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(2, 2, dimension.width - 2, 2);
                    graphics.drawLine(2, 2, 2, n7 - 1);
                }
                if (n6 > 2) {
                    graphics.setColor(Color.gray);
                    graphics.fillRect(2, dimension.height - n6, n5, n6 - 2);
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(2, dimension.height - n6, 2, dimension.height - 2);
                }
            }
        }
        graphics.setColor(Color.black);
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n8 = fontMetrics.getMaxAscent() - fontMetrics.getHeight() / 2;
        if (this.unitType == 0) {
            n4 = 4;
            n3 = 8;
            n2 = 1;
            n = 1;
        } else {
            n4 = 2;
            n3 = 4;
            n2 = 2;
            n = 2;
        }
        if (this.orientation == 0) {
            int n9;
            String string;
            n5 = dimension.height + 1 >> 1;
            n8 += n5;
            int n10 = 0;
            int n11 = 0;
            int n12 = n7 = this.tlMargin > 2 ? this.tlMargin : 0;
            int n13 = 2;
            while (n12 > n13) {
                if (n10 % n3 == 0) {
                    string = Integer.toString(n11);
                    n9 = fontMetrics.stringWidth(string) >> 1;
                    if (n12 - n9 >= n13) {
                        graphics.drawString(string, n12 - n9, n8);
                        n11 += n;
                    }
                } else if (n10 % n4 == 0) {
                    graphics.drawLine(n12, n5 - 2, n12, n5 + 2);
                } else {
                    graphics.drawLine(n12, n5 - 1, n12, n5);
                }
                n12 = n7 - (this.unitType == 0 ? Unit.convertInchToPixel((double)n10 / 8.0, this.resolution) : Unit.convertCentimeterToPixel((double)(++n10) / 2.0, this.resolution));
            }
            n10 = 1;
            n11 = n2;
            n12 = n7 + (this.unitType == 0 ? Unit.convertInchToPixel((double)n10 / 8.0, this.resolution) : Unit.convertCentimeterToPixel((double)n10 / 2.0, this.resolution));
            n13 = dimension.width - 2;
            while (n12 < n13) {
                if (n10 % n3 == 0) {
                    string = Integer.toString(n11);
                    n9 = fontMetrics.stringWidth(string) >> 1;
                    if (n12 + n9 <= n13) {
                        graphics.drawString(string, n12 - n9, n8);
                        n11 += n;
                    }
                } else if (n10 % n4 == 0) {
                    graphics.drawLine(n12, n5 - 2, n12, n5 + 2);
                } else {
                    graphics.drawLine(n12, n5 - 1, n12, n5);
                }
                n12 = n7 + (this.unitType == 0 ? Unit.convertInchToPixel((double)n10 / 8.0, this.resolution) : Unit.convertCentimeterToPixel((double)(++n10) / 2.0, this.resolution));
            }
        } else if (this.orientation == 1) {
            int n14;
            String string;
            n5 = dimension.width + 1 >> 1;
            int n15 = fontMetrics.getHeight();
            int n16 = 0;
            int n17 = 0;
            int n18 = n7 = this.tlMargin > 2 ? this.tlMargin : 0;
            int n19 = 2;
            while (n18 > n19) {
                if (n16 % n3 == 0) {
                    string = Integer.toString(n17);
                    n14 = fontMetrics.stringWidth(string) >> 1;
                    if (n18 + n15 - n8 >= n19) {
                        graphics.drawString(string, n5 - n14, n18 + n8);
                        n17 += n;
                    }
                } else if (n16 % n4 == 0) {
                    graphics.drawLine(n5 - 2, n18, n5 + 2, n18);
                } else {
                    graphics.drawLine(n5 - 1, n18, n5, n18);
                }
                n18 = n7 - (this.unitType == 0 ? Unit.convertInchToPixel((double)n16 / 8.0, this.resolution) : Unit.convertCentimeterToPixel((double)(++n16) / 2.0, this.resolution));
            }
            n16 = 1;
            n17 = n2;
            n18 = n7 + (this.unitType == 0 ? Unit.convertInchToPixel((double)n16 / 8.0, this.resolution) : Unit.convertCentimeterToPixel((double)n16 / 2.0, this.resolution));
            n19 = dimension.height - 2;
            while (n18 < n19) {
                if (n16 % n3 == 0) {
                    string = Integer.toString(n17);
                    n14 = fontMetrics.stringWidth(string) >> 1;
                    if (n18 + n15 - n8 <= n19) {
                        graphics.drawString(string, n5 - n14, n18 + n8);
                        n17 += n;
                    }
                } else if (n16 % n4 == 0) {
                    graphics.drawLine(n5 - 2, n18, n5 + 2, n18);
                } else {
                    graphics.drawLine(n5 - 1, n18, n5, n18);
                }
                n18 = n7 + (this.unitType == 0 ? Unit.convertInchToPixel((double)n16 / 8.0, this.resolution) : Unit.convertCentimeterToPixel((double)(++n16) / 2.0, this.resolution));
            }
        }
        super.paint(graphics);
    }

    @Override
    public Component getComponentAt(int n, int n2) {
        int n3 = this.getComponentCount();
        if (n3 > 0) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < n3; ++i) {
                Component component = componentArray[i];
                if (component == null || !component.isVisible()) continue;
                Point point = component.getLocation();
                if ((component = component.getComponentAt(n - point.x, n2 - point.y)) == null) continue;
                return component;
            }
        }
        return this;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int unitType() {
        return this.unitType;
    }

    public void unitType(int n) {
        if (n != this.unitType && (n == 1 || n == 0)) {
            this.unitType = n;
            this.repaint();
        }
    }

    public int unit() {
        int n = 8;
        if (this.unitType == 0) {
            n = (int)Math.round((double)this.resolution / 8.0);
        } else if (this.unitType == 1) {
            n = (int)Math.round((double)this.resolution * 5.0 / 25.4);
        }
        return n;
    }

    public void setMarginEnable(boolean bl) {
        this.enableMargin = bl;
    }

    public boolean isMarginEnable() {
        return this.enableMargin;
    }

    public int getTLMargin() {
        return this.tlMargin;
    }

    public int getBRMargin() {
        return this.brMargin;
    }

    public int getTopMargin() {
        return this.getTLMargin();
    }

    public int getBottomMargin() {
        return this.getBRMargin();
    }

    public void setMargins(int n, int n2) {
        if (n != this.tlMargin || n2 != this.brMargin) {
            this.tlMargin = n;
            this.brMargin = n2;
            this.repaint();
        }
    }

    public void setTopMargin(int n) {
        this.setMargins(n, this.brMargin);
    }

    public void setBottomMargin(int n) {
        this.setMargins(this.tlMargin, n);
    }

    public void setActionListener(RulerActionListener rulerActionListener) {
        this.actionListener = rulerActionListener;
    }

    public void setMarginListener(RulerMarginListener rulerMarginListener) {
        this.marginListener = rulerMarginListener;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.lastxy = this.orientation == 0 ? n : n2;
            switch (this.getCursor().getType()) {
                case 8: {
                    if (this.marginListener != null) {
                        this.marginListener.prepareDragTopMargin(this.tlMargin);
                    }
                    this.editorState = 1;
                    return;
                }
                case 9: {
                    if (this.marginListener != null) {
                        this.marginListener.prepareDragBottomMargin(this.brMargin);
                    }
                    this.editorState = 3;
                    return;
                }
                case 10: {
                    if (this.marginListener != null) {
                        this.marginListener.prepareDragLeftMargin(this.tlMargin);
                    }
                    this.editorState = 2;
                    return;
                }
                case 11: {
                    if (this.marginListener != null) {
                        this.marginListener.prepareDragRightMargin(this.brMargin);
                    }
                    this.editorState = 4;
                    return;
                }
            }
            Component component = this.getComponentAt(n, n2);
            if (component == this) {
                this.catchIn = this.catchInCursor(n, n2);
                if (this.catchIn != null) {
                    RulerCursor rulerCursor = this.searchUnionCursor(this.catchIn, this.lastxy);
                    if (rulerCursor == null) {
                        if (this.actionListener != null) {
                            if (this.actionListener.catchInRulerCursor(this, this.catchIn, this.lastxy)) {
                                this.updatePosition(this.catchIn, this.lastxy);
                                this.add(this.catchIn);
                                this.catchIn.repaint();
                                this.lastPos = this.catchIn.getPosition();
                            } else {
                                this.catchIn = null;
                            }
                        } else {
                            this.updatePosition(this.catchIn, this.lastxy);
                            this.add(this.catchIn);
                            this.catchIn.repaint();
                            this.lastPos = this.catchIn.getPosition();
                        }
                    } else {
                        this.catchIn = null;
                    }
                }
                if (this.catchIn != null) {
                    this.editorState = 5;
                }
            } else if (component instanceof RulerCursor) {
                this.catchIn = (RulerCursor)component;
                this.lastPos = this.catchIn.getPosition();
                if (!this.prepareDragRulerCursor(this.catchIn, this.lastPos)) {
                    this.updatePosition(this.catchIn, this.lastPos);
                    this.editorState = 0;
                } else {
                    this.editorState = 5;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) {
            this.mouseDragged(mouseEvent);
            switch (this.editorState) {
                case 1: {
                    if (this.marginListener == null) break;
                    this.marginListener.overDragTopMargin(this.tlMargin);
                    break;
                }
                case 3: {
                    if (this.marginListener == null) break;
                    this.marginListener.overDragBottomMargin(this.brMargin);
                    break;
                }
                case 2: {
                    if (this.marginListener == null) break;
                    this.marginListener.overDragLeftMargin(this.tlMargin);
                    break;
                }
                case 4: {
                    if (this.marginListener == null) break;
                    this.marginListener.overDragRightMargin(this.brMargin);
                    break;
                }
                case 5: {
                    if (this.catchIn == null) break;
                    if (!this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                        if (this.actionListener != null) {
                            if (this.actionListener.throwOutRulerCursor(this, this.catchIn, this.lastPos)) break;
                            this.remove(this.catchIn);
                            Rectangle rectangle = this.catchIn.getBounds();
                            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            break;
                        }
                        this.remove(this.catchIn);
                        Rectangle rectangle = this.catchIn.getBounds();
                        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        break;
                    }
                    if (this.overDragRulerCursor(this.catchIn, this.lastPos)) break;
                    this.updatePosition(this.catchIn, this.lastPos);
                }
            }
            this.editorState = 0;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.orientation == 0 ? n : n2;
            this.tpb.lockUpdate();
            switch (this.editorState) {
                case 1: {
                    if (this.marginListener != null && !this.marginListener.dragTopMargin(this.tlMargin + n3 - this.lastxy)) break;
                    this.tlMargin += n3 - this.lastxy;
                    this.updateCursorsPos(n3 - this.lastxy);
                    this.lastxy = n3;
                    this.repaint();
                    break;
                }
                case 3: {
                    if (this.marginListener != null && !this.marginListener.dragBottomMargin(this.brMargin - n3 + this.lastxy)) break;
                    this.brMargin -= n3 - this.lastxy;
                    this.lastxy = n3;
                    this.repaint();
                    break;
                }
                case 2: {
                    if (this.marginListener != null && !this.marginListener.dragLeftMargin(this.tlMargin + n3 - this.lastxy)) break;
                    this.tlMargin += n3 - this.lastxy;
                    this.updateCursorsPos(n3 - this.lastxy);
                    this.lastxy = n3;
                    this.repaint();
                    break;
                }
                case 4: {
                    if (this.marginListener != null && !this.marginListener.dragRightMargin(this.brMargin - n3 + this.lastxy)) break;
                    this.brMargin -= n3 - this.lastxy;
                    this.lastxy = n3;
                    this.repaint();
                    break;
                }
                case 5: {
                    if (this.catchIn == null) break;
                    RulerCursor rulerCursor = this.searchUnionCursor(this.catchIn, n3 = this.lastPos + n3 - this.lastxy);
                    if (rulerCursor != null && this.actionListener != null) {
                        if (!this.actionListener.unionRulerCursor(this, rulerCursor, this.catchIn, n3)) {
                            this.updatePosition(this.catchIn, n3);
                        }
                    } else if (!this.dragRulerCursor(this.catchIn, n3)) {
                        this.updatePosition(this.catchIn, n3);
                    }
                    n3 = this.catchIn.getPosition();
                    this.lastxy += n3 - this.lastxy;
                    this.lastPos = n3;
                }
            }
            this.tpb.unlockUpdate();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (this.getComponentAt(n2, n = mouseEvent.getY()) == this && this.enableMargin) {
            int n3;
            Dimension dimension = this.getSize();
            int n4 = (this.orientation == 0 ? dimension.width - 1 : dimension.height - 1) - this.brMargin;
            int n5 = this.orientation == 0 ? n2 : n;
            Cursor cursor = this.getCursor();
            int n6 = n3 = cursor == null ? 0 : cursor.getType();
            if (n5 > this.tlMargin - 3 && n5 < this.tlMargin + 3) {
                int n7;
                int n8 = n7 = this.orientation == 0 ? 10 : 8;
                if (n3 != n7) {
                    n3 = n7;
                    this.setCursor(Cursor.getPredefinedCursor(n3));
                }
            } else if (n5 > n4 - 3 && n5 < n4 + 3) {
                int n9;
                int n10 = n9 = this.orientation == 0 ? 11 : 9;
                if (n3 != n9) {
                    n3 = n9;
                    this.setCursor(Cursor.getPredefinedCursor(n3));
                }
            } else if (n3 != 0) {
                n3 = 0;
                this.setCursor(Cursor.getPredefinedCursor(n3));
            }
        }
    }

    public void updatePosition(RulerCursor rulerCursor, int n) {
        Point point = rulerCursor.getLocation();
        Dimension dimension = rulerCursor.getSize();
        int n2 = rulerCursor.getHotPoint();
        if (this.orientation == 0) {
            if (n2 < 0) {
                n2 = dimension.width / 2;
            }
            point.x = n - n2;
        } else if (this.orientation == 1) {
            if (n2 < 0) {
                n2 = dimension.height / 2;
            }
            point.y = n - n2;
        }
        Rectangle rectangle = rulerCursor.getBounds();
        rulerCursor.setBounds(point.x, point.y, dimension.width, dimension.height);
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public RulerCursor catchInCursor(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        this.catchIn = new RulerCursor();
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (this.orientation == 0) {
            n4 = dimension.height / 2;
            n3 = n4;
            if (n2 <= n3) {
                this.catchIn.setAttachment(0);
            } else if (n2 > n3) {
                this.catchIn.setAttachment(1);
            }
            if (this.catchIn.getAttachment() == 0) {
                rectangle.y = 0;
            } else if (this.catchIn.getAttachment() == 1) {
                rectangle.y = n3;
            }
            rectangle.width = n4 + 2;
            rectangle.height = n4;
        } else if (this.orientation == 1) {
            n4 = dimension.width / 2;
            n3 = n4;
            if (n <= n3) {
                this.catchIn.setAttachment(0);
            } else if (n > n3) {
                this.catchIn.setAttachment(1);
            }
            if (this.catchIn.getAttachment() == 0) {
                rectangle.x = 0;
            } else if (this.catchIn.getAttachment() == 1) {
                rectangle.x = n3;
            }
            rectangle.width = n4;
            rectangle.height = n4 + 2;
        }
        this.catchIn.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return this.catchIn;
    }

    RulerCursor searchUnionCursor(RulerCursor rulerCursor, int n) {
        if (rulerCursor != null) {
            Rectangle rectangle = rulerCursor.getBounds();
            int n2 = rulerCursor.getAttachment();
            int n3 = rulerCursor.getHotPoint();
            if (this.orientation == 0) {
                rectangle.x = n - n3;
            } else {
                rectangle.y = n - n3;
            }
            int n4 = this.getComponentCount();
            if (n4 > 0) {
                Component[] componentArray = this.getComponents();
                for (int i = n4 - 1; i >= 0; --i) {
                    Component component = componentArray[i];
                    if (component == null || !(component instanceof RulerCursor)) continue;
                    RulerCursor rulerCursor2 = (RulerCursor)component;
                    Rectangle rectangle2 = rulerCursor2.getBounds();
                    if (rulerCursor2.getAttachment() != n2 || rulerCursor2 == rulerCursor || !rectangle2.intersects(rectangle)) continue;
                    return rulerCursor2;
                }
            }
        }
        return null;
    }

    boolean prepareDragRulerCursor(RulerCursor rulerCursor, int n) {
        if (this.actionListener != null) {
            return this.actionListener.prepareDragRulerCursor(this, rulerCursor, n);
        }
        return false;
    }

    boolean dragRulerCursor(RulerCursor rulerCursor, int n) {
        if (this.actionListener != null) {
            return this.actionListener.dragRulerCursor(this, rulerCursor, n);
        }
        return false;
    }

    boolean overDragRulerCursor(RulerCursor rulerCursor, int n) {
        if (this.actionListener != null) {
            return this.actionListener.overDragRulerCursor(this, rulerCursor, n);
        }
        return false;
    }

    protected void updateCursorsPos(int n) {
        int n2 = this.getComponentCount();
        if (n2 > 0) {
            Component[] componentArray = this.getComponents();
            for (int i = n2 - 1; i >= 0; --i) {
                Component component = componentArray[i];
                this.updatePosition((RulerCursor)component, ((RulerCursor)component).getPosition() + n);
            }
        }
    }
}

