/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.Ruler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class RulerCursor
extends Component {
    public static final int TOPLEFT = 0;
    public static final int BOTTOMRIGHT = 1;
    private int SEDU = 0;
    private int addPoint = -1;

    public RulerCursor() {
        this(0);
    }

    public RulerCursor(int n) {
        this.SEDU = n;
    }

    @Override
    public void paint(Graphics graphics) {
        Ruler ruler = (Ruler)this.getParent();
        if (ruler != null) {
            int n = ruler.getOrientation();
            Polygon polygon = this.getPolygon(n);
            this.drawCursor(graphics, polygon, n);
        }
    }

    public void setAttachment(int n) {
        if (this.SEDU != n) {
            Container container = this.getParent();
            this.SEDU = n;
            if (container != null) {
                container.doLayout();
            }
        }
    }

    public int getAttachment() {
        return this.SEDU;
    }

    public void setHotPoint(int n) {
        int n2 = 0;
        Dimension dimension = this.getSize();
        Ruler ruler = (Ruler)this.getParent();
        if (ruler != null) {
            int n3 = ruler.getOrientation();
            if (n3 == 0) {
                n2 = dimension.width;
            } else if (n3 == 1) {
                n2 = dimension.height;
            }
        }
        if (this.addPoint != n && n >= 0 && n < n2) {
            if (ruler != null) {
                ruler.prepareDragRulerCursor(this, this.getPosition());
            }
            this.addPoint = n;
            if (ruler != null) {
                ruler.dragRulerCursor(this, this.getPosition());
                ruler.overDragRulerCursor(this, this.getPosition());
            }
        }
    }

    public int getHotPoint() {
        if (this.addPoint < 0) {
            Dimension dimension = this.getSize();
            Ruler ruler = (Ruler)this.getParent();
            if (ruler != null) {
                int n = ruler.getOrientation();
                if (n == 0) {
                    this.addPoint = dimension.width / 2;
                } else if (n == 1) {
                    this.addPoint = dimension.height / 2;
                }
            }
        }
        return this.addPoint;
    }

    public int getPosition() {
        Point point = this.getLocation();
        Ruler ruler = (Ruler)this.getParent();
        if (ruler != null) {
            int n = ruler.getOrientation();
            if (n == 0) {
                return point.x + this.getHotPoint();
            }
            if (n == 1) {
                return point.y + this.getHotPoint();
            }
        }
        int n = point.x + this.getHotPoint();
        return n;
    }

    @Override
    public boolean contains(int n, int n2) {
        boolean bl = false;
        if (this.isVisible()) {
            Ruler ruler = (Ruler)this.getParent();
            if (ruler != null) {
                int n3 = ruler.getOrientation();
                Polygon polygon = this.getPolygon(n3);
                bl = polygon.contains(n, n2);
            } else {
                Dimension dimension = this.getSize();
                bl = n >= 0 && n < dimension.width && n2 >= 0 && n2 < dimension.height;
            }
        }
        return bl;
    }

    protected Polygon getPolygon(int n) {
        int n2 = this.getHotPoint();
        Polygon polygon = new Polygon();
        Dimension dimension = this.getSize();
        --dimension.width;
        --dimension.height;
        if (n == 0) {
            int n3 = dimension.width / 2;
            if (this.SEDU == 0) {
                polygon.addPoint(0, n3);
                polygon.addPoint(0, 0);
                polygon.addPoint(dimension.width, 0);
                polygon.addPoint(dimension.width, n3);
                polygon.addPoint(n2, dimension.height);
            } else if (this.SEDU == 1) {
                n3 = dimension.height - n3;
                polygon.addPoint(dimension.width, n3);
                polygon.addPoint(dimension.width, dimension.height);
                polygon.addPoint(0, dimension.height);
                polygon.addPoint(0, n3);
                polygon.addPoint(n2, 0);
            }
        } else if (n == 1) {
            int n4 = dimension.height / 2;
            if (this.SEDU == 0) {
                polygon.addPoint(n4, dimension.height);
                polygon.addPoint(0, dimension.height);
                polygon.addPoint(0, 0);
                polygon.addPoint(n4, 0);
                polygon.addPoint(dimension.width, n2);
            } else if (this.SEDU == 1) {
                n4 = dimension.width - n4;
                polygon.addPoint(n4, 0);
                polygon.addPoint(dimension.width, 0);
                polygon.addPoint(dimension.width, dimension.height);
                polygon.addPoint(n4, dimension.height);
                polygon.addPoint(0, n2);
            }
        }
        return polygon;
    }

    protected void drawCursor(Graphics graphics, Polygon polygon, int n) {
        graphics.setColor(Color.lightGray);
        graphics.fillPolygon(polygon);
        graphics.setColor(Color.gray);
        graphics.drawLine(polygon.xpoints[3], polygon.ypoints[3], polygon.xpoints[4], polygon.ypoints[4]);
        graphics.drawLine(polygon.xpoints[4], polygon.ypoints[4], polygon.xpoints[0], polygon.ypoints[0]);
        graphics.setColor(Color.black);
        for (int i = 0; i < 3; ++i) {
            graphics.drawLine(polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
        }
        if (n == 0) {
            if (this.SEDU == 0) {
                graphics.setColor(Color.white);
                graphics.drawLine(polygon.xpoints[0] + 1, polygon.ypoints[0], polygon.xpoints[1] + 1, polygon.ypoints[1] + 2);
                graphics.drawLine(polygon.xpoints[1] + 1, polygon.ypoints[1] + 1, polygon.xpoints[2] - 2, polygon.ypoints[2] + 1);
                graphics.setColor(Color.gray);
                graphics.drawLine(polygon.xpoints[2] - 1, polygon.ypoints[2] + 1, polygon.xpoints[3] - 1, polygon.ypoints[3] - 1);
                graphics.drawLine(polygon.xpoints[3] - 1, polygon.ypoints[3], polygon.xpoints[4], polygon.ypoints[4] - 1);
            } else if (this.SEDU == 1) {
                graphics.setColor(Color.white);
                graphics.drawLine(polygon.xpoints[4], polygon.ypoints[4] + 1, polygon.xpoints[3] + 1, polygon.ypoints[3]);
                graphics.drawLine(polygon.xpoints[3] + 1, polygon.ypoints[3] + 1, polygon.xpoints[2] + 1, polygon.ypoints[2] - 1);
                graphics.setColor(Color.gray);
                graphics.drawLine(polygon.xpoints[2] + 2, polygon.ypoints[2] - 1, polygon.xpoints[1] - 1, polygon.ypoints[1] - 1);
                graphics.drawLine(polygon.xpoints[0] - 1, polygon.ypoints[0], polygon.xpoints[1] - 1, polygon.ypoints[1] - 2);
            }
        } else if (n == 1) {
            if (this.SEDU == 0) {
                graphics.setColor(Color.white);
                graphics.drawLine(polygon.xpoints[2] + 1, polygon.ypoints[2] - 1, polygon.xpoints[1] + 1, polygon.ypoints[1] + 1);
                graphics.drawLine(polygon.xpoints[2] + 2, polygon.ypoints[2] + 1, polygon.xpoints[3], polygon.ypoints[3] + 1);
                graphics.setColor(Color.gray);
                graphics.drawLine(polygon.xpoints[1] + 2, polygon.ypoints[1] - 1, polygon.xpoints[0] - 1, polygon.ypoints[0] - 1);
                graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0] - 1, polygon.xpoints[4] - 1, polygon.ypoints[4]);
            } else if (this.SEDU == 1) {
                graphics.setColor(Color.white);
                graphics.drawLine(polygon.xpoints[4] + 1, polygon.ypoints[4], polygon.xpoints[0], polygon.ypoints[0] + 1);
                graphics.drawLine(polygon.xpoints[0] + 2, polygon.ypoints[0] + 1, polygon.xpoints[1] - 2, polygon.ypoints[1] + 1);
                graphics.setColor(Color.gray);
                graphics.drawLine(polygon.xpoints[1] - 1, polygon.ypoints[1] + 1, polygon.xpoints[2] - 1, polygon.ypoints[2] - 1);
                graphics.drawLine(polygon.xpoints[3], polygon.ypoints[3] - 1, polygon.xpoints[2] - 1, polygon.ypoints[2] - 1);
            }
        }
    }
}

