/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.EditablePaintBoard;
import guitools.toolkit.SplitterContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.util.Vector;

public class Splitterbar
extends Component {
    public static final int WIDTHHEIGHT = 4;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int orientation;
    Vector topleft = new Vector(1);
    Vector bottomright = new Vector(1);

    public Splitterbar() {
        this(0);
    }

    public Splitterbar(int n) {
        this.orientation = n;
        if (n == 0) {
            this.setCursor(Cursor.getPredefinedCursor(9));
        } else if (n == 1) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        if (container instanceof EditablePaintBoard) {
            EditablePaintBoard editablePaintBoard = (EditablePaintBoard)container;
            editablePaintBoard.addSplitterbar(this);
            this.addMouseListener(editablePaintBoard);
            this.addMouseMotionListener(editablePaintBoard);
        }
    }

    @Override
    public void removeNotify() {
        Container container = this.getParent();
        if (container instanceof EditablePaintBoard) {
            EditablePaintBoard editablePaintBoard = (EditablePaintBoard)container;
            editablePaintBoard.removeSplitterbar(this);
            this.removeMouseListener(editablePaintBoard);
            this.removeMouseMotionListener(editablePaintBoard);
        }
        super.removeNotify();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getTopLeftSplitterContainerCount() {
        return this.topleft.size();
    }

    public SplitterContainer getTopLeftSplitterContainer(int n) {
        if (this.topleft.size() > 0) {
            return (SplitterContainer)this.topleft.elementAt(n);
        }
        return null;
    }

    public int getBottomRightSplitterContainerCount() {
        return this.bottomright.size();
    }

    public SplitterContainer getBottomRightSplitterContainer(int n) {
        if (this.bottomright.size() > 0) {
            return (SplitterContainer)this.bottomright.elementAt(n);
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        --dimension.width;
        --dimension.height;
        SystemColor systemColor = SystemColor.control;
        if (this.orientation == 0) {
            graphics.setColor(systemColor.darker());
            graphics.drawLine(0, 0, dimension.width, 0);
            graphics.drawLine(0, dimension.height, dimension.width, dimension.height);
            --dimension.height;
            graphics.setColor(systemColor);
            graphics.drawLine(0, dimension.height, dimension.width, dimension.height);
            --dimension.height;
            graphics.setColor(systemColor.brighter());
            graphics.drawLine(0, dimension.height, dimension.width, dimension.height);
        } else if (this.orientation == 1) {
            graphics.setColor(systemColor.darker());
            graphics.drawLine(0, 0, 0, dimension.height);
            graphics.drawLine(dimension.width, 0, dimension.width, dimension.height);
            --dimension.width;
            graphics.setColor(systemColor);
            graphics.drawLine(dimension.width, 0, dimension.width, dimension.height);
            --dimension.width;
            graphics.setColor(systemColor.brighter());
            graphics.drawLine(dimension.width, 0, dimension.width, dimension.height);
        }
    }

    @Override
    public final void reshape(int n, int n2, int n3, int n4) {
        if (this.orientation == 0) {
            n4 = 4;
        } else if (this.orientation == 1) {
            n3 = 4;
        }
        super.reshape(n, n2, n3, n4);
    }
}

