/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.UIResource;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.Window;

class TipWindow
extends Window {
    int iMargin = 3;
    String tipHelp;

    TipWindow(Frame frame, String string) {
        super(frame);
        this.tipHelp = string;
        this.setEnabled(false);
        this.setBackground(SystemColor.info);
        this.setForeground(SystemColor.infoText);
        this.setFont(UIResource.getFont("Tip Font"));
        this.setSize(this.getPreferredSize());
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return this.tipHelp == null ? new Dimension() : new Dimension(fontMetrics.stringWidth(this.tipHelp) + this.iMargin * 2, fontMetrics.getHeight() + this.iMargin * 2);
    }

    void setTip(String string) {
        this.tipHelp = string;
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.drawString(this.tipHelp, this.iMargin, dimension.height - this.iMargin - 3);
    }
}

