/*
 * Decompiled with CFR 0.152.
 */
package html;

import html.GUIBlock;
import html.HTMLAlign;
import html.HTMLNode;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Stack;

public class BlockInfo {
    int bw;
    int bh;
    Stack rows = new Stack();
    HTMLAlign align;
    HTMLNode node;
    GUIBlock block;
    BlockInfo parent;

    public BlockInfo() {
        this(new GUIBlock(), null, null);
    }

    public BlockInfo(String string, HTMLNode hTMLNode) {
        this(new GUIBlock(), string, hTMLNode);
    }

    public BlockInfo(GUIBlock gUIBlock, String string, HTMLNode hTMLNode) {
        this.block = gUIBlock;
        this.node = hTMLNode;
        if (string != null) {
            this.align = HTMLAlign.create(string);
        }
    }

    public BlockInfo addBlock(BlockInfo blockInfo) {
        blockInfo.parent = this;
        this.rows.push(blockInfo);
        this.block.add(blockInfo.block);
        return blockInfo;
    }

    public void updateInfo(BlockInfo blockInfo, int n) {
        Dimension dimension = this.block.getSize();
        if (!this.rows.isEmpty() && this.rows.indexOf(blockInfo) != 0) {
            dimension.height += n;
        }
        blockInfo.block.setLocation(0, dimension.height);
        blockInfo.bw = this.bw;
        int n2 = blockInfo.bh = this.bh == -1 ? this.bh : this.bh - dimension.height;
        if (blockInfo.align == null) {
            blockInfo.align = this.align;
        }
    }

    public boolean breakBlock() {
        if (!this.rows.isEmpty()) {
            Dimension dimension = this.block.getSize();
            BlockInfo blockInfo = (BlockInfo)this.rows.peek();
            Rectangle rectangle = blockInfo.block.getBounds();
            if (dimension.height < rectangle.y + rectangle.height) {
                dimension.height = rectangle.y + rectangle.height;
            }
            if (dimension.width < rectangle.x + rectangle.width) {
                dimension.width = rectangle.x + rectangle.width;
            }
            this.block.setSize(dimension);
            return this.parent.breakBlock();
        }
        return false;
    }

    public boolean isFull(int n) {
        return this.bh == -1 ? false : this.bh - this.block.getSize().height - n <= 0;
    }
}

