/*
 * Decompiled with CFR 0.152.
 */
package html;

import html.BlockInfo;
import html.GUICell;
import html.HTMLNode;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class CellInfo
extends BlockInfo {
    int rowspan;
    int colspan;
    int cellpadding;

    public CellInfo() {
    }

    public CellInfo(String string, HTMLNode hTMLNode, boolean bl, int n) {
        super(new GUICell(bl, n), string, hTMLNode);
    }

    @Override
    public void updateInfo(BlockInfo blockInfo, int n) {
        Dimension dimension = this.block.getSize();
        if (!this.rows.isEmpty() && this.rows.indexOf(blockInfo) != 0) {
            dimension.height += 1 + this.cellpadding;
        }
        blockInfo.block.setLocation(1 + this.cellpadding, dimension.height + this.cellpadding);
        blockInfo.bw = this.bw - 2 - this.cellpadding * 2;
        int n2 = blockInfo.bh = this.bh == -1 ? this.bh : this.bh - dimension.height;
        if (blockInfo.align == null) {
            blockInfo.align = this.align;
        }
    }

    @Override
    public boolean breakBlock() {
        if (!this.rows.isEmpty()) {
            Dimension dimension = this.block.getSize();
            BlockInfo blockInfo = (BlockInfo)this.rows.peek();
            Rectangle rectangle = blockInfo.block.getBounds();
            if (dimension.height < rectangle.y + rectangle.height) {
                dimension.height = rectangle.y + rectangle.height + this.cellpadding;
            }
            if (dimension.width < rectangle.x + rectangle.width) {
                dimension.width = rectangle.x + rectangle.width;
            }
            ++dimension.height;
            this.block.setSize(dimension);
        }
        return false;
    }

    public void updateContents() {
        BlockInfo blockInfo;
        int n;
        int n2;
        int n3 = n2 = this.block.getSize().height - 1;
        int n4 = 0;
        for (n = 0; n < this.rows.size(); ++n) {
            blockInfo = (BlockInfo)this.rows.elementAt(n);
            Rectangle rectangle = blockInfo.block.getBounds();
            rectangle.height += rectangle.y;
            if (n3 > rectangle.y) {
                n3 = rectangle.y;
            }
            if (n4 >= rectangle.height) continue;
            n4 = rectangle.height;
        }
        int n5 = (n2 - (n4 - n3)) / 2 - n3;
        for (n = 0; n < this.rows.size(); ++n) {
            blockInfo = (BlockInfo)this.rows.elementAt(n);
            Point point = blockInfo.block.getLocation();
            point.y += n5;
            blockInfo.block.setLocation(point);
        }
    }
}

