/*
 * Decompiled with CFR 0.152.
 */
package html;

import html.HTMLSearchAnchor;
import html.Hyperlinkable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import jet.log.JRLogger;

public abstract class GUIContent
extends Component
implements HTMLSearchAnchor {
    boolean pressed;
    String href;
    String name;
    Hyperlinkable hyperlink;
    private static JRLogger SEDU = JRLogger.getLogger(GUIContent.class.getName());

    public GUIContent(Hyperlinkable hyperlinkable) {
        this.enableEvents(16L);
        this.hyperlink = hyperlinkable;
    }

    public void setHRef(String string) {
        if (string != null) {
            int n = string.indexOf(35);
            if (n != -1 && string.indexOf(58, n + 1) != -1) {
                this.href = string.substring(0, n);
                this.href = this.href + string.replace(':', ';').substring(n);
            } else {
                this.href = string;
            }
        } else {
            this.href = null;
        }
        if (string != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void setAnchor(String string) {
        this.name = string == null ? null : string.replace(':', ';');
    }

    public boolean isAnchor(String string) {
        return this.name == null ? false : this.name.equals(string);
    }

    public boolean isSourceAnchor() {
        return this.href != null;
    }

    @Override
    public Point searchAnchor(String string) {
        if (this.name != null && string.equalsIgnoreCase(this.name)) {
            return this.getLocation();
        }
        return null;
    }

    @Override
    public Color getForeground() {
        return this.href != null ? (this.pressed ? this.hyperlink.getALink() : this.hyperlink.getLink(this.href)) : super.getForeground();
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.hyperlink != null) {
            switch (mouseEvent.getID()) {
                case 500: {
                    if (this.href == null) break;
                    try {
                        URL uRL = new URL(this.hyperlink.getBase(), this.href);
                        this.hyperlink.hypervlink(this.href);
                        this.hyperlink.hyperlink(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (!SEDU.isErrorEnabled()) break;
                        SEDU.error("", malformedURLException);
                    }
                    break;
                }
                case 501: {
                    this.pressed = true;
                    if (this.href == null) break;
                    this.repaint();
                    break;
                }
                case 502: {
                    this.pressed = false;
                    if (this.href == null) break;
                    this.repaint();
                    break;
                }
                case 505: {
                    this.hyperlink.showPrompt("");
                    break;
                }
                case 504: {
                    this.hyperlink.showPrompt(this.href);
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected abstract void dump(String var1);
}

