/*
 * Decompiled with CFR 0.152.
 */
package html;

import html.GUIContent;
import html.HTMLAlign;
import html.Hyperlinkable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class GUIImage
extends GUIContent {
    int height;
    int width;
    int hspace;
    int vspace;
    int border;
    String src;
    String alt;
    Image img;
    HTMLAlign align;

    public GUIImage(Hyperlinkable hyperlinkable, String string, String string2, Image image) {
        super(hyperlinkable);
        this.enableEvents(48L);
        this.src = string;
        this.alt = string2 == null ? string : string2;
        this.img = image;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.width, this.height);
        if (this.width <= 0 && this.img != null) {
            dimension.width = this.img.getWidth(this) + this.border + this.hspace;
        }
        if (this.height <= 0 && this.img != null) {
            dimension.height = this.img.getHeight(this) + this.border + this.vspace;
        }
        return dimension;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 505: {
                this.hyperlink.hideTip();
                this.hyperlink.showPrompt("");
                break;
            }
            case 504: {
                if (!this.isShowing()) break;
                Point point = this.getLocationOnScreen();
                this.hyperlink.showTip(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y, this.alt);
                this.hyperlink.showPrompt(this.src);
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 503 && this.isShowing()) {
            Point point = this.getLocationOnScreen();
            this.hyperlink.showTip(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y, this.alt);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.border + this.hspace;
        int n2 = this.border + this.vspace;
        if (this.img == null) {
            graphics.drawRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.drawImage(this.img, n, n2, dimension.width - (n << 1), dimension.height - (n2 << 1), this);
        }
        graphics.setColor(this.getForeground());
        n = this.hspace;
        n2 = this.vspace;
        dimension.width -= this.hspace;
        dimension.height -= this.vspace;
        for (int i = 0; i < this.border; ++i) {
            graphics.drawRect(n + i, n2 + i, dimension.width - (i << 1), dimension.height - (i << 1));
        }
    }

    @Override
    protected void dump(String string) {
        System.out.println(string + this.toString());
    }
}

