/*
 * Decompiled with CFR 0.152.
 */
package html;

import html.DrawString;
import html.GUIBody;
import html.GUIContent;
import html.HTMLColor;
import html.Hyperlinkable;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import jet.util.JavaEnv;

public class GUIText
extends GUIContent {
    int sel;
    int sellen;
    int selx;
    int selw;
    int ex;
    int ey;
    String text;

    public GUIText(Hyperlinkable hyperlinkable, Font font, String string, String string2) {
        super(hyperlinkable);
        this.enableEvents(32L);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setFont(font);
        this.setForeground(HTMLColor.getColor(string));
        this.text = string2;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        if (this.text != null) {
            int n = this.text.length() > 0 ? (int)this.text.charAt(0) : 32;
            FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.getFont());
            dimension.width = fontMetrics.stringWidth(this.text) + (n == 87 || n == 86 || n == 118 ? 1 : 0);
            dimension.height = fontMetrics.getAscent() + fontMetrics.getDescent();
        }
        return dimension;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.text != null && this.text.length() > 0) {
            int n;
            Dimension dimension = this.getSize();
            int n2 = this.text.length() > 0 ? (int)this.text.charAt(0) : 32;
            Font font = this.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            graphics.setColor(this.getForeground());
            graphics.setFont(font);
            int n3 = font.getStyle();
            if ((n3 & 4) == 4 || this.href != null) {
                int n4 = fontMetrics.getLeading();
                n = dimension.height - (n4 == 0 ? 2 : 1);
                graphics.drawLine(0, n, dimension.width - 1, n);
            }
            if (JavaEnv.is2D(graphics)) {
                DrawString.drawString(graphics, font, fontMetrics, this.text);
            } else {
                graphics.drawString(this.text, n2 == 87 || n2 == 86 || n2 == 118 ? 1 : 0, fontMetrics.getAscent());
            }
            if ((n3 & 8) == 8) {
                n = (int)((double)dimension.height / 3.0 * 2.0);
                graphics.drawLine(0, n, dimension.width - 1, n);
            }
            if (this.sellen > 0) {
                graphics.setColor(SystemColor.textHighlight);
                graphics.fillRect(this.selx, 0, this.selw, dimension.height);
                graphics.setColor(SystemColor.textHighlightText);
                graphics.drawString(this.text.substring(this.sel, this.sel + this.sellen), this.selx, fontMetrics.getAscent());
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                Point point = this.mapToBody(mouseEvent.getX(), mouseEvent.getY());
                this.ex = point.x;
                this.ey = point.y;
                this.hyperlink.select(this.ex, this.ey, this.ex, this.ey);
                break;
            }
            case 502: {
                Point point = this.mapToBody(mouseEvent.getX(), mouseEvent.getY());
                this.hyperlink.select(this.ex, this.ey, point.x, point.y);
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            Point point = this.mapToBody(mouseEvent.getX(), mouseEvent.getY());
            this.hyperlink.select(this.ex, this.ey, point.x, point.y);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    void clearSelection() {
        this.sel = 0;
        this.sellen = 0;
        this.selx = 0;
        this.selw = 0;
    }

    void selected(int n, int n2) {
        this.sel = n;
        this.sellen = n2;
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.getFont());
        this.selx = this.sel == 0 ? 0 : fontMetrics.stringWidth(this.text.substring(0, n));
        this.selw = fontMetrics.stringWidth(this.text.substring(n, n + n2));
    }

    void selected() {
        this.sel = 0;
        this.sellen = this.text.length();
        this.selx = 0;
        this.selw = this.getSize().width;
    }

    int getPos(int n) {
        int n2;
        int n3 = this.getSize().width;
        if (n <= 0) {
            n2 = 0;
        } else if (n >= n3) {
            n2 = this.text.length();
        } else {
            FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.getFont());
            int n4 = this.text.length() / 2;
            int n5 = 0;
            int n6 = this.text.length();
            while (true) {
                int n7;
                if ((n3 = fontMetrics.stringWidth(this.text.substring(0, n4))) == n) {
                    n2 = n4;
                    break;
                }
                if (n3 < n) {
                    n5 = n4 + 1;
                    if (n6 <= n5) {
                        n2 = n5;
                        break;
                    }
                    n7 = (n6 - n5) / 2;
                    n4 += n7 == 0 ? 1 : n7;
                    continue;
                }
                n6 = n4 - 1;
                if (n6 <= n5) {
                    n2 = n6;
                    break;
                }
                n7 = (n6 - n5) / 2;
                n4 -= n7 == 0 ? 1 : n7;
            }
        }
        return n2;
    }

    Point mapToBody(int n, int n2) {
        Point point = this.getLocation();
        n += point.x;
        n2 += point.y;
        Container container = this.getParent();
        while (!(container instanceof GUIBody)) {
            point = container.getLocation();
            n += point.x;
            n2 += point.y;
            container = container.getParent();
        }
        point.x = n;
        point.y = n2;
        return point;
    }

    @Override
    public String toString() {
        return this.text;
    }

    @Override
    protected void dump(String string) {
        System.out.println(string + this.toString());
        System.out.println(string + this.text + '(' + this.text.length() + ')');
    }
}

