/*
 * Decompiled with CFR 0.152.
 */
package html;

import guitools.swing.dialog.ShowMessageDialog;
import guitools.toolkit.Find;
import guitools.toolkit.ScrollPanel;
import guitools.toolkit.StdWindow;
import guitools.toolkit.Unit;
import html.GUIBody;
import html.GUIText;
import html.HTMLBaseFont;
import html.HTMLColor;
import html.HTMLCompositor;
import html.HTMLParser;
import html.HistoryInfo;
import html.Hyperlinkable;
import html.ScrollListener;
import html.TextInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;
import jet.JDesgResource;
import jet.JResource;
import jet.util.JavaEnv;

public class HTMLBrowser
extends ScrollPanel
implements Hyperlinkable,
Find {
    private int Blue;
    private int Red;
    private int SEDU;
    private int addElement;
    private StdWindow append;
    private Vector barWidth = new Vector();
    private Stack clearSelected = new Stack();
    private Stack clearSelection = new Stack();
    Vector textObjs = new Vector();
    private TextInfo clipRect;
    private TextInfo clone;
    static final Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private GUIBody compose;
    HTMLCompositor compositor = new HTMLCompositor(this);
    HTMLParser parser = new HTMLParser(this);
    boolean ref;
    int sclx;
    int scly;
    int pgW;
    private URL contains;
    URL base;
    URL tagbase;
    InputStream in;
    private HTMLBaseFont dispose;
    Hyperlinkable linkable = this;
    Color link = HTMLColor.Blue;
    Color alink = HTMLColor.Red;
    Color vlink = new Color(64, 16, 128);
    Image img;
    boolean nowarn;
    ScrollListener sl;

    public HTMLBrowser() {
        this.Blue();
    }

    public HTMLBrowser(LayoutManager layoutManager) {
        super(layoutManager);
        this.Blue();
    }

    public HTMLBrowser(int n) {
        super(n);
        this.Blue();
    }

    public HTMLBrowser(LayoutManager layoutManager, int n) {
        super(layoutManager, n);
        this.Blue();
    }

    public void setLocation(URL uRL) throws IOException {
        this.setLocation(uRL, null);
    }

    public void setLocation(URL uRL, InputStream inputStream) throws IOException {
        HistoryInfo historyInfo;
        if (!this.clearSelected.empty()) {
            historyInfo = (HistoryInfo)this.clearSelected.peek();
            historyInfo.setLocation(this.getValue(0), this.getValue(1));
        }
        this.load(uRL, inputStream, true, 0, 0);
        this.clearSelection.removeAllElements();
        historyInfo = new HistoryInfo(0, 0, uRL, inputStream);
        int n = this.clearSelected.indexOf(historyInfo);
        if (n != -1) {
            for (int i = this.clearSelected.size() - 1; i >= n; --i) {
                this.clearSelected.removeElementAt(i);
            }
        }
        this.clearSelected.push(historyInfo);
        this.updateTrigger();
    }

    public boolean isNowarn() {
        return this.nowarn;
    }

    public void setNowarn(boolean bl) {
        this.nowarn = bl;
    }

    @Override
    public void warnning(IOException iOException) {
        if (!this.nowarn) {
            ShowMessageDialog.showMessageDialog(this, JResource.getMessage("HTML_0", (Object)iOException.getMessage()), JDesgResource.getMessage("MESSAGE"));
        }
        if (this.append != null) {
            this.append.stopProgress("progress");
            this.append.setBusy(false);
        }
    }

    public void setStdWindow(StdWindow stdWindow) {
        this.append = stdWindow;
    }

    public void setHyperlinkables(Hyperlinkable hyperlinkable) {
        this.linkable = hyperlinkable == null ? this : hyperlinkable;
    }

    @Override
    public void setHome(URL uRL) {
        this.contains = uRL;
    }

    @Override
    public URL getHome() {
        return this.contains;
    }

    @Override
    public void hypervlink(String string) {
        if (!this.barWidth.contains(string)) {
            this.barWidth.addElement(string);
        }
    }

    @Override
    public Vector getHypervlink() {
        return (Vector)this.barWidth.clone();
    }

    @Override
    public void hyperlink(URL uRL) {
        HistoryInfo historyInfo;
        boolean bl = false;
        if (!this.clearSelected.empty()) {
            historyInfo = (HistoryInfo)this.clearSelected.peek();
            historyInfo.setLocation(this.getValue(0), this.getValue(1));
        }
        if (HTMLBrowser.sameFile(this.base, uRL)) {
            String string = uRL.getRef();
            if (string != null) {
                bl = this.hyperlink(uRL, string);
            }
        } else {
            try {
                this.load(uRL, null, true, 0, 0);
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        if (bl) {
            this.clearSelection.removeAllElements();
            historyInfo = new HistoryInfo(0, 0, uRL, this.in);
            int n = this.clearSelected.indexOf(historyInfo);
            if (n != -1) {
                for (int i = this.clearSelected.size() - 1; i >= n; --i) {
                    this.clearSelected.removeElementAt(i);
                }
            }
            this.clearSelected.push(historyInfo);
        }
        this.updateTrigger();
    }

    public void hyperlink(URL uRL, InputStream inputStream) {
        HistoryInfo historyInfo;
        boolean bl = false;
        if (!this.clearSelected.empty()) {
            historyInfo = (HistoryInfo)this.clearSelected.peek();
            historyInfo.setLocation(this.getValue(0), this.getValue(1));
        }
        if (HTMLBrowser.sameFile(this.base, uRL)) {
            String string = uRL.getRef();
            if (string != null) {
                bl = this.hyperlink(uRL, string);
            }
        } else {
            try {
                this.load(uRL, inputStream, true, 0, 0);
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        if (bl) {
            this.clearSelection.removeAllElements();
            historyInfo = new HistoryInfo(0, 0, uRL, inputStream);
            int n = this.clearSelected.indexOf(historyInfo);
            if (n != -1) {
                for (int i = this.clearSelected.size() - 1; i >= n; --i) {
                    this.clearSelected.removeElementAt(i);
                }
            }
            this.clearSelected.push(historyInfo);
        }
        this.updateTrigger();
    }

    @Override
    public URL getBase() {
        return this.tagbase == null ? this.base : this.tagbase;
    }

    @Override
    public Color getLink(String string) {
        return string != null && this.barWidth.contains(string) ? this.vlink : this.link;
    }

    @Override
    public Color getALink() {
        return this.alink;
    }

    protected void load(URL uRL, InputStream inputStream, boolean bl, int n, int n2) throws IOException {
        try {
            this.base = uRL;
            this.tagbase = null;
            this.in = inputStream;
            this.ref = bl;
            this.sclx = n;
            this.scly = n2;
            this.dispose = this.parser.parse(uRL, inputStream == null ? uRL.openStream() : inputStream);
            this.compose();
        }
        catch (IOException iOException) {
            this.warnning(iOException);
            throw iOException;
        }
    }

    protected void updateTrigger() {
        if (this.append != null) {
            this.append.setEnabled("backward", this.clearSelected.size() > 1);
            this.append.setEnabled("forward", !this.clearSelection.empty());
            this.append.setEnabled("reload", !this.clearSelected.empty());
            this.append.setEnabled("home", this.contains != null);
            this.append.setEnabled("search", !this.clearSelected.empty() || !this.clearSelection.empty());
        }
    }

    public boolean hyperlink(URL uRL, String string) {
        if (string != null && this.compose != null) {
            Point point = this.compose.searchAnchor(string);
            if (point != null) {
                this.setValue(0, point.x);
                this.setValue(1, point.y);
                this.base = uRL;
                return true;
            }
        } else {
            this.setValue(0, this.sclx);
            this.setValue(1, this.scly);
        }
        return false;
    }

    public void backward() {
        if (!this.clearSelected.isEmpty()) {
            HistoryInfo historyInfo = (HistoryInfo)this.clearSelected.pop();
            historyInfo.setLocation(this.getValue(0), this.getValue(1));
            this.clearSelection.push(historyInfo);
            historyInfo = (HistoryInfo)this.clearSelected.peek();
            this.reload(historyInfo);
        }
    }

    public void forward() {
        if (!this.clearSelection.empty()) {
            HistoryInfo historyInfo = (HistoryInfo)this.clearSelected.peek();
            historyInfo.setLocation(this.getValue(0), this.getValue(1));
            historyInfo = (HistoryInfo)this.clearSelection.pop();
            this.clearSelected.push(historyInfo);
            this.reload(historyInfo);
        }
    }

    public void reload() {
        if (this.base != null) {
            try {
                this.load(this.base, this.in, false, this.sclx, this.scly);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void home() {
        if (this.contains != null) {
            try {
                this.load(this.contains, null, true, 0, 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void reload(HistoryInfo historyInfo) {
        if (HTMLBrowser.sameFile(this.base, historyInfo.url)) {
            String string = historyInfo.url.getRef();
            if (string != null) {
                this.hyperlink(historyInfo.url, string);
            } else {
                this.setValue(0, historyInfo.x);
                this.setValue(1, historyInfo.y);
            }
        } else {
            try {
                if (this.base.getRef() == null) {
                    this.load(historyInfo.url, historyInfo.in, false, historyInfo.x, historyInfo.y);
                } else {
                    this.load(historyInfo.url, historyInfo.in, false, 0, 0);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.updateTrigger();
    }

    protected static final boolean sameFile(URL uRL, URL uRL2) {
        if (uRL != null && uRL2 != null && uRL.getPort() == uRL2.getPort()) {
            String string = uRL.getProtocol();
            String string2 = uRL2.getProtocol();
            if (string == null && string2 == null || string != null && string2 != null && string.equals(string2)) {
                string = uRL.getHost();
                string2 = uRL2.getHost();
                if (string == null && string2 == null || string != null && string2 != null && string.equals(string2)) {
                    string = uRL.getFile();
                    string = string.replace('/', '\\');
                    string2 = uRL2.getFile();
                    string2 = string2.replace('/', '\\');
                    if (string == null && string2 == null || string != null && string2 != null && string.equals(string2)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected static final boolean sameURL(URL uRL, URL uRL2) {
        if (HTMLBrowser.sameFile(uRL, uRL2)) {
            String string = uRL.getRef();
            String string2 = uRL2.getRef();
            if (string == null && string2 == null || string != null && string2 != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean findNext(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.find(string, bl, bl2, bl3);
    }

    @Override
    public void endFind() {
        this.append.setEnabled("search", !this.clearSelected.empty() || !this.clearSelection.empty());
    }

    protected void clearTextObjects() {
        this.textObjs.removeAllElements();
        this.clipRect = null;
        this.clone = null;
        this.Blue = 0;
        this.Red = 0;
        this.SEDU = 0;
        this.addElement = 0;
    }

    protected void clearSelected() {
        if (this.clipRect != null && this.clone != null) {
            this.clipRect.text.clearSelection();
            this.clone.text.clearSelection();
            for (int i = this.textObjs.indexOf(this.clipRect) + 1; i < this.textObjs.indexOf(this.clone); ++i) {
                ((TextInfo)this.textObjs.elementAt((int)i)).text.clearSelection();
            }
            this.Blue = 0;
            this.Red = 0;
            this.SEDU = 0;
            this.addElement = 0;
        }
    }

    protected boolean find(String string, boolean bl, boolean bl2, boolean bl3) {
        TextInfo textInfo = null;
        int n = -1;
        if (!this.textObjs.isEmpty()) {
            if (!bl2) {
                string = string.toLowerCase();
            }
            if (bl3) {
                int n2;
                TextInfo textInfo2;
                TextInfo textInfo3 = (TextInfo)this.textObjs.elementAt(0);
                if (this.clipRect == null || this.clipRect == textInfo3) {
                    textInfo2 = (TextInfo)this.textObjs.elementAt(this.textObjs.size() - 1);
                    n2 = -1;
                } else {
                    n2 = this.Blue - 1;
                    if (n2 <= 0) {
                        n2 = -1;
                        textInfo2 = (TextInfo)this.textObjs.elementAt(this.textObjs.indexOf(this.clipRect) - 1);
                    } else {
                        textInfo2 = this.clipRect;
                    }
                }
                for (int i = this.textObjs.indexOf(textInfo2); i >= this.textObjs.indexOf(textInfo3) && (n = textInfo.search(string, bl, bl2, bl3, textInfo2 == (textInfo = (TextInfo)this.textObjs.elementAt(i)) ? n2 : -1)) == -1; --i) {
                }
            } else {
                int n3;
                TextInfo textInfo4;
                TextInfo textInfo5 = (TextInfo)this.textObjs.elementAt(this.textObjs.size() - 1);
                if (this.clone == null || this.clone == textInfo5) {
                    textInfo4 = (TextInfo)this.textObjs.elementAt(0);
                    n3 = -1;
                } else {
                    n3 = this.SEDU + this.addElement + 1;
                    if (n3 >= this.clone.text.text.length()) {
                        n3 = -1;
                        textInfo4 = (TextInfo)this.textObjs.elementAt(this.textObjs.indexOf(this.clone) + 1);
                    } else {
                        textInfo4 = this.clone;
                    }
                }
                for (int i = this.textObjs.indexOf(textInfo4); i <= this.textObjs.indexOf(textInfo5) && (n = textInfo.search(string, bl, bl2, bl3, textInfo4 == (textInfo = (TextInfo)this.textObjs.elementAt(i)) ? n3 : -1)) == -1; ++i) {
                }
            }
            if (n != -1) {
                this.clearSelected();
                this.clipRect = textInfo;
                this.clone = textInfo;
                this.Blue = n;
                this.Red = string.length();
                this.SEDU = this.Blue;
                this.addElement = this.Red;
                Point point = textInfo.selected(n, string.length());
                this.updataSelect(point, textInfo.text.selw, textInfo.text.getSize().height);
            }
        }
        return n != -1;
    }

    void updataSelect(Point point, int n, int n2) {
        Point point2 = this.compose.getLocation();
        Dimension dimension = this.getClientSize();
        point.translate(point2.x, point2.y);
        if (point.x + n > dimension.width) {
            point.x = dimension.width - n;
        }
        if (point.y + n2 > dimension.height) {
            point.y = dimension.height - n2;
        }
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        point.translate(-point2.x, -point2.y);
        this.setValue(0, point.x);
        this.setValue(1, point.y);
        this.repaint();
    }

    @Override
    public void select(int n, int n2, int n3, int n4) {
        if (!this.textObjs.isEmpty()) {
            TextInfo textInfo;
            TextInfo textInfo2;
            int n5;
            TextInfo textInfo3;
            Component component;
            Point point = this.compose.getLocation();
            Dimension dimension = this.getClientSize();
            int n6 = point.x + n3;
            if (n6 < 0) {
                this.setValue(0, n3);
            } else if (n6 > dimension.width - 20) {
                this.setValue(0, n3 - (dimension.width - 20));
            }
            n6 = point.y + n4;
            if (n6 < 0) {
                this.setValue(1, n4);
            } else if (n6 > dimension.height - 20) {
                this.setValue(1, n4 - (dimension.height - 20));
            }
            Rectangle rectangle = this.compose.getBounds();
            rectangle.width += rectangle.x - 1;
            rectangle.height += rectangle.y - 1;
            if (n < rectangle.x) {
                n = rectangle.x;
            } else if (n > rectangle.width) {
                n = rectangle.width;
            }
            if (n3 < rectangle.x) {
                n3 = rectangle.x;
            } else if (n3 > rectangle.width) {
                n3 = rectangle.width;
            }
            if (n2 < rectangle.y) {
                n2 = rectangle.y;
            } else if (n2 > rectangle.height) {
                n2 = rectangle.height;
            }
            if (n4 < rectangle.y) {
                n4 = rectangle.y;
            } else if (n4 > rectangle.height) {
                n4 = rectangle.height;
            }
            if (n > n3) {
                n6 = n;
                n = n3;
                n3 = n6;
            }
            if (n2 > n4) {
                n6 = n2;
                n2 = n4;
                n4 = n6;
            }
            if ((component = this.getComponentAt(n, n2, this.compose)) instanceof GUIText) {
                textInfo3 = (TextInfo)this.textObjs.elementAt(this.textObjs.indexOf(new TextInfo(0, 0, (GUIText)component)));
            } else {
                textInfo3 = (TextInfo)this.textObjs.elementAt(0);
                for (n5 = 0; n5 < this.textObjs.size(); ++n5) {
                    textInfo2 = (TextInfo)this.textObjs.elementAt(n5);
                    if (textInfo2.y <= n2) continue;
                    textInfo3 = textInfo2;
                    break;
                }
            }
            component = this.getComponentAt(n3, n4, this.compose);
            if (component instanceof GUIText) {
                textInfo = (TextInfo)this.textObjs.elementAt(this.textObjs.indexOf(new TextInfo(0, 0, (GUIText)component)));
            } else {
                textInfo = textInfo3;
                for (n5 = this.textObjs.size() - 1; n5 >= 0; --n5) {
                    textInfo2 = (TextInfo)this.textObjs.elementAt(n5);
                    dimension = textInfo2.text.getSize();
                    if (textInfo2.y >= n4) continue;
                    textInfo = textInfo2;
                    break;
                }
            }
            this.select(textInfo3, textInfo, n, n3);
            this.repaint();
        }
    }

    public Component getComponentAt(int n, int n2, Container container) {
        Component component = container.getComponentAt(n, n2);
        while (container != component && component instanceof Container) {
            container = (Container)component;
            Point point = container.getLocation();
            component = container.getComponentAt(n -= point.x, n2 -= point.y);
        }
        return component;
    }

    protected void select(TextInfo textInfo, TextInfo textInfo2, int n, int n2) {
        this.clearSelected();
        this.clipRect = textInfo;
        this.clone = textInfo2;
        this.Blue = textInfo.text.getPos(n - textInfo.x);
        this.SEDU = textInfo2.text.getPos(n2 - textInfo2.x);
        if (textInfo.equals(textInfo2)) {
            this.Red = this.SEDU - this.Blue;
            this.SEDU = this.Blue;
            this.addElement = this.Red;
        } else {
            this.Red = textInfo.text.text.length() - this.Blue;
            this.addElement = this.SEDU;
            this.SEDU = 0;
        }
        this.clipRect.selected(this.Blue, this.Red);
        this.clone.selected(this.SEDU, this.addElement);
        for (int i = this.textObjs.indexOf(this.clipRect) + 1; i < this.textObjs.indexOf(this.clone); ++i) {
            ((TextInfo)this.textObjs.elementAt((int)i)).text.selected();
        }
    }

    @Override
    public void showPrompt(String string) {
        if (this.append != null && !this.append.isBusy()) {
            string = string == null ? this.base.toExternalForm() : (string.length() == 0 ? JDesgResource.getLabel("ready") : string);
            this.append.setText("prompt", string);
        }
    }

    @Override
    public void showTip(int n, int n2, String string) {
        if (this.append != null && !this.append.isBusy() && !this.append.isVisibleTipWin()) {
            this.append.showTipWin(n, n2, string);
        }
    }

    @Override
    public void hideTip() {
        if (this.append != null) {
            this.append.hideTipWin();
        }
    }

    @Override
    public void setTitle(String string) {
        if (this.append != null) {
            this.append.setTitle(string);
        }
    }

    public GUIBody getPage() {
        return this.compose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        n = n < 0 ? 0 : n;
        n2 = n2 < 0 ? 0 : n2;
        n3 = ((n3 += n) > rectangle.width ? rectangle.width : n3) - n;
        n4 = (n4 > rectangle.height ? rectangle.height : (n4 += n2)) - n2;
        if (n3 > 0 && n4 > 0) {
            Graphics graphics;
            try {
                graphics = this.getGraphics();
            }
            catch (Exception exception) {
                graphics = null;
            }
            if (graphics != null) {
                try {
                    graphics.clipRect(n, n2, n3, n4);
                    this.paint(graphics);
                }
                finally {
                    graphics.dispose();
                }
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics instanceof PrintGraphics || JavaEnv.isPrinter(graphics)) {
            super.paint(graphics);
        } else {
            Rectangle rectangle = graphics.getClipRect();
            if (rectangle != null) {
                this.updateImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (this.img != null) {
                    graphics.drawImage(this.img, 0, 0, this);
                }
            } else {
                Dimension dimension = this.getSize();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                super.paint(graphics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateImage(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        if ((this.img == null || this.img.getWidth(this) != dimension.width || this.img.getHeight(this) != dimension.height) && dimension.width > 0 && dimension.height > 0) {
            this.img = this.createImage(dimension.width, dimension.height);
            n = 0;
            n2 = 0;
            n3 = dimension.width;
            n4 = dimension.height;
        }
        if (this.img != null) {
            Graphics graphics = this.img.getGraphics();
            try {
                graphics.clipRect(n, n2, n3, n4);
                graphics.setColor(this.getBackground());
                graphics.fillRect(n, n2, n3, n4);
                super.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        String string;
        if (componentEvent.getID() == 101) {
            this.compose();
        }
        if ((string = System.getProperty("java.vendor")) == null || !string.equals("Microsoft Corp.")) {
            super.processComponentEvent(componentEvent);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            int n = keyEvent.getModifiers();
            switch (keyEvent.getKeyCode()) {
                case 114: {
                    if (this.append == null || n != 0) break;
                    this.append.find();
                    break;
                }
                case 67: {
                    if (n != 2 || this.clipRect.equals(this.clone)) break;
                    clipBoard.setContents(new StringSelection(this.getSelectedText()), null);
                }
            }
        }
        super.processKeyEvent(keyEvent);
    }

    protected String getSelectedText() {
        return "";
    }

    public void setScrollListener(ScrollListener scrollListener) {
        this.sl = scrollListener;
    }

    @Override
    public void horizontalScroll(int n) {
        if (this.compose != null) {
            this.hideTip();
            Point point = this.compose.getLocation();
            point.x = -n;
            this.compose.setLocation(point);
            if (this.sl != null && this.sclx != n) {
                this.sl.scrolled();
            }
            this.sclx = n;
        }
    }

    @Override
    public void verticalScroll(int n) {
        if (this.compose != null) {
            this.hideTip();
            Point point = this.compose.getLocation();
            point.y = -n;
            this.compose.setLocation(point);
            if (this.sl != null && this.scly != n) {
                this.sl.scrolled();
            }
            this.scly = n;
        }
    }

    protected boolean updateScroll(int n) {
        Dimension dimension = this.getSize();
        return n > dimension.height && this.pgW == dimension.width;
    }

    protected void updateScroll() {
        if (this.compose != null) {
            Dimension dimension = this.compose.getSize();
            this.setMaximum(0, dimension.width);
            this.setMaximum(1, dimension.height);
            this.doLayout();
        }
    }

    protected void setBody(GUIBody gUIBody) {
        if (this.compose != null) {
            gUIBody.setLocation(this.compose.getLocation());
            this.remove(this.compose);
        }
        this.add(gUIBody);
        this.compose = gUIBody;
        this.repaint();
    }

    public void compose() {
        if (this.dispose != null) {
            this.pgW = this.getSize().width - Unit.barWidth();
            this.compositor.compose(this.dispose);
        }
    }

    protected void recompose() {
        if (this.dispose != null) {
            this.pgW = this.getSize().width - Unit.barWidth();
            this.compositor = new HTMLCompositor(this);
            this.compositor.compose(this.dispose);
        }
    }

    protected void startCompose() {
        if (this.append != null) {
            this.append.setBusy(true);
            this.append.startProgress("progress", 1000L);
            this.append.setText("prompt", JDesgResource.getLabel("Load") + this.base.toExternalForm());
        }
    }

    protected void endCompose() {
        this.updateScroll();
        if (this.ref) {
            this.hyperlink(this.base, this.base.getRef());
        } else {
            this.setValue(0, this.sclx);
            this.setValue(1, this.scly);
        }
        if (this.append != null) {
            this.append.stopProgress("progress");
            this.append.setBusy(false);
            ((Component)((Object)this.append)).setEnabled(false);
            ((Component)((Object)this.append)).setEnabled(true);
        }
    }

    private void Blue() {
        this.enableEvents(1L);
        this.setUnitIncrement(0, 16);
        this.setUnitIncrement(1, 16);
        this.updateTrigger();
    }
}

