/*
 * Decompiled with CFR 0.152.
 */
package html;

import guitools.toolkit.IntStack;
import html.ColumnInfo;
import html.FieldInfo;
import html.HTMLNode;
import java.util.Stack;

public class HTMLTable
extends HTMLNode {
    int cols;
    int maxw;
    int minw;
    int fixedw;
    int cellspacing;
    int cellpadding;
    int border;
    HTMLNode end;
    Stack rows = new Stack();
    Stack infos = new Stack();

    public HTMLTable(HTMLNode hTMLNode) {
        super(343, hTMLNode);
    }

    public void newTr() {
        int n;
        int n2;
        FieldInfo fieldInfo;
        Stack stack;
        if (!this.rows.isEmpty() && !(stack = (Stack)this.rows.peek()).isEmpty()) {
            fieldInfo = (FieldInfo)stack.peek();
            if (fieldInfo.cell != null) {
                fieldInfo.updateSpans();
                for (n2 = 1; n2 < fieldInfo.colspan; ++n2) {
                    stack.push(new FieldInfo());
                }
            }
        }
        if (this.rows.size() > 1) {
            stack = (Stack)this.rows.pop();
            Stack stack2 = (Stack)this.rows.peek();
            for (n2 = stack.size(); n2 < stack2.size(); ++n2) {
                fieldInfo = (FieldInfo)stack2.elementAt(n2);
                if (fieldInfo.rowspan > 1) {
                    stack.push(fieldInfo);
                    --fieldInfo.rowspan;
                    for (int i = 1; i < fieldInfo.colspan; ++i) {
                        stack.push(new FieldInfo());
                        ++n2;
                    }
                    continue;
                }
                stack.push(new FieldInfo());
            }
            this.rows.push(stack);
        }
        if (!this.rows.isEmpty() && this.cols < (n = ((Stack)this.rows.peek()).size())) {
            this.cols = n;
        }
        this.rows.push(new Stack());
    }

    public void addFieldInfo(FieldInfo fieldInfo) {
        int n;
        FieldInfo fieldInfo2;
        fieldInfo.cellpadding = this.cellpadding;
        fieldInfo.minw += this.cellpadding * 2;
        fieldInfo.maxw += this.cellpadding * 2;
        Stack stack = (Stack)this.rows.pop();
        if (!stack.isEmpty()) {
            fieldInfo2 = (FieldInfo)stack.peek();
            if (fieldInfo2.cell != null) {
                fieldInfo2.updateSpans();
                for (n = 1; n < fieldInfo2.colspan; ++n) {
                    stack.push(new FieldInfo());
                }
            }
        }
        if (!this.rows.isEmpty()) {
            int n2 = stack.size();
            Stack stack2 = (Stack)this.rows.peek();
            while (stack2.size() > n2) {
                fieldInfo2 = (FieldInfo)stack2.elementAt(n2);
                if (fieldInfo2.rowspan <= 1) break;
                ++n2;
                stack.push(fieldInfo2);
                --fieldInfo2.rowspan;
                for (n = 1; n < fieldInfo2.colspan; ++n) {
                    stack.push(new FieldInfo());
                    ++n2;
                }
            }
        }
        this.rows.push(stack);
        stack.push(fieldInfo);
    }

    public void updateCellWidth(int n, int n2) {
        Stack stack;
        if (!this.rows.isEmpty() && !(stack = (Stack)this.rows.peek()).isEmpty()) {
            ((FieldInfo)stack.elementAt(stack.size() - 1)).update(n, n2);
        }
    }

    void updateProperties() {
        String string = this.getProperty("cellspacing");
        this.cellspacing = string == null ? 2 : Integer.parseInt(string);
        string = this.getProperty("cellpadding");
        this.cellpadding = string == null ? 0 : Integer.parseInt(string);
        string = this.getProperty("border");
        this.border = string == null ? 0 : (string.equals("border") ? 1 : Integer.parseInt(string));
    }

    void setEnd(HTMLNode hTMLNode) {
        ColumnInfo columnInfo;
        int n;
        this.end = hTMLNode;
        if (!this.rows.isEmpty()) {
            int n2;
            int n3;
            FieldInfo fieldInfo;
            Stack stack = (Stack)this.rows.peek();
            if (!stack.isEmpty()) {
                fieldInfo = (FieldInfo)stack.peek();
                if (fieldInfo.cell != null) {
                    fieldInfo.updateSpans();
                    for (n = 1; n < fieldInfo.colspan; ++n) {
                        stack.push(new FieldInfo());
                    }
                }
            }
            if (this.cols < (n3 = stack.size())) {
                this.cols = n3;
            }
            for (n = 0; n < this.cols; ++n) {
                this.infos.push(new ColumnInfo());
            }
            n = this.rows.size();
            while (--n >= 0) {
                stack = (Stack)this.rows.elementAt(n);
                n2 = stack.size();
                while (--n2 >= 0) {
                    fieldInfo = (FieldInfo)stack.elementAt(n2);
                    columnInfo = (ColumnInfo)this.infos.elementAt(n2);
                    if (fieldInfo.colspan == 1) {
                        columnInfo.update(fieldInfo.minw, fieldInfo.maxw, fieldInfo.getWidth(), fieldInfo.getPercent());
                        continue;
                    }
                    if (fieldInfo.colspan <= 1) continue;
                    columnInfo.addSpan(new ColumnInfo(fieldInfo.minw, fieldInfo.maxw, fieldInfo.getWidth(), fieldInfo.getPercent(), fieldInfo.colspan));
                }
            }
            n = this.cols;
            while (--n >= 0) {
                columnInfo = (ColumnInfo)this.infos.elementAt(n);
                if (columnInfo.colspans == null) continue;
                for (n2 = 0; n2 < columnInfo.colspans.size(); ++n2) {
                    int n4;
                    ColumnInfo columnInfo2;
                    int n5;
                    int n6 = columnInfo.minw;
                    int n7 = columnInfo.maxw;
                    ColumnInfo columnInfo3 = (ColumnInfo)columnInfo.colspans.elementAt(n2);
                    for (n5 = 1; n5 < columnInfo3.colspan && n5 < this.cols; ++n5) {
                        columnInfo2 = (ColumnInfo)this.infos.elementAt(n + n5);
                        n6 += this.cellspacing + 1 + columnInfo2.minw;
                        n7 += this.cellspacing + 1 + columnInfo2.maxw;
                    }
                    if (columnInfo3.minw > n6) {
                        n4 = (columnInfo3.minw - n6) / columnInfo3.colspan;
                        if (columnInfo.minw == columnInfo.maxw) {
                            columnInfo.maxw += n4;
                            n7 += n4;
                        }
                        columnInfo.minw += n4;
                        for (n5 = 1; n5 < columnInfo3.colspan && n5 < this.cols; ++n5) {
                            columnInfo2 = (ColumnInfo)this.infos.elementAt(n + n5);
                            if (columnInfo2.minw == columnInfo2.maxw) {
                                columnInfo2.maxw += n4;
                                n7 += n4;
                            }
                            columnInfo2.minw += n4;
                        }
                    } else if (columnInfo3.minw < n6) {
                        if (columnInfo3.minw == columnInfo3.maxw) {
                            columnInfo3.maxw = n6;
                        }
                        columnInfo3.minw = n6;
                    }
                    if (columnInfo3.maxw > n7) {
                        n4 = (columnInfo3.maxw - n7) / columnInfo3.colspan;
                        for (n5 = 1; n5 < columnInfo3.colspan; ++n5) {
                            columnInfo2 = (ColumnInfo)this.infos.elementAt(n + n5);
                            columnInfo2.maxw += n4;
                        }
                        continue;
                    }
                    if (columnInfo3.maxw >= n7) continue;
                    columnInfo3.maxw = n7;
                }
            }
        }
        this.maxw = this.minw = this.border * 2 + (this.cellspacing + 2) * (this.cols + 1) - 2;
        this.fixedw = this.minw;
        for (n = 0; n < this.cols; ++n) {
            columnInfo = (ColumnInfo)this.infos.elementAt(n);
            this.minw += columnInfo.minw;
            this.maxw += columnInfo.maxw;
            this.fixedw += columnInfo.minw == columnInfo.maxw ? columnInfo.minw : 0;
        }
    }

    public IntStack width(int n) {
        int n2;
        int n3;
        IntStack intStack = new IntStack();
        String string = this.getProperty("width");
        if (string != null) {
            int n4 = n3 = string.charAt(string.length() - 1) == '%' ? (int)((double)(n * Integer.parseInt(string.substring(0, string.length() - 1))) / 100.0) : Integer.parseInt(string);
            if (n3 > 0) {
                n = n3;
            }
        }
        n3 = n2 = this.border * 2 + (this.cellspacing + 2) * (this.cols + 1) - 2;
        for (int i = 0; i < this.cols; ++i) {
            int n5 = ((ColumnInfo)this.infos.elementAt(i)).getWidth(n);
            n3 += n5;
            intStack.push(n5);
        }
        intStack.push(n3);
        return intStack;
    }
}

