/*
 * Decompiled with CFR 0.152.
 */
package html;

import com.jinfonet.util.JWLog;
import guitools.UIResource;
import guitools.toolkit.GifButton;
import guitools.toolkit.MsgCell;
import guitools.toolkit.Statusbar;
import guitools.toolkit.StdFrame;
import guitools.toolkit.Toolbar;
import html.HTMLBrowser;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import jet.JDesgResource;

public class HelpFrame
extends StdFrame {
    HTMLBrowser browser;
    private Vector SEDU = new Vector();
    private static final String addBar = "Windows";
    private static final String addSeparater = "rundll32";
    private static final String append = "url.dll,FileProtocolHandler";
    private static final String backward = "netscape";
    private static final String displayURL = "firefox";
    private static final String error = "-remote openURL";
    private static final String exec = "Mac";

    public HelpFrame() {
        this.addBar();
    }

    public HelpFrame(String string) {
        super(string);
        this.addBar();
    }

    public void setHome(URL uRL) {
        this.browser.setHome(uRL);
    }

    public URL getHome() {
        return this.browser.getHome();
    }

    private void SEDU(URL uRL) throws IOException {
        this.setVisible(true);
        this.browser.setLocation(uRL);
        this.browser.requestFocus();
    }

    public void setLocation(URL uRL) throws IOException {
        this.displayURL(uRL);
    }

    public void setLocation(URL uRL, InputStream inputStream) throws IOException {
        this.setVisible(true);
        this.browser.setLocation(uRL, inputStream);
        this.browser.requestFocus();
    }

    public void backward(ActionEvent actionEvent) {
        this.browser.backward();
    }

    public void forward(ActionEvent actionEvent) {
        this.browser.forward();
    }

    public void reload(ActionEvent actionEvent) {
        this.browser.reload();
    }

    public void home(ActionEvent actionEvent) {
        this.browser.home();
    }

    public void search(ActionEvent actionEvent) {
        this.setEnabled("search", false);
        this.setEnabled("search", true);
    }

    @Override
    public void find() {
        this.setEnabled("search", false);
        this.setEnabled("search", true);
    }

    @Override
    public void setTitle(String string) {
        String string2 = JDesgResource.getLabel("helptitle");
        string = string + (string.length() == 0 ? string2 : " - " + string2);
        super.setTitle(string);
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        if (n == 205) {
            this.browser.requestFocus();
        } else if (n == 201) {
            this.setVisible(false);
        }
        super.processWindowEvent(windowEvent);
    }

    private void addBar() {
        this.enableEvents(64L);
        this.pack();
        this.setBounds(30, 30, 600, 500);
        this.initStatusbar();
        this.initToolbar();
        this.browser = new HTMLBrowser();
        this.browser.setStdWindow(this);
        this.add(this.browser);
        this.setEnabledAll(false);
    }

    protected void initStatusbar() {
        Statusbar statusbar = new Statusbar(1);
        statusbar.setFont(UIResource.getFont("Tip Font"));
        statusbar.setName("Statusbar");
        statusbar.setStretch(1);
        MsgCell msgCell = new MsgCell(2);
        msgCell.setName("Progress");
        this.putPrompt("progress", msgCell);
        msgCell.setSize(140, 0);
        statusbar.add(msgCell);
        msgCell = new MsgCell(JDesgResource.getLabel("ready"), 2, 140);
        msgCell.setName("Prompt");
        this.putPrompt("prompt", msgCell);
        statusbar.add(msgCell);
        this.addBar(statusbar);
    }

    protected void initToolbar() {
        Object[] objectArray = new Object[1];
        Toolbar toolbar = new Toolbar("Standrad", 1);
        toolbar.setDefWidth(44);
        toolbar.setDefHeight(44);
        GifButton gifButton = new GifButton(JDesgResource.getIcon("htmlbackward").getImage(), (Object)this, objectArray, "Backward", "Return to previous document in history list");
        gifButton.setMethod(this.getMethod("backward", "java.awt.event.ActionEvent"));
        this.putTrigger("backward", gifButton);
        toolbar.add(gifButton);
        gifButton = new GifButton(JDesgResource.getIcon("htmlforward").getImage(), (Object)this, objectArray, "Forward", "Move forward to next document in history list");
        gifButton.setMethod(this.getMethod("forward", "java.awt.event.ActionEvent"));
        this.putTrigger("forward", gifButton);
        toolbar.add(gifButton);
        toolbar.addSeparater();
        gifButton = new GifButton(JDesgResource.getIcon("htmlreload").getImage(), (Object)this, objectArray, "Reload", "Document Done");
        gifButton.setMethod(this.getMethod("reload", "java.awt.event.ActionEvent"));
        this.putTrigger("reload", gifButton);
        toolbar.add(gifButton);
        gifButton = new GifButton(JDesgResource.getIcon("htmlhome").getImage(), (Object)this, objectArray, "Home", "Go to the Home page");
        gifButton.setMethod(this.getMethod("home", "java.awt.event.ActionEvent"));
        this.putTrigger("home", gifButton);
        toolbar.add(gifButton);
        gifButton = new GifButton(JDesgResource.getIcon("htmlsearch").getImage(), (Object)this, objectArray, "Search", "Search the Internet for information");
        gifButton.setMethod(this.getMethod("search", "java.awt.event.ActionEvent"));
        this.putTrigger("search", gifButton);
        toolbar.add(gifButton);
        this.addBar(toolbar);
    }

    public void displayURL(URL uRL) {
        block28: {
            boolean bl = this.isWindowsPlatform();
            boolean bl2 = this.isMacOSXPlatform();
            String string = null;
            Process process = null;
            String string2 = uRL.getPath();
            if (bl) {
                string = "rundll32 url.dll,FileProtocolHandler " + string2;
                try {
                    process = Runtime.getRuntime().exec(string);
                }
                catch (IOException iOException) {
                    try {
                        this.SEDU(uRL);
                        break block28;
                    }
                    catch (IOException iOException2) {
                        if (JWLog.isError(2)) {
                            JWLog.error(2, iOException2);
                        }
                        break block28;
                    }
                }
            }
            if (bl2) {
                try {
                    process = Runtime.getRuntime().exec("open " + string2);
                }
                catch (IOException iOException) {
                    try {
                        this.SEDU(uRL);
                        break block28;
                    }
                    catch (IOException iOException3) {
                        if (JWLog.isError(2)) {
                            JWLog.error(2, iOException3);
                        }
                        break block28;
                    }
                }
            }
            String string3 = System.getProperty("BrowserCmd");
            if (string3 != null) {
                try {
                    Runtime.getRuntime().exec(new String[]{string3, string2});
                }
                catch (IOException iOException) {
                    if (JWLog.isError(2)) {
                        JWLog.error(2, iOException);
                    }
                    break block28;
                }
            }
            string = "netscape -remote openURL(" + string2 + ")";
            try {
                process = Runtime.getRuntime().exec(string);
                int n = process.waitFor();
                if (n != 0) {
                    string = "netscape " + string2;
                    process = Runtime.getRuntime().exec(string);
                }
            }
            catch (IOException iOException) {
                string = "firefox -remote openURL(" + string2 + ")";
                try {
                    process = Runtime.getRuntime().exec(string);
                    int n = process.waitFor();
                    if (n != 0) {
                        string = "firefox " + string2;
                        process = Runtime.getRuntime().exec(string);
                    }
                }
                catch (IOException iOException4) {
                    try {
                        this.SEDU(uRL);
                    }
                    catch (IOException iOException5) {
                        if (JWLog.isError(2)) {
                            JWLog.error(2, iOException5);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (JWLog.isError(2)) {
                        JWLog.error(2, interruptedException);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                if (!JWLog.isError(2)) break block28;
                JWLog.error(2, interruptedException);
            }
        }
    }

    public boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith(addBar);
    }

    public boolean isMacOSXPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith(exec);
    }
}

