/*
 * Decompiled with CFR 0.152.
 */
package html;

import html.BlockInfo;
import html.GUIBody;
import html.GUIContent;
import html.GUIImage;
import html.GUIListLabel;
import html.GUINumLbl;
import html.GUIText;
import html.TextInfo;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Stack;
import java.util.Vector;

public class PInfo
extends BlockInfo {
    int curH;
    int curW;
    int curRow;
    int baseline;
    int ascent;
    int descent;
    int basey;
    int indent;
    Vector textObjs;

    public PInfo(Vector vector) {
        this.textObjs = vector;
    }

    @Override
    public boolean breakBlock() {
        this.breakContent();
        if (this.parent != null) {
            return this.parent.breakBlock();
        }
        return false;
    }

    public void breakContent() {
        if (this.curRow < this.rows.size()) {
            GUIContent gUIContent;
            Stack stack = (Stack)this.rows.peek();
            int n = this.indent;
            if (this.curW < this.bw) {
                if (this.align.isAlign(-65534)) {
                    n += this.bw - this.curW + this.indent;
                } else if (this.align.isAlign(-65535)) {
                    n += (this.bw - this.curW) / 2 + this.indent;
                }
            }
            Dimension dimension = this.block.getSize();
            for (int i = 0; i < stack.size(); ++i) {
                int n2;
                gUIContent = (GUIContent)stack.elementAt(i);
                Dimension dimension2 = gUIContent.size();
                if (gUIContent instanceof GUIImage) {
                    int n3 = this.ascent + this.descent;
                    n2 = ((GUIImage)gUIContent).align == null || ((GUIImage)gUIContent).align.isAlign(65535) ? (dimension2.height <= n3 || this.curH - (this.baseline - this.ascent - this.basey) >= dimension2.height ? this.baseline - this.ascent : this.basey) : (((GUIImage)gUIContent).align.isAlign(131071) || ((GUIImage)gUIContent).align.isAlign(-65535) ? (dimension2.height == n3 ? this.baseline - this.ascent : (dimension2.height < n3 ? this.baseline - (n3 >> 1) - (dimension2.height >> 1) : this.baseline - (dimension2.height >> 1))) : this.baseline + this.descent - dimension2.height);
                } else {
                    n2 = this.baseline - gUIContent.getToolkit().getFontMetrics(gUIContent.getFont()).getAscent();
                }
                gUIContent.setLocation(n, n2);
                this.block.add(gUIContent);
                n += dimension2.width;
                if (!(gUIContent instanceof GUIText)) continue;
                Point point = gUIContent.getLocation();
                Container container = gUIContent.getParent();
                while (!(container instanceof GUIBody)) {
                    Point point2 = container.getLocation();
                    point.translate(point2.x, point2.y);
                    container = container.getParent();
                }
                this.textObjs.addElement(new TextInfo(point.x, point.y, (GUIText)gUIContent));
            }
            if (n > dimension.width) {
                dimension.width = n;
            }
            dimension.height += this.curH;
            this.block.setSize(dimension);
            this.curH = 0;
            this.curW = 0;
            ++this.curRow;
            stack = (Stack)this.rows.peek();
            gUIContent = (GUIContent)stack.elementAt(0);
            if (gUIContent instanceof GUINumLbl || gUIContent instanceof GUIListLabel) {
                this.bw -= 40;
                this.indent = 40;
            }
        }
    }

    public void addContent(GUIContent gUIContent) {
        Stack stack;
        if (this.curRow == this.rows.size()) {
            stack = new Stack();
            this.rows.push(stack);
            this.baseline = this.basey = this.block.getSize().height;
            this.ascent = 0;
            this.descent = 0;
        } else {
            stack = (Stack)this.rows.peek();
        }
        Dimension dimension = gUIContent.getPreferredSize();
        gUIContent.setSize(dimension);
        stack.push(gUIContent);
        if (gUIContent instanceof GUIImage) {
            if (dimension.height > this.ascent + this.descent) {
                if (((GUIImage)gUIContent).align == null || ((GUIImage)gUIContent).align.isAlign(65535)) {
                    int n = this.baseline + this.descent - this.basey;
                    if (n < dimension.height && this.curH < dimension.height) {
                        this.curH += dimension.height - (n - (this.ascent + this.descent));
                    }
                } else if (((GUIImage)gUIContent).align.isAlign(131071) || ((GUIImage)gUIContent).align.isAlign(-65535)) {
                    int n = dimension.height >> 1;
                    int n2 = this.baseline + this.descent - this.basey;
                    if (n > n2) {
                        this.baseline += n - n2;
                    }
                    if ((n = dimension.height - n) > (n2 = this.curH - (this.baseline + this.descent - this.basey)) && this.curH < dimension.height) {
                        this.curH += n - n2;
                    }
                } else {
                    int n = dimension.height - (this.baseline + this.ascent - this.basey);
                    if (n > 0) {
                        this.baseline += n;
                        if (this.curH < dimension.height) {
                            this.curH += n;
                        }
                    }
                }
            }
        } else {
            int n;
            int n3 = gUIContent.getToolkit().getFontMetrics(gUIContent.getFont()).getAscent();
            if (dimension.height > this.curH) {
                this.curH = dimension.height;
            }
            if ((n = n3 - this.ascent) > 0) {
                this.baseline += n;
                this.ascent = n3;
            }
            if ((n = dimension.height - n3 - this.descent) > 0) {
                this.descent += n;
            }
            if ((n = this.baseline + this.descent - this.basey - this.curH) > 0) {
                int n4 = this.ascent + this.descent;
                if (n4 <= this.curH) {
                    this.baseline = this.curH - this.descent + this.basey;
                } else {
                    this.baseline = this.ascent + this.basey;
                    this.curH = n4;
                }
            }
        }
        this.curW += dimension.width;
    }

    public int remains() {
        return this.bw - this.curW;
    }

    boolean isHead() {
        return this.rows.isEmpty() || this.curRow == this.rows.size() || ((Stack)this.rows.peek()).isEmpty();
    }
}

