/*
 * Decompiled with CFR 0.152.
 */
package html;

import html.BlockInfo;
import html.CellInfo;
import html.GUICell;
import html.GUITable;
import html.HTMLColor;
import html.HTMLNode;
import html.TableInfo;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Stack;

public class TabInfo
extends BlockInfo {
    int cellspacing;
    int curW;

    public TabInfo() {
        this.bh = -1;
    }

    public TabInfo(HTMLNode hTMLNode, int n, int n2, int n3) {
        super(new GUITable(n, n2, n3 + n * 2), null, hTMLNode);
        this.cellspacing = n3;
        this.bh = -1;
    }

    public void addTr() {
        if (this.rows.size() == 1) {
            Stack stack = (Stack)this.rows.peek();
            for (int i = stack.size(); i < ((TableInfo)this.parent).table.cols; ++i) {
                stack.push(new CellInfo());
            }
        } else if (this.rows.size() > 1) {
            Stack stack = (Stack)this.rows.pop();
            Stack stack2 = (Stack)this.rows.peek();
            for (int i = stack.size(); i < stack2.size(); ++i) {
                CellInfo cellInfo = (CellInfo)stack2.elementAt(i);
                if (cellInfo.rowspan > 1) {
                    stack.push(cellInfo);
                    --cellInfo.rowspan;
                    for (int j = 1; j < cellInfo.colspan; ++j) {
                        stack.push(new CellInfo());
                        ++i;
                    }
                    continue;
                }
                stack.push(new CellInfo());
            }
            this.rows.push(stack);
        }
        this.breakBlock();
        this.rows.push(new Stack());
        this.curW = ((GUITable)this.block).border;
    }

    public CellInfo getCellInfo(HTMLNode hTMLNode) {
        int n;
        CellInfo cellInfo;
        String string = hTMLNode.getProperty("rowspan");
        int n2 = string == null ? 1 : Integer.parseInt(string);
        string = hTMLNode.getProperty("colspan");
        int n3 = string == null ? 1 : Integer.parseInt(string);
        Stack stack = (Stack)this.rows.pop();
        int n4 = stack.size();
        if (!this.rows.isEmpty()) {
            Stack stack2 = (Stack)this.rows.peek();
            while (stack2.size() > n4) {
                cellInfo = (CellInfo)stack2.elementAt(n4);
                if (cellInfo.rowspan <= 1) break;
                ++n4;
                stack.push(cellInfo);
                --cellInfo.rowspan;
                for (n = 1; n < cellInfo.colspan; ++n) {
                    stack.push(new CellInfo());
                    ++n4;
                }
                this.curW += this.cellspacing + cellInfo.bw;
            }
        }
        int n5 = ((TableInfo)this.parent).winfo.elementAt(n4) + 2;
        for (n = 1; n < n3; ++n) {
            n5 += this.cellspacing + ((TableInfo)this.parent).winfo.elementAt(n + n4) + 2;
        }
        this.curW += this.cellspacing;
        string = hTMLNode.getProperty("align");
        if (string == null) {
            string = hTMLNode.token == 358 ? "center" : "left";
        }
        cellInfo = new CellInfo(string, hTMLNode, ((GUITable)this.block).border > 0, n5);
        cellInfo.parent = this;
        cellInfo.bw = n5;
        cellInfo.bh = -1;
        cellInfo.rowspan = n2;
        cellInfo.colspan = n3;
        cellInfo.cellpadding = ((TableInfo)this.parent).table.cellpadding;
        cellInfo.block.setLocation(this.curW, this.block.getSize().height - ((GUITable)this.block).border);
        this.block.add(cellInfo.block);
        stack.push(cellInfo);
        this.curW += n5;
        for (n = 1; n < n3; ++n) {
            stack.push(new CellInfo());
        }
        string = hTMLNode.getProperty("bgcolor");
        if (string == null) {
            string = this.node.getProperty("bgcolor");
        }
        if (string != null) {
            ((GUICell)cellInfo.block).bgcolor = HTMLColor.getColor(string);
        }
        this.rows.push(stack);
        return cellInfo;
    }

    @Override
    public BlockInfo addBlock(BlockInfo blockInfo) {
        return blockInfo;
    }

    @Override
    public boolean breakBlock() {
        Stack stack;
        if (!this.rows.isEmpty() && !(stack = (Stack)this.rows.peek()).isEmpty()) {
            Rectangle rectangle;
            CellInfo cellInfo;
            int n;
            Dimension dimension = this.block.getSize();
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < stack.size(); ++n) {
                cellInfo = (CellInfo)stack.elementAt(n);
                if (cellInfo.rowspan != 1) continue;
                rectangle = cellInfo.block.getBounds();
                if (n2 >= rectangle.height || rectangle.y < dimension.height - ((GUITable)this.block).border) continue;
                n2 = rectangle.height;
            }
            n2 += dimension.height;
            for (n = 0; n < stack.size(); ++n) {
                cellInfo = (CellInfo)stack.elementAt(n);
                rectangle = cellInfo.block.getBounds();
                if (rectangle.y + rectangle.height < n2) {
                    rectangle.height = n2 - rectangle.y;
                    cellInfo.block.setSize(rectangle.width, rectangle.height);
                }
                if (n3 < rectangle.x + rectangle.width) {
                    n3 = rectangle.x + rectangle.width;
                }
                cellInfo.updateContents();
            }
            if (n3 > dimension.width) {
                dimension.width = n3;
            }
            this.block.setSize(dimension.width, n2 + this.cellspacing + ((GUITable)this.block).border);
            return this.parent.breakBlock();
        }
        return false;
    }
}

