/*
 * Decompiled with CFR 0.152.
 */
package jet.acl;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.util.JRLog;
import java.security.Principal;
import java.security.acl.NotOwnerException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import jet.acl.ACLException;
import jet.acl.AclTextReader;
import jet.acl.JetAclEntry;
import jet.acl.JetGroup;
import jet.acl.JetPrincipal;
import jet.acl.JetRole;
import jet.acl.JetUser;
import jet.client.connector.ClientConnector;
import jet.controls.JetBoolean;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAclEntryImpl;
import jet.cs.jacl.JAclImpl;
import jet.cs.jacl.SecurityData;
import jet.export.xml.ObjectToXML;
import jet.export.xml.XMLToObject;
import jet.server.api.SecurityContext;
import jet.util.TreeIterater;

public class JetAcl
extends JetObject
implements JetRootable,
JetContainable,
SecurityData,
Cloneable {
    private JetBoolean SEDU;
    private JetBoolean add;
    private String addElement = "";
    public static final int APPEND_TYPE = 1;
    public static final int OVERWRITE_TYPE = 2;
    public static final int REPLACE_NO_PERMISSION = 1;
    public static final int MERGE_WITH_PERMISSION = 2;
    private Vector addEntry = new Vector(5);
    private Hashtable addGroup = new Hashtable(10);
    private Hashtable addParentRole = new Hashtable(10);
    private Hashtable addRole = new Hashtable(10);
    private Hashtable addUser = new Hashtable();
    private Hashtable afterInit = new Hashtable();
    public static final int ALL = 0;
    public static final int SERVER = 1;
    public static final int USERDEFINED = 2;
    private int append = 0;
    private boolean clear = false;
    private int clearMem = 65648;
    private static final HashMap clone = new HashMap(2);

    public JetAcl() {
        this.contains();
    }

    public JetAcl(String string) {
        this.contains();
        this.setName(string);
    }

    public void setName(String string) {
        this.addElement = string;
    }

    public String getName() {
        return this.addElement;
    }

    public boolean isValidRLS() {
        return !this.SEDU.get();
    }

    public boolean isValidCLS() {
        return this.add.get();
    }

    public void setRLSValid(boolean bl) {
        this.SEDU.set(!bl);
    }

    public void setCLSValid(boolean bl) {
        this.add.set(bl);
    }

    public String addUser(JetUser jetUser) {
        String string = jetUser.getName();
        if (this.addGroup.containsKey(string)) {
            return new String("The user " + string + " already exits!");
        }
        JetAclEntry jetAclEntry = new JetAclEntry(jetUser);
        this.add(jetAclEntry);
        this.addGroup.put(string, jetAclEntry);
        return null;
    }

    public String addRole(JetRole jetRole) {
        String string = jetRole.getName();
        if (this.addParentRole.containsKey(string)) {
            return new String("The role " + string + " already exits!");
        }
        JetAclEntry jetAclEntry = new JetAclEntry(jetRole);
        this.add(jetAclEntry);
        this.addParentRole.put(string, jetAclEntry);
        return null;
    }

    public String addGroup(JetGroup jetGroup) {
        String string = jetGroup.getName();
        if (this.addRole.containsKey(string)) {
            return new String("The group " + string + " already exits!");
        }
        JetAclEntry jetAclEntry = new JetAclEntry(jetGroup);
        this.add(jetAclEntry);
        this.addRole.put(string, jetAclEntry);
        return null;
    }

    public boolean deleteUser(JetUser jetUser) {
        return this.deleteUser(jetUser.getName());
    }

    public boolean deleteUser(JetUser jetUser, boolean bl) {
        return this.deleteUser(jetUser.getName(), bl);
    }

    public boolean deleteUser(String string) {
        return this.deleteUser(string, false);
    }

    public boolean deleteUser(String string, boolean bl) {
        if (!this.addGroup.containsKey(string)) {
            return false;
        }
        JetAclEntry jetAclEntry = (JetAclEntry)this.addGroup.get(string);
        this.remove(jetAclEntry);
        this.addGroup.remove(string);
        if (bl) {
            Vector vector = ((JetUser)jetAclEntry.getPrincipal()).getParentRoleNames();
            int n = vector == null ? 0 : vector.size();
            for (int i = 0; i < n; ++i) {
                JetRole jetRole = (JetRole)this.getRole((String)vector.elementAt(i));
                jetRole.removeSubUser(string);
            }
            Vector vector2 = ((JetUser)jetAclEntry.getPrincipal()).getGroupNames();
            n = vector2 == null ? 0 : vector2.size();
            for (int i = 0; i < n; ++i) {
                JetGroup jetGroup = (JetGroup)this.getGroup((String)vector2.elementAt(i));
                jetGroup.removeUser(string);
            }
        }
        return true;
    }

    public boolean deleteRole(JetRole jetRole) {
        return this.deleteRole(jetRole.getName());
    }

    public boolean deleteRole(JetRole jetRole, boolean bl) {
        return this.deleteRole(jetRole.getName(), bl);
    }

    public boolean deleteRole(String string) {
        return this.deleteRole(string, false);
    }

    public boolean deleteRole(String string, boolean bl) {
        if (!this.addParentRole.containsKey(string)) {
            return false;
        }
        JetAclEntry jetAclEntry = (JetAclEntry)this.addParentRole.get(string);
        this.remove(jetAclEntry);
        this.addParentRole.remove(string);
        if (bl) {
            Vector vector = ((JetRole)jetAclEntry.getPrincipal()).getSubUserNames();
            int n = vector == null ? 0 : vector.size();
            for (int i = 0; i < n; ++i) {
                JetUser jetUser = (JetUser)this.getUser((String)vector.elementAt(i));
                jetUser.removeParentRole(string);
            }
            Vector vector2 = ((JetRole)jetAclEntry.getPrincipal()).getGroupNames();
            n = vector2 == null ? 0 : vector2.size();
            for (int i = 0; i < n; ++i) {
                JetGroup jetGroup = (JetGroup)this.getGroup((String)vector2.elementAt(i));
                jetGroup.removeRole(string);
            }
        }
        return true;
    }

    public boolean deleteGroup(JetGroup jetGroup, boolean bl) {
        return this.deleteGroup(jetGroup.getName(), bl);
    }

    public boolean deleteGroup(String string) {
        return this.deleteGroup(string, false);
    }

    public boolean deleteGroup(String string, boolean bl) {
        if (!this.addRole.containsKey(string)) {
            return false;
        }
        JetAclEntry jetAclEntry = (JetAclEntry)this.addRole.get(string);
        this.remove(jetAclEntry);
        this.addRole.remove(string);
        if (bl) {
            Vector vector = ((JetGroup)jetAclEntry.getPrincipal()).getUserNames();
            int n = vector == null ? 0 : vector.size();
            for (int i = 0; i < n; ++i) {
                JetUser jetUser = (JetUser)this.getUser((String)vector.elementAt(i));
                jetUser.removeGroup(string);
            }
            Vector vector2 = ((JetGroup)jetAclEntry.getPrincipal()).getRoleNames();
            n = vector2 == null ? 0 : vector2.size();
            for (int i = 0; i < n; ++i) {
                JetRole jetRole = (JetRole)this.getRole((String)vector2.elementAt(i));
                jetRole.removeGroup(string);
            }
        }
        return true;
    }

    public Vector getEntries() {
        return this.getChildren();
    }

    public Vector getPincipals() {
        Vector<JetPrincipal> vector = new Vector<JetPrincipal>(10);
        int n = this.addEntry.size();
        for (int i = 0; i < n; ++i) {
            JetAclEntry jetAclEntry = (JetAclEntry)this.addEntry.elementAt(i);
            vector.add(jetAclEntry.getPrincipal());
        }
        return vector;
    }

    public Vector getUsers() {
        Vector<JetPrincipal> vector = new Vector<JetPrincipal>(10);
        int n = this.addEntry.size();
        for (int i = 0; i < n; ++i) {
            JetAclEntry jetAclEntry = (JetAclEntry)this.addEntry.elementAt(i);
            if (!(jetAclEntry.getPrincipal() instanceof JetUser)) continue;
            vector.add(jetAclEntry.getPrincipal());
        }
        return vector;
    }

    public Vector getRoles() {
        Vector<JetPrincipal> vector = new Vector<JetPrincipal>(10);
        int n = this.addEntry.size();
        for (int i = 0; i < n; ++i) {
            JetAclEntry jetAclEntry = (JetAclEntry)this.addEntry.elementAt(i);
            if (!(jetAclEntry.getPrincipal() instanceof JetRole)) continue;
            vector.add(jetAclEntry.getPrincipal());
        }
        return vector;
    }

    public Vector getGroups() {
        Vector<JetPrincipal> vector = new Vector<JetPrincipal>();
        int n = this.addEntry.size();
        for (int i = 0; i < n; ++i) {
            JetAclEntry jetAclEntry = (JetAclEntry)this.addEntry.elementAt(i);
            if (!(jetAclEntry.getPrincipal() instanceof JetGroup)) continue;
            vector.add(jetAclEntry.getPrincipal());
        }
        return vector;
    }

    private Vector SEDU(Hashtable hashtable) {
        Vector<JetPrincipal> vector = new Vector<JetPrincipal>();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            JetAclEntry jetAclEntry = (JetAclEntry)enumeration.nextElement();
            vector.add(jetAclEntry.getPrincipal());
        }
        return vector;
    }

    public Vector getServerUsers() {
        return this.getUsers(1);
    }

    public Vector getDefaultUsers() {
        return this.getUsers(2);
    }

    public Vector getServerRoles() {
        return this.getRoles(1);
    }

    public Vector getDefaultRoles() {
        return this.getRoles(2);
    }

    public Vector getServerGroups() {
        return this.getGroups(1);
    }

    public Vector getDefaultGroups() {
        return this.getGroups(2);
    }

    public Vector getUsers(int n) {
        Vector vector = this.getUsers();
        int n2 = vector.size();
        Vector<JetUser> vector2 = new Vector<JetUser>();
        for (int i = 0; i < n2; ++i) {
            JetUser jetUser = (JetUser)vector.elementAt(i);
            if (jetUser.getSourceType() != n) continue;
            vector2.add(jetUser);
        }
        return vector2;
    }

    public Vector getRoles(int n) {
        Vector vector = this.getRoles();
        int n2 = vector.size();
        Vector<JetRole> vector2 = new Vector<JetRole>();
        for (int i = 0; i < n2; ++i) {
            JetRole jetRole = (JetRole)vector.elementAt(i);
            if (jetRole.getSourceType() != n) continue;
            vector2.add(jetRole);
        }
        return vector2;
    }

    public Vector getGroups(int n) {
        Vector vector = this.getGroups();
        int n2 = vector.size();
        Vector<JetGroup> vector2 = new Vector<JetGroup>();
        for (int i = 0; i < n2; ++i) {
            JetGroup jetGroup = (JetGroup)vector.elementAt(i);
            if (jetGroup.getSourceType() != n) continue;
            vector2.add(jetGroup);
        }
        return vector2;
    }

    public JetAclEntry getAclEntry(JetPrincipal jetPrincipal) {
        if (jetPrincipal == null) {
            return null;
        }
        if (jetPrincipal instanceof JetUser) {
            return this.getAclEntry((JetUser)jetPrincipal);
        }
        if (jetPrincipal instanceof JetRole) {
            return this.getAclEntry((JetRole)jetPrincipal);
        }
        if (jetPrincipal instanceof JetGroup) {
            return this.getAclEntry((JetGroup)jetPrincipal);
        }
        return null;
    }

    public JetAclEntry getAclEntry(JetUser jetUser) {
        if (jetUser == null) {
            return null;
        }
        return (JetAclEntry)this.addGroup.get(jetUser.getName());
    }

    public JetAclEntry getAclEntry(JetRole jetRole) {
        if (jetRole == null) {
            return null;
        }
        return (JetAclEntry)this.addParentRole.get(jetRole.getName());
    }

    public JetAclEntry getAclEntry(JetGroup jetGroup) {
        if (jetGroup == null) {
            return null;
        }
        return (JetAclEntry)this.addRole.get(jetGroup.getName());
    }

    public void removeAllEntries() {
        this.addEntry.removeAllElements();
        this.addGroup.clear();
        this.addParentRole.clear();
        this.addRole.clear();
    }

    public Hashtable getUserEntries() {
        return this.addGroup;
    }

    public Hashtable getRoleEntries() {
        return this.addParentRole;
    }

    public Hashtable getGroupEntries() {
        return this.addRole;
    }

    @Override
    public JetObject add(JetObject jetObject) {
        if (jetObject instanceof JetAclEntry) {
            this.addEntry.add(jetObject);
            jetObject.setParent(this);
            return jetObject;
        }
        return null;
    }

    @Override
    public JetObject remove(JetObject jetObject) {
        boolean bl = this.addEntry.removeElement(jetObject);
        if (bl) {
            jetObject.setParent(null);
            return jetObject;
        }
        return null;
    }

    @Override
    public void broadcast(JetObject jetObject, int n) {
    }

    @Override
    public Vector getChildren() {
        return this.addEntry;
    }

    public boolean isAdminUser(String string) {
        JetUser jetUser = (JetUser)this.getUser(string);
        if (jetUser == null) {
            return false;
        }
        if (jetUser.isAdmin()) {
            return true;
        }
        Vector vector = jetUser.getParentRoleNames();
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isAdminRole((String)vector.elementAt(i))) continue;
            return true;
        }
        Vector vector2 = jetUser.getGroupNames();
        n = vector2 == null ? 0 : vector2.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isAdminGroup((String)vector2.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isAdminRole(String string) {
        JetRole jetRole = (JetRole)this.getRole(string);
        if (jetRole == null) {
            return false;
        }
        if (jetRole.isAdminRole()) {
            return true;
        }
        Vector vector = jetRole.getParentRoleNames();
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isAdminRole((String)vector.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isAdminGroup(String string) {
        JetGroup jetGroup = (JetGroup)this.getGroup(string);
        if (jetGroup == null) {
            return false;
        }
        if (jetGroup.isAdminGroup()) {
            return true;
        }
        Vector vector = jetGroup.getParentGroupNames();
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isAdminGroup((String)vector.elementAt(i))) continue;
            return true;
        }
        Vector vector2 = jetGroup.getRoleNames();
        n = vector2 == null ? 0 : vector2.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isAdminRole((String)vector2.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isAdminUser(String string, SecurityData securityData) {
        BaseUser baseUser = securityData.getUser(string);
        if (baseUser == null) {
            return false;
        }
        JetUser jetUser = (JetUser)this.getUser(string);
        if (jetUser == null) {
            return false;
        }
        if (jetUser.isAdmin()) {
            return true;
        }
        Vector vector = baseUser.getParentRoleNames();
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isAdminRole((String)vector.elementAt(i), securityData)) continue;
            return true;
        }
        Vector vector2 = baseUser.getGroupNames();
        n = vector2 == null ? 0 : vector2.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isAdminGroup((String)vector2.elementAt(i))) continue;
            return true;
        }
        Vector vector3 = jetUser.getParentRoleNames();
        n = vector3 == null ? 0 : vector3.size();
        for (int i = 0; i < n; ++i) {
            JetRole jetRole = (JetRole)this.getRole((String)vector3.elementAt(i));
            if (jetRole == null || jetRole.getSourceType() != 2 || !jetRole.isAdminRole()) continue;
            return true;
        }
        return false;
    }

    public boolean isAdminRole(String string, SecurityData securityData) {
        BaseRole baseRole = securityData.getRole(string);
        if (baseRole == null) {
            return false;
        }
        JetRole jetRole = (JetRole)this.getRole(string);
        if (jetRole == null) {
            return false;
        }
        if (jetRole.isAdminRole()) {
            return true;
        }
        Vector vector = baseRole.getParentRoleNames();
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isAdminRole((String)vector.elementAt(i), securityData)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdminGroup(String string, SecurityData securityData) {
        BaseGroup baseGroup = securityData.getGroup(string);
        if (baseGroup == null) {
            return false;
        }
        JetGroup jetGroup = (JetGroup)this.getGroup(string);
        if (jetGroup == null) {
            return false;
        }
        if (jetGroup.isAdminGroup()) {
            return true;
        }
        Vector vector = baseGroup.getParentGroupNames();
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isAdminGroup((String)vector.elementAt(i), securityData)) continue;
            return true;
        }
        Vector vector2 = baseGroup.getRoleNames();
        n = vector2 == null ? 0 : vector2.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isAdminRole((String)vector2.elementAt(i), securityData)) continue;
            return true;
        }
        Vector vector3 = jetGroup.getRoleNames();
        n = vector3 == null ? 0 : vector3.size();
        for (int i = 0; i < n; ++i) {
            JetRole jetRole = (JetRole)this.getRole((String)vector3.elementAt(i));
            if (jetRole == null || jetRole.getSourceType() != 2 || !jetRole.isAdminRole()) continue;
            return true;
        }
        return false;
    }

    public boolean isAdmin(SecurityContext securityContext) {
        Vector vector = securityContext.getRoles();
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            JetRole jetRole = (JetRole)this.getRole((String)vector.elementAt(i));
            if (jetRole == null || !jetRole.isAdminRole()) continue;
            return true;
        }
        return false;
    }

    public boolean isHaveUser(String string) {
        return this.addGroup.get(string) != null;
    }

    public boolean isHaveRole(String string) {
        return this.addParentRole.get(string) != null;
    }

    public boolean isHaveGroup(String string) {
        return this.addRole.get(string) != null;
    }

    @Override
    public BaseRole getRole(String string) {
        JetAclEntry jetAclEntry = (JetAclEntry)this.addParentRole.get(string);
        if (jetAclEntry == null) {
            return null;
        }
        return (JetRole)jetAclEntry.getPrincipal();
    }

    @Override
    public BaseUser getUser(String string) {
        JetAclEntry jetAclEntry = (JetAclEntry)this.addGroup.get(string);
        if (jetAclEntry == null) {
            return null;
        }
        return (JetUser)jetAclEntry.getPrincipal();
    }

    @Override
    public BaseGroup getGroup(String string) {
        JetAclEntry jetAclEntry = (JetAclEntry)this.addRole.get(string);
        if (jetAclEntry == null) {
            return null;
        }
        return (JetGroup)jetAclEntry.getPrincipal();
    }

    @Override
    public String getInstancePrefix() {
        return "ACL";
    }

    @Override
    public void afterInit() {
        super.afterInit();
        int n = this.addEntry.size();
        for (int i = 0; i < n; ++i) {
            JetAclEntry jetAclEntry = (JetAclEntry)this.addEntry.elementAt(i);
            JetPrincipal jetPrincipal = jetAclEntry.getPrincipal();
            if (jetPrincipal instanceof JetUser) {
                this.addGroup.put(((JetUser)jetPrincipal).getName(), jetAclEntry);
            }
            if (jetPrincipal instanceof JetRole) {
                this.addParentRole.put(((JetRole)jetPrincipal).getName(), jetAclEntry);
            }
            if (!(jetPrincipal instanceof JetGroup)) continue;
            this.addRole.put(((JetGroup)jetPrincipal).getName(), jetAclEntry);
        }
    }

    public JetAcl copy() {
        return (JetAcl)this.clone();
    }

    public Object clone() {
        JetAcl jetAcl = new JetAcl();
        jetAcl.setName(this.getName());
        jetAcl.setRLSValid(this.isValidRLS());
        jetAcl.setCLSValid(this.isValidCLS());
        int n = this.addEntry.size();
        for (int i = 0; i < n; ++i) {
            JetObject jetObject = (JetObject)this.addEntry.elementAt(i);
            if (!(jetObject instanceof JetAclEntry)) continue;
            jetAcl.add(((JetAclEntry)jetObject).copy());
        }
        jetAcl.afterInit();
        return jetAcl;
    }

    public String refreshFromServer(String string, String string2, String string3, String string4, String string5) throws ACLException {
        return this.refreshFromServer(string, string2, string3, string4, string5, 1, 1);
    }

    public String refreshFromServer(String string, String string2, String string3, String string4, String string5, int n) throws ACLException {
        return this.refreshFromServer(string, string2, string3, string4, string5, 1, n);
    }

    public String refreshFromServer(String string, String string2, String string3, String string4, String string5, int n, int n2) throws ACLException {
        String string6 = new String("http://" + string + ":" + string2);
        Vector[] vectorArray = null;
        try {
            ClientConnector clientConnector = new ClientConnector(string6, string3, string4, string5);
            vectorArray = clientConnector.getUsersAndRolesInfo();
        }
        catch (Exception exception) {
            throw new ACLException(exception.getMessage());
        }
        if (vectorArray != null) {
            this.refreshPrincipal(vectorArray, n, n2);
        }
        return null;
    }

    public boolean refreshPrincipal(Vector[] vectorArray, int n, int n2) {
        if (vectorArray.length != 3) {
            return false;
        }
        Vector vector = vectorArray[0];
        Vector vector2 = vectorArray[1];
        Vector vector3 = vectorArray[2];
        switch (n) {
            case 1: {
                return this.addElement(vector, vector2, vector3, n2);
            }
            case 2: {
                return this.add(vector, vector2, vector3);
            }
        }
        return false;
    }

    private boolean add(Vector vector, Vector vector2, Vector vector3) {
        int n;
        int n2;
        this.removeAllEntries();
        int n3 = vector == null ? 0 : vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            JetUser jetUser = this.addGroup((BaseUser)vector.elementAt(n2));
            this.addUser(jetUser);
        }
        n2 = vector2 == null ? 0 : vector2.size();
        for (n = 0; n < n2; ++n) {
            JetRole jetRole = this.afterInit((BaseRole)vector2.elementAt(n));
            this.addRole(jetRole);
        }
        n = vector3 == null ? 0 : vector3.size();
        for (int i = 0; i < n; ++i) {
            JetGroup jetGroup = this.addRole((BaseGroup)vector3.elementAt(i));
            this.addGroup(jetGroup);
        }
        return true;
    }

    private boolean addElement(Vector vector, Vector vector2, Vector vector3, int n) {
        if (n != 1 && n != 2) {
            return false;
        }
        boolean bl = false;
        Vector<String> vector4 = new Vector<String>();
        Vector vector5 = new Vector();
        int n2 = vector == null ? 0 : vector.size();
        BaseUser baseUser = null;
        for (int i = 0; i < n2; ++i) {
            JetUser jetUser;
            baseUser = (BaseUser)vector.elementAt(i);
            if (this.addGroup.containsKey(baseUser.getName())) {
                jetUser = (JetUser)this.getUser(baseUser.getName());
                if (jetUser.getSourceType() != 1) {
                    if (n == 1) {
                        this.deleteUser(jetUser, true);
                        this.addUser(this.addGroup(baseUser));
                    } else if (n == 2) {
                        this.addParentRole(jetUser, baseUser);
                    }
                } else {
                    this.addParentRole(jetUser, baseUser);
                }
            } else {
                jetUser = this.addGroup(baseUser);
                this.addUser(jetUser);
            }
            vector4.addElement(baseUser.getName());
            bl = true;
        }
        vector5 = this.getServerUsers();
        n2 = vector5.size();
        for (int i = 0; i < n2; ++i) {
            JetUser jetUser = (JetUser)vector5.elementAt(i);
            if (vector4.contains(jetUser.getName())) continue;
            this.deleteUser(jetUser, true);
        }
        vector4.clear();
        vector5.removeAllElements();
        n2 = vector3 == null ? 0 : vector3.size();
        BaseGroup baseGroup = null;
        for (int i = 0; i < n2; ++i) {
            JetGroup jetGroup;
            baseGroup = (BaseGroup)vector3.elementAt(i);
            if (this.addRole.containsKey(baseGroup.getName())) {
                jetGroup = (JetGroup)this.getGroup(baseGroup.getName());
                if (jetGroup.getSourceType() != 1) {
                    if (n == 1) {
                        this.deleteGroup(jetGroup, true);
                        this.addGroup(this.addRole(baseGroup));
                    } else if (n == 2) {
                        this.addUser(jetGroup, baseGroup);
                    }
                } else {
                    this.addUser(jetGroup, baseGroup);
                }
            } else {
                jetGroup = this.addRole(baseGroup);
                this.addGroup(jetGroup);
            }
            vector4.addElement(baseGroup.getName());
            bl = true;
        }
        vector5 = this.getServerGroups();
        n2 = vector5.size();
        for (int i = 0; i < n2; ++i) {
            JetGroup jetGroup = (JetGroup)vector5.elementAt(i);
            if (vector4.contains(jetGroup.getName())) continue;
            this.deleteGroup(jetGroup, true);
        }
        vector4.clear();
        vector5.removeAllElements();
        n2 = vector2 == null ? 0 : vector2.size();
        BaseRole baseRole = null;
        for (int i = 0; i < n2; ++i) {
            JetRole jetRole;
            baseRole = (BaseRole)vector2.elementAt(i);
            if (this.addParentRole.containsKey(baseRole.getName())) {
                jetRole = (JetRole)this.getRole(baseRole.getName());
                if (jetRole.getSourceType() != 1) {
                    if (n == 1) {
                        this.deleteRole(jetRole);
                        this.addRole(this.afterInit(baseRole));
                    } else if (n == 2) {
                        this.append(jetRole, baseRole);
                    }
                } else {
                    this.append(jetRole, baseRole);
                }
            } else {
                jetRole = this.afterInit(baseRole);
                this.addRole(jetRole);
            }
            vector4.addElement(baseRole.getName());
            bl = true;
        }
        vector5 = this.getServerRoles();
        n2 = vector5.size();
        for (int i = 0; i < n2; ++i) {
            JetRole jetRole = (JetRole)vector5.elementAt(i);
            if (vector4.contains(jetRole.getName())) continue;
            this.deleteRole(jetRole);
        }
        this.addEntry();
        return bl;
    }

    private void addEntry() {
        JetGroup jetGroup;
        JetRole jetRole;
        int n;
        int n2;
        JetUser jetUser;
        int n3;
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        vector = this.getUsers(2);
        int n4 = vector.size();
        for (n3 = 0; n3 < n4; ++n3) {
            jetUser = (JetUser)vector.elementAt(n3);
            vector4 = jetUser.getParentRoleNames();
            n2 = vector4.size();
            for (n = 0; n < n2; ++n) {
                jetRole = (JetRole)this.getRole((String)vector4.elementAt(n));
                if (jetRole == null || jetRole.getSourceType() != 1) continue;
                jetUser.removeParentRole(jetRole.getName());
                --n2;
                --n;
            }
            vector4 = jetUser.getGroupNames();
            n2 = vector4.size();
            for (n = 0; n < n2; ++n) {
                jetGroup = (JetGroup)this.getGroup((String)vector4.elementAt(n));
                if (jetGroup == null || jetGroup.getSourceType() != 1) continue;
                jetUser.removeGroup(jetGroup.getName());
                --n2;
                --n;
            }
        }
        vector3 = this.getGroups(2);
        n4 = vector3.size();
        for (n3 = 0; n3 < n4; ++n3) {
            jetGroup = (JetGroup)vector3.elementAt(n3);
            vector4 = jetGroup.getRoleNames();
            n2 = vector4.size();
            for (n = 0; n < n2; ++n) {
                jetRole = (JetRole)this.getRole((String)vector4.elementAt(n));
                if (jetRole == null || jetRole.getSourceType() != 1) continue;
                jetGroup.removeRole(jetRole.getName());
                --n2;
                --n;
            }
            vector4 = jetGroup.getUserNames();
            n2 = vector4.size();
            for (n = 0; n < n2; ++n) {
                jetUser = (JetUser)this.getUser((String)vector4.elementAt(n));
                if (jetUser == null || jetUser.getSourceType() != 1) continue;
                jetGroup.removeUser(jetUser.getName());
                --n2;
                --n;
            }
        }
        vector2 = this.getRoles(2);
        n4 = vector2.size();
        for (n3 = 0; n3 < n4; ++n3) {
            jetRole = (JetRole)vector2.elementAt(n3);
            vector4 = jetRole.getSubUserNames();
            n2 = vector4.size();
            for (n = 0; n < n2; ++n) {
                jetUser = (JetUser)this.getUser((String)vector4.elementAt(n));
                if (jetUser.getSourceType() != 1) continue;
                jetUser.addParentRole(jetRole.getName());
            }
            vector4 = jetRole.getGroupNames();
            n2 = vector4.size();
            for (n = 0; n < n2; ++n) {
                jetGroup = (JetGroup)this.getGroup((String)vector4.elementAt(n));
                if (jetGroup.getSourceType() != 1) continue;
                jetGroup.addRole(jetRole.getName());
            }
        }
    }

    private JetUser addGroup(BaseUser baseUser) {
        JetUser jetUser = new JetUser();
        jetUser.setName(baseUser.getName());
        jetUser.setEmail(baseUser.getEmail());
        jetUser.setRoles(baseUser.getParentRoleNames());
        jetUser.setSourceType(1);
        jetUser.setGroups(baseUser.getGroupNames());
        return jetUser;
    }

    private void addParentRole(JetUser jetUser, BaseUser baseUser) {
        jetUser.setSourceType(1);
        jetUser.setName(baseUser.getName());
        jetUser.setEmail(baseUser.getEmail());
        jetUser.setRoles(baseUser.getParentRoleNames());
        jetUser.setGroups(baseUser.getGroupNames());
    }

    private JetGroup addRole(BaseGroup baseGroup) {
        JetGroup jetGroup = new JetGroup();
        jetGroup.setName(baseGroup.getName());
        jetGroup.setSourceType(1);
        jetGroup.setUsers(baseGroup.getUserNames());
        jetGroup.setParentGroups(baseGroup.getParentGroupNames());
        jetGroup.setSubGroups(baseGroup.getSubGroupNames());
        jetGroup.setRoles(baseGroup.getRoleNames());
        return jetGroup;
    }

    private void addUser(JetGroup jetGroup, BaseGroup baseGroup) {
        jetGroup.setName(baseGroup.getName());
        jetGroup.setSourceType(1);
        jetGroup.setUsers(baseGroup.getUserNames());
        jetGroup.setParentGroups(baseGroup.getParentGroupNames());
        jetGroup.setSubGroups(baseGroup.getSubGroupNames());
        jetGroup.setRoles(baseGroup.getRoleNames());
    }

    private JetRole afterInit(BaseRole baseRole) {
        JetRole jetRole = new JetRole();
        jetRole.setName(baseRole.getName());
        jetRole.setSourceType(1);
        jetRole.setUsers(baseRole.getSubUserNames());
        jetRole.setParentRoles(baseRole.getParentRoleNames());
        jetRole.setSubRoles(baseRole.getSubRoleNames());
        jetRole.setGroups(baseRole.getGroupNames());
        return jetRole;
    }

    private void append(JetRole jetRole, BaseRole baseRole) {
        jetRole.setName(baseRole.getName());
        jetRole.setSourceType(1);
        jetRole.setUsers(baseRole.getSubUserNames());
        jetRole.setParentRoles(baseRole.getParentRoleNames());
        jetRole.setSubRoles(baseRole.getSubRoleNames());
        jetRole.setGroups(baseRole.getGroupNames());
    }

    public JAclImpl createAclImpl(BaseUser baseUser) throws NotOwnerException {
        return this.createAclImpl(baseUser, this, 0);
    }

    public JAclImpl createAclImpl(BaseUser baseUser, SecurityData securityData, int n) throws NotOwnerException {
        JAclImpl jAclImpl;
        block11: {
            JAclEntryImpl jAclEntryImpl;
            JetAclEntry jetAclEntry;
            JetUser jetUser;
            block10: {
                if (baseUser == null) {
                    return null;
                }
                jetUser = new JetUser();
                jAclImpl = new JAclImpl(jetUser, this.getName(), securityData);
                jetAclEntry = (JetAclEntry)this.addGroup.get(baseUser.getName());
                if (jetAclEntry != null) {
                    switch (n) {
                        case 0: {
                            jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseUser, securityData);
                            jAclImpl.addEntry(jetUser, jAclEntryImpl);
                            break;
                        }
                        case 1: {
                            if (jetAclEntry.getPrincipal().getSourceType() != 1) break;
                            jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseUser, securityData);
                            jAclImpl.addEntry(jetUser, jAclEntryImpl);
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                }
                if (n != 0 && n != 1) break block10;
                Vector vector = baseUser.getParentRoleNames();
                int n2 = vector == null ? 0 : vector.size();
                for (int i = 0; i < n2; ++i) {
                    BaseRole baseRole = securityData.getRole((String)vector.elementAt(i));
                    if (baseRole == null) continue;
                    this.clearMem(jetUser, jAclImpl, baseRole, securityData, n);
                }
                Vector vector2 = baseUser.getGroupNames();
                n2 = vector2 == null ? 0 : vector2.size();
                for (int i = 0; i < n2; ++i) {
                    BaseGroup baseGroup = securityData.getGroup((String)vector2.elementAt(i));
                    if (baseGroup == null) continue;
                    this.clear(jetUser, jAclImpl, baseGroup, securityData, n);
                }
                break block11;
            }
            if (n != 2) break block11;
            Vector vector = this.clone(baseUser.getName());
            int n3 = vector == null ? 0 : vector.size();
            for (int i = 0; i < n3; ++i) {
                jetAclEntry = (JetAclEntry)vector.elementAt(i);
                jAclEntryImpl = jetAclEntry.createAclEntryImpl((JetRole)jetAclEntry.getPrincipal(), securityData);
                jAclImpl.addEntry(jetUser, jAclEntryImpl);
            }
        }
        return jAclImpl;
    }

    private void clear(Principal principal, JAclImpl jAclImpl, BaseGroup baseGroup, SecurityData securityData, int n) throws NotOwnerException {
        Vector vector;
        JetAclEntry jetAclEntry = (JetAclEntry)this.addRole.get(baseGroup.getName());
        if (jetAclEntry != null) {
            switch (n) {
                case 0: {
                    JAclEntryImpl jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseGroup, securityData);
                    jAclImpl.addEntry(principal, jAclEntryImpl);
                    break;
                }
                case 1: {
                    if (jetAclEntry.getPrincipal().getSourceType() != 1) break;
                    JAclEntryImpl jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseGroup, securityData);
                    jAclImpl.addEntry(principal, jAclEntryImpl);
                    break;
                }
            }
        }
        int n2 = (vector = baseGroup.getParentGroupNames()) == null ? 0 : vector.size();
        for (int i = 0; i < n2; ++i) {
            BaseGroup baseGroup2 = securityData.getGroup((String)vector.elementAt(i));
            if (baseGroup2 == null) continue;
            this.clear(principal, jAclImpl, baseGroup2, securityData, n);
        }
        Vector vector2 = baseGroup.getRoleNames();
        n2 = vector2 == null ? 0 : vector2.size();
        for (int i = 0; i < n2; ++i) {
            BaseRole baseRole = securityData.getRole((String)vector2.elementAt(i));
            if (baseRole == null) continue;
            this.clearMem(principal, jAclImpl, baseRole, securityData, n);
        }
    }

    private void clearMem(Principal principal, JAclImpl jAclImpl, BaseRole baseRole, SecurityData securityData, int n) throws NotOwnerException {
        Vector vector;
        JetAclEntry jetAclEntry = (JetAclEntry)this.addParentRole.get(baseRole.getName());
        if (jetAclEntry != null) {
            switch (n) {
                case 0: {
                    JAclEntryImpl jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseRole, securityData);
                    jAclImpl.addEntry(principal, jAclEntryImpl);
                    break;
                }
                case 1: {
                    if (jetAclEntry.getPrincipal().getSourceType() != 1) break;
                    JAclEntryImpl jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseRole, securityData);
                    jAclImpl.addEntry(principal, jAclEntryImpl);
                    break;
                }
            }
        }
        int n2 = (vector = baseRole.getParentRoleNames()) == null ? 0 : vector.size();
        for (int i = 0; i < n2; ++i) {
            BaseRole baseRole2 = securityData.getRole((String)vector.elementAt(i));
            if (baseRole2 == null) continue;
            this.clearMem(principal, jAclImpl, baseRole2, securityData, n);
        }
    }

    private Vector clone(String string) {
        JetAclEntry jetAclEntry = (JetAclEntry)this.addGroup.get(string);
        if (jetAclEntry == null) {
            return null;
        }
        JetUser jetUser = (JetUser)jetAclEntry.getPrincipal();
        if (jetUser.getSourceType() != 1) {
            return null;
        }
        Vector<JetAclEntry> vector = new Vector<JetAclEntry>();
        Vector vector2 = jetUser.getParentRoleNames();
        int n = vector2 == null ? 0 : vector2.size();
        for (int i = 0; i < n; ++i) {
            JetRole jetRole;
            jetAclEntry = (JetAclEntry)this.addParentRole.get((String)vector2.elementAt(i));
            if (jetAclEntry == null || (jetRole = (JetRole)jetAclEntry.getPrincipal()).getSourceType() != 2) continue;
            vector.add(jetAclEntry);
        }
        return vector;
    }

    @Override
    public void setNamingTable(Hashtable hashtable) {
        this.addUser = hashtable;
    }

    @Override
    public Hashtable getNamingTable() {
        return this.addUser;
    }

    @Override
    public void setNamingCount(Hashtable hashtable) {
        this.afterInit = hashtable;
    }

    @Override
    public Hashtable getNamingCount() {
        if (this.afterInit == null) {
            this.afterInit = new Hashtable();
        }
        return this.afterInit;
    }

    @Override
    public void clearMem() {
        JetObject jetObject;
        this.addUser.clear();
        TreeIterater treeIterater = new TreeIterater(this, true);
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            jetObject.delete();
        }
    }

    @Override
    public synchronized int getRefCount() {
        return this.append;
    }

    @Override
    public synchronized void refer() {
        ++this.append;
    }

    @Override
    public synchronized void free() {
        if (this.append > 0) {
            --this.append;
        }
        if (!this.clear && this.append == 0) {
            this.clearMem();
        }
    }

    @Override
    public void setCached(boolean bl) {
        this.clear = bl;
    }

    @Override
    public boolean isCached() {
        return this.clear;
    }

    @Override
    public void setVersion(int n) {
        this.clearMem = n;
    }

    @Override
    public int getVersion() {
        return this.clearMem;
    }

    public static void exportToXML(JetAcl jetAcl, String string) throws ACLException {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "deprecated API called[JetAcl#exportToXML(JetAcl acl, String outFile)]----- It was Error if not in Designer Context.");
        }
        JetAcl.exportToXML(null, jetAcl, string);
    }

    public static void exportToXML(DiskStore diskStore, JetAcl jetAcl, String string) throws ACLException {
        try {
            ObjectToXML objectToXML = new ObjectToXML(diskStore, jetAcl, string);
        }
        catch (Exception exception) {
            throw new ACLException(exception.getMessage());
        }
    }

    public static JetAcl importXML(String string) throws ACLException {
        JetAcl jetAcl = null;
        try {
            jetAcl = (JetAcl)XMLToObject.toObject(string);
        }
        catch (Exception exception) {
            throw new ACLException(exception.getMessage());
        }
        return jetAcl;
    }

    public static JetAcl importTxt(String string) throws ACLException {
        JetAcl jetAcl = null;
        try {
            jetAcl = AclTextReader.readAcl(string);
        }
        catch (Exception exception) {
            throw new ACLException(exception.getMessage());
        }
        return jetAcl;
    }

    public boolean equalsTo(JetAcl jetAcl) {
        JetAclEntry jetAclEntry;
        JetAclEntry jetAclEntry2;
        Hashtable hashtable = jetAcl.getUserEntries();
        Hashtable hashtable2 = jetAcl.getRoleEntries();
        Hashtable hashtable3 = jetAcl.getGroupEntries();
        if (this.isValidRLS() != jetAcl.isValidRLS() || this.isValidCLS() != jetAcl.isValidCLS()) {
            return false;
        }
        if (this.addGroup.size() != hashtable.size() || this.addParentRole.size() != hashtable2.size() || this.addRole.size() != hashtable3.size()) {
            return false;
        }
        String string2 = null;
        Set set = null;
        Iterator iterator = null;
        set = this.addGroup.keySet();
        for (String string2 : set) {
            jetAclEntry2 = (JetAclEntry)this.addGroup.get(string2);
            jetAclEntry = (JetAclEntry)hashtable.get(string2);
            if (jetAclEntry != null && jetAclEntry2.equalsTo(jetAclEntry)) continue;
            return false;
        }
        set = this.addRole.keySet();
        for (String string2 : set) {
            jetAclEntry2 = (JetAclEntry)this.addRole.get(string2);
            jetAclEntry = (JetAclEntry)hashtable3.get(string2);
            if (jetAclEntry != null && jetAclEntry2.equalsTo(jetAclEntry)) continue;
            return false;
        }
        set = this.addParentRole.keySet();
        for (String string2 : set) {
            jetAclEntry2 = (JetAclEntry)this.addParentRole.get(string2);
            jetAclEntry = (JetAclEntry)hashtable2.get(string2);
            if (jetAclEntry != null && jetAclEntry2.equalsTo(jetAclEntry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public HashMap getIndecialMap() {
        return clone;
    }

    private void contains() {
        this.SEDU = new JetBoolean(this, "IsNotValidRLS");
        this.add = new JetBoolean(this, "IsValidCLS");
    }

    static {
        int n = 0;
        clone.put("IsValidCLS", new Integer(n++));
        clone.put("IsNotValidRLS", new Integer(n++));
    }
}

