/*
 * Decompiled with CFR 0.152.
 */
package jet.acl;

import java.util.HashMap;
import java.util.Vector;
import jet.acl.AclTools;
import jet.acl.JetPrincipal;
import jet.controls.JetBoolean;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.cs.jacl.BaseGroup;

public class JetGroup
extends JetPrincipal
implements BaseGroup {
    private JetString SEDU;
    private JetString addString;
    private JetVector afterInit;
    private JetVector clone;
    private JetVector equals;
    private JetVector get;
    private JetString getGroupName;
    private JetBoolean getLength;
    private int getParentGroups = -1;
    private static final HashMap getRoles = new HashMap(7);

    public JetGroup() {
        this.SEDU();
    }

    public String getDescription() {
        return this.getGroupName.get();
    }

    public void setDescription(String string) {
        this.getGroupName.set(string);
    }

    public String getGroupName() {
        return this.SEDU.get();
    }

    public void setGroupName(String string) {
        this.SEDU.set(string);
    }

    public boolean isAdminGroup() {
        return this.getLength.get();
    }

    public void setAdminGroup(boolean bl) {
        this.getLength.set(bl);
    }

    public Vector getUsers() {
        return this.afterInit.get();
    }

    public void setUsers(Vector vector) {
        AclTools.setStrings(this.afterInit, vector);
    }

    public Vector getRoles() {
        return this.clone.get();
    }

    public void setRoles(Vector vector) {
        AclTools.setStrings(this.clone, vector);
    }

    public Vector getParentGroups() {
        return this.equals.get();
    }

    public void setParentGroups(Vector vector) {
        AclTools.setStrings(this.equals, vector);
    }

    public Vector getSubGroups() {
        return this.get.get();
    }

    public void setSubGroups(Vector vector) {
        AclTools.setStrings(this.get, vector);
    }

    @Override
    public String getName() {
        return this.getGroupName();
    }

    public void setName(String string) {
        this.setGroupName(string);
    }

    @Override
    public boolean equalsTo(JetPrincipal jetPrincipal) {
        if (!(jetPrincipal instanceof JetGroup)) {
            return false;
        }
        JetGroup jetGroup = (JetGroup)jetPrincipal;
        return this.isAdminGroup() == jetGroup.isAdminGroup() && this.getSourceType() == jetGroup.getSourceType() && this.getGroupName().equals(jetGroup.getGroupName()) && this.getUsers().toString().equals(jetGroup.getUsers().toString()) && this.getRoles().toString().equals(jetGroup.getRoles().toString()) && this.getParentGroups().toString().equals(jetGroup.getParentGroups().toString()) && this.getSubGroups().toString().equals(jetGroup.getSubGroups().toString());
    }

    @Override
    public int getSourceType() {
        return this.getParentGroups;
    }

    @Override
    public void setSourceType(int n) {
        this.getParentGroups = n;
        this.addString.set(this.getSourceName(n));
    }

    @Override
    public Vector getRoleNames() {
        return this.getRoles();
    }

    public boolean isFromServer() {
        return this.getSourceType() == 1;
    }

    @Override
    public Vector getParentGroupNames() {
        return this.getParentGroups();
    }

    @Override
    public Vector getUserNames() {
        return this.getUsers();
    }

    @Override
    public Vector getSubGroupNames() {
        return this.getSubGroups();
    }

    public boolean isHaveRole(String string) {
        return AclTools.isHaveString(this.clone, string);
    }

    public void addRole(String string) {
        AclTools.addString(this.clone, string);
    }

    public void removeRole(String string) {
        AclTools.removeString(this.clone, string);
    }

    public int getRolesCount() {
        return AclTools.getLength(this.clone);
    }

    public boolean isHaveParentGroup(String string) {
        return AclTools.isHaveString(this.equals, string);
    }

    public void addParentGroup(String string) {
        AclTools.addString(this.equals, string);
    }

    public void removeParentGroup(String string) {
        AclTools.removeString(this.equals, string);
    }

    public int getParentGroupsCount() {
        return AclTools.getLength(this.equals);
    }

    public void addUser(String string) {
        AclTools.addString(this.afterInit, string);
    }

    public void removeUser(String string) {
        AclTools.removeString(this.afterInit, string);
    }

    public boolean isHaveUser(String string) {
        return AclTools.isHaveString(this.afterInit, string);
    }

    public int getUsersCount() {
        return AclTools.getLength(this.afterInit);
    }

    public void addSubGroup(String string) {
        AclTools.addString(this.get, string);
    }

    public void removeSubGroup(String string) {
        AclTools.removeString(this.get, string);
    }

    public boolean isHaveSubGroup(String string) {
        return AclTools.isHaveString(this.get, string);
    }

    public int getSubGroupsCount() {
        return AclTools.getLength(this.get);
    }

    @Override
    public String getInstancePrefix() {
        return "Group";
    }

    @Override
    public void afterInit() {
        super.afterInit();
        this.getParentGroups = this.getSourceType(this.addString.get());
    }

    public Object clone() {
        JetGroup jetGroup = new JetGroup();
        jetGroup.setGroupName(this.getGroupName());
        jetGroup.setAdminGroup(this.isAdminGroup());
        jetGroup.setSourceType(this.getSourceType());
        jetGroup.setUsers(this.getUsers());
        jetGroup.setRoles(this.getRoles());
        jetGroup.setParentGroups(this.getParentGroups());
        jetGroup.setSubGroups(this.getSubGroups());
        return jetGroup;
    }

    public JetGroup copy() {
        return (JetGroup)this.clone();
    }

    @Override
    public HashMap getIndecialMap() {
        return getRoles;
    }

    private void SEDU() {
        this.SEDU = new JetString(this, "GroupName");
        this.addString = new JetString(this, "SourceName");
        this.afterInit = new JetVector(this, "Users");
        this.clone = new JetVector(this, "Roles");
        this.equals = new JetVector(this, "ParentGroups");
        this.get = new JetVector(this, "SubGroups");
        this.getLength = new JetBoolean(this, "IsReportAdminGroup");
        this.getGroupName = new JetString(this, "Description");
    }

    static {
        int n = 0;
        getRoles.put("IsReportAdminGroup", new Integer(n++));
        getRoles.put("Roles", new Integer(n++));
        getRoles.put("SubGroups", new Integer(n++));
        getRoles.put("ParentGroups", new Integer(n++));
        getRoles.put("GroupName", new Integer(n++));
        getRoles.put("Users", new Integer(n++));
        getRoles.put("SourceName", new Integer(n++));
        getRoles.put("Description", new Integer(n++));
    }
}

