/*
 * Decompiled with CFR 0.152.
 */
package jet.acl;

import java.util.HashMap;
import java.util.Vector;
import jet.acl.JetAbstractPolicy;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.cs.jacl.JPermissionImpl;
import jet.cs.jacl.JPrivilege;

public class JetPermission
extends JetObject
implements JetContainable,
Cloneable {
    private JetString DELETE;
    private JetString EXECUTE;
    private int GRANT = -1;
    private int READ = -1;
    private Vector SCHEDULE = new Vector(1);
    private static final HashMap SEDU = new HashMap(2);

    public JetPermission() {
        this.SEDU();
    }

    public JetPermission(int n, int n2) {
        this.SEDU();
        this.setPrivilegeType(n);
        this.setType(n2);
    }

    public JetPermission(int n, int n2, JetAbstractPolicy jetAbstractPolicy) {
        this.SEDU();
        this.setPrivilegeType(n);
        this.setType(n2);
        this.setPolicy(jetAbstractPolicy);
    }

    public void setPrivilegeName(String string) {
        this.DELETE.set(string);
    }

    public String getPrivilegeName() {
        return this.DELETE.get();
    }

    public void setPermissionName(String string) {
        this.EXECUTE.set(string);
    }

    public String getPermissionName() {
        return this.EXECUTE.get();
    }

    public void setPrivilegeType(int n) {
        this.GRANT = n;
        this.DELETE.set(this.EXECUTE(n));
    }

    public int getPrivilegeType() {
        return this.GRANT;
    }

    public void setType(int n) {
        this.READ = n;
        this.EXECUTE.set(this.READ(n));
    }

    public int getType() {
        return this.READ;
    }

    public JetPermission copy() {
        return (JetPermission)this.clone();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof JetPermission)) {
            return false;
        }
        if (this.isHavePolicy() != ((JetPermission)object).isHavePolicy()) {
            return false;
        }
        return this.isHavePolicy() ? this.getPrivilegeName().equals(((JetPermission)object).getPrivilegeName()) && this.getPermissionName().equals(((JetPermission)object).getPermissionName()) && this.getPolicy().equals(((JetPermission)object).getPolicy()) : this.getPrivilegeName().equals(((JetPermission)object).getPrivilegeName()) && this.getPermissionName().equals(((JetPermission)object).getPermissionName());
    }

    public String toString() {
        return "PermissionName:" + this.getPrivilegeName() + "  PermissionType:" + this.getPermissionName() + "  Policy:" + this.getPolicy();
    }

    public void setPolicy(JetAbstractPolicy jetAbstractPolicy) {
        this.SCHEDULE.removeAllElements();
        this.add(jetAbstractPolicy);
    }

    public boolean removePolicy() {
        if (this.SCHEDULE == null || this.SCHEDULE.size() == 0) {
            return false;
        }
        this.SCHEDULE.removeAllElements();
        return true;
    }

    public JetAbstractPolicy getPolicy() {
        if (this.SCHEDULE == null || this.SCHEDULE.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.SCHEDULE.size(); ++i) {
            JetObject jetObject = (JetObject)this.SCHEDULE.elementAt(i);
            if (!(jetObject instanceof JetAbstractPolicy)) continue;
            return (JetAbstractPolicy)jetObject;
        }
        return null;
    }

    @Override
    public JetObject add(JetObject jetObject) {
        this.SCHEDULE.add(jetObject);
        jetObject.setParent(this);
        return jetObject;
    }

    @Override
    public JetObject remove(JetObject jetObject) {
        boolean bl = this.SCHEDULE.removeElement(jetObject);
        if (bl) {
            jetObject.setParent(null);
            return jetObject;
        }
        return null;
    }

    @Override
    public void broadcast(JetObject jetObject, int n) {
    }

    @Override
    public Vector getChildren() {
        return this.SCHEDULE;
    }

    @Override
    public String getInstancePrefix() {
        return "Permission";
    }

    @Override
    public void afterInit() {
        super.afterInit();
        this.GRANT = this.GRANT(this.getPrivilegeName());
        this.READ = this.SCHEDULE(this.getPermissionName());
    }

    public Object clone() {
        JetPermission jetPermission = new JetPermission();
        jetPermission.setPrivilegeType(this.getPrivilegeType());
        jetPermission.setType(this.getType());
        JetAbstractPolicy jetAbstractPolicy = this.getPolicy();
        if (jetAbstractPolicy != null) {
            jetPermission.setPolicy((JetAbstractPolicy)jetAbstractPolicy.clone());
        }
        return jetPermission;
    }

    public boolean isHavePolicy() {
        return this.getPolicy() != null;
    }

    public JPermissionImpl createPermissionImpl() {
        JPermissionImpl jPermissionImpl = new JPermissionImpl(this.DELETE(), this.getType(), this.getPolicy());
        return jPermissionImpl;
    }

    private JPrivilege DELETE() {
        switch (this.GRANT) {
            case 0: {
                return JPrivilege.VISIBLE;
            }
            case 1: {
                return JPrivilege.READ;
            }
            case 2: {
                return JPrivilege.WRITE;
            }
            case 3: {
                return JPrivilege.EXECUTE;
            }
            case 4: {
                return JPrivilege.SCHEDULE;
            }
            case 5: {
                return JPrivilege.DELETE;
            }
            case 6: {
                return JPrivilege.GRANT;
            }
        }
        return null;
    }

    private String EXECUTE(int n) {
        switch (n) {
            case 0: {
                return "visible";
            }
            case 1: {
                return "read";
            }
            case 2: {
                return "write";
            }
            case 3: {
                return "execute";
            }
            case 4: {
                return "schedule";
            }
            case 5: {
                return "delete";
            }
            case 6: {
                return "grant";
            }
        }
        return null;
    }

    private int GRANT(String string) {
        if (string.equals("visible")) {
            return 0;
        }
        if (string.equals("read")) {
            return 1;
        }
        if (string.equals("write")) {
            return 2;
        }
        if (string.equals("execute")) {
            return 3;
        }
        if (string.equals("schedule")) {
            return 4;
        }
        if (string.equals("delete")) {
            return 5;
        }
        if (string.equals("grant")) {
            return 6;
        }
        return -1;
    }

    private String READ(int n) {
        switch (n) {
            case -1: {
                return "basic_null";
            }
            case 0: {
                return "basic";
            }
            case 1: {
                return "RLS";
            }
            case 2: {
                return "CLS";
            }
        }
        return null;
    }

    private int SCHEDULE(String string) {
        if (string.equals("basic_null")) {
            return -1;
        }
        if (string.equals("basic")) {
            return 0;
        }
        if (string.equals("RLS")) {
            return 1;
        }
        if (string.equals("CLS")) {
            return 2;
        }
        return -1;
    }

    @Override
    public HashMap getIndecialMap() {
        return SEDU;
    }

    private void SEDU() {
        this.DELETE = new JetString(this, "PermissionName");
        this.EXECUTE = new JetString(this, "PermissionType");
    }

    static {
        int n = 0;
        SEDU.put("PermissionType", new Integer(n++));
        SEDU.put("PermissionName", new Integer(n++));
    }
}

