/*
 * Decompiled with CFR 0.152.
 */
package jet.acl;

import java.util.HashMap;
import java.util.Vector;
import jet.acl.AclTools;
import jet.acl.JetPrincipal;
import jet.controls.JetBoolean;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.cs.jacl.BaseUser;

public class JetUser
extends JetPrincipal
implements BaseUser {
    private JetString SEDU;
    private JetString addString;
    private JetString afterInit;
    private JetString clone;
    private JetString equals;
    private JetVector get;
    private JetVector getEmail;
    private JetBoolean getGroups;
    private int getGroupsProperty = -1;
    private static final HashMap getLength = new HashMap(7);

    public JetUser() {
        this.SEDU();
    }

    public JetVector getPropertyRoles() {
        return this.get;
    }

    public JetVector getGroupsProperty() {
        return this.getEmail;
    }

    @Override
    public String getName() {
        return this.SEDU.get();
    }

    public void setName(String string) {
        this.SEDU.set(string);
    }

    @Override
    public String getEmail() {
        return this.addString.get();
    }

    public void setEmail(String string) {
        this.addString.set(string);
    }

    public void addParentRole(String string) {
        AclTools.addString(this.get, string);
    }

    public void removeParentRole(String string) {
        AclTools.removeString(this.get, string);
    }

    public boolean isHaveParentRole(String string) {
        return AclTools.isHaveString(this.get, string);
    }

    @Override
    public Vector getParentRoleNames() {
        return this.get.get();
    }

    public int getParentRolesCount() {
        Vector vector = this.get.get();
        return vector == null ? 0 : vector.size();
    }

    public void addGroup(String string) {
        AclTools.addString(this.getEmail, string);
    }

    public void removeGroup(String string) {
        AclTools.removeString(this.getEmail, string);
    }

    public boolean isHaveGroup(String string) {
        return AclTools.isHaveString(this.getEmail, string);
    }

    @Override
    public Vector getGroupNames() {
        return this.getEmail.get();
    }

    public int getGroupsCount() {
        return AclTools.getLength(this.getEmail);
    }

    public boolean isFromServer() {
        return this.getSourceType() == 1;
    }

    public String getTitle() {
        return this.afterInit.get();
    }

    public void setTitle(String string) {
        this.afterInit.set(string);
    }

    @Override
    public int getSourceType() {
        return this.getGroupsProperty;
    }

    @Override
    public void setSourceType(int n) {
        this.getGroupsProperty = n;
        this.clone.set(this.getSourceName(n));
    }

    public String getDescription() {
        return this.equals.get();
    }

    public void setDescription(String string) {
        this.equals.set(string);
    }

    public boolean isAdmin() {
        return this.getGroups.get();
    }

    public void setAdmin(boolean bl) {
        this.getGroups.set(bl);
    }

    public Vector getRoles() {
        return this.get.get();
    }

    public void setRoles(Vector vector) {
        AclTools.setStrings(this.get, vector);
    }

    public Vector getGroups() {
        return this.getEmail.get();
    }

    public void setGroups(Vector vector) {
        AclTools.setStrings(this.getEmail, vector);
    }

    @Override
    public String getInstancePrefix() {
        return "User";
    }

    @Override
    public void afterInit() {
        super.afterInit();
        this.getGroupsProperty = this.getSourceType(this.clone.get());
    }

    public Object clone() {
        JetUser jetUser = new JetUser();
        jetUser.setName(this.getName());
        jetUser.setEmail(this.getEmail());
        jetUser.setTitle(this.getTitle());
        jetUser.setSourceType(this.getSourceType());
        jetUser.setAdmin(this.isAdmin());
        jetUser.setRoles(this.getRoles());
        jetUser.setGroups(this.getGroups());
        return jetUser;
    }

    public JetUser copy() {
        return (JetUser)this.clone();
    }

    @Override
    public boolean equalsTo(JetPrincipal jetPrincipal) {
        if (!(jetPrincipal instanceof JetUser)) {
            return false;
        }
        return this.isAdmin() == ((JetUser)jetPrincipal).isAdmin() && this.getName().equals(((JetUser)jetPrincipal).getName()) && this.getEmail().equals(((JetUser)jetPrincipal).getEmail()) && this.getSourceType() == ((JetUser)jetPrincipal).getSourceType() && this.getTitle().equals(((JetUser)jetPrincipal).getTitle()) && this.get.toString().equals(((JetUser)jetPrincipal).getPropertyRoles().toString()) && this.getGroupsProperty().toString().equals(((JetUser)jetPrincipal).getGroupsProperty().toString());
    }

    @Override
    public HashMap getIndecialMap() {
        return getLength;
    }

    private void SEDU() {
        this.SEDU = new JetString(this, "UserName");
        this.addString = new JetString(this, "Email");
        this.afterInit = new JetString(this, "Title");
        this.clone = new JetString(this, "SourceName");
        this.get = new JetVector(this, "Roles");
        this.getEmail = new JetVector(this, "Groups");
        this.getGroups = new JetBoolean(this, "IsReportAdmin");
        this.equals = new JetString(this, "Description");
    }

    static {
        int n = 0;
        getLength.put("Email", new Integer(n++));
        getLength.put("Roles", new Integer(n++));
        getLength.put("IsReportAdmin", new Integer(n++));
        getLength.put("Title", new Integer(n++));
        getLength.put("UserName", new Integer(n++));
        getLength.put("Groups", new Integer(n++));
        getLength.put("SourceName", new Integer(n++));
        getLength.put("Description", new Integer(n++));
    }
}

