/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import jet.JResource;
import jet.api.Node;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetContainable;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetQualifyReference;
import jet.controls.JetString;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.report.JRObjectTemplate;
import jet.report.JetLink;
import jet.report.JetRptChartLabel;
import jet.report.JetRptGeometryObject;

public abstract class API {
    public static final int UNKNOWN = -1;
    public static final int BOOLEAN = 0;
    public static final int INTEGER = 1;
    public static final int LONG = 2;
    public static final int FLOAT = 3;
    public static final int DOUBLE = 4;
    public static final int STRING = 5;
    public static final int COLOR = 6;
    public static final int ENUM = 7;
    public static final int REFERENCE = 8;
    public static final int INCH = 0;
    public static final int CENTIMETER = 1;
    public static final int PIXEL = 2;
    public static final String RPT = ".cls";
    public static final String XMLRPT = ".cls.xml";
    public static final String SELFRPT = ".clx";
    public static final String TEXTRPT = ".rpt";
    public static final String CAT = ".cat";
    public static final String XMLCAT = ".cat.xml";
    int unit;
    private final String SEDU = JResource.getMessage("API_ERROR");
    private final String addElement = JResource.getMessage("API_WARN");
    String warning;
    String error;
    PrintWriter log;
    public Hashtable handles = new Hashtable();

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") >= 0;
    }

    public static String checkFilename(String string) {
        return API.isWindows() ? string.toLowerCase() : string;
    }

    public JetObject getObj(String string) {
        if (string != null) {
            JetObject jetObject = (JetObject)this.handles.get(string);
            return jetObject;
        }
        return null;
    }

    public boolean setUnit(int n) {
        this.clearMsg();
        if (n >= 0 && n <= 2) {
            this.unit = n;
            return true;
        }
        this.setWarning("setUnit(" + n + "): " + JResource.getMessage("API_14"));
        return false;
    }

    public int getUnit() {
        return this.unit;
    }

    boolean checkName(JetContainable jetContainable, String string) {
        Vector vector = jetContainable.getChildren();
        int n = vector.size();
        while (--n >= 0) {
            if (!((JetObject)vector.elementAt(n)).getInstName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean delete(String var1);

    public String[] getPropNames(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            Hashtable hashtable = jetObject.getProperties();
            String[] stringArray = new String[hashtable.size()];
            int n = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                stringArray[n++] = (String)enumeration.nextElement();
            }
            return stringArray;
        }
        this.setError("getPropName(\"" + string + "\"): " + JResource.getMessage("API_01") + string + '.');
        return null;
    }

    public boolean containPropName(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return jetObject.nameToProperty(string2) != null;
        }
        this.setError("containPropName(\"" + string + "\",\"" + string2 + "\"):" + JResource.getMessage("API_01") + string + '.');
        return false;
    }

    public int getPropType(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetBoolean) {
                    return 0;
                }
                if (jetProperty instanceof JetEnumeration) {
                    return 7;
                }
                if (jetProperty instanceof JetUnitNumber) {
                    return 4;
                }
                if (jetProperty instanceof JetNumber) {
                    Object object = jetProperty.getObject();
                    if (object instanceof Integer) {
                        return 1;
                    }
                    if (object instanceof Float) {
                        return 3;
                    }
                    if (object instanceof Double) {
                        return 4;
                    }
                    if (object instanceof Long) {
                        return 2;
                    }
                    return 3;
                }
                if (jetProperty instanceof JetString || jetProperty instanceof JetVector || jetProperty instanceof JetLink) {
                    return 5;
                }
                if (jetProperty instanceof JetColor) {
                    return 6;
                }
                if (jetProperty instanceof JetQualifyReference) {
                    return 8;
                }
            } else {
                this.setError("getPropType(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_02", new String[]{string2, string}));
            }
        } else {
            this.setError("getPropType(\"" + string + "\",\"" + string2 + "\"):" + JResource.getMessage("API_01") + string + '.');
        }
        return -1;
    }

    boolean validType(int[] nArray, int n) {
        int n2 = nArray.length;
        while (--n2 >= 0) {
            if (nArray[n2] != n) continue;
            return true;
        }
        return false;
    }

    public boolean set(String string, String string2, boolean bl) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.validateProp(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + bl + "): " + string3);
            } else {
                if (jetProperty instanceof JetBoolean) {
                    ((JetBoolean)jetProperty).set(bl);
                    if (string2.equals("TileDetailSection")) {
                        ((JRObjectTemplate)jetObject).width.setEditFlag(2);
                    }
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + bl + "): " + JResource.getMessage("API_05", (Object)string2));
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + bl + "):" + JResource.getMessage("API_01") + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, int n) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.validateProp(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + n + "): " + string3);
            } else {
                if (jetProperty instanceof JetNumber) {
                    if (!this.convertIn((JetNumber)jetProperty, n)) {
                        ((JetNumber)jetProperty).set(n);
                    }
                    return true;
                }
                if (jetProperty instanceof JetEnumeration) {
                    Hashtable hashtable = ((JetEnumeration)jetProperty).getEnumerationSet();
                    Vector vector = new Vector(hashtable.values());
                    if (vector.contains(n)) {
                        ((JetEnumeration)jetProperty).set(n);
                        return true;
                    }
                    this.setError("set(\"" + string + "\",\"" + string2 + "\"," + n + "): " + JResource.getMessage("API_16", new Object[]{n, string2}));
                } else {
                    this.setError("set(\"" + string + "\",\"" + string2 + "\"," + n + "): " + JResource.getMessage("API_06", (Object)string2));
                }
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + n + "):" + JResource.getMessage("API_01") + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, long l) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.validateProp(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + l + "): " + string3);
            } else {
                if (jetProperty instanceof JetNumber) {
                    if (!this.convertIn((JetNumber)jetProperty, l)) {
                        ((JetNumber)jetProperty).set(l);
                    }
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + l + "): " + JResource.getMessage("API_07", (Object)string2));
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + l + "):" + JResource.getMessage("API_01") + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, float f) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.validateProp(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + f + "): " + string3);
            } else {
                if (jetProperty instanceof JetNumber) {
                    if (!this.convertIn((JetNumber)jetProperty, f)) {
                        ((JetNumber)jetProperty).set(f);
                    }
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + f + "): " + JResource.getMessage("API_08", (Object)string2));
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + f + "):" + JResource.getMessage("API_01") + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, double d) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.validateProp(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + d + "): " + string3);
            } else {
                if (jetProperty instanceof JetNumber) {
                    if (!this.convertIn((JetNumber)jetProperty, d)) {
                        ((JetNumber)jetProperty).set(d);
                    }
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + d + "): " + JResource.getMessage("API_09", (Object)string2));
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + d + "):" + JResource.getMessage("API_01") + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, String string3) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string4 = this.validateProp(jetProperty, string, string2);
            if (string4 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + string3 + "): " + string4);
            } else {
                if (jetProperty instanceof JetString) {
                    ((JetString)jetProperty).set(string3);
                    return true;
                }
                if (jetProperty instanceof JetEnumeration) {
                    Hashtable hashtable = ((JetEnumeration)jetProperty).getEnumerationSet();
                    Vector vector = new Vector(hashtable.values());
                    if (vector.contains(Integer.valueOf(string3))) {
                        ((JetEnumeration)jetProperty).set(string3);
                        return true;
                    }
                    this.setError("set(\"" + string + "\",\"" + string2 + "\"," + string3 + "): " + JResource.getMessage("API_16", new Object[]{Integer.valueOf(string3), string2}));
                } else {
                    if (jetProperty instanceof JetVector) {
                        ((JetVector)jetProperty).set(string3);
                        return true;
                    }
                    if (jetProperty instanceof JetColor) {
                        ((JetColor)jetProperty).set(string3);
                        return true;
                    }
                    if (jetProperty instanceof JetLink) {
                        ((JetLink)jetProperty).set(string3);
                        return true;
                    }
                    this.setError("set(\"" + string + "\",\"" + string2 + "\"," + string3 + "): " + JResource.getMessage("API_10", (Object)string2));
                }
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + string3 + "):" + JResource.getMessage("API_01") + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, Color color) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.validateProp(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + color + "): " + string3);
            } else {
                if (jetProperty instanceof JetColor) {
                    ((JetColor)jetProperty).set(color);
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + color + "): " + JResource.getMessage("API_11", (Object)string2));
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + color + "):" + JResource.getMessage("API_01") + string + '.');
        }
        return false;
    }

    public boolean setReference(String string, String string2, String string3) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string4 = this.validateProp(jetProperty, string, string2);
            if (string4 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + string3 + "): " + string4);
            } else {
                if (jetProperty instanceof JetQualifyReference) {
                    ((JetQualifyReference)jetProperty).setObject(this.getObj(string3));
                    ((JetQualifyReference)jetProperty).setInstanceName(string3);
                    if (jetObject instanceof JetRptGeometryObject) {
                        ((JRObjectTemplate)jetObject).afterInit();
                    }
                    return true;
                }
                this.setError("setRefence(\"" + string + "\",\"" + string2 + "\"," + string3 + "): " + JResource.getMessage("API_12", (Object)string2));
            }
        } else {
            this.setError("setRefence(\"" + string + "\",\"" + string2 + "\"," + string3 + "):" + JResource.getMessage("API_01") + string + '.');
        }
        return false;
    }

    public boolean getBool(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetBoolean) {
                    return ((JetBoolean)jetProperty).get();
                }
                this.setError("getBool(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_05", (Object)string2));
            } else {
                this.setError("getBool(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_03", new String[]{string2, string}));
            }
        } else {
            this.setError("getBool(\"" + string + "\",\"" + string2 + "\"):" + JResource.getMessage("API_01") + string + '.');
        }
        return false;
    }

    public int getInt(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetNumber) {
                    return jetProperty instanceof JetUnitNumber && this.unit != 2 ? (int)this.convertOut((JetUnitNumber)jetProperty) : ((JetNumber)jetProperty).get();
                }
                if (jetProperty instanceof JetEnumeration) {
                    return ((JetEnumeration)jetProperty).intValue();
                }
                this.setError("getInt(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_06", (Object)string2));
            } else {
                this.setError("getInt(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_03", new String[]{string2, string}));
            }
        } else {
            this.setError("getInt(\"" + string + "\",\"" + string2 + "\"):" + JResource.getMessage("API_01") + string + '.');
        }
        return 0;
    }

    public long getLong(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetNumber) {
                    return jetProperty instanceof JetUnitNumber && this.unit != 2 ? (long)this.convertOut((JetUnitNumber)jetProperty) : ((JetNumber)jetProperty).longValue();
                }
                this.setError("getLong(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_07", (Object)string2));
            } else {
                this.setError("getLong(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_03", new String[]{string2, string}));
            }
        } else {
            this.setError("getLong(\"" + string + "\",\"" + string2 + "\"):" + JResource.getMessage("API_01") + string + '.');
        }
        return 0L;
    }

    public float getFloat(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetNumber) {
                    return jetProperty instanceof JetUnitNumber && this.unit != 2 ? (float)this.convertOut((JetUnitNumber)jetProperty) : ((JetNumber)jetProperty).floatValue();
                }
                this.setError("getFloat(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_08", (Object)string2));
            } else {
                this.setError("getFloat(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_03", new String[]{string2, string}));
            }
        } else {
            this.setError("getFloat(\"" + string + "\",\"" + string2 + "\"):" + JResource.getMessage("API_01") + string + '.');
        }
        return 0.0f;
    }

    public double getDouble(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetNumber) {
                    return jetProperty instanceof JetUnitNumber && this.unit != 2 ? this.convertOut((JetUnitNumber)jetProperty) : ((JetNumber)jetProperty).doubleValue();
                }
                this.setError("getDouble(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_09", (Object)string2));
            } else {
                this.setError("getDouble(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_03", new String[]{string2, string}));
            }
        } else {
            this.setError("getDouble(\"" + string + "\",\"" + string2 + "\"):" + JResource.getMessage("API_01") + string + '.');
        }
        return 0.0;
    }

    public String getString(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetString) {
                    return ((JetString)jetProperty).get();
                }
                if (jetProperty instanceof JetEnumeration) {
                    return ((JetEnumeration)jetProperty).getCurKey();
                }
                if (jetProperty instanceof JetQualifyReference) {
                    return ((JetQualifyReference)jetProperty).toString();
                }
                if (jetProperty instanceof JetVector) {
                    String[] stringArray = ((JetVector)jetProperty).toStringArray();
                    return stringArray.length == 0 ? "" : stringArray[0];
                }
                if (jetProperty instanceof JetLink) {
                    return ((JetLink)jetProperty).toString();
                }
                this.setError("getString(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_10", (Object)string2));
            } else {
                this.setError("getString(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_03", new String[]{string2, string}));
            }
        } else {
            this.setError("getString(\"" + string + "\",\"" + string2 + "\"):" + JResource.getMessage("API_01") + string + '.');
        }
        return "";
    }

    public String[] getStringArray(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        String[] stringArray = new String[]{};
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetVector) {
                    stringArray = ((JetVector)jetProperty).toStringArray();
                } else {
                    this.setError("getStringArray(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_13", (Object)string2));
                }
            } else {
                this.setError("getStringArray(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_03", new String[]{string2, string}));
            }
        } else {
            this.setError("getStringArray(\"" + string + "\",\"" + string2 + "\"):" + JResource.getMessage("API_01") + string + '.');
        }
        return stringArray;
    }

    public Color getColor(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetColor) {
                    return ((JetColor)jetProperty).get();
                }
                this.setError("getColor(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_1", (Object)string2));
            } else {
                this.setError("getColor(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_03", new String[]{string2, string}));
            }
        } else {
            this.setError("getColor(\"" + string + "\",\"" + string2 + "\"): " + JResource.getMessage("API_01") + string + '.');
        }
        return Color.lightGray;
    }

    public String[] getHandles() {
        int n = 0;
        String[] stringArray = new String[this.handles.size()];
        Enumeration enumeration = this.handles.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String[] getHandles(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            String[] stringArray;
            if (jetObject instanceof JetContainable) {
                Vector vector = ((JetContainable)((Object)jetObject)).getChildren();
                stringArray = new String[vector.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = ((JetObject)vector.elementAt(i)).getQualifyName();
                }
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        this.setError("getHandles(\"" + string + "\"):" + JResource.getMessage("API_01") + string + '.');
        return new String[0];
    }

    public String[] getHandles(String string, int n) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            String[] stringArray;
            int n2 = 0;
            if (jetObject instanceof JetContainable) {
                Vector vector = ((JetContainable)((Object)jetObject)).getChildren();
                stringArray = new String[vector.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    JetObject jetObject2 = (JetObject)vector.elementAt(i);
                    if (n != this.getClassType(jetObject2)) continue;
                    stringArray[n2++] = jetObject2.getQualifyName();
                }
                if (n2 < stringArray.length) {
                    String[] stringArray2 = new String[n2];
                    System.arraycopy(stringArray, 0, stringArray2, 0, n2);
                    stringArray = stringArray2;
                }
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        this.setError("getHandles(\"" + string + "\"," + n + "):" + JResource.getMessage("API_01") + string + '.');
        return new String[0];
    }

    public String[] getHandles(String string, int n, int n2) {
        this.clearMsg();
        if (n2 == 0) {
            return this.getHandles(string, n);
        }
        if (n2 < 0) {
            return this.getHandles(string, n, 16);
        }
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            String[] stringArray;
            Vector vector = new Vector();
            Vector<String> vector2 = new Vector<String>();
            Stack<Node> stack = new Stack<Node>();
            Node node = new Node(string, n2);
            stack.push(node);
            while (!stack.empty()) {
                this.getSubNode(stack, vector);
            }
            int n3 = vector.size();
            while (--n3 >= 0) {
                stringArray = this.getHandles((String)vector.elementAt(n3), n);
                int n4 = stringArray.length;
                while (--n4 >= 0) {
                    vector2.addElement(stringArray[n4]);
                }
            }
            int n5 = vector2.size();
            stringArray = new String[n5];
            n3 = n5;
            while (--n3 >= 0) {
                stringArray[n3] = (String)vector2.elementAt(n3);
            }
            return stringArray;
        }
        this.setError("getHandles(\"" + string + "\"," + n + "):" + JResource.getMessage("API_01") + string + '.');
        return new String[0];
    }

    void getSubNode(Stack stack, Vector vector) {
        Node node = (Node)stack.pop();
        if (node.deepth > 0) {
            String[] stringArray = this.getHandles(node.name);
            vector.addElement(node.name);
            --node.deepth;
            int n = stringArray.length;
            while (--n >= 0) {
                stack.push(new Node(stringArray[n], node.deepth));
            }
        }
    }

    public String getInstanceName(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return jetObject.getInstName();
        }
        this.setError("getInstanceName(\"" + string + "\"):" + JResource.getMessage("API_01") + string + '.');
        return null;
    }

    public String getQualifyName(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return jetObject.getQualifyName();
        }
        this.setError("getQualifyName(\"" + string + "\"):" + JResource.getMessage("API_01") + string + '.');
        return null;
    }

    public int getClassType(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return this.getClassType(jetObject);
        }
        this.setError("getClassType(\"" + string + "\"):" + JResource.getMessage("API_01") + string + '.');
        return -1;
    }

    public String getParent(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetContainable jetContainable = jetObject.getParent();
            if (jetContainable != null) {
                return ((JetObject)((Object)jetContainable)).getQualifyName();
            }
            this.setWarning("getParent(\"" + string + "\"): " + JResource.getMessage("API_15", (Object)string));
        } else {
            this.setError("getParent(\"" + string + "\"):" + JResource.getMessage("API_01") + string + '.');
        }
        return null;
    }

    public String getWarning() {
        return this.warning;
    }

    public void clearWarning() {
        this.warning = null;
    }

    public String getError() {
        return this.error;
    }

    public void clearError() {
        this.error = null;
    }

    public void clearMsg() {
        this.warning = null;
        this.error = null;
    }

    public boolean setLog(OutputStream outputStream, String string) {
        this.clearMsg();
        try {
            this.log = new PrintWriter(new OutputStreamWriter(outputStream, string));
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.log = new PrintWriter(new OutputStreamWriter(outputStream));
            this.setWarning(unsupportedEncodingException);
            return false;
        }
    }

    public boolean setLog(String string, boolean bl) {
        try {
            this.setLog(new FileOutputStream(string, bl), "8859_1");
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setWarning(fileNotFoundException);
            return false;
        }
    }

    public boolean setLog(String string) {
        return this.setLog(string, false);
    }

    public void writeLog(String string) {
        if (this.log != null) {
            this.log.print('\n');
            this.log.print(string);
            this.log.flush();
        }
    }

    public void writeLog(String string, Throwable throwable) {
        if (this.log != null) {
            this.log.print('\n');
            this.log.print(string);
            throwable.printStackTrace(this.log);
            this.log.flush();
        }
    }

    public void closeLog() throws IOException {
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
    }

    void setWarning(String string) {
        this.warning = string;
        this.writeLog(this.addElement + string);
    }

    void setWarning(Exception exception) {
        this.warning = exception.getMessage();
        this.writeLog(this.addElement, exception);
    }

    protected void setError(String string) {
        this.error = string;
        this.writeLog(this.SEDU + string);
    }

    void setError(Exception exception) {
        this.error = exception.getMessage();
        this.writeLog(this.SEDU, exception);
    }

    protected void createHandles(JetContainable jetContainable, String string) {
        Vector vector = jetContainable.getChildren();
        string = string + '.';
        int n = vector.size();
        while (--n >= 0) {
            JetObject jetObject = (JetObject)vector.elementAt(n);
            String string2 = string + jetObject.getInstName();
            this.handles.put(string2, jetObject);
            if (!(jetObject instanceof JetContainable)) continue;
            this.createHandles((JetContainable)((Object)jetObject), string2);
        }
    }

    protected void createHandles(JetRptChartLabel jetRptChartLabel, String string) {
        this.handles.put(string, jetRptChartLabel);
    }

    protected void destroyHandles(JetContainable jetContainable, String string) {
        Vector vector = jetContainable.getChildren();
        string = string + '.';
        int n = vector.size();
        while (--n >= 0) {
            JetObject jetObject = (JetObject)vector.elementAt(n);
            String string2 = string + jetObject.getInstName();
            this.handles.remove(string2);
            if (!(jetObject instanceof JetContainable)) continue;
            this.destroyHandles((JetContainable)((Object)jetObject), string2);
        }
    }

    abstract int getClassType(JetObject var1);

    boolean convertIn(JetNumber jetNumber, double d) {
        if (this.unit != 2 && jetNumber instanceof JetUnitNumber) {
            ((JetUnitNumber)jetNumber).setUnitValue(this.unit == 0 ? Unit.convertInchToUnit(d) : Unit.convertCentimeterToUnit(d));
            return true;
        }
        return false;
    }

    double convertOut(JetUnitNumber jetUnitNumber) {
        return this.unit == 0 ? Unit.convertUnitToInch(jetUnitNumber.getUnit()) : Unit.convertUnitToCentimeter(jetUnitNumber.getUnit());
    }

    String validateProp(JetProperty jetProperty, String string, String string2) {
        if (jetProperty == null) {
            return JResource.getMessage("API_03", new String[]{string2, string});
        }
        int n = jetProperty.getEditFlag();
        if (n == 0 || n == 3) {
            return JResource.getMessage("API_04", (Object)string2);
        }
        return null;
    }

    boolean exist(String[] stringArray, String string) {
        boolean bl = false;
        int n = stringArray.length;
        while (--n >= 0) {
            if (!stringArray[n].equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String[] getChildren(String string) {
        this.clearMsg();
        String[] stringArray = new String[]{};
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null && jetObject instanceof JetContainable) {
            Vector vector = ((JetContainable)((Object)jetObject)).getChildren();
            int n = vector.size();
            JetObject jetObject2 = null;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                jetObject2 = (JetObject)vector.elementAt(i);
                stringArray[i] = jetObject2.getQualifyName();
            }
        } else {
            this.setError("getChildren(\"" + string + "\"):" + JResource.getMessage("API_01") + string + '.');
        }
        return stringArray;
    }
}

