/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.wsdl20.Description;
import com.jinfonet.dataservice.api.wsdl20.InterfaceOperation;
import com.jinfonet.dataservice.api.wsdl20.Service;
import com.jinfonet.dataservice.expression.unchecked.UnCheckedOperatorImpl;
import com.jinfonet.security.api.Permissions;
import guitools.toolkit.JDebug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.acl.Permission;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.namespace.QName;
import jet.JRException;
import jet.JRStopEngineException;
import jet.JResource;
import jet.api.API;
import jet.api.AndInfo;
import jet.api.BLCategoryInfo;
import jet.api.BLDetailInfo;
import jet.api.BLDimensionInfo;
import jet.api.BLFilterInformation;
import jet.api.BLHierarchyInfo;
import jet.api.BLMeasureInfo;
import jet.api.BLNodeInformation;
import jet.api.BVAggregationInfo;
import jet.api.BVDetailInfo;
import jet.api.BVGroupInfo;
import jet.api.BusinessViewCategoryInfo;
import jet.api.ConnectionInfo;
import jet.api.CrossReferenceConfigure;
import jet.api.Designer;
import jet.api.DesignerErrorException;
import jet.api.DesignerFactory;
import jet.api.ExpressionFieldInfo;
import jet.api.ExpressionGroupInfo;
import jet.api.ExpressionInfo;
import jet.api.ExpressionNode;
import jet.api.FormulaInfo;
import jet.api.JRUDSHostVariableContainerAPI;
import jet.api.JoinInfo;
import jet.api.ObjectInfo;
import jet.api.ParameterInfo;
import jet.api.QBEInfo;
import jet.api.QueryAndInfo;
import jet.api.QueryFieldInfo;
import jet.api.QueryJoinInfo;
import jet.api.QueryQBEInfo;
import jet.api.QuerySubQueryInfo;
import jet.api.QueryTableInfo;
import jet.api.SpecFuncDateTimeInfo;
import jet.api.SpecFuncInfo;
import jet.api.SpecFuncNumInfo;
import jet.api.SpecFuncStringInfo;
import jet.api.SpecFuncValueChangeInfo;
import jet.api.SubQueryInfo;
import jet.api.SummaryInfo;
import jet.api.TableInfo;
import jet.api.UDSColumnInfo;
import jet.api.UnionInfo;
import jet.api.UnionInfos;
import jet.api.WherePortionInfo;
import jet.connect.DbColDesc;
import jet.connect.DbProcedure;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IBinary;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IMulti;
import jet.dataengine.api.expression.IOperatorFactory;
import jet.dataengine.api.expression.ISingle;
import jet.dataengine.api.expression.ITriple;
import jet.dataengine.api.expression.IUnCheckedExpression;
import jet.dataengine.api.expression.tuple.IConditionExpression;
import jet.dataengine.api.expression.tuple.IMultiLogicExpression;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.api.expression.tuple.IUnCheckedBinaryExpression;
import jet.dataengine.api.expression.tuple.IUnCheckedMultiExpression;
import jet.dataengine.api.expression.tuple.op.IBinaryConditionOperator;
import jet.dataengine.api.expression.tuple.op.IMultiLogicOperator;
import jet.dataengine.api.expression.tuple.op.ISingleConditionOperator;
import jet.dataengine.api.expression.tuple.op.ITripleConditionOperator;
import jet.dataengine.api.expression.tuple.op.ITupleOperator;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IUnCheckedVariableExpression;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.xml.MetadataContainerImpl;
import jet.datasource.JRHierarchicalDataSource;
import jet.datasource.JRHierarchicalDatasetMetaData;
import jet.datasource.JRResultSet;
import jet.datasource.JRUserDataSource;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.LoadUserDataSourceException;
import jet.datasource.hds.AnalyXSD;
import jet.datasource.hds.HDSElementNode;
import jet.exception.FormulaSyntaxErrorException;
import jet.exception.InvalidParameterException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.ParamDesc;
import jet.formula.SumaryFuncs;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.rptservice.api.ISecurityProvider;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUConnection;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUHDSField;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUProcParameter;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTable;
import jet.universe.JetUTableView;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUView;
import jet.universe.JetUWSOperationConnection;
import jet.universe.JetUWebServiceConnection;
import jet.universe.JetUWherePortion;
import jet.universe.JetUXMLConnection;
import jet.universe.RefResourceException;
import jet.universe.ReferenceResource;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DTInformation;
import jet.universe.businesslogic.DetailInformation;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.FilterInfo;
import jet.universe.businesslogic.HierarchyContainer;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JBusinessView;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.impl.Aggregation;
import jet.universe.businesslogic.impl.BLNodeImpl;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.businesslogic.impl.BusinessView;
import jet.universe.businesslogic.impl.Category;
import jet.universe.businesslogic.impl.DataElement;
import jet.universe.businesslogic.impl.Detail;
import jet.universe.businesslogic.impl.DetailInfo;
import jet.universe.businesslogic.impl.Dimension;
import jet.universe.businesslogic.impl.Group;
import jet.universe.businesslogic.impl.Hierarchy;
import jet.universe.businesslogic.impl.HierarchyContainerImpl;
import jet.universe.businesslogic.impl.Measure;
import jet.universe.businesslogic.impl.Prefilter;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.UniverseFileException;
import jet.universe.psql.BadFileQueryException;
import jet.universe.psql.FileQuery;
import jet.universe.psql.RptPsqlQuery;
import jet.universe.psql.RptPsqlTools;
import jet.universe.summary.JetUSpecFuncDateTime;
import jet.universe.summary.JetUSpecFuncInfo;
import jet.universe.summary.JetUSpecFuncNum;
import jet.universe.summary.JetUSpecFuncString;
import jet.universe.summary.JetUSpecFuncValChan;
import jet.universe.webservice.wsdl_1.JetUOperation;
import jet.universe.webservice.wsdl_1.JetUPortType;
import jet.universe.webservice.wsdl_1.JetUService11;
import jet.util.IntKeyHashtable;
import jet.util.UnionVerifier;
import jet.xml.model.AttValuesNode;
import jet.xml.model.ElementNode;
import jet.xml.model.FetchXMLStruct;
import toolkit.db.ColumnInfo;
import toolkit.db.ColumnInfoTree;
import toolkit.db.ConnectionToolkit;
import toolkit.db.DataSourceInfo;
import toolkit.db.DateTimeFormat;
import toolkit.db.DbTools;
import toolkit.db.EnhancedDataSourceInfo;
import toolkit.db.ParameterFormatInvalid;
import toolkit.db.ProcInfo;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlFKey;
import toolkit.db.PsqlFKeyCol;
import toolkit.db.PsqlJdbcDSInfo;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlKeyCol;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.PsqlUnion;
import toolkit.db.gui.JdbcDatabase;
import toolkit.db.gui.MappingSQLType;

public class CatalogAPI
extends API {
    String suffix = ".cat";
    final int iFixedVersionNumber = 16;
    protected static SecurityData secData;
    public static final int CATALOG = 0;
    public static final int CONNECTION = 1;
    public static final int TABLE = 2;
    public static final int VIEW = 3;
    public static final int COLUMN = 4;
    public static final int QUERY = 5;
    public static final int PROCEDURE = 6;
    public static final int FILESQL = 7;
    public static final int UDS = 8;
    public static final int FORMULA = 9;
    public static final int SUMMARY = 10;
    public static final int PARAMETER = 11;
    public static final int WHEREPORTION = 12;
    public static final int SYNONYM = 13;
    public static final int ALIAS = 14;
    public static final int DATABASE = 15;
    public static final int HDS = 16;
    public static final int BUSINESSLOGIC = 17;
    public static final int BUSINESSLOGIC_CATEGORY = 18;
    public static final int BUSINESSLOGIC_DIMENSION = 19;
    public static final int BUSINESSLOGIC_MEASURE = 20;
    public static final int BUSINESSLOGIC_DETAILINFO = 22;
    public static final int BUSINESSLOGIC_HIERARCHY = 23;
    public static final int BUSINESSLOGIC_HIERARCHYCONTAINER = 24;
    public static final int ONDEMAND_QUERY = 25;
    public static final int XML_CONNECTION = 26;
    public static final int XML_MDCONTAINER = 27;
    public static final int BUSINESSVIEW_GROUP = 28;
    public static final int BUSINESSVIEW_AGGREGATION = 29;
    public static final int BUSINESSVIEW_DETAIL = 30;
    public static final int UNIFIEDBUSINESSVIEW = 31;
    public static final int BUSINESSVIEW = 32;
    public static final int JDBC_ODBC_BRIDGE;
    public static final int JDBC;
    public static final int PATTERN_1PART_NAME = 0;
    public static final int PATTERN_2PART_NAME = 1;
    public static final int PATTERN_3PART_NAME = 2;
    public static final int EXTRA_NAME_JDBC = 0;
    public static final int EXTRA_NAME_USERDEFINED = 1;
    public static final int ENCODINGAUTO = 0;
    public static final int ENCODINGYES = 1;
    public static final int ENCODINGNO = 2;
    public static final int TRANSACTION_DEFAULT = 0;
    public static final int TRANSACTION_NONE = 1;
    public static final int TRANSACTION_READ_UNCOMMITTED = 2;
    public static final int TRANSACTION_READ_COMMITTED = 3;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 5;
    public static final int READ_ONLY_DEFAULT = 1;
    public static final int READ_ONLY_TRUE = 2;
    public static final int READ_ONLY_FALSE = 0;
    public static final String INTEGER = "Integer";
    public static final String NUMBER = "Number";
    public static final String STRING = "String";
    public static final String DECIMAL = "Decimal";
    public static final String CURRENCY = "Currency";
    public static final String BOOLEAN = "Boolean";
    public static final String DATE = "Date";
    public static final String TIME = "Time";
    public static final String DATETIME = "DateTime";
    public static final String BINARY = "Binary";
    public static final String PARAMETERS = "Parameters";
    public static final int COUNT = 1;
    public static final int SUM = 2;
    public static final int AVERAGE = 6;
    public static final int MAXIMUM = 4;
    public static final int MINIMUM = 3;
    public static final int POPULATIONSTDDEV = 8;
    public static final int POPULATIONVARIANCE = 9;
    public static final int STDDEV = 10;
    public static final int VARIANCE = 11;
    public static final int DISTINCTCOUNT = 5;
    public static final int RUNNING_COUNT = 16;
    public static final int RUNNING_DISTINCTCOUNT = 20;
    public static final int RUNNING_MAXIMUM = 19;
    public static final int RUNNING_MINIMUM = 18;
    public static final int RUNNING_AVERAGE = 21;
    public static final int RUNNING_SUM = 17;
    public static final int WSDLTYPE_LOCALEFILE = 1;
    public static final int WSDLTYPE_URI = 2;
    private static final String BuildDefaultUniverse = "jdbc:odbc:";
    static final String[] CLASSNAME;
    int reportidx;
    int paramidx;
    int summaryidx;
    int formulaidx;
    JetUUniverse cat;
    private boolean C = true;
    private boolean CreateCatalog = false;
    private DesignerFactory GetFileQueryByResourceName;
    private String GetQueryByResourceName;
    ReferenceResource referResource = null;
    ISecurityProvider securityProvider = null;
    boolean isquery = false;

    CatalogAPI() {
    }

    CatalogAPI(JetUUniverse jetUUniverse, String string, String string2) {
        this(jetUUniverse, string, string2, ".cat");
        this.suffix = ".cat";
    }

    CatalogAPI(JetUUniverse jetUUniverse, String string, String string2, String string3) {
        String string4 = jetUUniverse.getInstName();
        JetUUniverse.setUniverse(jetUUniverse);
        if (string3 == null || string3.length() == 0) {
            string2 = string2 + ".cat";
            this.suffix = ".cat";
        } else if (!string2.endsWith(".cat") && !string2.endsWith(".cat.xml")) {
            if (string3.indexOf(".") == -1) {
                string2 = string2 + "." + string3;
                this.suffix = "." + string3;
            } else {
                string2 = string2 + string3;
                this.suffix = string3;
            }
        }
        jetUUniverse.setFullFileName(new File(string, string2));
        this.cat = jetUUniverse;
        jetUUniverse.setName(this.getCatalogName(string2));
        this.handles.put(string4, jetUUniverse);
        this.createHandles(jetUUniverse, string4);
        this.lookForCurrentReportIndex(string);
    }

    CatalogAPI(String string, String string2) throws ReadFailureException, UniverseFileException {
        this(string, string2, ".cat");
        this.suffix = ".cat";
    }

    CatalogAPI(String string, String string2, String string3) throws ReadFailureException, UniverseFileException {
        if (string3 == null || string3.length() == 0) {
            string2 = string2 + ".cat";
            this.suffix = ".cat";
        } else if (!string2.endsWith(".cat") && !string2.endsWith(".cat.xml")) {
            if (string3.indexOf(".") == -1) {
                string2 = string2 + "." + string3;
                this.suffix = "." + string3;
            } else {
                string2 = string2 + string3;
                this.suffix = string3;
            }
        }
        JetUUniverse.setUniverse(null);
        this.cat = JetUUniverse.LoadNoCache(string, string2, 16);
        JetUUniverse.setUniverse(this.cat);
        String string4 = this.cat.getQualifyName();
        this.handles.put(string4, this.cat);
        this.createHandles(this.cat, string4);
        this.lookForCurrentReportIndex(string);
    }

    protected void setUserID(String string) {
        this.GetQueryByResourceName = string;
    }

    public String getUserID() {
        return this.GetQueryByResourceName;
    }

    protected void setFactory(DesignerFactory designerFactory) {
        this.GetFileQueryByResourceName = designerFactory;
    }

    public boolean save() throws WriteFailureException, FMLFileException {
        JetUUniverse.setUniverse(this.cat);
        boolean bl = this.cat.Save();
        if (this.referResource != null) {
            try {
                this.referResource.saveCatalog();
            }
            catch (RefResourceException refResourceException) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean saveAs(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        this.clearMsg();
        boolean bl = false;
        try {
            bl = this.cat.Save(string, string2);
        }
        catch (Exception exception) {
            this.setError(exception);
        }
        return bl;
    }

    public String getNewQueryName() {
        return this.IsTableNameOK(this.getDefaultDataSourceName());
    }

    public String getNewQueryName(String string) {
        return this.IsTableNameOK(string);
    }

    public String getNewFormulaName() {
        return this.IsModified(this.cat, this.getDefaultDataSourceName());
    }

    public String getNewFormulaName(String string) {
        return this.IsModified(this.cat, string);
    }

    public String getNewReportName() {
        return "report" + String.valueOf(++this.reportidx);
    }

    public String getMappingname(String string) {
        JetUDBTreeNode jetUDBTreeNode = (JetUDBTreeNode)this.handles.get(string);
        if (jetUDBTreeNode != null) {
            return jetUDBTreeNode.getResourceName();
        }
        return null;
    }

    protected boolean quit() {
        if (this.cat == null) {
            return true;
        }
        String string = this.cat.getInstName();
        JetObject jetObject = (JetObject)this.handles.get(string);
        this.clearMsg();
        if (jetObject != null) {
            if (jetObject instanceof JetUUniverse) {
                this.destroyHandles((JetUUniverse)jetObject, string);
                JetUUniverse.setUniverse(null);
                CatalogAPI catalogAPI = this;
                catalogAPI.cat.closeCurrentUniverse();
                this.cat.clearMem();
                this.cat = null;
                return true;
            }
            this.setError("quit():  can not exit.");
        } else {
            this.setError("quit(): can not exit.");
        }
        return false;
    }

    public Designer create(String string, String string2) {
        return new Designer(new CatalogAPI(JetUUniverse.BuildDefaultUniverse(string + File.separatorChar + string2, "Data Source 1"), string, string2));
    }

    public String insert(String string, int n) {
        this.clearMsg();
        String string2 = null;
        if (this.isNameExist("", string, this.cat)) {
            this.setError("insert(\"" + string + "\",\"" + n + "\")" + string + " already exists.");
            return null;
        }
        JetUDBTreeNode jetUDBTreeNode = this.insertObject(string, n, this.cat.getDatabase());
        if (jetUDBTreeNode != null) {
            string2 = jetUDBTreeNode.getQualifyName();
            this.handles.put(string2, jetUDBTreeNode);
        }
        return string2;
    }

    public String insert(String string, String string2, int n) {
        JetUDBTreeNode jetUDBTreeNode;
        this.clearMsg();
        String string3 = null;
        if (this.isNameExist(string, string2, this.cat)) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + n + "\")" + string2 + " already exists.");
            return null;
        }
        if (n == 15) {
            if (this.getDatabase(string, this.cat) != null) {
                this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + n + "\")" + string2 + " already exists.");
                return null;
            }
            JetUDatabase jetUDatabase = this.cat.addDatabase(string);
            jetUDBTreeNode = jetUDatabase;
            this.notifyReference(jetUDBTreeNode, 0);
        } else {
            jetUDBTreeNode = this.insertObject(string2, n, this.getDatabase(string, this.cat));
        }
        if (jetUDBTreeNode != null) {
            string3 = jetUDBTreeNode.getQualifyName();
            this.handles.put(string3, jetUDBTreeNode);
        }
        return string3;
    }

    JetUDBTreeNode insertObject(String string, int n, JetUDatabase jetUDatabase) {
        JetUDBTreeNode jetUDBTreeNode = null;
        boolean bl = false;
        if (jetUDatabase != null) {
            switch (n) {
                case 5: {
                    RptPsqlQuery rptPsqlQuery = new RptPsqlQuery();
                    rptPsqlQuery.setUniverse(jetUDatabase.getUniverse(), jetUDatabase.getResourceName());
                    jetUDBTreeNode = jetUDatabase.addQuery(string, rptPsqlQuery);
                    break;
                }
                case 11: {
                    JetUParameter jetUParameter = new JetUParameter();
                    jetUParameter.name.set(string);
                    jetUParameter.type.set(INTEGER);
                    bl = jetUDatabase.addParameter(jetUParameter);
                    if (!bl) break;
                    jetUDBTreeNode = jetUParameter;
                    break;
                }
                case 9: {
                    JetUFormula jetUFormula = new JetUFormula();
                    jetUFormula.name.set(string);
                    jetUDatabase.addFormula(jetUFormula);
                    jetUDBTreeNode = jetUFormula;
                    break;
                }
                case 10: {
                    JetUSummary jetUSummary = new JetUSummary();
                    jetUSummary.name.set(string);
                    jetUDatabase.addSummary(jetUSummary);
                    jetUDatabase.setFormulaModified(true);
                    try {
                        jetUDatabase.parseSummary(jetUSummary);
                    }
                    catch (ParseFormulaFailedException parseFormulaFailedException) {
                        // empty catch block
                    }
                    jetUDBTreeNode = jetUSummary;
                    break;
                }
                default: {
                    jetUDBTreeNode = null;
                }
            }
            if (jetUDBTreeNode != null) {
                this.notifyReference(jetUDBTreeNode, 0);
            }
        }
        return jetUDBTreeNode;
    }

    public String insert(String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl) {
        return this.insert(string, string2, string3, string4, string5, string6, n, bl, "_");
    }

    public String insert(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7) {
        return this.insert(string, string2, string3, string4, string5, string6, n, string7.length() > 0, string7);
    }

    public String insert(String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl, String string7) {
        return this.insertStoredProcedure(string, null, string2, string3, string4, string5, string6, n, bl, string7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertStoredProcedure(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, boolean bl, String string8) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        if (this.isNameExist(string, string3, this.cat)) {
            this.setError("insert(\"" + string + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\",\"" + string6 + "\",\"" + string7 + "\",\"" + n + "\")" + string3 + " already exists.");
            return null;
        }
        JetObject jetObject = null;
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        ProcInfo procInfo = new ProcInfo(string4, string5, string6, string7, n);
        JetUJDBCConnection jetUJDBCConnection = this.BuildDefaultUniverse(string, string2);
        if (jetUJDBCConnection == null) {
            this.setError("insert(\"" + string + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\",\"" + string6 + "\",\"" + string7 + "\",\"" + n + "\"):there is no connection in current data source. Please insert a connection first.");
            return null;
        }
        Object object = null;
        try {
            object = ConnectionToolkit.getConnection(jetUJDBCConnection);
            procInfo.fetchProcedureParams((Connection)object, jetUJDBCConnection);
            JdbcDatabase jdbcDatabase = new JdbcDatabase(jetUJDBCConnection.getURL(), jetUJDBCConnection.getUID(), jetUJDBCConnection.getPSWD(), jetUJDBCConnection.getJdbcDriver());
            int n2 = jetUJDBCConnection.getQualifiedNamePattern();
            if (procInfo.hasBinaryParameter()) {
                this.setError("insert(\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\",\"" + string6 + "\",\"" + string7 + "\",\"" + n + "\"):The stored procedure  has BINARY type parameters. This is not supported at this time");
                ConnectionToolkit.freeConnection((Connection)object);
                String string9 = null;
                return string9;
            }
            this.runProcedure(string, jdbcDatabase, procInfo, n2, jetUJDBCConnection);
            jetObject = jetUJDBCConnection.addProcedure(string3, procInfo);
            if (jetObject != null) {
                if (procInfo.getINParamsCount() > 0) {
                    this.initProcParameterItems((JetUProcedure)jetObject);
                }
                if (bl) {
                    Vector vector = ((JetUProcedure)jetObject).getFields();
                    if (string8.length() == 0) {
                        string8 = "_";
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        JetUProcField jetUProcField = (JetUProcField)vector.elementAt(i);
                        jetUProcField.setResourceName(string3 + string8 + jetUProcField.getFldName());
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            this.setError(sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.setError(classNotFoundException);
        }
        catch (ParameterFormatInvalid parameterFormatInvalid) {
            this.setError(parameterFormatInvalid);
        }
        catch (JRStopEngineException jRStopEngineException) {
            this.setError(jRStopEngineException);
        }
        finally {
            if (object != null) {
                try {
                    ConnectionToolkit.freeConnection((Connection)object);
                }
                catch (SQLException sQLException) {
                    this.setError(sQLException);
                }
            }
        }
        if (jetObject != null) {
            object = jetObject.getQualifyName();
            this.handles.put(object, jetObject);
            this.createHandles((JetContainable)((Object)jetObject), (String)object);
            this.notifyReference(jetObject, 0);
            return object;
        }
        this.setError("insert(\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\",\"" + string6 + "\",\"" + string7 + "\",\"" + n + "\")can not insert this procedure into connection");
        return null;
    }

    public String insert(String string, String string2, String string3, String string4, String string5, int n, boolean bl) {
        return this.insert(this.getDefaultDataSourceName(), string, string2, string3, string4, string5, n, bl);
    }

    public String insert(String string, String string2, String string3, String string4, String string5, int n) {
        return this.insert(this.getDefaultDataSourceName(), string, string2, string3, string4, string5, n, false);
    }

    public String insert(String string, String string2, String string3, UDSColumnInfo uDSColumnInfo) {
        return this.insert(this.getDefaultDataSourceName(), string, string2, string3, uDSColumnInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String insert(String string, String string2, String string3, String string4, UDSColumnInfo uDSColumnInfo) {
        JetUUserDataSource jetUUserDataSource;
        DataSourceInfo dataSourceInfo;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        if (this.isNameExist(string, string2, this.cat)) {
            this.setError("insert(" + string2 + "," + string3 + "," + string4 + ",UDSColumnInfo):" + string2 + " already exists.");
            return null;
        }
        if (!this.checkClass(string3)) {
            this.setError("insert(\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"udsColInfo\"):can not load class " + string3);
            return null;
        }
        if (uDSColumnInfo == null || uDSColumnInfo.getColInfo() == null) {
            dataSourceInfo = new DataSourceInfo(string2, string3, string4, new JRUDSHostVariableContainerAPI(this.cat));
            dataSourceInfo.setParamNameFormatPair(new Hashtable());
            try {
                dataSourceInfo.initialize();
            }
            catch (LoadUserDataSourceException loadUserDataSourceException) {
                this.setError("insert(" + string2 + "," + string3 + "," + string4 + ",UDSColumnInfo):" + loadUserDataSourceException.getMessage());
            }
            jetUUserDataSource = new JetUUserDataSource(dataSourceInfo);
        } else {
            dataSourceInfo = new EnhancedDataSourceInfo(string2, string3, string4, uDSColumnInfo.getColInfo());
            dataSourceInfo.setParamNameFormatPair(new Hashtable());
            jetUUserDataSource = new JetUUserDataSource((EnhancedDataSourceInfo)dataSourceInfo);
        }
        boolean bl = false;
        JetUDatabase jetUDatabase = null;
        jetUDatabase = string == null || string.length() == 0 ? this.cat.getDatabase() : this.cat.getDatabase(string);
        if (jetUDatabase != null) {
            bl = jetUDatabase.addDataSource(jetUUserDataSource);
        }
        if (!bl) {
            this.setError("insert(\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"udsColInfo\"):insert uds failed");
            return null;
        }
        String string5 = jetUUserDataSource.getQualifyName();
        this.handles.put(string5, jetUUserDataSource);
        this.createHandles(jetUUserDataSource, string5);
        this.notifyReference(jetUUserDataSource, 0);
        return string5;
    }

    public String insert(String string, String string2, String string3, String string4, String string5) {
        return this.insert(this.getDefaultDataSourceName(), string, string2, string3, string4, string5);
    }

    public String insert(String string, String string2, String string3, String string4, String string5, String string6) {
        JetUParameter jetUParameter;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = null;
        jetUDatabase = string == null || string.length() == 0 ? this.cat.getDatabase() : this.cat.getDatabase(string);
        if (this.isNameExist(string, string2, this.cat)) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string6 + "):" + string2 + " already exists.");
            return null;
        }
        if (jetUDatabase == null) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string6 + "):insert parameter failed. Invalid data source name.");
            return null;
        }
        if (DECIMAL.equalsIgnoreCase(string5)) {
            string5 = NUMBER;
        }
        if ((jetUParameter = jetUDatabase.addParameter(string2, string3, string4, string5, string6)) != null) {
            String string7 = jetUParameter.getQualifyName();
            this.handles.put(string7, jetUParameter);
            this.notifyReference(jetUParameter, 0);
            return string7;
        }
        this.setError("insert(\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string6 + "):insert parameter failed");
        return null;
    }

    public String insert(String string, String string2, WherePortionInfo wherePortionInfo) {
        return this.insert(this.getDefaultDataSourceName(), string, string2, wherePortionInfo);
    }

    public String insert(String string, String string2, String string3, WherePortionInfo wherePortionInfo) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUWherePortion jetUWherePortion = new JetUWherePortion(string2, string3, wherePortionInfo.getWherePortion());
        JetUDatabase jetUDatabase = null;
        jetUDatabase = string == null || string.length() == 0 ? this.cat.getDatabase() : this.cat.getDatabase(string);
        if (jetUDatabase == null) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"whereportionInfo" + "):insert wherepotion failed. Void data source name.");
            return null;
        }
        boolean bl = jetUDatabase.addWherePortion(jetUWherePortion);
        if (bl) {
            String string4 = jetUWherePortion.getQualifyName();
            this.handles.put(string4, jetUWherePortion);
            return string4;
        }
        this.setError("insert(\"" + string2 + "\",\"" + string3 + "\",\"whereportionInfo" + "):insert wherepotion failed");
        return null;
    }

    public String insert(String string, String string2, String string3) {
        return this.insert(this.getDefaultDataSourceName(), string, string2, string3);
    }

    public String insert(String string, String string2, String string3, String string4) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = null;
        jetUDatabase = string == null || string.length() == 0 ? this.cat.getDatabase() : this.cat.getDatabase(string);
        if (jetUDatabase == null) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "):insert formula failed. Void data source name.");
        }
        if (this.isNameExist(string, string2, this.cat)) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "):" + string2 + " already exists.");
            return null;
        }
        JetUFormula jetUFormula = jetUDatabase.addFormula(string2, string3, string4);
        if (jetUFormula != null) {
            jetUDatabase.setFormulaModified(true);
            if (this.C) {
                try {
                    jetUDatabase.parseFormulas(true, true);
                }
                catch (ParseFormulaFailedException parseFormulaFailedException) {
                    this.setError(parseFormulaFailedException);
                }
            }
            String string5 = jetUFormula.getQualifyName();
            this.handles.put(string5, jetUFormula);
            this.notifyReference(jetUFormula, 0);
            return string5;
        }
        this.setError("insert(\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "):insert formula failed");
        return null;
    }

    public String insert(String string, String string2, int n, String string3, String string4) {
        return this.insert(this.getDefaultDataSourceName(), string, string2, n, string3, string4);
    }

    public String insert(String string, String string2, String string3, int n, String string4, String string5) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string6 = this.mapFunction(n);
        JetUDatabase jetUDatabase = null;
        jetUDatabase = string == null || string.length() == 0 ? this.cat.getDatabase() : this.cat.getDatabase(string);
        if (jetUDatabase == null) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + n + "\",\"" + string4 + "\",\"" + string5 + "\"):insert summary failed");
        }
        if (this.isNameExist(string, string2, this.cat)) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + n + "\",\"" + string4 + "\",\"" + string5 + "\"):" + string2 + " already exists.");
            return null;
        }
        JetUSummary jetUSummary = jetUDatabase.addSummary(string2, string3, string6, string4, string5);
        if (jetUSummary != null) {
            Object object;
            block7: {
                jetUDatabase.setFormulaModified(true);
                try {
                    if (!this.C && !this.CreateCatalog) {
                        JetUFormula jetUFormula;
                        object = jetUDatabase.getFormulaByResourceName(string4);
                        JetUFormula jetUFormula2 = jetUFormula = string5 != null ? jetUDatabase.getFormulaByResourceName(string5) : null;
                        if (object != null || jetUFormula != null) {
                            this.CreateCatalog = true;
                        }
                    }
                    jetUDatabase.parseSummary(jetUSummary);
                }
                catch (ParseFormulaFailedException parseFormulaFailedException) {
                    if (this.CreateCatalog) break block7;
                    this.setError(parseFormulaFailedException);
                }
            }
            object = jetUSummary.getQualifyName();
            this.handles.put(object, jetUSummary);
            this.notifyReference(jetUSummary, 0);
            return object;
        }
        this.setError("insert(\"" + string2 + "\",\"" + string3 + "\",\"" + n + "\",\"" + string4 + "\",\"" + string5 + "\"):insert summary failed");
        return null;
    }

    public String insert(String string, String string2) {
        return this.insertSql(null, null, string, string2);
    }

    public String insertSql(String string, String string2, String string3) {
        return this.insertSql(string, null, string2, string3);
    }

    public String insertSql(String string, String string2, String string3, String string4) {
        Object object;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        if (this.isNameExist("", string3, this.cat)) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"):" + string3 + " already exists.");
            return null;
        }
        try {
            object = new FileReader(string4);
            ((InputStreamReader)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"):File " + string4 + " cannot be found. Please verify the path and name");
            return null;
        }
        catch (IOException iOException) {
            this.setError("insert(\"" + string3 + "\",\"" + string4 + "\"):File " + string4 + " cannot be loaded.");
            return null;
        }
        try {
            object = this.IsMappingNameOK(string, string2);
            if (object == null) {
                this.setError("insert(\"" + string3 + "\",\"" + string4 + "\"):there is no connection in current universe. Please insert a connection first.");
                return null;
            }
            FileQuery fileQuery = FileQuery.createFileQuery(string4, this.cat, ((JetUConnection)object).getDatabase().getResourceName(), null, ((JetUDBTreeNode)object).getResourceName(), null);
            JetUFileQuery jetUFileQuery = ((JetUConnection)object).addFileQuery(string3, fileQuery);
            if (jetUFileQuery != null) {
                String string5 = jetUFileQuery.getQualifyName();
                this.handles.put(string5, jetUFileQuery);
                this.createHandles(jetUFileQuery, string5);
                this.notifyReference(jetUFileQuery, 0);
                return string5;
            }
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"):can not insert this SQL file into connection.");
        }
        catch (BadFileQueryException badFileQueryException) {
            String string6 = "insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"):" + string4 + " is not a valid  SQL file.\n";
            string6 = string6 + badFileQueryException.getMessage();
            this.setError(string6);
            return null;
        }
        return null;
    }

    public String updateSQLFile(String string, String string2) {
        return this.updateSQLFile(null, string, string2);
    }

    public String updateSQLFile(String string, String string2, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUConnection jetUConnection = this.IsMappingNameOK(string, null);
        if (jetUConnection == null) {
            this.setError("update(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):there is no connection in current universe. Please insert a connection first.");
            return null;
        }
        JetUFileQuery jetUFileQuery = jetUConnection.GetFileQueryByResourceName(string2);
        if (jetUFileQuery == null) {
            this.setError("update(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):Cannot find SQL " + string2 + '.');
        } else {
            try {
                FileReader fileReader = new FileReader(string3);
                fileReader.close();
                FileQuery fileQuery = FileQuery.createFileQuery(string3, this.cat, jetUFileQuery.getDatabase().getResourceName(), null, jetUConnection.getResourceName(), null);
                jetUFileQuery.setFileQuery(fileQuery);
                this.notifyReference(jetUFileQuery, 2);
                String string4 = jetUFileQuery.getQualifyName();
                this.createHandles(jetUFileQuery, string4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.setError("update(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):File " + string3 + " cannot be found. Please verify the path and name");
                return null;
            }
            catch (IOException iOException) {
                this.setError("update(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):File " + string3 + " cannot be loaded.");
                return null;
            }
            catch (BadFileQueryException badFileQueryException) {
                this.setError("update(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):File " + string3 + " is a bad file query.");
                return null;
            }
        }
        return null;
    }

    public String insert(boolean bl, String string, String string2, String string3, String string4) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        ConnectionInfo connectionInfo = new ConnectionInfo("", "", 0, 0, "", DbTools.sQuoteChar, 0, "yyyy-MM-dd", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", false, 0, 1);
        return this.insert(this.getDefaultDataSourceName(), bl, string, string2, string3, string4, connectionInfo);
    }

    public String insert(String string, boolean bl, String string2, String string3, String string4, String string5) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        ConnectionInfo connectionInfo = new ConnectionInfo("", "", 0, 0, "", DbTools.sQuoteChar, 0, "yyyy-MM-dd", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", false, 0, 1);
        return this.insert(string, bl, string2, string3, string4, string5, connectionInfo);
    }

    public String insert(boolean bl, String string, String string2, String string3, String string4, ConnectionInfo connectionInfo) {
        return this.insert(this.getDefaultDataSourceName(), bl, string, string2, string3, string4, connectionInfo);
    }

    public String insert(String string, boolean bl, String string2, String string3, String string4, String string5, ConnectionInfo connectionInfo) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = null;
        if (string != null && string.length() > 0) {
            jetUDatabase = this.cat.getDatabase(string);
            if (jetUDatabase == null) {
                jetUDatabase = this.cat.addDatabase(string);
            }
        } else {
            jetUDatabase = this.cat.getDatabase();
            if (jetUDatabase == null) {
                this.setError("insert(\"" + string + "," + bl + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + connectionInfo.getUID() + "\",\"" + connectionInfo.getPSWD() + "\",\"" + string5 + "\"):  Please insert a datasource first.");
                return null;
            }
        }
        if (this.isNameExist(string, string2, this.cat)) {
            this.setError("insert(\"" + string + "," + bl + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + connectionInfo.getUID() + "\",\"" + connectionInfo.getPSWD() + "\",\"" + string5 + "\"):" + string2 + " already exists.");
            return null;
        }
        try {
            JetUJDBCConnection jetUJDBCConnection = bl ? new JetUJDBCConnection(string2, string3, BuildDefaultUniverse + string4, connectionInfo.getUID(), connectionInfo.getPSWD(), connectionInfo.getQualifiedNamePattern(), null) : new JetUJDBCConnection(string2, string3, string4, connectionInfo.getUID(), connectionInfo.getPSWD(), connectionInfo.getQualifiedNamePattern(), string5);
            jetUJDBCConnection.setOuterJoinMarker(connectionInfo.getOuterJoinMarker());
            jetUJDBCConnection.setQualifiedNamePattern(connectionInfo.getQualifiedNamePattern());
            jetUJDBCConnection.setDateFormat(connectionInfo.getDateFormat());
            jetUJDBCConnection.setTimeFormat(connectionInfo.getTimeFormat());
            jetUJDBCConnection.setTimestampFormat(connectionInfo.getTimestampFormat());
            int n = connectionInfo.getExtraNamePattern();
            if (connectionInfo.getExtraNamePattern() == 1) {
                jetUJDBCConnection.getSupportInfo().setExtraNameChar(connectionInfo.getExtraNameChar());
                jetUJDBCConnection.getSupportInfo().setQuoteChar(connectionInfo.getQuoteNameChar());
            } else {
                try {
                    jetUJDBCConnection.fetchSupportInfo();
                }
                catch (SQLException sQLException) {
                    this.setError("insert(\"" + string + "," + bl + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + connectionInfo.getUID() + "\",\"" + connectionInfo.getPSWD() + "\",\"" + string5 + "\") : invalid strExtraNamePattern " + connectionInfo.getExtraNamePattern() + '.');
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.setError("insert(\"" + string + "," + bl + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + connectionInfo.getUID() + "\",\"" + connectionInfo.getPSWD() + "\",\"" + string5 + "\") : invalid strExtraNamePattern " + connectionInfo.getExtraNamePattern() + '.');
                }
            }
            jetUJDBCConnection.setExtraNamePattern(n);
            jetUJDBCConnection.setEncodingPattern(connectionInfo.getEncodingPattern());
            jetUJDBCConnection.setTransactionIsolation(connectionInfo.getTransactionIsolation());
            jetUJDBCConnection.setReadOnly(connectionInfo.getReadOnly());
            jetUJDBCConnection.setUptoDateSupportInfo(connectionInfo.getUptoDateSI());
            jetUDatabase.addConnection(jetUJDBCConnection);
            String string6 = jetUJDBCConnection.getQualifyName();
            this.handles.put(string6, jetUJDBCConnection);
            return string6;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.setError("insert(\"" + string + "," + bl + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + connectionInfo.getUID() + "\",\"" + connectionInfo.getPSWD() + "\",\"" + string5 + "\") : invalid driver " + string5 + '.');
        }
        catch (SQLException sQLException) {
            this.setError("insert(\"" + string + "," + bl + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + connectionInfo.getUID() + "\",\"" + connectionInfo.getPSWD() + "\",\"" + string5 + "\") : invalid URL " + string4 + '.');
        }
        return null;
    }

    public String insertWSDLConnection(String string, String string2, String string3, String string4, int n, ConnectionInfo connectionInfo) {
        JetUDatabase jetUDatabase;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        if (string != null && string.length() > 0) {
            jetUDatabase = this.cat.getDatabase(string);
            if (jetUDatabase == null) {
                jetUDatabase = this.cat.addDatabase(string);
            }
        } else {
            jetUDatabase = this.cat.getDatabase();
            if (jetUDatabase == null) {
                return null;
            }
        }
        if (this.isNameExist(string, string2, this.cat)) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + connectionInfo + "\"):" + string2 + " already exists.");
            return null;
        }
        try {
            Object object;
            JetUWebServiceConnection jetUWebServiceConnection = new JetUWebServiceConnection(string4, n, null, null, connectionInfo.getWSDLTimeOut());
            jetUWebServiceConnection.setResourceName(string2);
            if (jetUWebServiceConnection.getWsdlVersion() == "20") {
                object = jetUWebServiceConnection.getMemDescription().getServices();
                for (int i = 0; i < ((Service[])object).length; ++i) {
                    QName qName = object[i].getName();
                    InterfaceOperation[] interfaceOperationArray = object[i].getInterface().getInterfaceOperations();
                    for (int j = 0; j < interfaceOperationArray.length; ++j) {
                        QName qName2 = interfaceOperationArray[j].getName();
                        JetUWSOperationConnection jetUWSOperationConnection = jetUWebServiceConnection.createOperationConnection(qName, qName2);
                        if (jetUWSOperationConnection == null) continue;
                        jetUWebServiceConnection.addOperationConnection(jetUWSOperationConnection);
                    }
                }
            } else if (jetUWebServiceConnection.getWsdlVersion() == "11") {
                object = jetUWebServiceConnection.getDefinition().getServices();
                QName qName = null;
                QName qName3 = null;
                QName qName4 = null;
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    qName = ((JetUService11)((Vector)object).get(i)).getQName();
                    Vector vector = ((JetUService11)((Vector)object).get(i)).getRelatedPortTypes();
                    for (int j = 0; j < vector.size(); ++j) {
                        qName3 = ((JetUPortType)vector.get(j)).getQName();
                        Vector vector2 = ((JetUPortType)vector.get(j)).getRelatedOperations();
                        for (int k = 0; k < vector2.size(); ++k) {
                            qName4 = ((JetUOperation)vector2.get(k)).getQName();
                            JetUWSOperationConnection jetUWSOperationConnection = jetUWebServiceConnection.createOperationConnection(qName, qName3, qName4);
                            if (jetUWSOperationConnection == null) continue;
                            jetUWebServiceConnection.addOperationConnection(jetUWSOperationConnection);
                        }
                    }
                }
            }
            jetUWebServiceConnection.setQualifiedNamePattern(connectionInfo.getQualifiedNamePattern());
            jetUWebServiceConnection.setDateFormat(connectionInfo.getDateFormat());
            jetUWebServiceConnection.setTimeFormat(connectionInfo.getTimeFormat());
            jetUWebServiceConnection.setTimestampFormat(connectionInfo.getTimestampFormat());
            int n2 = connectionInfo.getExtraNamePattern();
            if (n2 == 1) {
                jetUWebServiceConnection.getSupportInfo().setExtraNameChar(connectionInfo.getExtraNameChar());
                jetUWebServiceConnection.getSupportInfo().setQuoteChar(connectionInfo.getQuoteNameChar());
            } else {
                try {
                    jetUWebServiceConnection.fetchSupportInfo();
                }
                catch (SQLException sQLException) {
                    this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + connectionInfo + "\") : invalid strExtraNamePattern " + connectionInfo.getExtraNamePattern() + '.');
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + connectionInfo + "\") : invalid strExtraNamePattern " + connectionInfo.getExtraNamePattern() + '.');
                }
            }
            jetUWebServiceConnection.setEncodingPattern(connectionInfo.getEncodingPattern());
            jetUDatabase.addConnection(jetUWebServiceConnection);
            String string5 = jetUWebServiceConnection.getQualifyName();
            this.handles.put(string5, jetUWebServiceConnection);
            return string5;
        }
        catch (JRException jRException) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + connectionInfo + "\") : invalid URL " + string4 + '.');
            return null;
        }
    }

    public static void setSecurityData(SecurityData securityData) {
        secData = securityData;
    }

    public void setSecurityProvider(ISecurityProvider iSecurityProvider) {
        this.securityProvider = iSecurityProvider;
    }

    public QName[] getWSDLServices(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        QName[] qNameArray = null;
        if (jetObject != null && jetObject instanceof JetUWebServiceConnection) {
            Service[] serviceArray;
            Description description = ((JetUWebServiceConnection)jetObject).getMemDescription();
            if (description != null && (serviceArray = description.getServices()) != null) {
                qNameArray = new QName[serviceArray.length];
                for (int i = 0; i < serviceArray.length; ++i) {
                    qNameArray[i] = serviceArray[i].getName();
                }
            }
        } else {
            this.setError("getWSDLServices(\"" + string + "\"): invalid handle.");
        }
        return qNameArray;
    }

    public QName[] getWSDLOperations(String string, QName qName) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        QName[] qNameArray = null;
        if (jetObject != null && jetObject instanceof JetUWebServiceConnection) {
            Description description = ((JetUWebServiceConnection)jetObject).getMemDescription();
            if (description != null) {
                Service service = description.getService(qName);
                if (service != null) {
                    InterfaceOperation[] interfaceOperationArray = service.getInterface().getInterfaceOperations();
                    qNameArray = new QName[interfaceOperationArray.length];
                    for (int i = 0; i < interfaceOperationArray.length; ++i) {
                        qNameArray[i] = interfaceOperationArray[i].getName();
                    }
                } else {
                    this.setError("getWSDLOperations(\"" + string + "\", \"" + qName + "\"): invalid service name.");
                }
            }
        } else {
            this.setError("getWSDLOperations(\"" + string + "\", \"" + qName + "\"): invalid handle.");
        }
        return qNameArray;
    }

    public ConnectionInfo getConnectionInfo() {
        JetUJDBCConnection jetUJDBCConnection = this.BuildDefaultUniverse(null, null);
        if (jetUJDBCConnection != null) {
            ConnectionInfo connectionInfo = new ConnectionInfo(jetUJDBCConnection.getUID(), jetUJDBCConnection.getPSWD(), jetUJDBCConnection.getQualifiedNamePattern(), jetUJDBCConnection.getExtraNamePattern(), jetUJDBCConnection.getSupportInfo().getExtraNameChar(), jetUJDBCConnection.getSupportInfo().getQuoteChar(), jetUJDBCConnection.getEncodingPattern(), jetUJDBCConnection.getDateFormat(), jetUJDBCConnection.getTimeFormat(), jetUJDBCConnection.getTimestampFormat(), jetUJDBCConnection.isUptoDateSupportInfo(), jetUJDBCConnection.getTransactionIsolation(), jetUJDBCConnection.getReadOnly());
            connectionInfo.setOuterJoinMarker(jetUJDBCConnection.getOuterJoinMarker());
            return connectionInfo;
        }
        return null;
    }

    public ConnectionInfo getConnectionInfo(String string) {
        JetUJDBCConnection jetUJDBCConnection = this.BuildDefaultUniverse(string, null);
        if (jetUJDBCConnection != null) {
            ConnectionInfo connectionInfo = new ConnectionInfo(jetUJDBCConnection.getUID(), jetUJDBCConnection.getPSWD(), jetUJDBCConnection.getQualifiedNamePattern(), jetUJDBCConnection.getExtraNamePattern(), jetUJDBCConnection.getSupportInfo().getExtraNameChar(), jetUJDBCConnection.getSupportInfo().getQuoteChar(), jetUJDBCConnection.getEncodingPattern(), jetUJDBCConnection.getDateFormat(), jetUJDBCConnection.getTimeFormat(), jetUJDBCConnection.getTimestampFormat(), jetUJDBCConnection.isUptoDateSupportInfo(), jetUJDBCConnection.getTransactionIsolation(), jetUJDBCConnection.getReadOnly());
            connectionInfo.setOuterJoinMarker(jetUJDBCConnection.getOuterJoinMarker());
            return connectionInfo;
        }
        return null;
    }

    public ConnectionInfo getConnectionInfo(String string, String string2) {
        JetUJDBCConnection jetUJDBCConnection = this.BuildDefaultUniverse(string, string2);
        if (jetUJDBCConnection != null) {
            ConnectionInfo connectionInfo = new ConnectionInfo(jetUJDBCConnection.getUID(), jetUJDBCConnection.getPSWD(), jetUJDBCConnection.getQualifiedNamePattern(), jetUJDBCConnection.getExtraNamePattern(), jetUJDBCConnection.getSupportInfo().getExtraNameChar(), jetUJDBCConnection.getSupportInfo().getQuoteChar(), jetUJDBCConnection.getEncodingPattern(), jetUJDBCConnection.getDateFormat(), jetUJDBCConnection.getTimeFormat(), jetUJDBCConnection.getTimestampFormat(), jetUJDBCConnection.isUptoDateSupportInfo(), jetUJDBCConnection.getTransactionIsolation(), jetUJDBCConnection.getReadOnly());
            connectionInfo.setOuterJoinMarker(jetUJDBCConnection.getOuterJoinMarker());
            return connectionInfo;
        }
        return null;
    }

    public String insert(String string, String string2, String string3, int n) {
        return this.insertTable(this.getDefaultDataSourceName(), null, string3, string, string2, string3, n, null);
    }

    public String insert(String string, String string2, String string3, int n, boolean bl) {
        return this.insertTable(this.getDefaultDataSourceName(), null, string3, string, string2, string3, n, bl ? "_" : null);
    }

    public String insert(String string, String string2, String string3, String string4, int n, boolean bl) {
        return this.insert(string, string2, string3, string4, n, bl ? "_" : null);
    }

    public String insert(String string, String string2, String string3, String string4, int n, String string5) {
        return this.insert(this.getDefaultDataSourceName(), string, string2, string3, string4, n, string5);
    }

    public String insert(String string, String string2, String string3, String string4, String string5, int n, String string6) {
        return this.insertTable(string, null, string2, string3, string4, string5, n, string6);
    }

    public String insertTable(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUJDBCConnection jetUJDBCConnection = null;
        if (jetUDatabase != null) {
            jetUJDBCConnection = this.BuildDefaultUniverse(string, string2);
        }
        if (this.isNameExist(string, string3, this.cat)) {
            this.setError("insert(\"" + string4 + "\",\"" + string5 + "\",\"" + string6 + "\",\"" + n + "\"):" + string3 + " already exists.");
            return null;
        }
        if (jetUJDBCConnection == null) {
            this.setError("insert(\"" + string4 + "\",\"" + string5 + "\",\"" + string6 + "\",\"" + n + "\"):there is no such connection in current data source. Please insert a connection first.");
        } else {
            Vector vector = this.getTablesInDatabase(string, string2, string4, string5, true, n);
            if (!DbTools.hasTheStringInVector(string6, vector)) {
                this.setError("insert(\"" + string4 + "\",\"" + string5 + "\",\"" + string6 + "\",\"" + n + "\"):void tablename " + string6);
            } else {
                int n2 = 0;
                switch (n) {
                    case 2: {
                        n2 = 1;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                    case 14: {
                        n2 = 4;
                        break;
                    }
                    case 13: {
                        n2 = 8;
                        break;
                    }
                    default: {
                        this.setError("insert(\"" + string4 + "\",\"" + string5 + "\",\"" + string6 + "\",\"" + n + "\"):void Type " + n2);
                    }
                }
                try {
                    toolkit.db.TableInfo tableInfo = new toolkit.db.TableInfo(string4, string5, string6, n2);
                    Connection connection = ConnectionToolkit.getConnection(jetUJDBCConnection);
                    tableInfo.getColumns(connection);
                    JetUTableView jetUTableView = jetUJDBCConnection.addTableView(string3 == null || string3.length() == 0 ? string6 : string3, tableInfo, string7 == null || string7.trim().length() == 0 ? null : Character.valueOf(string7.charAt(0)));
                    if (jetUTableView != null) {
                        if (string3 != null && string3.length() > 0) {
                            jetUTableView.setResourceName(string3);
                        } else {
                            string3 = string6;
                        }
                        JetUTableView jetUTableView2 = this.IsMappingNameOK(string, string2).getTableViewsByResourceName(string3, n2);
                        String string8 = jetUTableView2.getQualifyName();
                        this.handles.put(string8, jetUTableView2);
                        this.createHandles(jetUTableView2, string8);
                        ConnectionToolkit.freeConnection(connection);
                        this.notifyReference(jetUTableView2, 0);
                        return string8;
                    }
                    ConnectionToolkit.freeConnection(connection);
                    this.setError("insert(\"" + string4 + "\",\"" + string5 + "\",\"" + string6 + "\",\"" + n + "\"):can not insert table into connection.");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.setError("insert(\"" + string4 + "\",\"" + string5 + "\",\"" + string6 + "\",\"" + n + "\"):can not insert table into connection.");
                }
                catch (SQLException sQLException) {
                    this.setError("insert(\"" + string4 + "\",\"" + string5 + "\",\"" + string6 + "\",\"" + n + "\"):can not insert table into connection.");
                }
            }
        }
        return null;
    }

    protected boolean checkFmlName(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.cat.getFormulasInDatabase(string);
        if (vector != null && string2 != null) {
            int n = vector.size();
            while (--n >= 0) {
                if (!((JetUFormula)vector.elementAt(n)).getResourceName().equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getPrimaryKeys(String string) {
        return this.getPrimaryKeys(this.getDefaultDataSourceName(), string);
    }

    public String[] getPrimaryKeys(String string, String string2) {
        return this.getPrimaryKeys(string, null, string2);
    }

    public String[] getPrimaryKeys(String string, String string2, String string3) {
        JetUTableView jetUTableView;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUConnection jetUConnection = this.IsMappingNameOK(string, string2);
        if (jetUConnection != null && (jetUTableView = jetUConnection.GetTableOrViewByResourceName(string3)) != null) {
            PsqlTable psqlTable = RptPsqlTools.UTableToPsqlTable(jetUTableView, true);
            Vector vector = psqlTable.getPKeyCols();
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = ((PsqlKeyCol)vector.elementAt(i)).getName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getForeignKeys(String string) {
        return this.getForeignKeys(this.getDefaultDataSourceName(), string);
    }

    private JetUJDBCConnection BuildDefaultUniverse(String string, String string2) {
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase != null) {
            JetUConnection jetUConnection = null;
            jetUConnection = string2 == null ? jetUDatabase.getConnection() : jetUDatabase.getConnectionByResourceName(string2);
            if (jetUConnection != null && jetUConnection instanceof JetUJDBCConnection) {
                return (JetUJDBCConnection)jetUConnection;
            }
        }
        return null;
    }

    public String[] getForeignKeys(String string, String string2) {
        return this.getForeignKeys(string, null, string2);
    }

    public String[] getForeignKeys(String string, String string2, String string3) {
        JetUTableView jetUTableView;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUJDBCConnection jetUJDBCConnection = this.BuildDefaultUniverse(string, string2);
        if (jetUJDBCConnection != null && (jetUTableView = jetUJDBCConnection.GetTableOrViewByResourceName(string3)) != null) {
            String[] stringArray;
            Object object;
            PsqlTable psqlTable = RptPsqlTools.UTableToPsqlTable(jetUTableView, true);
            try {
                object = ConnectionToolkit.getConnection(jetUJDBCConnection);
                stringArray = new PsqlJdbcDSInfo((Connection)object, true);
                stringArray.updatePKey(psqlTable);
                ConnectionToolkit.freeConnection((Connection)object);
            }
            catch (SQLException sQLException) {
                this.setError(sQLException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.setError(classNotFoundException);
            }
            object = psqlTable.getFKeys();
            stringArray = new String[((Vector)object).size()];
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                stringArray[i] = ((PsqlKeyCol)((Vector)object).elementAt(i)).getName();
            }
            return stringArray;
        }
        return new String[0];
    }

    boolean getJoinLineWithForeignKeys(JetUDatabase jetUDatabase, RptPsqlQuery rptPsqlQuery) {
        boolean bl = false;
        Vector vector = rptPsqlQuery.getPsqlTablesVector();
        Vector vector2 = rptPsqlQuery.getPsqlJoinsVector();
        CatalogAPI.updatePFKeys(vector, jetUDatabase);
        if (vector.size() > 1) {
            block2: for (int i = 0; i < vector.size(); ++i) {
                PsqlTable psqlTable = (PsqlTable)vector.elementAt(i);
                Vector vector3 = psqlTable.getFKeys();
                if (vector3.isEmpty()) continue;
                for (int j = 0; j < vector3.size(); ++j) {
                    PsqlTable psqlTable2;
                    PsqlFKey psqlFKey = (PsqlFKey)vector3.elementAt(j);
                    Vector vector4 = this.JDBC(vector, psqlFKey.pkqlf, psqlFKey.pkowner, psqlFKey.pkname);
                    if (vector4 == null || vector4.isEmpty()) continue block2;
                    for (int k = 0; k < vector4.size() && !(psqlTable2 = (PsqlTable)vector4.elementAt(k)).getName().equalsIgnoreCase(psqlTable.getName()); ++k) {
                        Vector vector5 = psqlFKey.getKeyColsVector();
                        for (int i2 = 0; i2 < vector5.size(); ++i2) {
                            PsqlColumn psqlColumn;
                            PsqlFKeyCol psqlFKeyCol = (PsqlFKeyCol)vector5.elementAt(i2);
                            String string = psqlFKeyCol.getPKColName();
                            String string2 = psqlFKeyCol.getFKColName();
                            PsqlColumn psqlColumn2 = psqlTable.getColumnByName(string2);
                            if (!this.JDBC_ODBC_BRIDGE(psqlColumn2, psqlColumn = psqlTable2.getColumnByName(string))) continue;
                            try {
                                PsqlJoin psqlJoin = new PsqlJoin(rptPsqlQuery.getPsqlTablesVector(), psqlTable, psqlTable2, psqlColumn2, psqlColumn, "=");
                                if (!this.LoadNoCache(vector2, psqlJoin)) {
                                    vector2.addElement(psqlJoin);
                                }
                                bl = true;
                                continue;
                            }
                            catch (Exception exception) {
                                this.setError(exception);
                            }
                        }
                    }
                }
            }
        }
        rptPsqlQuery.setPsqlJoinsVector(vector2);
        return bl;
    }

    public String insertCompCol(String string, String string2, String string3) {
        return this.insertCompCol(this.getDefaultDataSourceName(), string, string2, string3);
    }

    public String insertCompCol(String string, String string2, String string3, String string4) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = null;
        jetUDatabase = string == null || string.length() == 0 ? this.cat.getDatabase() : this.cat.getDatabase(string);
        if (jetUDatabase == null) {
            this.setError("insertCompCol(" + string + "," + string2 + "," + string3 + "," + string4 + "):invalid query name.");
            return null;
        }
        JetUQuery jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        if (jetUQuery == null) {
            this.setError("insertCompCol(" + string2 + "," + string3 + "," + string4 + "):invalid query name.");
            return null;
        }
        String[] stringArray = this.getCompColumns(jetUQuery);
        if (this.exist(stringArray, string3)) {
            this.setError("insertCompCol(" + string2 + "," + string3 + "," + string4 + "):" + string3 + " already exists.");
        } else {
            this.insertCompCol(jetUQuery, string3, string4);
            JetUResourceEntity jetUResourceEntity = jetUQuery.getFieldByResourceName(string3);
            if (jetUResourceEntity != null) {
                this.handles.put(jetUResourceEntity.getQualifyName(), jetUQuery);
                this.notifyReference(jetUQuery, 2);
                return jetUResourceEntity.getQualifyName();
            }
        }
        return null;
    }

    void insertCompCol(JetUQuery jetUQuery, String string, String string2) {
        PsqlSelColumn psqlSelColumn = new PsqlSelColumn(null, string, -1, "", 0, 0, 0, 0, 0, "");
        psqlSelColumn.setCompCol(true);
        psqlSelColumn.setName(string);
        psqlSelColumn.setExpressionOfCompCol(string2);
        psqlSelColumn.isTypeSet = false;
        jetUQuery.addField(psqlSelColumn);
        jetUQuery.getPsqlQuery().vSelCols.addElement(psqlSelColumn);
    }

    public boolean deleteCompCol(String string, String string2) {
        return this.deleteCompCol(this.getDefaultDataSourceName(), string, string2);
    }

    public boolean deleteCompCol(String string, String string2, String string3) {
        JetUQuery jetUQuery;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = null;
        jetUDatabase = string == null || string.length() == 0 ? this.cat.getDatabase() : this.cat.getDatabase(string);
        if (jetUDatabase == null) {
            this.setError("deleteCompCol(" + string + "," + string2 + "," + string3 + "):invalid data source name.");
        }
        if ((jetUQuery = jetUDatabase.GetQueryByResourceName(string2)) == null) {
            this.setError("deleteCompCol(" + string2 + "," + string3 + "):invalid query name.");
        } else {
            JetUResourceEntity jetUResourceEntity = jetUQuery.getFieldByResourceName(string3);
            if (jetUResourceEntity != null) {
                String string4 = jetUResourceEntity.getQualifyName();
                this.deleteCompCol(jetUQuery, string3);
                this.handles.remove(string4);
                this.notifyReference(jetUQuery, 2);
                return true;
            }
            this.setError("deleteCompCol(" + string2 + "," + string3 + "):invalid column name.");
        }
        return false;
    }

    void deleteCompCol(JetUQuery jetUQuery, String string) {
        Vector vector = jetUQuery.getFields();
        for (int i = 0; i < vector.size(); ++i) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(i);
            if (!(jetUQueryField instanceof JetUCompColQueryField) || !jetUQueryField.getResourceName().equalsIgnoreCase(string)) continue;
            PsqlSelColumn psqlSelColumn = jetUQueryField.getPsqlSelColumn();
            jetUQuery.removeField(jetUQueryField);
            jetUQuery.getPsqlQuery().vSelCols.removeElement(psqlSelColumn);
            break;
        }
    }

    public boolean setCompCol(String string, String string2, String string3) {
        return this.setCompCol(this.getDefaultDataSourceName(), string, string2, string3);
    }

    public boolean setCompCol(String string, String string2, String string3, String string4) {
        JetUQuery jetUQuery;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = null;
        jetUDatabase = string == null || string.length() == 0 ? this.cat.getDatabase() : this.cat.getDatabase(string);
        if (jetUDatabase == null) {
            this.setError("setCompCol(" + string + "," + string2 + "," + string3 + "):void data source name.");
        }
        if ((jetUQuery = jetUDatabase.GetQueryByResourceName(string2)) == null) {
            this.setError("setCompCol(" + string2 + "," + string3 + ", " + string4 + "):invalid query name.");
        } else {
            JetUResourceEntity jetUResourceEntity = jetUQuery.getFieldByResourceName(string3);
            if (jetUResourceEntity != null) {
                return this.setCompCol(jetUQuery, string3, string4);
            }
            this.setError("setCompCol(" + string2 + "," + string3 + ", " + string4 + "):invalid column name.");
        }
        return false;
    }

    boolean setCompCol(JetUQuery jetUQuery, String string, String string2) {
        Vector vector = jetUQuery.getFields();
        for (int i = 0; i < vector.size(); ++i) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(i);
            if (!(jetUQueryField instanceof JetUCompColQueryField) || !jetUQueryField.getResourceName().equalsIgnoreCase(string)) continue;
            PsqlSelColumn psqlSelColumn = jetUQueryField.getPsqlSelColumn();
            psqlSelColumn.setExpressionOfCompCol(string2);
            this.notifyReference(jetUQuery, 2);
            return true;
        }
        return false;
    }

    public String insert(String string, QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo) {
        return this.insert(this.getDefaultDataSourceName(), string, queryFieldInfo, queryJoinInfo, queryQBEInfo, queryAndInfo);
    }

    public String insert(String string, String string2, QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("insert(" + string + "," + string2 + "\" queryFieldInfo, queryJoinInfo, queryQBEInfo, queryAndInfo \"):void data source name");
            return null;
        }
        if (jetUDatabase.getQueriableByResourceName(string2) != null) {
            this.setError("insert(" + string2 + "\" queryFieldInfo, queryJoinInfo, queryQBEInfo, queryAndInfo \"):query \"" + string2 + "\"has exist in the catalog");
            return null;
        }
        Object var9_8 = null;
        if (queryFieldInfo == null) {
            this.setError("insert(" + string2 + "\" queryFieldInfo, queryJoinInfo, queryQBEInfo, queryAndInfo \"):user must specify tables and fields in queryFieldInfo ");
            return null;
        }
        JetUQuery jetUQuery = this.createQuery(string, string2, queryFieldInfo, queryJoinInfo, queryQBEInfo, queryAndInfo, null);
        if (jetUQuery != null) {
            jetUDatabase.addQuery(jetUQuery);
            this.handles.put(jetUQuery.getQualifyName(), jetUQuery);
            this.createHandles(jetUQuery, jetUQuery.getQualifyName());
            this.notifyReference(jetUQuery, 0);
            return jetUQuery.getQualifyName();
        }
        return null;
    }

    JetUTableView getTableOrViewByResourceName(JetUDatabase jetUDatabase, String string) {
        JetUTableView jetUTableView = null;
        Vector vector = jetUDatabase.getConnections();
        for (JetUConnection jetUConnection : vector) {
            jetUTableView = jetUConnection.GetTableOrViewByResourceName(string);
            if (jetUTableView == null) continue;
            return jetUTableView;
        }
        return null;
    }

    private JetUTableView C(JetUDatabase jetUDatabase, String string) {
        JetUTableView jetUTableView = null;
        Vector vector = jetUDatabase.getConnections();
        JetUConnection jetUConnection = jetUDatabase.getConnection();
        if (jetUConnection != null && (jetUTableView = jetUConnection.GetTableOrViewByRealName(string)) != null) {
            return jetUTableView;
        }
        for (JetUConnection jetUConnection2 : vector) {
            jetUTableView = jetUConnection2.GetTableOrViewByResourceName(string);
            if (jetUTableView == null) continue;
            return jetUTableView;
        }
        return null;
    }

    JetUQuery createQuery(String string, String string2, QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo, QuerySubQueryInfo querySubQueryInfo) {
        Vector<Object> vector = new Vector<Object>();
        RptPsqlQuery rptPsqlQuery = new RptPsqlQuery();
        rptPsqlQuery.setUniverse(this.cat, string);
        rptPsqlQuery.setShowMappingName(true);
        JetUDatabase jetUDatabase = this.cat.getDatabase(string);
        if (queryFieldInfo != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            JetUTableView jetUTableView;
            int n;
            Hashtable hashtable = queryFieldInfo.fields;
            Vector vector2 = queryFieldInfo.tables;
            Vector vector3 = queryFieldInfo.formulae;
            if (vector2 != null) {
                n = vector2.size();
                while (--n >= 0) {
                    jetUTableView = this.getTableOrViewByResourceName(jetUDatabase, (String)vector2.elementAt(n));
                    if (jetUTableView != null) {
                        object5 = RptPsqlTools.UTableToPsqlTable(jetUTableView, true);
                        rptPsqlQuery.addPsqlTable((PsqlTable)object5);
                        vector.addElement(object5);
                        object4 = jetUTableView.getFields();
                        for (int i = 0; i < ((Vector)object4).size(); ++i) {
                            JetUField jetUField = (JetUField)((Vector)object4).elementAt(i);
                            object3 = jetUField.getResourceName();
                            rptPsqlQuery.addUFieldByName((String)object3).setMappingName((String)object3);
                        }
                        continue;
                    }
                    this.setError("createQuery(\" QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo \"):void table name [" + (String)vector2.elementAt(n) + "]");
                }
            }
            if (vector3 != null) {
                n = vector3.size();
                while (--n >= 0) {
                    object5 = (String)vector3.elementAt(n);
                    if (this.checkFmlName(string, (String)object5)) {
                        rptPsqlQuery.addUFieldByName((String)object5).setMappingName((String)object5);
                        continue;
                    }
                    this.setError("createQuery(\" QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo \"):void formula name [" + (String)object5 + "]");
                }
            }
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    object5 = (String)enumeration.nextElement();
                    jetUTableView = this.getTableOrViewByResourceName(jetUDatabase, (String)object5);
                    if (jetUTableView != null) {
                        object4 = RptPsqlTools.UTableToPsqlTable(jetUTableView, true);
                        rptPsqlQuery.addPsqlTable((PsqlTable)object4);
                        vector.addElement(object4);
                        Vector vector4 = (Vector)hashtable.get(object5);
                        int n2 = vector4.size();
                        while (--n2 >= 0) {
                            object3 = (String)vector4.elementAt(n2);
                            object2 = jetUTableView.getFieldByFieldName((String)object3);
                            if (object2 == null) {
                                object2 = jetUTableView.getFieldByResourceName((String)object3);
                            }
                            if (object2 != null) {
                                object = ((JetUDBTreeNode)object2).getResourceName();
                                rptPsqlQuery.addUFieldByName((String)object).setMappingName((String)object);
                                continue;
                            }
                            this.setError("createQuery(\" QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo \"):void field name [" + (String)object3 + "]");
                        }
                        continue;
                    }
                    this.setError("createQuery(\" QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo \"):void table name [" + (String)object5 + "]");
                }
            }
            Vector vector5 = rptPsqlQuery.getSelColsVector();
            if (queryJoinInfo != null) {
                object5 = queryJoinInfo.getJoinInfo();
                object4 = new Vector();
                rptPsqlQuery.initialPsqlTables(vector);
                int n3 = ((Vector)object5).size();
                while (--n3 >= 0) {
                    PsqlSelColumn psqlSelColumn;
                    QueryJoinInfo queryJoinInfo2 = (QueryJoinInfo)((Vector)object5).elementAt(n3);
                    object3 = PsqlTable.getTableByWitchName(vector, queryJoinInfo2.getTableFrom(), true);
                    if (object3 == null) {
                        object3 = PsqlTable.getTableByWitchName(vector, queryJoinInfo2.getTableFrom(), false);
                    }
                    if ((object2 = PsqlTable.getTableByWitchName(vector, queryJoinInfo2.getTableTo(), true)) == null) {
                        object2 = PsqlTable.getTableByWitchName(vector, queryJoinInfo2.getTableTo(), false);
                    }
                    if ((object = PsqlSelColumn.getSelColByName(vector5, queryJoinInfo2.getColumnFrom(), true)) == null) {
                        object = PsqlSelColumn.getSelColByName(vector5, queryJoinInfo2.getColumnFrom(), false);
                    }
                    if ((psqlSelColumn = PsqlSelColumn.getSelColByName(vector5, queryJoinInfo2.getColumnTo(), true)) == null) {
                        psqlSelColumn = PsqlSelColumn.getSelColByName(vector5, queryJoinInfo2.getColumnTo(), false);
                    }
                    if (object3 == null) {
                        this.setError("createQuery(\" QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo \"): void \"FROM\" table name [" + queryJoinInfo2.getTableFrom() + "]");
                        continue;
                    }
                    if (object2 == null) {
                        this.setError("createQuery(\" QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo \"): void \"TO\" table name [" + queryJoinInfo2.getTableTo() + "]");
                        continue;
                    }
                    if (object == null) {
                        this.setError("createQuery(\" QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo \"): void \"FROM\" column name [" + queryJoinInfo2.getTableFrom() + "." + queryJoinInfo2.getColumnFrom() + "]");
                        continue;
                    }
                    if (psqlSelColumn == null) {
                        this.setError("createQuery(\" QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo \"): void \"TO\" column name [" + queryJoinInfo2.getTableTo() + "." + queryJoinInfo2.getColumnTo() + "]");
                        continue;
                    }
                    PsqlJoin psqlJoin = new PsqlJoin(vector, (PsqlTable)object3, (PsqlTable)object2, (PsqlColumn)object, psqlSelColumn, queryJoinInfo2.getOperator());
                    psqlJoin.setOuterJoin(queryJoinInfo2.getType());
                    ((Vector)object4).addElement(psqlJoin);
                }
                rptPsqlQuery.setPsqlJoinsVector((Vector)object4);
            }
            if (queryQBEInfo != null) {
                object5 = queryQBEInfo.getQBEInfo();
                object4 = null;
                int n4 = ((Vector)object5).size();
                while (--n4 >= 0) {
                    QueryQBEInfo queryQBEInfo2 = (QueryQBEInfo)((Vector)object5).elementAt(n4);
                    object4 = PsqlSelColumn.getSelColByName(vector5, queryQBEInfo2.getColumnName(), true);
                    if (object4 == null) {
                        object4 = PsqlSelColumn.getSelColByName(vector5, queryQBEInfo2.getColumnName(), false);
                    }
                    if (object4 == null) continue;
                    ((PsqlSelColumn)object4).vConditions.addElement(queryQBEInfo2.getExpression());
                }
                rptPsqlQuery.initialPsqlTables(vector);
            }
            if (queryAndInfo != null || querySubQueryInfo != null) {
                object5 = new Vector();
                if (queryAndInfo != null && ((Vector)(object4 = queryAndInfo.getAndInfoVector())).size() > 0) {
                    for (int i = 0; i < ((Vector)object4).size() / 4; ++i) {
                        String[] stringArray = new String[4];
                        int n5 = i * 4;
                        stringArray[0] = (String)((Vector)object4).elementAt(n5);
                        stringArray[1] = (String)((Vector)object4).elementAt(n5 + 1);
                        stringArray[2] = (String)((Vector)object4).elementAt(n5 + 2);
                        stringArray[3] = (String)((Vector)object4).elementAt(n5 + 3);
                        ((Vector)object5).add(stringArray);
                    }
                }
                if (querySubQueryInfo != null && ((Vector)(object4 = querySubQueryInfo.getSubQueryInfoVector())).size() > 0) {
                    for (int i = 0; i < ((Vector)object4).size() / 4; ++i) {
                        String[] stringArray = new String[4];
                        int n6 = i * 4;
                        stringArray[0] = (String)((Vector)object4).elementAt(n6);
                        stringArray[1] = (String)((Vector)object4).elementAt(n6 + 1);
                        stringArray[2] = (String)((Vector)object4).elementAt(n6 + 2);
                        stringArray[3] = (String)((Vector)object4).elementAt(n6 + 3);
                        ((Vector)object5).add(stringArray);
                    }
                }
                rptPsqlQuery.setSearchConditionGroups(RptPsqlQuery.scGroup2scExpression((Vector)object5));
            }
            object5 = jetUDatabase.addQuery(string2, rptPsqlQuery);
            return object5;
        }
        return null;
    }

    public String insertXMLHDS(String string, String string2, String string3, String string4) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"" + "):insert HDS failed. Invalid data source name.");
            return null;
        }
        if (string3 != null && string3.length() > 0) {
            Object object;
            String string5;
            JetUDBTreeNode jetUDBTreeNode = null;
            String string6 = string5 = !string3.endsWith(".xml") ? this.CreateCatalog(jetUDatabase, string3) : string3;
            if (string4 != null && string4.length() > 0) {
                if (string5 != null && string5.trim().length() > 0) {
                    jetUDBTreeNode = jetUDatabase.addHierDataSource(this.CLASSNAME(string4, string5, jetUDatabase), this.getURI(string3, string4));
                }
            } else if (string5 != null && string5.trim().length() > 0) {
                object = this.read(string5);
                jetUDBTreeNode = jetUDatabase.addHierDataSource((ElementNode)object, this.getURI(string3, string4));
            }
            if (jetUDBTreeNode == null) {
                this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"" + "):insert HDS failed.");
            } else {
                jetUDBTreeNode.setResourceName(string2);
                object = jetUDBTreeNode.getQualifyName();
                this.handles.put(object, jetUDBTreeNode);
                this.notifyReference(jetUDBTreeNode, 0);
                return object;
            }
        }
        return null;
    }

    private ElementNode CLASSNAME(String string, String string2, JetUDatabase jetUDatabase) {
        AnalyXSD analyXSD;
        HDSElementNode hDSElementNode;
        ElementNode elementNode = FetchXMLStruct.fetch(string2);
        String string3 = null;
        if (elementNode != null) {
            string3 = elementNode.getName();
        }
        if ((hDSElementNode = (analyXSD = new AnalyXSD(string2, string, string3, jetUDatabase.getUniverse().getFilePath())).getRootNode()) != null) {
            this.GetFileQueryByResourceName(hDSElementNode);
        }
        return hDSElementNode;
    }

    private ElementNode read(String string) {
        ElementNode elementNode = null;
        if (string != null && string.length() > 0) {
            elementNode = FetchXMLStruct.fetch(string);
        }
        if (elementNode != null) {
            this.GetFileQueryByResourceName(elementNode);
        }
        return elementNode;
    }

    private String CreateCatalog(JetUDatabase jetUDatabase, String string) {
        String string2 = null;
        if (string.startsWith("@") || string.startsWith(":")) {
            string2 = string.substring(1);
        }
        if (string2 != null) {
            Vector vector = jetUDatabase.getParameters();
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2;
                JetUParameter jetUParameter = (JetUParameter)vector.elementAt(i);
                if (!jetUParameter.getResourceName().equalsIgnoreCase(string2) || (vector2 = jetUParameter.getValues()) == null || vector2.size() <= 0) continue;
                String string3 = (String)vector2.elementAt(0);
                if (string3.indexOf(File.separator) <= -1) {
                    string3 = jetUDatabase.getUniverse().getFilePath() + string3;
                }
                return string3;
            }
        }
        return null;
    }

    public String getURI(String string, String string2) {
        String string3 = string2 != null && string2.trim().length() > 0 ? string2.trim() : string.trim();
        int n = string3.lastIndexOf(File.separator);
        if (n > -1 && this.cat.getFilePath().equalsIgnoreCase(string3.substring(0, n + 1))) {
            string3 = string3.substring(n + 1);
        }
        return string3;
    }

    private DefaultMutableTreeNode GetFileQueryByResourceName(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
        ElementNode elementNode = null;
        Vector vector = null;
        if (object instanceof ElementNode) {
            elementNode = (ElementNode)object;
            vector = (Vector)elementNode.getChildren().clone();
            vector.addAll(elementNode.getAttributs().values());
        }
        JetUHDSField jetUHDSField = null;
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            String string = null;
            String string2 = null;
            if (vector.elementAt(i) instanceof AttValuesNode) {
                AttValuesNode attValuesNode = (AttValuesNode)vector.elementAt(i);
                string = attValuesNode.getName();
                string2 = ElementNode.getFullPath(elementNode) + ElementNode.pathDelimer + string;
                jetUHDSField = new JetUHDSField(string, "", string, string2, "", 12, 255, 0, 1, false, true, false);
                if (attValuesNode.getObject() != null) continue;
                attValuesNode.setObject(jetUHDSField);
                continue;
            }
            if (!(vector.elementAt(i) instanceof ElementNode)) continue;
            ElementNode elementNode2 = (ElementNode)vector.elementAt(i);
            if (!elementNode2.isLeaf()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = this.GetFileQueryByResourceName(elementNode2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                continue;
            }
            string = elementNode2.getName();
            string2 = ElementNode.getFullPath(elementNode2);
            jetUHDSField = new JetUHDSField(string, "", string, string2, "", 12, 255, 0, 1, false, false, false);
            if (elementNode2.getObject() != null) continue;
            elementNode2.setObject(jetUHDSField);
        }
        return defaultMutableTreeNode;
    }

    public String insertClassHDS(String string, String string2, String string3, String string4) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"" + "):insert HDS failed. Invalid data source name.");
            return null;
        }
        if (string3 != null && string3.length() > 0) {
            Object object;
            JetUDBTreeNode jetUDBTreeNode = null;
            Object object2 = this.GetTableOrViewByRealName(string3);
            if (object2 != null) {
                try {
                    object = ((JRHierarchicalDataSource)object2).getHierarchicalDataset(string4);
                    JRHierarchicalDatasetMetaData jRHierarchicalDatasetMetaData = object.getMetaData();
                    String string5 = jRHierarchicalDatasetMetaData.getRoot();
                    ElementNode elementNode = new ElementNode(string5);
                    this.GetQueryByResourceName(jRHierarchicalDatasetMetaData, elementNode);
                    jetUDBTreeNode = new JetUHierDataSource(elementNode.getName(), string3, string4);
                    ((JetUHierDataSource)jetUDBTreeNode).hidePros();
                    ((JetUHierDataSource)jetUDBTreeNode).setEltRoot(elementNode);
                }
                catch (JRUserDataSourceException jRUserDataSourceException) {
                    return null;
                }
            }
            if (!jetUDatabase.addHierDataSource((JetUHierDataSource)jetUDBTreeNode)) {
                this.setError("insert(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"" + "):insert HDS failed.");
            } else {
                jetUDBTreeNode.setResourceName(string2);
                object = jetUDBTreeNode.getQualifyName();
                this.handles.put(object, jetUDBTreeNode);
                this.notifyReference(jetUDBTreeNode, 0);
                return object;
            }
        }
        return null;
    }

    private void GetQueryByResourceName(JRHierarchicalDatasetMetaData jRHierarchicalDatasetMetaData, ElementNode elementNode) {
        String[] stringArray = jRHierarchicalDatasetMetaData.getLeafNames(elementNode.getFullPath());
        for (int i = 0; i < stringArray.length; ++i) {
            HDSElementNode hDSElementNode = new HDSElementNode(stringArray[i]);
            elementNode.appendChild(hDSElementNode);
            String string = elementNode.getFullPath();
            String string2 = hDSElementNode.getName();
            int n = jRHierarchicalDatasetMetaData.getLeafType(string, string2);
            int n2 = jRHierarchicalDatasetMetaData.getPrecision(string, string2);
            int n3 = jRHierarchicalDatasetMetaData.getScale(string, string2);
            int n4 = jRHierarchicalDatasetMetaData.isNullable(string, string2);
            boolean bl = jRHierarchicalDatasetMetaData.isCurrency(string, string2);
            boolean bl2 = jRHierarchicalDatasetMetaData.isArray(string, string2);
            JetUHDSField jetUHDSField = new JetUHDSField(string2, "", string2, hDSElementNode.getFullPath(), "", n, n2, n3, n4, bl, bl2);
            hDSElementNode.setObject(jetUHDSField);
        }
        String[] stringArray2 = jRHierarchicalDatasetMetaData.getBranchNames(elementNode.getFullPath());
        for (int i = 0; i < stringArray2.length; ++i) {
            elementNode.appendChild(new ElementNode(stringArray2[i]));
            this.GetQueryByResourceName(jRHierarchicalDatasetMetaData, elementNode.findChildByName(stringArray2[i]));
        }
    }

    private Object GetTableOrViewByRealName(String string) {
        Object var2_2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var2_2 = clazz.newInstance();
            if (!(var2_2 instanceof JRHierarchicalDataSource)) {
                this.setError(clazz.getName() + " can not implement JRHierarchicalDataSource, please reload a proper class file.");
            }
        }
        catch (Exception exception) {
            this.setError(exception);
        }
        return var2_2;
    }

    public boolean deleteQuery(String string) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.cat.getDatabase();
        this.handles.remove(this.getHandle(this.getDefaultDataSourceName(), string, 5));
        return jetUDatabase.removeQuery(string);
    }

    public boolean deleteQuery(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        this.handles.remove(this.getHandle(string, string2, 5));
        return jetUDatabase == null ? false : jetUDatabase.removeQuery(string2);
    }

    public boolean delete(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        return this.delete(this.cat, jetUQuery, string2);
    }

    public boolean deleteQueryTable(String string, String string2, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.delete(this.cat, jetUQuery, string3);
    }

    boolean delete(JetUUniverse jetUUniverse, JetObject jetObject, String string) {
        JetUUniverse.setUniverse(jetUUniverse);
        boolean bl = false;
        if (jetObject != null) {
            if (jetObject instanceof JetUQuery) {
                JetUQuery jetUQuery = (JetUQuery)jetObject;
                RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
                Vector vector = rptPsqlQuery.getPsqlTablesVector();
                PsqlTable psqlTable = null;
                int n = vector.size();
                while (--n >= 0) {
                    PsqlTable psqlTable2 = (PsqlTable)vector.elementAt(n);
                    if (!psqlTable2.getName().equalsIgnoreCase(string)) continue;
                    psqlTable = psqlTable2;
                    break;
                }
                if (!rptPsqlQuery.removePsqlTable(psqlTable)) {
                    this.setError("delete(\"" + jetUQuery.getResourceName() + ",\"" + string + "\"):can not delete table " + string);
                } else {
                    if (rptPsqlQuery.getPsqlTablesVector().size() == 0 && rptPsqlQuery.vSCGrps != null) {
                        rptPsqlQuery.vSCGrps.removeAllElements();
                    }
                    jetUQuery.setPsqlQuery(rptPsqlQuery);
                    rptPsqlQuery.setResolved(false);
                    rptPsqlQuery.resolveAll(((JetUQuery)jetObject).getDatabase().getUniverse());
                    bl = true;
                }
            }
        } else {
            this.setError("Illegal handle: handle is null .");
        }
        return bl;
    }

    public boolean delete(String string, String string2, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        return this.delete((JetObject)jetUQuery, string2, string3);
    }

    public boolean deleteQueryField(String string, String string2, String string3, String string4) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.delete((JetObject)jetUQuery, string3, string4);
    }

    boolean delete(JetObject jetObject, String string, String string2) {
        boolean bl = false;
        if (jetObject != null) {
            if (jetObject instanceof JetUQuery) {
                RptPsqlQuery rptPsqlQuery = ((JetUQuery)jetObject).getPsqlQuery();
                Vector vector = rptPsqlQuery.getSelColsVector();
                PsqlSelColumn psqlSelColumn = null;
                int n = vector.size();
                while (--n >= 0) {
                    PsqlSelColumn psqlSelColumn2 = (PsqlSelColumn)vector.elementAt(n);
                    if (!psqlSelColumn2.getName().equalsIgnoreCase(string2) || !psqlSelColumn2.getTableName().equalsIgnoreCase(string)) continue;
                    psqlSelColumn = psqlSelColumn2;
                    break;
                }
                if (psqlSelColumn == null) {
                    this.setError("delete(\"" + string + "\",\"" + string2 + "\"):table \"" + string + "\"does not have column \"" + string2 + "\"");
                } else if (!rptPsqlQuery.canRemove(psqlSelColumn)) {
                    this.setWarning("delete(\"" + string + "\",\"" + string2 + "\"):column \"" + string2 + "\" can not be deleted");
                } else {
                    rptPsqlQuery.removeQueryField(psqlSelColumn);
                    ((JetUQuery)jetObject).setPsqlQuery(rptPsqlQuery);
                    rptPsqlQuery.setResolved(false);
                    rptPsqlQuery.resolveAll(((JetUQuery)jetObject).getDatabase().getUniverse());
                    this.notifyReference(jetObject, 2);
                    bl = true;
                }
            } else {
                this.setError("delete(\"" + string + "\",\"" + string2 + "\"):void qryName.");
            }
        } else {
            this.setError("delete(\"" + string + "\",\"" + string2 + "\"):void qryName.");
        }
        return bl;
    }

    boolean delete(JetObject jetObject, int n) {
        boolean bl = false;
        if (jetObject != null && jetObject instanceof JetUQuery) {
            JetUQuery jetUQuery = (JetUQuery)jetObject;
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            Vector vector = rptPsqlQuery.getPsqlJoinsVector();
            if (n >= 0 && n < vector.size()) {
                vector.removeElementAt(n);
                rptPsqlQuery.setPsqlJoinsVector(vector);
                rptPsqlQuery.setResolved(false);
                rptPsqlQuery.resolveAll(jetUQuery.getDatabase().getUniverse());
                this.notifyReference(jetObject, 2);
                bl = true;
            } else {
                this.setError("delete(\"" + jetUQuery.getResourceName() + "\",\"" + n + "\"):void index.");
            }
        } else {
            this.setError("delete(\"" + n + "\"):void qryName.");
        }
        return bl;
    }

    public boolean delete(String string, String string2, String string3, String string4, String string5, String string6) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        return this.delete(jetUQuery, string2, string3, string4, string5, string6);
    }

    public boolean delete(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.delete(jetUQuery, string3, string4, string5, string6, string7);
    }

    boolean delete(JetObject jetObject, String string, String string2, String string3, String string4, String string5) {
        boolean bl = false;
        if (jetObject != null) {
            if (jetObject instanceof JetUQuery) {
                JetUQuery jetUQuery = (JetUQuery)jetObject;
                if (string != null && string2 != null && string4 != null && string5 != null && string3 != null) {
                    RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
                    Vector vector = rptPsqlQuery.getPsqlJoinsVector();
                    int n = vector.size();
                    while (--n >= 0) {
                        PsqlJoin psqlJoin = (PsqlJoin)vector.elementAt(n);
                        if (!psqlJoin.getTableFrom().getName().equalsIgnoreCase(string) || !psqlJoin.getColumnFrom().getName().equalsIgnoreCase(string2) || !psqlJoin.getTableTo().getName().equalsIgnoreCase(string4) || !psqlJoin.getColumnTo().getName().equalsIgnoreCase(string5) || !psqlJoin.getOperator().equalsIgnoreCase(string3)) continue;
                        vector.removeElementAt(n);
                        rptPsqlQuery.setPsqlJoinsVector(vector);
                        this.notifyReference(jetObject, 2);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.setError("delete(\"" + jetUQuery.getResourceName() + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"):this query does not have a join matching this join info.");
                    }
                } else {
                    this.setError("delete(\"" + jetUQuery.getResourceName() + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"):void join info.");
                }
            } else {
                this.setError("delete(\"" + ((JetUDBTreeNode)jetObject).getResourceName() + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"):void qryName.");
            }
        } else {
            this.setError("delete(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"):void qryName.");
        }
        return bl;
    }

    public boolean delete(String string, String string2, String string3, String string4) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.cat.GetQueryByResourceName(string);
        if (jetUQuery == null) {
            this.setError("delete(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"):void qryName.");
            return false;
        }
        return this.delete(jetUQuery, string2, string3, string4);
    }

    public boolean deleteQBE(String string, String string2, String string3, String string4, String string5) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase == null) {
            this.setError("delete(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"):void dataSourceName.");
            return false;
        }
        jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        if (jetUQuery == null) {
            this.setError("delete(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"):void qryName.");
            return false;
        }
        return this.delete(jetUQuery, string3, string4, string5);
    }

    boolean delete(JetObject jetObject, String string, String string2, String string3) {
        boolean bl = false;
        if (jetObject != null) {
            if (jetObject instanceof JetUQuery) {
                if (string != null && string2 != null) {
                    JetUQuery jetUQuery = (JetUQuery)jetObject;
                    RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
                    Vector vector = rptPsqlQuery.getSelColsVector();
                    int n = vector.size();
                    while (--n >= 0) {
                        PsqlSelColumn psqlSelColumn = (PsqlSelColumn)vector.elementAt(n);
                        if (psqlSelColumn.getTableName().equalsIgnoreCase(string) && psqlSelColumn.getName().equalsIgnoreCase(string2)) {
                            int n2 = psqlSelColumn.getConditionsVector().size();
                            while (--n2 >= 0) {
                                String string4 = (String)psqlSelColumn.getConditionsVector().elementAt(n2);
                                if (string4 == null || !string4.equalsIgnoreCase(string3)) continue;
                                psqlSelColumn.getConditionsVector().removeElementAt(n2);
                                rptPsqlQuery.setResolved(false);
                                rptPsqlQuery.resolveAll(jetUQuery.getDatabase().getUniverse());
                                bl = true;
                                this.notifyReference(jetUQuery, 2);
                                break;
                            }
                        }
                        if (!bl) continue;
                        break;
                    }
                    if (!bl) {
                        this.setError("delete(\"" + jetUQuery.getResourceName() + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):this query does not have a QBE condition matching this info.");
                    }
                } else {
                    this.setError("delete(\"" + ((JetUDBTreeNode)jetObject).getResourceName() + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):void QBE condition info.");
                }
            } else {
                this.setError("delete(\"" + ((JetUDBTreeNode)jetObject).getResourceName() + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):void qryName.");
            }
        }
        return bl;
    }

    public boolean delete(String string, String string2, String string3, String string4, String string5) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.delete(this.cat.getDatabase().GetQueryByResourceName(string), string2, string3, string4, string5);
    }

    public boolean deleteCondition(String string, String string2, String string3, String string4, String string5, String string6) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.delete(jetUQuery, string3, string4, string5, string6);
    }

    boolean delete(JetObject jetObject, String string, String string2, String string3, String string4) {
        boolean bl = false;
        if (jetObject != null) {
            if (jetObject instanceof JetUQuery) {
                RptPsqlQuery rptPsqlQuery = ((JetUQuery)jetObject).getPsqlQuery();
                IExpression iExpression = rptPsqlQuery.getSearchConditionGroups();
                Vector vector = RptPsqlQuery.convertExpression2Vector(iExpression);
                if (vector != null && vector.size() > 0) {
                    Vector vector2 = (Vector)vector.elementAt(0);
                    for (int i = 0; i < vector2.size(); ++i) {
                        String[] stringArray = (String[])vector2.elementAt(i);
                        if (stringArray[0] != null && !stringArray[0].equalsIgnoreCase(string) || stringArray[1] != null && !stringArray[1].equalsIgnoreCase(string2) || stringArray[2] != null && !stringArray[2].equalsIgnoreCase(string3) || stringArray[3] != null && !stringArray[3].equalsIgnoreCase(string4)) continue;
                        vector2.removeElementAt(i);
                        try {
                            rptPsqlQuery.setSearchConditionGroups(RptPsqlQuery.scGroup2scExpression(vector2));
                        }
                        catch (Exception exception) {
                            this.setError(exception);
                            this.setError("set(\"" + string4 + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):void sql statement.");
                        }
                        rptPsqlQuery.setResolved(false);
                        rptPsqlQuery.resolveAll(((JetUQuery)jetObject).getDatabase().getUniverse());
                        bl = true;
                        this.notifyReference(jetObject, 2);
                        break;
                    }
                }
                if (!bl) {
                    this.setError("delete(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"):this query does not have where condition matching this condition info.");
                }
            } else {
                this.setError("delete(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"):void qryName.");
            }
        } else {
            this.setError("delete(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\"):void qryName.");
        }
        return bl;
    }

    public boolean delete(String string, UnionInfo unionInfo) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.delete(string, unionInfo.getQueryName(), unionInfo.getUnionStatus());
    }

    public boolean delete(String string, String string2, UnionInfo unionInfo) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.deleteUnionQuery(string, string2, unionInfo.getQueryName(), unionInfo.getUnionStatus());
    }

    public boolean delete(String string, String string2, boolean bl) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        if (jetUQuery != null) {
            return this.delete(jetUQuery, string2, bl);
        }
        this.setError("delete(\"" + string + "\",\"" + string2 + "\",\"" + bl + "\"):void qryName.");
        return false;
    }

    public boolean deleteUnionQuery(String string, String string2, String string3, boolean bl) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return jetUQuery == null || this.cat.getDatabase(string) == null ? false : this.delete(this.cat.getDatabase(string).GetQueryByResourceName(string2), string3, bl);
    }

    boolean delete(JetUQuery jetUQuery, String string, boolean bl) {
        boolean bl2 = false;
        if (jetUQuery != null) {
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            Vector vector = rptPsqlQuery.getUnionVector();
            for (int i = 0; i < vector.size(); ++i) {
                PsqlUnion psqlUnion = (PsqlUnion)vector.elementAt(i);
                if (!psqlUnion.getUnionQuery().equalsIgnoreCase(string) || psqlUnion.isUnionAll() ^ bl) continue;
                vector.removeElementAt(i);
                bl2 = true;
                this.notifyReference(jetUQuery, 2);
                break;
            }
            if (!bl2) {
                this.setError("delete(\"" + jetUQuery.getResourceName() + "\",\"" + string + "\",\"" + bl + "\"):this query does not have a union query that matches this union info.");
            }
        } else {
            this.setError("delete(\"" + jetUQuery + "\",\"" + string + "\",\"" + bl + "\"):void qryName.");
        }
        return bl2;
    }

    public boolean setQueryTable(String string, String string2, boolean bl) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.set(this.getDefaultDataSourceName(), this.cat.getDatabase().GetQueryByResourceName(string), string2, false, bl);
    }

    public boolean setQueryTable(String string, String string2, String string3, boolean bl) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.set(string, jetUQuery, string3, false, bl);
    }

    public boolean setQueryTable(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.set(string, jetUQuery, string3, false, bl2);
    }

    boolean set(String string, JetObject jetObject, String string2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (jetObject != null) {
            if (jetObject instanceof JetUQuery) {
                JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
                RptPsqlQuery rptPsqlQuery = ((JetUQuery)jetObject).getPsqlQuery();
                Vector vector = rptPsqlQuery.getPsqlTablesVector();
                int n = vector.size();
                while (--n >= 0) {
                    if (bl) {
                        if (!((PsqlTable)vector.elementAt(n)).getMappingName().equalsIgnoreCase(string2)) continue;
                        this.setError("set(\"" + string2 + "\",\"" + bl2 + "\"):table \"" + string2 + "\"already exists in the query");
                        return bl3;
                    }
                    if (!((PsqlTable)vector.elementAt(n)).getName().equalsIgnoreCase(string2)) continue;
                    this.setError("set(\"" + string2 + "\",\"" + bl2 + "\"):table \"" + string2 + "\"already exists in the query");
                    return bl3;
                }
                JetUTableView jetUTableView = null;
                jetUTableView = bl ? this.getTableOrViewByResourceName(jetUDatabase, string2) : this.C(jetUDatabase, string2);
                PsqlTable psqlTable = RptPsqlTools.UTableToPsqlTable(jetUTableView, false);
                if (psqlTable != null) {
                    rptPsqlQuery.addPsqlTable(psqlTable);
                    if (bl2) {
                        Vector vector2 = jetUTableView.getFields();
                        for (int i = 0; i < vector2.size(); ++i) {
                            JetUField jetUField = (JetUField)vector2.elementAt(i);
                            String string3 = jetUField.getResourceName();
                            rptPsqlQuery.addUFieldByName(string3).setMappingName(string3);
                        }
                    }
                    this.getJoinLineWithForeignKeys(jetUDatabase, rptPsqlQuery);
                    ((JetUQuery)jetObject).setPsqlQuery(rptPsqlQuery);
                    this.notifyReference(jetObject, 2);
                    bl3 = true;
                } else {
                    this.setError("set(\"" + string2 + "\",\"" + bl2 + "\"):void table Name.");
                }
            } else {
                this.setError("set(\"" + string2 + "\",\"" + bl2 + "\"):void query name");
            }
        } else {
            this.setError("set(\"" + string2 + "\",\"" + bl2 + "\"):void qryName.");
        }
        return bl3;
    }

    public boolean set(String string, String string2, String string3, boolean bl) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.set(this.getDefaultDataSourceName(), this.cat.getDatabase().GetQueryByResourceName(string), string2, string3, bl, false);
    }

    public boolean set(String string, String string2, String string3, String string4, boolean bl) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.set(string, jetUQuery, string3, string4, bl, false);
    }

    public boolean setQueryField(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.set(string, jetUQuery, string3, string4, bl2, bl);
    }

    boolean set(String string, JetObject jetObject, String string2, String string3, boolean bl, boolean bl2) {
        boolean bl3 = false;
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase != null && jetObject != null) {
            if (jetObject instanceof JetUQuery) {
                RptPsqlQuery rptPsqlQuery = ((JetUQuery)jetObject).getPsqlQuery();
                Vector vector = rptPsqlQuery.getSelColsVector();
                if (bl) {
                    rptPsqlQuery.addUFieldByName(string3).setMappingName(string3);
                    ((JetUQuery)jetObject).setPsqlQuery(rptPsqlQuery);
                    this.notifyReference(jetObject, 2);
                    bl3 = true;
                } else {
                    JetUTableView jetUTableView = null;
                    jetUTableView = bl2 ? this.getTableOrViewByResourceName(jetUDatabase, string2) : this.C(jetUDatabase, string2);
                    if (jetUTableView != null) {
                        PsqlTable psqlTable = RptPsqlTools.UTableToPsqlTable(jetUTableView, true);
                        boolean bl4 = false;
                        int n = rptPsqlQuery.getPsqlTablesVector().size();
                        while (--n >= 0) {
                            if (bl2) {
                                if (!((PsqlTable)rptPsqlQuery.getPsqlTablesVector().elementAt(n)).getMappingName().equalsIgnoreCase(string2)) continue;
                                bl4 = true;
                                break;
                            }
                            if (!((PsqlTable)rptPsqlQuery.getPsqlTablesVector().elementAt(n)).getName().equalsIgnoreCase(string2)) continue;
                            bl4 = true;
                            break;
                        }
                        if (!bl4) {
                            rptPsqlQuery.addPsqlTable(psqlTable);
                            JetUField jetUField = null;
                            jetUField = bl2 ? jetUTableView.getFieldByResourceName(string3) : jetUTableView.getFieldByFieldName(string3);
                            if (jetUField != null) {
                                String string4 = jetUField.getResourceName();
                                rptPsqlQuery.addUFieldByName(string4).setMappingName(string4);
                                ((JetUQuery)jetObject).setPsqlQuery(rptPsqlQuery);
                                this.notifyReference(jetObject, 2);
                                bl3 = true;
                            } else {
                                this.setError("set(\"" + string2 + "\",\"" + string3 + "\",\"" + bl + "\"):void column name \"" + string3 + "\".");
                            }
                        } else {
                            Object object;
                            n = 0;
                            int n2 = vector.size();
                            while (--n2 >= 0) {
                                object = (PsqlSelColumn)vector.elementAt(n2);
                                if (bl2) {
                                    if (!((PsqlSelColumn)object).getMappingName().equalsIgnoreCase(string3) || !((PsqlSelColumn)object).getPsqlTable().getMappingName().equalsIgnoreCase(string2)) continue;
                                    n = 1;
                                    break;
                                }
                                if (!((PsqlColumn)object).getName().equalsIgnoreCase(string3) || !((PsqlSelColumn)object).getTableName().equalsIgnoreCase(string2)) continue;
                                n = 1;
                                break;
                            }
                            if (n == 0) {
                                JetUField jetUField = null;
                                jetUField = bl2 ? jetUTableView.getFieldByResourceName(string3) : jetUTableView.getFieldByFieldName(string3);
                                if (jetUField != null) {
                                    object = jetUField.getResourceName();
                                    rptPsqlQuery.addUFieldByName((String)object).setMappingName((String)object);
                                    ((JetUQuery)jetObject).setPsqlQuery(rptPsqlQuery);
                                    this.notifyReference(jetObject, 2);
                                    bl3 = true;
                                } else {
                                    this.setError("set(\"" + string2 + "\",\"" + string3 + "\",\"" + bl + "\"):void column name \"" + string3 + "\".");
                                }
                            } else {
                                this.setError("set(\"" + string2 + "\",\"" + string3 + "\",\"" + bl + "\"):field already exists in this query.");
                            }
                        }
                    } else {
                        this.setError("set(\"" + string2 + "\",\"" + string3 + "\",\"" + bl + "\"):void table name \"" + string2 + "\".");
                    }
                }
            }
        } else {
            this.setError("set(\"" + string2 + "\",\"" + string3 + "\",\"" + bl + "\"):void qryName .");
        }
        return bl3;
    }

    public boolean set(String string, JoinInfo joinInfo) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(null, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string);
        }
        return this.set(jetUQuery, joinInfo.getTableFrom(), joinInfo.getColumnFrom(), joinInfo.getOperator(), joinInfo.getTableTo(), joinInfo.getColumnTo(), joinInfo.isSQL92(), joinInfo.getOuterJoinType(), joinInfo.getJoinConditions());
    }

    public boolean set(String string, String string2, JoinInfo joinInfo) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.set(jetUQuery, joinInfo.getTableFrom(), joinInfo.getColumnFrom(), joinInfo.getOperator(), joinInfo.getTableTo(), joinInfo.getColumnTo(), joinInfo.isSQL92(), joinInfo.getOuterJoinType(), joinInfo.getJoinConditions());
    }

    public boolean set(String string, String string2, String string3, String string4, String string5, String string6) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.set(this.cat.getDatabase().GetQueryByResourceName(string), string2, string3, string4, string5, string6, true, 0, null);
    }

    public boolean setJoin(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.set(jetUQuery, string3, string4, string5, string6, string7, true, 0, null);
    }

    public boolean setDistinctQuery(String string, String string2, boolean bl) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null && jetUDatabase.getConnection() instanceof JetUJDBCConnection) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
            if (jetUQuery != null) {
                RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
                rptPsqlQuery.setDistinct(bl);
                return true;
            }
            this.setError("setDistinctQuery(\"" + string + "\",\"" + string2 + "\",\"" + bl + "\"):void query name.");
        } else {
            this.setError("setDistinctQuery(\"" + string + "\",\"" + string2 + "\",\"" + bl + "\"):void datasource name.");
        }
        return false;
    }

    public boolean isDistinctQuery(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
            if (jetUQuery != null) {
                RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
                return rptPsqlQuery.isDistinct();
            }
            this.setError("isDistinctQuery(\"" + string + "\",\"" + string2 + "\"):void query name.");
        } else {
            this.setError("setDistinctQuery(\"" + string + "\",\"" + string2 + "\"):void datasource name.");
        }
        return false;
    }

    public boolean set(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.set(this.cat.getDatabase().GetQueryByResourceName(string), string2, string3, string4, string5, string6, bl, n, null);
    }

    public boolean set(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, int n) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.set(jetUQuery, string3, string4, string5, string6, string7, bl, n, null);
    }

    boolean set(JetUQuery jetUQuery, String string, String string2, String string3, String string4, String string5, boolean bl, int n, Vector vector) {
        boolean bl2;
        block16: {
            bl2 = false;
            if (jetUQuery != null) {
                if (string != null && string2 != null && string4 != null && string5 != null && string3 != null) {
                    Serializable serializable;
                    RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
                    Vector vector2 = rptPsqlQuery.getPsqlJoinsVector();
                    int n2 = vector2.size();
                    while (--n2 >= 0) {
                        serializable = (PsqlJoin)vector2.elementAt(n2);
                        if (!((PsqlJoin)serializable).getTableFrom().getName().equalsIgnoreCase(string) || !((PsqlJoin)serializable).getColumnFrom().getName().equalsIgnoreCase(string2) || !((PsqlJoin)serializable).getTableTo().getName().equalsIgnoreCase(string4) || !((PsqlJoin)serializable).getColumnTo().getName().equalsIgnoreCase(string5) || !((PsqlJoin)serializable).getOperator().equalsIgnoreCase(string3) || ((PsqlJoin)serializable).getOuterJoin() != n) continue;
                        this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"):join already exists in this query.");
                        return bl2;
                    }
                    Vector vector3 = rptPsqlQuery.getSelColsVector();
                    serializable = rptPsqlQuery.getPsqlJoinsVector();
                    try {
                        PsqlTable psqlTable = PsqlTable.getTableByWitchName(rptPsqlQuery.getPsqlTablesVector(), string, true);
                        PsqlTable psqlTable2 = PsqlTable.getTableByWitchName(rptPsqlQuery.getPsqlTablesVector(), string4, true);
                        PsqlSelColumn psqlSelColumn = PsqlSelColumn.getSelColByName(vector3, string2, true);
                        PsqlSelColumn psqlSelColumn2 = PsqlSelColumn.getSelColByName(vector3, string5, true);
                        if (psqlTable == null) {
                            this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"): void \"FROM\" table name: " + string);
                            break block16;
                        }
                        if (psqlTable2 == null) {
                            this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"): void \"TO\" table name: " + string4);
                            break block16;
                        }
                        if (psqlSelColumn == null) {
                            this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"): void \"FROM\" column name: " + string2);
                            break block16;
                        }
                        if (psqlSelColumn2 == null) {
                            this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"): void \"TO\" column name: " + "." + string5);
                            break block16;
                        }
                        PsqlJoin psqlJoin = null;
                        if (vector == null || vector.size() == 0) {
                            psqlJoin = new PsqlJoin(rptPsqlQuery.getPsqlTablesVector(), psqlTable, psqlTable2, psqlSelColumn, psqlSelColumn2, string3);
                        } else {
                            IUnCheckedBinaryExpression iUnCheckedBinaryExpression = null;
                            try {
                                IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
                                IUnCheckedVariableExpression iUnCheckedVariableExpression = iExpressionFactory.createUnCheckedVariableExpression(psqlTable.getMappingName() + "." + ((PsqlColumn)psqlSelColumn).getMappingName());
                                IUnCheckedVariableExpression iUnCheckedVariableExpression2 = iExpressionFactory.createUnCheckedVariableExpression(psqlTable2.getMappingName() + "." + ((PsqlColumn)psqlSelColumn2).getMappingName());
                                UnCheckedOperatorImpl unCheckedOperatorImpl = new UnCheckedOperatorImpl(string3);
                                iUnCheckedBinaryExpression = iExpressionFactory.createUnCheckedBinaryExpression(unCheckedOperatorImpl, iUnCheckedVariableExpression, iUnCheckedVariableExpression2);
                                IUnCheckedExpression[] iUnCheckedExpressionArray = new IUnCheckedExpression[vector.size() + 1];
                                iUnCheckedExpressionArray[0] = iUnCheckedBinaryExpression;
                                for (int i = 0; i < vector.size(); ++i) {
                                    IUnCheckedBinaryExpression iUnCheckedBinaryExpression2 = null;
                                    ExpressionFieldInfo expressionFieldInfo = ((ExpressionInfo)vector.get(i)).get1stExpression();
                                    ExpressionFieldInfo expressionFieldInfo2 = ((ExpressionInfo)vector.get(i)).get2ndExpression();
                                    iUnCheckedVariableExpression = expressionFieldInfo.getExpressionValueType() == 32770 ? iExpressionFactory.createUnCheckedConstantVariableExpression(expressionFieldInfo.getExpressionValue()) : iExpressionFactory.createUnCheckedVariableExpression(expressionFieldInfo.getExpressionValue());
                                    iUnCheckedVariableExpression2 = expressionFieldInfo2.getExpressionValueType() == 32770 ? iExpressionFactory.createUnCheckedConstantVariableExpression(expressionFieldInfo2.getExpressionValue()) : iExpressionFactory.createUnCheckedVariableExpression(expressionFieldInfo2.getExpressionValue());
                                    unCheckedOperatorImpl = new UnCheckedOperatorImpl(((ExpressionInfo)vector.get(i)).getOperator());
                                    iUnCheckedBinaryExpression2 = iExpressionFactory.createUnCheckedBinaryExpression(unCheckedOperatorImpl, iUnCheckedVariableExpression, iUnCheckedVariableExpression2);
                                    iUnCheckedExpressionArray[i + 1] = iUnCheckedBinaryExpression2;
                                }
                                IUnCheckedMultiExpression iUnCheckedMultiExpression = iExpressionFactory.createUnCheckedMultiExpression(new UnCheckedOperatorImpl("And"), iUnCheckedExpressionArray);
                                psqlJoin = new PsqlJoin(rptPsqlQuery.getPsqlTablesVector(), psqlTable, psqlTable2, psqlSelColumn, psqlSelColumn2, string3, iUnCheckedMultiExpression);
                            }
                            catch (ConditionException conditionException) {
                                // empty catch block
                            }
                        }
                        psqlJoin.setOuterJoin(n);
                        ((Vector)serializable).addElement(psqlJoin);
                        rptPsqlQuery.setPsqlJoinsVector((Vector)serializable);
                        rptPsqlQuery.setResolved(false);
                        rptPsqlQuery.resolveAll(jetUQuery.getDatabase().getUniverse());
                        this.notifyReference(jetUQuery, 2);
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"):void join info.");
                        this.setError(exception);
                    }
                } else {
                    this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"):void qryName.");
                }
            } else {
                this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\"):void qryName.");
            }
        }
        return bl2;
    }

    public boolean set(String string, QBEInfo qBEInfo) {
        return this.set(string, qBEInfo.getTableName(), qBEInfo.getColumnName(), qBEInfo.getExpression());
    }

    public boolean set(String string, String string2, String string3, String string4) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.set(this.cat.getDatabase().GetQueryByResourceName(string), string2, string3, string4);
    }

    public boolean setQBE(String string, String string2, String string3, String string4, String string5) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.set(jetUQuery, string3, string4, string5);
    }

    boolean set(JetUQuery jetUQuery, String string, String string2, String string3) {
        boolean bl = false;
        if (jetUQuery != null) {
            if (string != null && string2 != null) {
                RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
                Vector vector = rptPsqlQuery.getSelColsVector();
                int n = vector.size();
                while (--n >= 0) {
                    int n2;
                    PsqlSelColumn psqlSelColumn = (PsqlSelColumn)vector.elementAt(n);
                    if (psqlSelColumn.isCompCol() && psqlSelColumn.getName().equalsIgnoreCase(string2)) {
                        n2 = psqlSelColumn.getConditionsVector().size();
                        while (--n2 >= 0) {
                            if (!((String)psqlSelColumn.getConditionsVector().elementAt(n2)).equalsIgnoreCase(string3)) continue;
                            this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):expression already exists in query.");
                            return bl;
                        }
                        psqlSelColumn.vConditions.addElement(string3);
                        bl = true;
                        continue;
                    }
                    if (psqlSelColumn.isCompCol() || !psqlSelColumn.getTableName().equalsIgnoreCase(string) || !psqlSelColumn.getName().equalsIgnoreCase(string2)) continue;
                    n2 = psqlSelColumn.getConditionsVector().size();
                    while (--n2 >= 0) {
                        if (!((String)psqlSelColumn.getConditionsVector().elementAt(n2)).equalsIgnoreCase(string3)) continue;
                        this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):expression already exists in query.");
                        return bl;
                    }
                    psqlSelColumn.vConditions.addElement(string3);
                    rptPsqlQuery.setResolved(false);
                    rptPsqlQuery.resolveAll(jetUQuery.getDatabase().getUniverse());
                    this.notifyReference(jetUQuery, 2);
                    bl = true;
                }
            } else {
                this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):void QBE info.");
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):void query Name.");
        }
        return bl;
    }

    public String[] getUnionableQueries(String string) {
        this.clearMsg();
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        if (jetUQuery != null) {
            int n;
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            IntKeyHashtable intKeyHashtable = UnionVerifier.getQueryInfo(rptPsqlQuery);
            Vector vector = this.cat.getDatabase().getQueries();
            int n2 = n = vector.size();
            while (--n2 >= 0) {
                if (UnionVerifier.verify(intKeyHashtable, string, (JetUQuery)vector.elementAt(n2))) continue;
                vector.removeElementAt(n2);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = ((JetUQuery)vector.elementAt(i)).getResourceName();
            }
            return stringArray;
        }
        this.setError("getUnionableQueries(\"" + string + "\"):void query name.");
        return new String[0];
    }

    public String[] getUnionableQueries(String string, String string2) {
        this.clearMsg();
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase != null) {
            JetUQuery jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
            if (jetUQuery != null) {
                int n;
                RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
                IntKeyHashtable intKeyHashtable = UnionVerifier.getQueryInfo(rptPsqlQuery);
                Vector vector = jetUDatabase.getQueries();
                int n2 = n = vector.size();
                while (--n2 >= 0) {
                    if (UnionVerifier.verify(intKeyHashtable, string2, (JetUQuery)vector.elementAt(n2))) continue;
                    vector.removeElementAt(n2);
                }
                String[] stringArray = new String[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    stringArray[i] = ((JetUQuery)vector.elementAt(i)).getResourceName();
                }
                return stringArray;
            }
            this.setError("getUnionableQueries(\"" + string2 + "\"):void query name.");
        }
        return new String[0];
    }

    public UnionInfos getUnionInfos(String string) {
        this.clearMsg();
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        if (jetUQuery == null) {
            this.setError("getUnionInfos(" + string + "): invalid query name");
        }
        return this.getUnionInfos(jetUQuery);
    }

    public UnionInfos getUnionInfos(String string, String string2) {
        this.clearMsg();
        JetUQuery jetUQuery = null;
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        if (jetUQuery == null) {
            this.setError("getUnionInfos(" + string2 + "): invalid query name");
        }
        return this.getUnionInfos(jetUQuery);
    }

    UnionInfos getUnionInfos(JetUQuery jetUQuery) {
        UnionInfos unionInfos = new UnionInfos();
        if (jetUQuery != null) {
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            Vector vector = rptPsqlQuery.getUnionVector();
            for (int i = 0; i < vector.size(); ++i) {
                PsqlUnion psqlUnion = (PsqlUnion)vector.elementAt(i);
                UnionInfo unionInfo = new UnionInfo(psqlUnion.getUnionQuery(), psqlUnion.isUnionAll());
                unionInfos.add(unionInfo);
            }
        }
        return unionInfos;
    }

    public String[] getUnionQueries(String string) {
        this.clearMsg();
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        if (jetUQuery == null) {
            this.setError("getUnionQueries(" + string + "): invalid query name");
        }
        return this.getUnionQueries(jetUQuery);
    }

    public String[] getUnionQueries(String string, String string2) {
        this.clearMsg();
        JetUQuery jetUQuery = null;
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        if (jetUQuery == null) {
            this.setError("getUnionQueries(" + string2 + "): invalid query name");
        }
        return this.getUnionQueries(jetUQuery);
    }

    String[] getUnionQueries(JetUQuery jetUQuery) {
        if (jetUQuery != null) {
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            Vector vector = rptPsqlQuery.getUnionVector();
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                PsqlUnion psqlUnion = (PsqlUnion)vector.elementAt(i);
                stringArray[i] = psqlUnion.getUnionQuery();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getUnionQueries(String string, boolean bl) {
        this.clearMsg();
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        if (jetUQuery == null) {
            this.setError("getUnionQueries(" + string + "," + bl + "): invalid query name");
        }
        return this.getUnionQueries(jetUQuery, bl);
    }

    public String[] getUnionQueries(String string, String string2, boolean bl) {
        this.clearMsg();
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        if (jetUQuery == null) {
            this.setError("getUnionQueries(" + string2 + "," + bl + "): invalid query name");
        }
        return this.getUnionQueries(jetUQuery, bl);
    }

    String[] getUnionQueries(JetUQuery jetUQuery, boolean bl) {
        if (jetUQuery != null) {
            PsqlUnion psqlUnion;
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            Vector vector = rptPsqlQuery.getUnionVector();
            int n = vector.size();
            while (--n >= 0) {
                psqlUnion = (PsqlUnion)vector.elementAt(n);
                if (!(psqlUnion.isUnionAll() ^ bl)) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            n = vector.size();
            while (--n >= 0) {
                psqlUnion = (PsqlUnion)vector.elementAt(n);
                stringArray[n] = psqlUnion.getUnionQuery();
            }
            return stringArray;
        }
        return new String[0];
    }

    public boolean set(String string, SubQueryInfo subQueryInfo) {
        this.clearMsg();
        return this.set(string, subQueryInfo.getExpression1(), subQueryInfo.getOperator(), subQueryInfo.getQueryname(), subQueryInfo.getLogic());
    }

    public boolean set(String string, String string2, SubQueryInfo subQueryInfo) {
        this.clearMsg();
        return this.set(string, string2, subQueryInfo.getExpression1(), subQueryInfo.getOperator(), subQueryInfo.getQueryname(), subQueryInfo.getLogic());
    }

    public boolean set(String string, UnionInfo unionInfo) {
        this.clearMsg();
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        if (jetUQuery != null) {
            return this.set(jetUQuery, unionInfo.getQueryName(), unionInfo.getUnionStatus());
        }
        this.setError("set(\"" + string + "\",\"" + unionInfo + "\"):void query name.");
        return false;
    }

    public boolean set(String string, String string2, UnionInfo unionInfo) {
        this.clearMsg();
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        if (jetUQuery != null) {
            return this.set(jetUQuery, unionInfo.getQueryName(), unionInfo.getUnionStatus());
        }
        this.setError("set(\"" + string2 + "\",\"" + unionInfo + "\"):void query name.");
        return false;
    }

    boolean set(JetUQuery jetUQuery, String string, boolean bl) {
        boolean bl2 = false;
        if (string != null && string.length() > 0) {
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            Vector vector = rptPsqlQuery.getUnionVector();
            PsqlUnion psqlUnion = null;
            for (int i = 0; i < vector.size(); ++i) {
                psqlUnion = (PsqlUnion)vector.elementAt(i);
                if (!psqlUnion.getUnionQuery().equalsIgnoreCase(string)) continue;
                ((PsqlUnion)vector.elementAt(i)).setUnionAll(bl);
                bl2 = true;
                this.notifyReference(jetUQuery, 2);
                break;
            }
            if (!bl2) {
                PsqlUnion psqlUnion2 = new PsqlUnion(string, bl);
                vector.addElement(psqlUnion2);
                this.notifyReference(jetUQuery, 2);
                bl2 = true;
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + bl + "\"):void union query name.");
        }
        return bl2;
    }

    public boolean set(String string, AndInfo andInfo) {
        return this.set(string, andInfo.getExpression1(), andInfo.getOperator(), andInfo.getExpression2(), andInfo.getLogic());
    }

    public boolean set(String string, String string2, AndInfo andInfo) {
        return this.set(string, string2, andInfo.getExpression1(), andInfo.getOperator(), andInfo.getExpression2(), andInfo.getLogic());
    }

    public boolean set(String string, String string2, String string3, String string4, String string5) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.set(this.cat.getDatabase().GetQueryByResourceName(string), string2, string3, string4, string5);
    }

    public boolean setCondition(String string, String string2, String string3, String string4, String string5, String string6) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return this.set(jetUQuery, string3, string4, string5, string6);
    }

    boolean set(JetUQuery jetUQuery, String string, String string2, String string3, String string4) {
        boolean bl = false;
        if (jetUQuery != null) {
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            if (rptPsqlQuery.vSCGrps == null) {
                rptPsqlQuery.vSCGrps = new Vector();
            }
            rptPsqlQuery.vSCGrps.addElement(new String[]{string, string2, string3, string4});
            Vector vector = rptPsqlQuery.vSCGrps;
            try {
                rptPsqlQuery.setSearchConditionGroups(RptPsqlQuery.scGroup2scExpression(rptPsqlQuery.vSCGrps));
                rptPsqlQuery.vSCGrps = vector;
            }
            catch (Exception exception) {
                this.setError(exception);
                this.setError("set(\"" + string4 + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):void sql statement.");
            }
            rptPsqlQuery.setResolved(false);
            rptPsqlQuery.resolveAll(jetUQuery.getDatabase().getUniverse());
            this.notifyReference(jetUQuery, 2);
            bl = true;
        } else {
            this.setError("set(\"" + string4 + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):void qryName.");
        }
        return bl;
    }

    boolean set(JetUQuery jetUQuery, AndInfo andInfo, int n) {
        return this.set(jetUQuery, andInfo.getExpression1(), andInfo.getOperator(), andInfo.getExpression2(), andInfo.getLogic(), n);
    }

    boolean set(JetUQuery jetUQuery, String string, String string2, String string3, String string4, int n) {
        boolean bl = false;
        if (jetUQuery != null) {
            Vector vector;
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            if (rptPsqlQuery.vSCGrps == null) {
                rptPsqlQuery.vSCGrps = new Vector();
                rptPsqlQuery.vSCGrps.addElement(new Vector());
            } else if (rptPsqlQuery.vSCGrps.size() == 0) {
                rptPsqlQuery.vSCGrps.addElement(new Vector());
            }
            if (rptPsqlQuery.vSCGrps.size() > 0) {
                vector = (Vector)rptPsqlQuery.vSCGrps.elementAt(0);
            } else {
                vector = new Vector();
                rptPsqlQuery.vSCGrps.addElement(vector);
            }
            if (n >= 0) {
                if (n < vector.size()) {
                    vector.setElementAt(new String[]{string, string2, string3, string4}, n);
                } else {
                    vector.addElement(new String[]{string, string2, string3, string4});
                }
                rptPsqlQuery.setResolved(false);
                rptPsqlQuery.resolveAll(jetUQuery.getDatabase().getUniverse());
                this.notifyReference(jetUQuery, 2);
                bl = true;
            } else {
                this.setError("set(\"" + string4 + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):void qryName.");
            }
        } else {
            this.setError("set(\"" + string4 + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):void qryName.");
        }
        return bl;
    }

    boolean set(JetUQuery jetUQuery, String string, String string2, String string3, int n) {
        boolean bl = false;
        if (jetUQuery != null) {
            if (string != null && string2 != null) {
                RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
                Vector vector = rptPsqlQuery.getSelColsVector();
                int n2 = vector.size();
                while (--n2 >= 0) {
                    PsqlSelColumn psqlSelColumn = (PsqlSelColumn)vector.elementAt(n2);
                    if (psqlSelColumn.isCompCol() && psqlSelColumn.getName().equalsIgnoreCase(string2)) {
                        if (n >= 0 && n < psqlSelColumn.getConditionsVector().size()) {
                            psqlSelColumn.vConditions.setElementAt(string3, n);
                            this.notifyReference(jetUQuery, 2);
                            return true;
                        }
                        psqlSelColumn.vConditions.addElement(string3);
                        bl = true;
                        continue;
                    }
                    if (psqlSelColumn.isCompCol() || !psqlSelColumn.getTableName().equalsIgnoreCase(string) || !psqlSelColumn.getName().equalsIgnoreCase(string2)) continue;
                    if (n >= 0 && n < psqlSelColumn.getConditionsVector().size()) {
                        psqlSelColumn.vConditions.setElementAt(string3, n);
                        this.notifyReference(jetUQuery, 2);
                        return true;
                    }
                    psqlSelColumn.vConditions.addElement(string3);
                    rptPsqlQuery.setResolved(false);
                    rptPsqlQuery.resolveAll(jetUQuery.getDatabase().getUniverse());
                    this.notifyReference(jetUQuery, 2);
                    bl = true;
                }
            } else {
                this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + n + "\"):void QBE info.");
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + n + "\"):void query Name.");
        }
        return bl;
    }

    public boolean set(String string, ParameterInfo parameterInfo) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return this.set(jetObject, parameterInfo);
        }
        this.setError("set parameter info error: illegal handle " + string);
        return false;
    }

    boolean set(JetObject jetObject, ParameterInfo parameterInfo) {
        boolean bl = false;
        if (jetObject != null && jetObject instanceof JetUParameter) {
            int n;
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            for (n = 0; n < parameterInfo.valueLength; ++n) {
                vector.add(parameterInfo.values[n]);
            }
            for (n = 0; n < 2; ++n) {
                vector2.add(parameterInfo.limits[n]);
            }
            ParamDesc paramDesc = new ParamDesc(parameterInfo.getName(), parameterInfo.getType(), parameterInfo.getPrompt(), vector2, vector, parameterInfo.getFormat(), 1, parameterInfo.getIndex());
            paramDesc.setWhenOutOfRange(1);
            if (this.checkParam(parameterInfo)) {
                ((JetUParameter)jetObject).setParameter(paramDesc);
                if (!((JetUParameter)jetObject).getDatabase().IsMappingNameExist(parameterInfo.getName()) || ((JetUParameter)jetObject).getResourceName().equalsIgnoreCase(parameterInfo.getName())) {
                    ((JetUParameter)jetObject).setResourceName(parameterInfo.getName());
                }
                ((JetUParameter)jetObject).InitAfterCreate();
                bl = true;
            }
        }
        return bl;
    }

    public boolean checkParam(ParameterInfo parameterInfo) {
        CharSequence charSequence;
        boolean bl = true;
        Locale locale = Locale.getDefault();
        String string = parameterInfo.getType();
        String string2 = parameterInfo.getFormat();
        if (string2 == null) {
            string2 = "";
        }
        ParamDesc paramDesc = new ParamDesc(parameterInfo.getName(), string, "", null, null, string2, 1, parameterInfo.getIndex());
        Vector<CharSequence> vector = new Vector<CharSequence>();
        if (parameterInfo.getOperator() == 1) {
            charSequence = parameterInfo.limits[0];
            String string3 = parameterInfo.limits[1];
            vector.insertElementAt(charSequence, 0);
            vector.insertElementAt(string3, 1);
        }
        charSequence = new StringBuffer(64);
        try {
            paramDesc.setLimit(vector, locale);
        }
        catch (InvalidParameterException invalidParameterException) {
            ((StringBuffer)charSequence).append(invalidParameterException.getMessage());
            bl = false;
        }
        if (string.equals(PARAMETERS)) {
            for (int i = 0; i < parameterInfo.valueLength; ++i) {
                try {
                    this.GetTableOrViewByResourceName(parameterInfo.values[i]);
                    continue;
                }
                catch (InvalidParameterException invalidParameterException) {
                    ((StringBuffer)charSequence).append("\n " + invalidParameterException.getMessage());
                    bl = false;
                }
            }
        }
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < parameterInfo.valueLength; ++i) {
            vector2.add(parameterInfo.values[i]);
        }
        try {
            paramDesc.setValues(vector2, locale);
        }
        catch (InvalidParameterException invalidParameterException) {
            ((StringBuffer)charSequence).append("\n " + invalidParameterException.getMessage());
            bl = false;
        }
        if (!bl) {
            this.setError("check parameter error:\n " + ((StringBuffer)charSequence).toString());
        }
        return bl;
    }

    private void GetTableOrViewByResourceName(String string) throws InvalidParameterException {
        String string2 = "Invalid parameter value: " + string + ", the valid format should be '@parameter,...'.";
        if (!string.startsWith("@")) {
            throw new InvalidParameterException(string2);
        }
        if (string.indexOf(",") == -1) {
            if (string.length() <= 1 || string.substring(1).indexOf("@") != -1) {
                throw new InvalidParameterException(string2);
            }
            return;
        }
        String[] stringArray = this.InitAfterCreate(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (string3.startsWith("@") && string3.substring(1).indexOf("@") == -1) continue;
            throw new InvalidParameterException(string2);
        }
    }

    private String[] InitAfterCreate(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != ',') continue;
            ++n2;
        }
        String[] stringArray = new String[n2 + 1];
        String string2 = string;
        int n3 = 0;
        while (string2.indexOf(",") != -1) {
            stringArray[n3] = string2.substring(0, string2.indexOf(","));
            string2 = string2.substring(string2.indexOf(",") + 1, string2.length());
            ++n3;
        }
        stringArray[n3] = string2;
        return stringArray;
    }

    public ParameterInfo getParameterInfo(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return this.getParameterInfo(jetObject);
        }
        this.setError("Get parameter info error: illegal handle " + string);
        return null;
    }

    ParameterInfo getParameterInfo(JetObject jetObject) {
        if (jetObject != null && jetObject instanceof JetUParameter) {
            int n;
            JetUParameter jetUParameter = (JetUParameter)jetObject;
            Vector vector = jetUParameter.getParamDesc().getDisplayValues(Locale.getDefault());
            Vector vector2 = jetUParameter.getLimit();
            ParameterInfo parameterInfo = new ParameterInfo(jetUParameter.name.get(), jetUParameter.desc.get(), jetUParameter.type.get(), jetUParameter.getPrompt(), jetUParameter.getFormat(), jetUParameter.getOperation(), jetUParameter.getDefaultIndex());
            if (vector != null) {
                for (n = 0; n < vector.size(); ++n) {
                    parameterInfo.setDefaultValue((String)vector.elementAt(n));
                }
            }
            if (vector2 != null && vector2.size() == 2) {
                for (n = 0; n < vector2.size(); ++n) {
                    parameterInfo.setLimit((String)vector2.elementAt(n), n);
                }
            }
            return parameterInfo;
        }
        return null;
    }

    public SummaryInfo getSummaryInfo(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return this.getSummaryInfo(jetObject);
        }
        this.setError("Get summary info error: illegal handle " + string);
        return null;
    }

    protected SummaryInfo getSummaryInfo(JetObject jetObject) {
        if (jetObject != null) {
            if (jetObject instanceof JetUSummary) {
                JetUSummary jetUSummary = (JetUSummary)jetObject;
                SummaryInfo summaryInfo = new SummaryInfo(jetUSummary.name.get(), jetUSummary.desc.get(), jetUSummary.function.get(), jetUSummary.fldName.get(), jetUSummary.groupbyFld.get());
                Vector vector = jetUSummary.getChildren();
                int n = vector == null ? 0 : vector.size();
                for (int i = 0; i < n; ++i) {
                    if (!(vector.get(i) instanceof JetUSpecFuncInfo)) continue;
                    summaryInfo.setSpecFuncInfo(this.IsDefaultDB((JetUSpecFuncInfo)vector.get(i)));
                }
                return summaryInfo;
            }
            this.setError("Get summary info error: illegal handle: " + jetObject.getQualifyName() + ", this object is not a summary");
        } else {
            this.setError("Get summary info error: illegal handle ");
        }
        return null;
    }

    public FormulaInfo getFormulaInfo(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetObject jetObject = this.getObj(string);
        return this.getFormulaInfo(jetObject);
    }

    FormulaInfo getFormulaInfo(JetObject jetObject) {
        if (jetObject != null && jetObject instanceof JetUFormula && !(jetObject instanceof JetUSummary)) {
            JetUFormula jetUFormula = (JetUFormula)jetObject;
            FormulaInfo formulaInfo = new FormulaInfo(jetUFormula.name.get(), jetUFormula.desc.get(), jetUFormula.expr.get());
            return formulaInfo;
        }
        return null;
    }

    public boolean set(String string, SummaryInfo summaryInfo) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return this.set(jetObject, summaryInfo, this.cat);
        }
        this.setError("set(" + string + ", \"SummaryInfo\")illegal handle: " + string);
        return false;
    }

    boolean set(JetObject jetObject, SummaryInfo summaryInfo, JetUUniverse jetUUniverse) {
        boolean bl;
        JetUUniverse.setUniverse(jetUUniverse);
        if (jetObject instanceof JetUSummary) {
            StringBuffer stringBuffer = new StringBuffer(64);
            JetUSummary jetUSummary = (JetUSummary)jetObject;
            JetUDatabase jetUDatabase = jetUSummary.getDatabase();
            SpecFuncInfo specFuncInfo = null;
            bl = true;
            String string = summaryInfo.getField();
            if (string == null || string.length() == 0 || !jetUDatabase.IsMappingNameExist(string)) {
                stringBuffer.append("\nset summary info error: illegal \"Sum On\" field name " + string);
                bl = false;
            } else {
                jetUSummary.setFieldName(string);
            }
            string = summaryInfo.getGroupBy();
            if (string != null && string.length() > 0) {
                specFuncInfo = summaryInfo.getSpecFuncInfo();
                if (!jetUDatabase.IsMappingNameExist(string)) {
                    stringBuffer.append("\nset summary info error: illegal \"GroupBy\" field name " + string);
                    bl = false;
                } else if (specFuncInfo != null) {
                    JetUSpecFuncInfo jetUSpecFuncInfo = this.IsConnectionNameExist(specFuncInfo);
                    if (jetUSpecFuncInfo != null) {
                        jetUSummary.add(jetUSpecFuncInfo);
                    } else {
                        stringBuffer.append("\nset summary info error: illegal \"SpecFuncInfo\" " + specFuncInfo);
                        bl = false;
                    }
                }
            }
            jetUSummary.setGroupByFld(string);
            string = summaryInfo.getFunction();
            if (string == null || string.length() == 0) {
                stringBuffer.append("\nset summary info error: illegal \"Function\" name " + string);
                bl = false;
            } else if (bl) {
                jetUSummary.setFunction(string);
            }
            string = summaryInfo.getName();
            if (string == null || string.length() == 0 || jetUDatabase.IsMappingNameExist(string) && !string.equalsIgnoreCase(jetUSummary.getResourceName())) {
                stringBuffer.append("\nset summary info error: illegal summary name " + string);
                bl = false;
            } else if (bl) {
                jetUSummary.setResourceName(string);
            }
            if (bl) {
                jetUSummary.desc.set(summaryInfo.getDescription());
                jetUDatabase.setFormulaModified(true);
                try {
                    jetUDatabase.parseSummary(jetUSummary);
                }
                catch (ParseFormulaFailedException parseFormulaFailedException) {
                    this.setError(parseFormulaFailedException.getMessage());
                }
                this.notifyReference(jetObject, 2);
            } else {
                this.setError(stringBuffer.toString());
            }
        } else {
            this.setError("set summary info error: illegal handle: " + jetObject.getQualifyName() + ", this object is not a summary");
            bl = false;
        }
        return bl;
    }

    private JetUSpecFuncInfo IsConnectionNameExist(SpecFuncInfo specFuncInfo) {
        JetUSpecFuncInfo jetUSpecFuncInfo = null;
        int n = specFuncInfo.getType();
        switch (n) {
            case 1: {
                jetUSpecFuncInfo = new JetUSpecFuncString();
                jetUSpecFuncInfo.setOtherName(specFuncInfo.getOtherName());
                jetUSpecFuncInfo.setDesc(specFuncInfo.getDesc());
                jetUSpecFuncInfo.setInterNum(specFuncInfo.getInterNum());
                ((JetUSpecFuncString)jetUSpecFuncInfo).setDirection(((SpecFuncStringInfo)specFuncInfo).getDirection());
                ((JetUSpecFuncString)jetUSpecFuncInfo).setCaseSensitive(((SpecFuncStringInfo)specFuncInfo).getCaseSensitive());
                ((JetUSpecFuncString)jetUSpecFuncInfo).setConvertGroupName(((SpecFuncStringInfo)specFuncInfo).getConvertGroupName());
                break;
            }
            case 2: {
                jetUSpecFuncInfo = new JetUSpecFuncDateTime();
                jetUSpecFuncInfo.setOtherName(specFuncInfo.getOtherName());
                jetUSpecFuncInfo.setDesc(specFuncInfo.getDesc());
                jetUSpecFuncInfo.setInterNum(specFuncInfo.getInterNum());
                ((JetUSpecFuncDateTime)jetUSpecFuncInfo).setUnit(((SpecFuncDateTimeInfo)specFuncInfo).getUnit());
                ((JetUSpecFuncDateTime)jetUSpecFuncInfo).setBenchPoint(((SpecFuncDateTimeInfo)specFuncInfo).getBenchPoint());
                ((JetUSpecFuncDateTime)jetUSpecFuncInfo).setfirstDayOfWeek(((SpecFuncDateTimeInfo)specFuncInfo).getFirstDayOfWeek());
                break;
            }
            case 3: {
                jetUSpecFuncInfo = new JetUSpecFuncValChan();
                ((JetUSpecFuncValChan)jetUSpecFuncInfo).setOtherName(specFuncInfo.getOtherName());
                ((JetUSpecFuncValChan)jetUSpecFuncInfo).setDesc(specFuncInfo.getDesc());
                ((JetUSpecFuncValChan)jetUSpecFuncInfo).setInterNum(specFuncInfo.getInterNum());
                ((JetUSpecFuncValChan)jetUSpecFuncInfo).setIncrease(((SpecFuncValueChangeInfo)specFuncInfo).getIsIncrease());
                break;
            }
            case 4: {
                jetUSpecFuncInfo = new JetUSpecFuncNum();
                jetUSpecFuncInfo.setOtherName(specFuncInfo.getOtherName());
                jetUSpecFuncInfo.setDesc(specFuncInfo.getDesc());
                jetUSpecFuncInfo.setInterNum(specFuncInfo.getInterNum());
            }
        }
        return jetUSpecFuncInfo;
    }

    private SpecFuncInfo IsDefaultDB(JetUSpecFuncInfo jetUSpecFuncInfo) {
        SpecFuncInfo specFuncInfo = null;
        int n = jetUSpecFuncInfo.getType();
        switch (n) {
            case 1: {
                specFuncInfo = new SpecFuncStringInfo();
                specFuncInfo.setOtherName(jetUSpecFuncInfo.getOtherName());
                specFuncInfo.setDesc(jetUSpecFuncInfo.getDesc());
                specFuncInfo.setInterNum(jetUSpecFuncInfo.getInterNum());
                ((SpecFuncStringInfo)specFuncInfo).setDirection(((JetUSpecFuncString)jetUSpecFuncInfo).getDirection());
                ((SpecFuncStringInfo)specFuncInfo).setCaseSensitive(((JetUSpecFuncString)jetUSpecFuncInfo).getCaseSensitive());
                ((SpecFuncStringInfo)specFuncInfo).setConvertGroupName(((JetUSpecFuncString)jetUSpecFuncInfo).getConvertGroupName());
                break;
            }
            case 2: {
                specFuncInfo = new SpecFuncDateTimeInfo();
                specFuncInfo.setOtherName(specFuncInfo.getOtherName());
                specFuncInfo.setDesc(specFuncInfo.getDesc());
                specFuncInfo.setInterNum(specFuncInfo.getInterNum());
                ((SpecFuncDateTimeInfo)specFuncInfo).setUnit(((JetUSpecFuncDateTime)jetUSpecFuncInfo).getUnit());
                ((SpecFuncDateTimeInfo)specFuncInfo).setBenchPoint(((JetUSpecFuncDateTime)jetUSpecFuncInfo).getBenchPoint());
                ((SpecFuncDateTimeInfo)specFuncInfo).setFirstDayOfWeek(((JetUSpecFuncDateTime)jetUSpecFuncInfo).getfirstDayOfWeek());
                break;
            }
            case 3: {
                specFuncInfo = new SpecFuncValueChangeInfo();
                specFuncInfo.setOtherName(jetUSpecFuncInfo.getOtherName());
                specFuncInfo.setDesc(jetUSpecFuncInfo.getDesc());
                specFuncInfo.setInterNum(jetUSpecFuncInfo.getInterNum());
                ((SpecFuncValueChangeInfo)specFuncInfo).setIsIncrease(((JetUSpecFuncValChan)jetUSpecFuncInfo).getIncrease());
                break;
            }
            case 4: {
                specFuncInfo = new SpecFuncNumInfo();
                specFuncInfo.setOtherName(jetUSpecFuncInfo.getOtherName());
                specFuncInfo.setDesc(jetUSpecFuncInfo.getDesc());
                specFuncInfo.setInterNum(jetUSpecFuncInfo.getInterNum());
            }
        }
        return specFuncInfo;
    }

    public boolean set(String string, FormulaInfo formulaInfo) {
        this.clearMsg();
        boolean bl = true;
        JetObject jetObject = this.getObj(string);
        bl = this.set(jetObject, formulaInfo, this.cat);
        return bl;
    }

    boolean set(JetObject jetObject, FormulaInfo formulaInfo, JetUUniverse jetUUniverse) {
        boolean bl = false;
        if (jetObject != null && jetObject instanceof JetUFormula && !(jetObject instanceof JetUSummary)) {
            JetUUniverse.setUniverse(jetUUniverse);
            JetUDatabase jetUDatabase = ((JetUFormula)jetObject).getDatabase();
            ((JetUFormula)jetObject).setExpression(formulaInfo.getExpression());
            try {
                jetUDatabase.parseFormulas(true, true);
            }
            catch (ParseFormulaFailedException parseFormulaFailedException) {
                this.setError(parseFormulaFailedException);
            }
            this.notifyReference(jetObject, 2);
            bl = true;
        }
        return bl;
    }

    public String parseFormulae() {
        this.clearMsg();
        return this.parseFormula(this.cat.getDatabase());
    }

    public String parseFormulae(String string) {
        this.clearMsg();
        return this.parseFormula(this.getDatabase(string, this.cat));
    }

    String parseFormula(JetUDatabase jetUDatabase) {
        String string = null;
        if (jetUDatabase != null) {
            JetUUniverse.setUniverse(jetUDatabase.getUniverse());
            jetUDatabase.setFormulaModified(true);
            try {
                jetUDatabase.parseFormulas(true, true);
            }
            catch (ParseFormulaFailedException parseFormulaFailedException) {
                string = parseFormulaFailedException.toString();
            }
        }
        return string;
    }

    public String parseFormula(FormulaInfo formulaInfo) {
        return this.parseFormula(formulaInfo, this.cat.getDatabase(), true);
    }

    public String parseFormula(String string, FormulaInfo formulaInfo) {
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase != null) {
            return this.parseFormula(formulaInfo, jetUDatabase, true);
        }
        return "Invalid datasource name " + string;
    }

    String parseFormula(FormulaInfo formulaInfo, JetUDatabase jetUDatabase, boolean bl) {
        String string = null;
        if (jetUDatabase != null) {
            JetUUniverse.setUniverse(jetUDatabase.getUniverse());
            JetUFormula jetUFormula = jetUDatabase.getFormulaByResourceName(formulaInfo.getName());
            jetUDatabase.setFormulaModified(true);
            JetUFormula jetUFormula2 = null;
            String string2 = null;
            try {
                if (jetUFormula == null) {
                    jetUFormula2 = new JetUFormula(formulaInfo.getName(), formulaInfo.getDescription(), formulaInfo.getExpression());
                    jetUDatabase.addFormula(jetUFormula2);
                } else {
                    string2 = jetUFormula.getExpression();
                    jetUFormula.setExpression(formulaInfo.getExpression());
                }
                jetUDatabase.parseFormulas(true, true);
            }
            catch (ParseFormulaFailedException parseFormulaFailedException) {
                Vector vector = parseFormulaFailedException.getFailedFormulas();
                FormulaSyntaxErrorException formulaSyntaxErrorException = null;
                for (int i = 0; i < vector.size(); ++i) {
                    if (!(vector.get(i) instanceof FormulaSyntaxErrorException) || !(formulaSyntaxErrorException = (FormulaSyntaxErrorException)vector.get(i)).getName().equalsIgnoreCase(formulaInfo.getName())) continue;
                    string = formulaSyntaxErrorException.getMessage();
                    break;
                }
            }
            if (bl) {
                if (jetUFormula == null) {
                    jetUDatabase.removeFormula(jetUFormula2);
                } else {
                    jetUFormula.setExpression(string2);
                }
            }
        }
        return string;
    }

    public boolean isNameExist(String string) {
        this.clearMsg();
        return this.isNameExist(this.getDefaultDataSourceName(), string, this.cat);
    }

    public boolean isNameExist(String string, String string2) {
        this.clearMsg();
        return this.isNameExist(string, string2, this.cat);
    }

    boolean isNameExist(String string, String string2, JetUUniverse jetUUniverse) {
        JetUUniverse.setUniverse(jetUUniverse);
        JetUDatabase jetUDatabase = this.getDatabase(string, jetUUniverse);
        return jetUDatabase != null && (jetUDatabase.IsConnectionNameExist(string2) || jetUDatabase.IsMappingNameExist(string2) || jetUDatabase.isQueriableExist(string2) || !jetUDatabase.IsTableNameOK(string2, null));
    }

    @Override
    public boolean delete(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.delete(this.getObj(string), this.cat, true);
    }

    boolean delete(JetObject jetObject, JetUUniverse jetUUniverse, boolean bl) {
        JetUUniverse.setUniverse(jetUUniverse);
        boolean bl2 = false;
        if (jetObject != null) {
            String string = jetObject.getQualifyName();
            boolean bl3 = true;
            if (jetObject instanceof JetUDatabase) {
                bl3 = jetUUniverse.getAllDatabases().size() > 1 && !((JetUDatabase)jetObject).IsDefaultDB();
                bl2 = jetUUniverse.removeDatabase(((JetUDatabase)jetObject).getResourceName());
            }
            if (bl3) {
                this.notifyReference(jetObject, 1);
            }
            if (jetObject instanceof JetUConnection) {
                JetUDatabase jetUDatabase = (JetUDatabase)jetObject.getParent();
                bl2 = jetUDatabase.removeConnection((JetUConnection)jetObject);
            } else if (jetObject instanceof JetUQuery) {
                JetUDatabase jetUDatabase = (JetUDatabase)jetObject.getParent();
                bl2 = jetUDatabase.removeQuery((JetUQuery)jetObject);
            } else if (jetObject instanceof JetUUserDataSource) {
                JetUDatabase jetUDatabase = (JetUDatabase)jetObject.getParent();
                bl2 = jetUDatabase.removeDataSource((JetUUserDataSource)jetObject);
            } else if (jetObject instanceof JetUWherePortion) {
                JetUDatabase jetUDatabase = (JetUDatabase)jetObject.getParent();
                bl2 = jetUDatabase.removeWherePortion((JetUWherePortion)jetObject);
            } else if (jetObject instanceof JetUFormula) {
                JetUDatabase jetUDatabase = (JetUDatabase)jetObject.getParent();
                bl2 = jetUDatabase.removeFormula((JetUFormula)jetObject);
            } else if (jetObject instanceof JetUParameter) {
                JetUDatabase jetUDatabase = (JetUDatabase)jetObject.getParent();
                bl2 = jetUDatabase.removeParameter((JetUParameter)jetObject);
            } else if (jetObject instanceof JetUSummary) {
                JetUDatabase jetUDatabase = (JetUDatabase)jetObject.getParent();
                bl2 = jetUDatabase.removeSummary((JetUSummary)jetObject);
            } else if (jetObject instanceof JetUFileQuery) {
                JetUDatabase jetUDatabase = (JetUDatabase)jetObject.getParent();
                bl2 = jetUDatabase.removeFileQuery((JetUFileQuery)jetObject);
            } else if (jetObject instanceof JetUProcedure) {
                JetUDatabase jetUDatabase = (JetUDatabase)jetObject.getParent();
                bl2 = jetUDatabase.removeProcedure((JetUProcedure)jetObject);
            } else if (jetObject instanceof JetUTableView) {
                JetUConnection jetUConnection = (JetUConnection)jetObject.getParent();
                bl2 = jetUConnection.removeTableView((JetUTableView)jetObject);
            } else if (jetObject instanceof JBusinessView) {
                ((JetContainable)((Object)((JBusinessView)((Object)jetObject)).getQuery())).remove(jetObject);
                bl2 = true;
            } else if (jetObject instanceof JBusinessLogic) {
                ((JetContainable)((Object)((JBusinessLogic)((Object)jetObject)).getQuery())).remove(jetObject);
                bl2 = true;
            } else if (jetObject instanceof Category) {
                String string2 = ((Category)jetObject).getName();
                bl2 = ((Category)jetObject).getBLParent().removeChildByName(string2) != null;
            } else if (jetObject instanceof Measure) {
                String string3 = ((Measure)jetObject).getName();
                bl2 = ((Measure)jetObject).getBLParent().removeChildByName(string3) != null;
            } else if (jetObject instanceof Dimension) {
                String string4 = ((Dimension)jetObject).getName();
                JBusinessLogic jBusinessLogic = ((Dimension)jetObject).getBusinessLogic();
                boolean bl4 = bl2 = ((Dimension)jetObject).getBLParent().removeChildByName(string4) != null;
                if (jBusinessLogic != null) {
                    HierarchyInfo[] hierarchyInfoArray = jBusinessLogic.getHierarchyContainer().getHierarchies(string4);
                    for (int i = 0; i < hierarchyInfoArray.length; ++i) {
                        hierarchyInfoArray[i].removeDimension(string4);
                    }
                }
            } else if (jetObject instanceof DetailInfo) {
                String string5 = ((DetailInfo)jetObject).getName();
                bl2 = ((DetailInfo)jetObject).getBLParent().removeChildByName(string5) != null;
            } else if (jetObject instanceof FilterInfo) {
                String string6 = ((FilterInfo)((Object)jetObject)).getName();
                boolean bl5 = bl2 = ((FilterInfo)((Object)jetObject)).getBLParent().removeChildByName(string6) != null;
            }
            if (bl2 && bl) {
                this.handles.remove(string);
            }
        } else {
            this.setError("Illegal handle: handle is null .");
        }
        return bl2;
    }

    public String[] getDBFields(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.getDBFields(this.cat.getDatabase().GetQueryByResourceName(string));
    }

    public String[] getDBFields(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        return jetUQuery == null ? new String[]{} : this.getDBFields(jetUQuery);
    }

    String[] getDBFields(JetObject jetObject) {
        if (jetObject != null) {
            try {
                Vector vector = ((JetUQuery)jetObject).getDBFields();
                String[] stringArray = new String[vector.size()];
                int n = stringArray.length;
                while (--n >= 0) {
                    stringArray[n] = ((JetUFldQueryField)vector.elementAt(n)).getResourceName();
                }
                return stringArray;
            }
            catch (Exception exception) {
                this.setError(exception);
            }
        } else {
            this.setError("getDBFields(): Illegal qryName .");
        }
        return new String[0];
    }

    public String[] getFormulae() {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.cat.getDatabase().getFormulas();
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUFormula)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getFormulae(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        Vector vector = new Vector();
        if (jetUDatabase != null) {
            vector = jetUDatabase.getFormulas();
        }
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUFormula)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getSummaries() {
        this.clearMsg();
        Vector vector = this.cat.getDatabase().getSummaries();
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUSummary)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getSummaries(String string) {
        this.clearMsg();
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        Vector vector = new Vector();
        if (jetUDatabase != null) {
            vector = jetUDatabase.getSummaries();
        }
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUSummary)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getSQLs() {
        String[] stringArray;
        JetUUniverse.setUniverse(this.cat);
        JetUConnection jetUConnection = this.cat.getDatabase().getConnection();
        if (jetUConnection != null) {
            Vector vector = jetUConnection.getFileQueries();
            stringArray = new String[vector.size()];
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray[n] = ((JetUFileQuery)vector.elementAt(n)).getResourceName();
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String[] getSQLs(String string) {
        String[] stringArray;
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUConnection jetUConnection = null;
        if (jetUDatabase != null) {
            jetUConnection = jetUDatabase.getConnection();
        }
        if (jetUConnection != null) {
            Vector vector = jetUConnection.getFileQueries();
            stringArray = new String[vector.size()];
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray[n] = ((JetUFileQuery)vector.elementAt(n)).getResourceName();
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String[] getSQLColumns(String string) {
        JetUFileQuery jetUFileQuery;
        JetUUniverse.setUniverse(this.cat);
        JetUConnection jetUConnection = this.cat.getDatabase().getConnection();
        if (jetUConnection != null && (jetUFileQuery = jetUConnection.GetFileQueryByResourceName(string)) != null) {
            Vector vector = jetUFileQuery.getChildren();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUFileQueryField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                JetUFileQueryField jetUFileQueryField = (JetUFileQueryField)vector.elementAt(n);
                stringArray[n] = jetUFileQueryField.getFldName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getSQLColumns(String string, String string2) {
        JetUFileQuery jetUFileQuery;
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUConnection jetUConnection = null;
        if (jetUDatabase != null) {
            jetUConnection = jetUDatabase.getConnection();
        }
        if (jetUConnection != null && (jetUFileQuery = jetUConnection.GetFileQueryByResourceName(string2)) != null) {
            Vector vector = jetUFileQuery.getChildren();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUFileQueryField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                JetUFileQueryField jetUFileQueryField = (JetUFileQueryField)vector.elementAt(n);
                stringArray[n] = jetUFileQueryField.getFldName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getSQLColumnsMap(String string) {
        JetUFileQuery jetUFileQuery;
        JetUUniverse.setUniverse(this.cat);
        JetUConnection jetUConnection = this.cat.getDatabase().getConnection();
        if (jetUConnection != null && (jetUFileQuery = jetUConnection.GetFileQueryByResourceName(string)) != null) {
            Vector vector = jetUFileQuery.getChildren();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUFileQueryField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                JetUFileQueryField jetUFileQueryField = (JetUFileQueryField)vector.elementAt(n);
                stringArray[n] = jetUFileQueryField.getResourceName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getSQLColumnsMap(String string, String string2) {
        JetUFileQuery jetUFileQuery;
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUConnection jetUConnection = null;
        if (jetUDatabase != null) {
            jetUConnection = jetUDatabase.getConnection();
        }
        if (jetUConnection != null && (jetUFileQuery = jetUConnection.GetFileQueryByResourceName(string2)) != null) {
            Vector vector = jetUFileQuery.getChildren();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUFileQueryField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                JetUFileQueryField jetUFileQueryField = (JetUFileQueryField)vector.elementAt(n);
                stringArray[n] = jetUFileQueryField.getResourceName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getUDSs() {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.cat.getDatabase().getDataSources();
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUUserDataSource)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getUDSs(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        Vector vector = new Vector();
        if (jetUDatabase != null) {
            vector = jetUDatabase.getDataSources();
        }
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUUserDataSource)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getHDSs() {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.cat.getDatabase().getHierDataSources();
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUHierDataSource)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getHDSs(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        Vector vector = new Vector();
        if (jetUDatabase != null) {
            vector = jetUDatabase.getHierDataSources();
        }
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUHierDataSource)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getUDSColumns(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUUserDataSource jetUUserDataSource = this.cat.getDatabase().getDataSourceByResourceName(string);
        if (jetUUserDataSource != null) {
            Vector vector = jetUUserDataSource.getChildren();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUUDSField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JetUUDSField jetUUDSField = (JetUUDSField)vector.elementAt(i);
                stringArray[i] = jetUUDSField.getFldName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getUDSColumns(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUUserDataSource jetUUserDataSource = null;
        if (jetUDatabase != null) {
            jetUUserDataSource = jetUDatabase.getDataSourceByResourceName(string2);
        }
        if (jetUUserDataSource != null) {
            Vector vector = jetUUserDataSource.getChildren();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUUDSField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JetUUDSField jetUUDSField = (JetUUDSField)vector.elementAt(i);
                stringArray[i] = jetUUDSField.getFldName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getUDSColumnsMap(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUUserDataSource jetUUserDataSource = this.cat.getDatabase().getDataSourceByResourceName(string);
        if (jetUUserDataSource != null) {
            Vector vector = jetUUserDataSource.getChildren();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUUDSField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JetUUDSField jetUUDSField = (JetUUDSField)vector.elementAt(i);
                stringArray[i] = jetUUDSField.getResourceName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getUDSColumnsMap(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUUserDataSource jetUUserDataSource = null;
        if (jetUDatabase != null) {
            jetUUserDataSource = jetUDatabase.getDataSourceByResourceName(string2);
        }
        if (jetUUserDataSource != null) {
            Vector vector = jetUUserDataSource.getChildren();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUUDSField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JetUUDSField jetUUDSField = (JetUUDSField)vector.elementAt(i);
                stringArray[i] = jetUUDSField.getResourceName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getProcedureNames() {
        String[] stringArray;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.cat.getDatabase();
        JetUConnection jetUConnection = null;
        if (jetUDatabase != null) {
            jetUConnection = jetUDatabase.getConnection();
        }
        if (jetUConnection != null) {
            Vector vector = jetUConnection.getProcedures();
            stringArray = new String[vector.size()];
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray[n] = ((JetUProcedure)vector.elementAt(n)).getResourceName();
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String[] getProcedureNames(String string) {
        String[] stringArray;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUConnection jetUConnection = null;
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase != null) {
            jetUConnection = jetUDatabase.getConnection();
        }
        if (jetUConnection != null) {
            Vector vector = jetUConnection.getProcedures();
            stringArray = new String[vector.size()];
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray[n] = ((JetUProcedure)vector.elementAt(n)).getResourceName();
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String[] getProcColumns(String string) {
        JetUProcedure jetUProcedure;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUConnection jetUConnection = this.cat.getDatabase().getConnection();
        if (jetUConnection != null && (jetUProcedure = jetUConnection.getProcedureByResourceName(string)) != null) {
            Vector vector = jetUProcedure.getFields();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUProcField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JetUProcField jetUProcField = (JetUProcField)vector.elementAt(i);
                stringArray[i] = jetUProcField.getFldName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getProcColumns(String string, String string2) {
        JetUProcedure jetUProcedure;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUConnection jetUConnection = null;
        if (jetUDatabase != null) {
            jetUConnection = jetUDatabase.getConnection();
        }
        if (jetUConnection != null && (jetUProcedure = jetUConnection.getProcedureByResourceName(string2)) != null) {
            Vector vector = jetUProcedure.getFields();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUProcField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JetUProcField jetUProcField = (JetUProcField)vector.elementAt(i);
                stringArray[i] = jetUProcField.getFldName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getProcColumnsMap(String string) {
        JetUProcedure jetUProcedure;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUConnection jetUConnection = this.cat.getDatabase().getConnection();
        if (jetUConnection != null && (jetUProcedure = jetUConnection.getProcedureByResourceName(string)) != null) {
            Vector vector = jetUProcedure.getFields();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUProcField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JetUProcField jetUProcField = (JetUProcField)vector.elementAt(i);
                stringArray[i] = jetUProcField.getResourceName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getProcColumnsMap(String string, String string2) {
        JetUProcedure jetUProcedure;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUConnection jetUConnection = null;
        if (jetUDatabase != null) {
            jetUConnection = jetUDatabase.getConnection();
        }
        if (jetUConnection != null && (jetUProcedure = jetUConnection.getProcedureByResourceName(string2)) != null) {
            Vector vector = jetUProcedure.getFields();
            int n = vector.size();
            while (--n >= 0) {
                if (vector.elementAt(n) instanceof JetUProcField) continue;
                vector.removeElementAt(n);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JetUProcField jetUProcField = (JetUProcField)vector.elementAt(i);
                stringArray[i] = jetUProcField.getResourceName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getParameter() {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.cat.getParameters();
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUParameter)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getParameter(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        Vector vector = new Vector();
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase != null) {
            vector = jetUDatabase.getParameters();
        }
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUParameter)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getQueries() {
        String[] stringArray;
        int n = 0;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        if (this.cat != null) {
            Vector vector = this.cat.getQueriables();
            int n2 = vector.size();
            stringArray = new String[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                if (!(vector.elementAt(n3) instanceof JetUQuery) || vector.elementAt(n3) instanceof JetUDemandQuery) continue;
                stringArray[n++] = ((JetUQuery)vector.elementAt(n3)).getResourceName();
            }
        } else {
            stringArray = new String[]{};
        }
        if (n < stringArray.length) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public String[] getQueries(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        Vector vector = new Vector();
        if (jetUDatabase != null) {
            vector = jetUDatabase.getQueries();
        }
        int n = vector.size();
        while (--n >= 0) {
            if (!(vector.elementAt(n) instanceof JetUDemandQuery)) continue;
            vector.removeElementAt(n);
        }
        String[] stringArray = new String[vector.size()];
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            stringArray[n2] = ((JetUQuery)vector.elementAt(n2)).getResourceName();
        }
        return stringArray;
    }

    String getCatalogName(String string) {
        if (string.endsWith(".cat")) {
            string = string.substring(0, string.length() - ".cat".length());
        } else if (string.endsWith(".cat.xml")) {
            string = string.substring(0, string.length() - ".cat.xml".length());
        }
        return string;
    }

    @Override
    int getClassType(JetObject jetObject) {
        if (jetObject != null) {
            if (jetObject instanceof JetUUniverse) {
                return 0;
            }
            if (jetObject instanceof JetUDatabase) {
                return 15;
            }
            if (jetObject instanceof JetUXMLConnection) {
                return 26;
            }
            if (jetObject instanceof JetUConnection) {
                return 1;
            }
            if (jetObject instanceof MetadataContainerImpl) {
                return 27;
            }
            if (jetObject instanceof JetUDemandQuery) {
                return 25;
            }
            if (jetObject instanceof JetUQuery) {
                return 5;
            }
            if (jetObject instanceof JetUProcedure) {
                return 6;
            }
            if (jetObject instanceof JetUUserDataSource) {
                return 8;
            }
            if (jetObject instanceof JetUFileQuery) {
                return 7;
            }
            if (jetObject instanceof JetUSummary) {
                return 10;
            }
            if (jetObject instanceof JetUFormula) {
                return 9;
            }
            if (jetObject instanceof JetUParameter) {
                return 11;
            }
            if (jetObject instanceof JetUWherePortion) {
                return 12;
            }
            if (jetObject instanceof JetUTableView) {
                if (((JetUTableView)jetObject).isTable()) {
                    return 2;
                }
                if (((JetUTableView)jetObject).isView()) {
                    return 3;
                }
                if (((JetUTableView)jetObject).isSynonym()) {
                    return 13;
                }
                if (((JetUTableView)jetObject).isAlias()) {
                    return 14;
                }
            } else {
                if (jetObject instanceof JetUFileQueryField || jetObject instanceof JetUProcField || jetObject instanceof JetUQueryField || jetObject instanceof JetUUDSField || jetObject instanceof JetUField) {
                    return 4;
                }
                if (jetObject instanceof JetUHierDataSource) {
                    return 16;
                }
                if (jetObject instanceof BusinessView) {
                    return 32;
                }
                if (jetObject instanceof BusinessLogic) {
                    return 17;
                }
                if (jetObject instanceof Category) {
                    return 18;
                }
                if (jetObject instanceof Dimension) {
                    return 19;
                }
                if (jetObject instanceof Measure) {
                    return 20;
                }
                if (jetObject instanceof DetailInfo) {
                    return 22;
                }
                if (jetObject instanceof Hierarchy) {
                    return 23;
                }
                if (jetObject instanceof HierarchyContainerImpl) {
                    return 24;
                }
            }
        }
        return -1;
    }

    public String[] getTables() {
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getTablesInCurrentConnection(null);
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUTableView)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getTables(String string) {
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getTablesInCurrentConnection(string);
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUTableView)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getTableColumns(String string) {
        int n;
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getTablesInCurrentConnection(null);
        int n2 = n = vector == null ? 0 : vector.size();
        while (--n2 >= 0) {
            if (!((JetUTableView)vector.elementAt(n2)).getTableName().equalsIgnoreCase(string)) continue;
            JetUTableView jetUTableView = (JetUTableView)vector.elementAt(n2);
            Vector vector2 = jetUTableView.getChildren();
            String[] stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                JetUField jetUField = (JetUField)vector2.elementAt(i);
                stringArray[i] = jetUField.getFldName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getTableColumns(String string, boolean bl) {
        int n;
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getTablesInCurrentConnection(null);
        int n2 = n = vector == null ? 0 : vector.size();
        while (--n2 >= 0) {
            if ((!bl || !((JetUTableView)vector.elementAt(n2)).getResourceName().equalsIgnoreCase(string)) && (bl || !((JetUTableView)vector.elementAt(n2)).getTableName().equalsIgnoreCase(string))) continue;
            JetUTableView jetUTableView = (JetUTableView)vector.elementAt(n2);
            Vector vector2 = jetUTableView.getChildren();
            String[] stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                JetUField jetUField = (JetUField)vector2.elementAt(i);
                stringArray[i] = jetUField.getFldName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getTableColumns(String string, String string2) {
        int n;
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getTablesInCurrentConnection(string);
        int n2 = n = vector == null ? 0 : vector.size();
        while (--n2 >= 0) {
            if (!((JetUTableView)vector.elementAt(n2)).getTableName().equalsIgnoreCase(string2)) continue;
            JetUTableView jetUTableView = (JetUTableView)vector.elementAt(n2);
            Vector vector2 = jetUTableView.getChildren();
            String[] stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                JetUField jetUField = (JetUField)vector2.elementAt(i);
                stringArray[i] = jetUField.getFldName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getTableColumns(String string, String string2, boolean bl) {
        int n;
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getTablesInCurrentConnection(string);
        int n2 = n = vector == null ? 0 : vector.size();
        while (--n2 >= 0) {
            if ((!bl || !((JetUTableView)vector.elementAt(n2)).getResourceName().equalsIgnoreCase(string2)) && (bl || !((JetUTableView)vector.elementAt(n2)).getTableName().equalsIgnoreCase(string2))) continue;
            JetUTableView jetUTableView = (JetUTableView)vector.elementAt(n2);
            Vector vector2 = jetUTableView.getChildren();
            String[] stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                JetUField jetUField = (JetUField)vector2.elementAt(i);
                stringArray[i] = jetUField.getFldName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getTableColumnsMap(String string) {
        int n;
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getTablesInCurrentConnection(null);
        int n2 = n = vector == null ? 0 : vector.size();
        while (--n2 >= 0) {
            if (!((JetUTableView)vector.elementAt(n2)).getTableName().equalsIgnoreCase(string)) continue;
            JetUTableView jetUTableView = (JetUTableView)vector.elementAt(n2);
            Vector vector2 = jetUTableView.getChildren();
            String[] stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                JetUField jetUField = (JetUField)vector2.elementAt(i);
                stringArray[i] = jetUField.getResourceName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getTableColumnsMap(String string, boolean bl) {
        int n;
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getTablesInCurrentConnection(null);
        int n2 = n = vector == null ? 0 : vector.size();
        while (--n2 >= 0) {
            if ((!bl || !((JetUTableView)vector.elementAt(n2)).getResourceName().equalsIgnoreCase(string)) && (bl || !((JetUTableView)vector.elementAt(n2)).getTableName().equalsIgnoreCase(string))) continue;
            JetUTableView jetUTableView = (JetUTableView)vector.elementAt(n2);
            Vector vector2 = jetUTableView.getChildren();
            String[] stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                JetUField jetUField = (JetUField)vector2.elementAt(i);
                stringArray[i] = jetUField.getResourceName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getTableColumnsMap(String string, String string2) {
        int n;
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getTablesInCurrentConnection(string);
        int n2 = n = vector == null ? 0 : vector.size();
        while (--n2 >= 0) {
            if (!((JetUTableView)vector.elementAt(n2)).getTableName().equalsIgnoreCase(string2)) continue;
            JetUTableView jetUTableView = (JetUTableView)vector.elementAt(n2);
            Vector vector2 = jetUTableView.getChildren();
            String[] stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                JetUField jetUField = (JetUField)vector2.elementAt(i);
                stringArray[i] = jetUField.getResourceName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getTableColumnsMap(String string, String string2, boolean bl) {
        int n;
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getTablesInCurrentConnection(string);
        int n2 = n = vector == null ? 0 : vector.size();
        while (--n2 >= 0) {
            if ((!bl || !((JetUTableView)vector.elementAt(n2)).getResourceName().equalsIgnoreCase(string2)) && (bl || !((JetUTableView)vector.elementAt(n2)).getTableName().equalsIgnoreCase(string2))) continue;
            JetUTableView jetUTableView = (JetUTableView)vector.elementAt(n2);
            Vector vector2 = jetUTableView.getChildren();
            String[] stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                JetUField jetUField = (JetUField)vector2.elementAt(i);
                stringArray[i] = jetUField.getResourceName();
            }
            return stringArray;
        }
        return new String[0];
    }

    Vector getTablesInCurrentConnection(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUConnection jetUConnection = null;
        if (jetUDatabase != null) {
            jetUConnection = jetUDatabase.getConnection();
        }
        if (jetUConnection != null) {
            return jetUConnection.getTableViews();
        }
        return new Vector();
    }

    public String[] getSPFields(String string, String string2, boolean bl) {
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getProcedures(string);
        int n = vector.size();
        while (--n >= 0) {
            if ((!bl || !((JetUProcedure)vector.elementAt(n)).getResourceName().equalsIgnoreCase(string2)) && (bl || !((JetUProcedure)vector.elementAt(n)).getProcedureName().equalsIgnoreCase(string2))) continue;
            JetUProcedure jetUProcedure = (JetUProcedure)vector.elementAt(n);
            Vector vector2 = jetUProcedure.getFields();
            String[] stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                JetUProcField jetUProcField = (JetUProcField)vector2.elementAt(i);
                stringArray[i] = jetUProcField.getFldName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getSPFieldsMap(String string, String string2, boolean bl) {
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getProcedures(string);
        int n = vector.size();
        while (--n >= 0) {
            if ((!bl || !((JetUProcedure)vector.elementAt(n)).getResourceName().equalsIgnoreCase(string2)) && (bl || !((JetUProcedure)vector.elementAt(n)).getProcedureName().equalsIgnoreCase(string2))) continue;
            JetUProcedure jetUProcedure = (JetUProcedure)vector.elementAt(n);
            Vector vector2 = jetUProcedure.getFields();
            String[] stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                JetUProcField jetUProcField = (JetUProcField)vector2.elementAt(i);
                stringArray[i] = jetUProcField.getResourceName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String[] getTables(boolean bl) {
        return this.getTables(null, null, bl);
    }

    public String[] getTables(String string, boolean bl) {
        return this.getTables(string, null, bl);
    }

    public String[] getTables(String string, String string2, boolean bl) {
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.getTablesInDatabase(string, string2, null, null, bl, -1);
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public QueryTableInfo getColumns(String string, boolean bl) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        if (jetUQuery == null) {
            this.setError("getColumns(" + string + "): void query name. ");
            return new QueryTableInfo(1);
        }
        return this.getColumns(jetUQuery, bl);
    }

    public QueryTableInfo getColumns(String string, String string2, boolean bl) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        if (jetUQuery == null) {
            this.setError("getColumns(" + string2 + "): void query name. ");
            return new QueryTableInfo(1);
        }
        return this.getColumns(jetUQuery, bl);
    }

    QueryTableInfo getColumns(JetUQuery jetUQuery, boolean bl) {
        Object object;
        int n;
        String string;
        String string2;
        int n2;
        Vector vector = jetUQuery.getDBFields();
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = jetUQuery.getPsqlQuery().getPsqlTablesVector();
        QueryTableInfo queryTableInfo = new QueryTableInfo(8);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(n2);
            if (!(jetUQueryField instanceof JetUFldQueryField)) continue;
            string2 = ((JetUFldQueryField)jetUQueryField).getTableShowName();
            string = jetUQueryField.getFldName();
            n = queryTableInfo.indexOf(string2);
            if (n == -1) {
                object = new TableInfo(string2, 16);
                ((TableInfo)object).add(string);
                queryTableInfo.add((TableInfo)object);
                vector2.add(string2);
                continue;
            }
            object = queryTableInfo.getTableInfo(n);
            ((TableInfo)object).add(string);
        }
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            string2 = ((PsqlTable)vector3.elementAt(n2)).getShowName(false);
            int n3 = queryTableInfo.indexOf(string2);
            if (n3 != -1) continue;
            vector2.add(string2);
        }
        if (bl) {
            QueryTableInfo queryTableInfo2 = new QueryTableInfo(8);
            JetUConnection jetUConnection = jetUQuery.getDatabase().getConnection();
            for (n = 0; n < vector2.size(); ++n) {
                object = (String)vector2.elementAt(n);
                JetUTableView jetUTableView = jetUConnection.GetTableOrViewByResourceName((String)object);
                if (jetUTableView == null) continue;
                Vector vector4 = jetUTableView.getFields();
                TableInfo tableInfo = new TableInfo((String)object, 16);
                for (int i = 0; i < vector4.size(); ++i) {
                    JetUField jetUField = (JetUField)vector4.elementAt(i);
                    string = jetUField.getFldName();
                    tableInfo.add(string);
                }
                queryTableInfo2.add(tableInfo);
            }
            return queryTableInfo2;
        }
        return queryTableInfo;
    }

    public QueryTableInfo getMapColumns(String string) {
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        if (jetUQuery == null) {
            this.setError("getMapColumns(" + string + "): void query name. ");
            return new QueryTableInfo(1);
        }
        return this.getMapColumns(jetUQuery);
    }

    public QueryTableInfo getMapColumns(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        if (jetUQuery == null) {
            this.setError("getMapColumns(" + string2 + "): void query name. ");
            return new QueryTableInfo(1);
        }
        return this.getMapColumns(jetUQuery);
    }

    QueryTableInfo getMapColumns(JetUQuery jetUQuery) {
        Vector vector = jetUQuery.getDBFields();
        QueryTableInfo queryTableInfo = new QueryTableInfo(8);
        JetUUniverse.setUniverse(this.cat);
        for (int i = 0; i < vector.size(); ++i) {
            TableInfo tableInfo;
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(i);
            if (!(jetUQueryField instanceof JetUFldQueryField)) continue;
            String string = ((JetUFldQueryField)jetUQueryField).getTableShowName();
            String string2 = jetUQueryField.getResourceName();
            int n = queryTableInfo.indexOf(string);
            if (n == -1) {
                tableInfo = new TableInfo(string, 16);
                tableInfo.add(string2);
                queryTableInfo.add(tableInfo);
                continue;
            }
            tableInfo = queryTableInfo.getTableInfo(n);
            tableInfo.add(string2);
        }
        return queryTableInfo;
    }

    public String[] getCompColumns(String string) {
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        return this.getCompColumns(jetUQuery);
    }

    public String[] getCompColumns(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        return jetUDatabase == null ? new String[]{} : this.getCompColumns(jetUDatabase.GetQueryByResourceName(string2));
    }

    String[] getCompColumns(JetUQuery jetUQuery) {
        int n;
        Vector<JetUQueryField> vector = new Vector<JetUQueryField>();
        Vector vector2 = jetUQuery.getFields();
        for (n = 0; n < vector2.size(); ++n) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector2.elementAt(n);
            if (!(jetUQueryField instanceof JetUCompColQueryField)) continue;
            vector.add(jetUQueryField);
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = ((JetUCompColQueryField)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    public String[] getCompColumnHandles(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        return jetUDatabase == null ? new String[]{} : this.getCompColumnHandles(jetUDatabase.GetQueryByResourceName(string2));
    }

    String[] getCompColumnHandles(JetUQuery jetUQuery) {
        int n;
        Vector<JetUQueryField> vector = new Vector<JetUQueryField>();
        Vector vector2 = jetUQuery.getFields();
        for (n = 0; n < vector2.size(); ++n) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector2.elementAt(n);
            if (!(jetUQueryField instanceof JetUCompColQueryField)) continue;
            vector.add(jetUQueryField);
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = ((JetUCompColQueryField)vector.elementAt(n)).getQualifyName();
        }
        return stringArray;
    }

    public String[][] getJoins(String string) {
        JetUUniverse.setUniverse(this.cat);
        return this.getJoins(this.cat.getDatabase().GetQueryByResourceName(string));
    }

    public String[][] getJoins(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        return jetUDatabase == null ? new String[0][0] : this.getJoins(jetUDatabase.GetQueryByResourceName(string2));
    }

    public JoinInfo[] getJoinInfos(String string) {
        return this.transferJoinInfo(this.getJoins(string));
    }

    public JoinInfo[] getJoinInfos(String string, String string2) {
        return this.transferJoinInfo(this.getJoins(string, string2));
    }

    JoinInfo[] transferJoinInfo(String[][] stringArray) {
        int n = 0;
        if (stringArray != null) {
            JoinInfo[] joinInfoArray = new JoinInfo[stringArray.length];
            for (int i = 0; i < joinInfoArray.length; ++i) {
                try {
                    n = Integer.parseInt(stringArray[i][6]);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                joinInfoArray[i] = new JoinInfo(stringArray[i][0], stringArray[i][1], stringArray[i][4], stringArray[i][2], stringArray[i][3], stringArray[i][5].equalsIgnoreCase("true"), n);
            }
            return joinInfoArray;
        }
        return new JoinInfo[0];
    }

    String[][] getJoins(JetUQuery jetUQuery) {
        if (jetUQuery != null) {
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            Vector vector = rptPsqlQuery.getPsqlJoinsVector();
            String[][] stringArray = new String[vector.size()][7];
            for (int i = 0; i < vector.size(); ++i) {
                PsqlJoin psqlJoin = (PsqlJoin)vector.elementAt(i);
                stringArray[i][0] = psqlJoin.getTableFrom().getName();
                stringArray[i][1] = psqlJoin.getColumnFrom().getName();
                stringArray[i][2] = psqlJoin.getTableTo().getName();
                stringArray[i][3] = psqlJoin.getColumnTo().getName();
                stringArray[i][4] = psqlJoin.getOperator();
                stringArray[i][5] = "false";
                stringArray[i][6] = String.valueOf(psqlJoin.getOuterJoin());
            }
            return stringArray;
        }
        return new String[0][0];
    }

    public String[][] getQBEInfo(String string) {
        JetUUniverse.setUniverse(this.cat);
        return this.getQBEInfo(this.cat.getDatabase().GetQueryByResourceName(string));
    }

    public String[][] getQBEInfo(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        return jetUDatabase == null ? new String[0][0] : this.getQBEInfo(jetUDatabase.GetQueryByResourceName(string2));
    }

    String[][] getQBEInfo(JetUQuery jetUQuery) {
        if (jetUQuery != null) {
            Object object;
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            Vector vector = rptPsqlQuery.getSelColsVector();
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                PsqlSelColumn psqlSelColumn = (PsqlSelColumn)vector.elementAt(i);
                object = psqlSelColumn.getConditionsVector();
                if (((Vector)object).size() <= n) continue;
                n = ((Vector)object).size();
            }
            String[][] stringArray = new String[vector.size()][n + 2];
            for (int i = 0; i < vector.size(); ++i) {
                object = (PsqlSelColumn)vector.elementAt(i);
                Vector vector2 = ((PsqlSelColumn)object).getConditionsVector();
                stringArray[i][1] = ((PsqlColumn)object).getName();
                stringArray[i][0] = ((PsqlSelColumn)object).getTableName();
                for (int j = 0; j < vector2.size(); ++j) {
                    stringArray[i][j + 2] = (String)vector2.elementAt(j);
                }
            }
            return stringArray;
        }
        return new String[0][0];
    }

    public QBEInfo[] getQBEInfos(String string) {
        return this.transferQBEInfo(this.getQBEInfo(string));
    }

    public QBEInfo[] getQBEInfos(String string, String string2) {
        return this.transferQBEInfo(this.getQBEInfo(string, string2));
    }

    QBEInfo[] transferQBEInfo(String[][] stringArray) {
        int n = 0;
        QBEInfo[] qBEInfoArray = new QBEInfo[stringArray.length * stringArray[0].length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 2; j < stringArray[i].length; ++j) {
                if (stringArray[i][j] == null || stringArray[i][j].length() == 0) continue;
                qBEInfoArray[n++] = new QBEInfo(stringArray[i][0], stringArray[i][1], stringArray[i][j]);
            }
        }
        QBEInfo[] qBEInfoArray2 = new QBEInfo[n];
        System.arraycopy(qBEInfoArray, 0, qBEInfoArray2, 0, n);
        qBEInfoArray = qBEInfoArray2;
        return qBEInfoArray;
    }

    public String[] getSubQueries(String string) {
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.cat.getDatabase().GetQueryByResourceName(string);
        if (jetUQuery == null) {
            this.setError("getSubQueries(" + string + "): invalid query name");
        }
        return this.getSubQueries(jetUQuery);
    }

    public String[] getSubQueries(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQuery jetUQuery = null;
        if (jetUDatabase != null) {
            jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
        }
        if (jetUQuery == null) {
            this.setError("getSubQueries(" + string2 + "): invalid query name");
        }
        return this.getSubQueries(jetUQuery);
    }

    String[] getSubQueries(JetUQuery jetUQuery) {
        Vector vector = new Vector();
        if (jetUQuery != null) {
            String[] stringArray;
            int n;
            Vector vector2 = jetUQuery.getDatabase().getQueries();
            String[] stringArray2 = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                stringArray2[i] = ((JetUQuery)vector2.elementAt(i)).getResourceName();
            }
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            IExpression iExpression = rptPsqlQuery.getSearchConditionGroups();
            Vector vector3 = RptPsqlQuery.convertExpression2Vector(iExpression);
            if (vector3 != null && vector3.size() != 0) {
                for (n = 0; n < vector3.size(); ++n) {
                    Vector vector4 = (Vector)vector3.elementAt(n);
                    stringArray = null;
                    for (int i = 0; i < vector4.size(); ++i) {
                        stringArray = (String[])vector4.elementAt(i);
                        this.parseSubquery(vector, stringArray2, stringArray[0]);
                        this.parseSubquery(vector, stringArray2, stringArray[2]);
                    }
                }
            } else {
                vector3 = rptPsqlQuery.getAndExpressionVector();
                if (vector3 != null && vector3.size() != 0) {
                    n = 0;
                    int n2 = vector3.size() / 4;
                    for (int i = 0; i < n2; ++i) {
                        int n3 = ++n;
                        ++n;
                        stringArray = (String[])vector3.elementAt(n3);
                        int n4 = ++n;
                        ++n;
                        String string = (String)vector3.elementAt(n4);
                        this.parseSubquery(vector, stringArray2, (String)stringArray);
                        this.parseSubquery(vector, stringArray2, string);
                    }
                }
            }
            String[] stringArray3 = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                stringArray3[i] = string.substring(1);
            }
            return stringArray3;
        }
        this.setError("getSubQueries( ): void qryName");
        return new String[0];
    }

    public String[][] getAndConditions(String string) {
        JetUUniverse.setUniverse(this.cat);
        return this.getAndConditions(this.cat.getDatabase().GetQueryByResourceName(string));
    }

    public String[][] getAndConditions(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        return jetUDatabase == null ? new String[0][0] : this.getAndConditions(jetUDatabase.GetQueryByResourceName(string2));
    }

    String[][] getAndConditions(JetUQuery jetUQuery) {
        if (jetUQuery != null) {
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            IExpression iExpression = rptPsqlQuery.getSearchConditionGroups();
            Vector vector = RptPsqlQuery.convertExpression2Vector(iExpression);
            int n = 0;
            if (vector != null && vector.size() != 0) {
                String[][] stringArray;
                int n2;
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    stringArray = (String[][])vector.elementAt(n2);
                    n += stringArray.size();
                }
                n2 = 0;
                stringArray = new String[n][4];
                for (int i = 0; i < vector.size(); ++i) {
                    Vector vector2 = (Vector)vector.elementAt(i);
                    String[] stringArray2 = null;
                    for (int j = 0; j < vector2.size(); ++j) {
                        stringArray2 = (String[])vector2.elementAt(j);
                        stringArray[n2 + j][0] = stringArray2[3];
                        stringArray[n2 + j][1] = stringArray2[0];
                        stringArray[n2 + j][2] = stringArray2[1];
                        stringArray[n2 + j][3] = stringArray2[2];
                        ++n2;
                    }
                }
                return stringArray;
            }
            vector = rptPsqlQuery.getAndExpressionVector();
            if (vector != null && vector.size() != 0) {
                int n3 = 0;
                int n4 = vector.size() / 4;
                String[][] stringArray = new String[n4][4];
                for (int i = 0; i < n4; ++i) {
                    stringArray[i][3] = (String)vector.elementAt(n3++);
                    stringArray[i][0] = (String)vector.elementAt(n3++);
                    stringArray[i][1] = (String)vector.elementAt(n3++);
                    stringArray[i][2] = (String)vector.elementAt(n3++);
                }
                return stringArray;
            }
        } else {
            this.setError("getAndConditions( ): void qryName ");
        }
        return new String[0][0];
    }

    public AndInfo[] getAndInfos(String string) {
        return this.IsMappingNameExist(this.getAndConditions(string));
    }

    public AndInfo[] getAndInfos(String string, String string2) {
        return this.IsMappingNameExist(this.getAndConditions(string, string2));
    }

    private AndInfo[] IsMappingNameExist(String[][] stringArray) {
        if (stringArray != null) {
            AndInfo[] andInfoArray = new AndInfo[stringArray.length];
            for (int i = 0; i < andInfoArray.length; ++i) {
                andInfoArray[i] = new AndInfo(stringArray[i][0], stringArray[i][1], stringArray[i][2], stringArray[i][3]);
            }
            return andInfoArray;
        }
        return new AndInfo[0];
    }

    public String[] getColumnMappingnames(String string) {
        JetUUniverse.setUniverse(this.cat);
        return this.getColumnMappingnames(this.cat.getDatabase().getQueriableByResourceName(string));
    }

    public String[] getColumnMappingnames(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        return jetUDatabase == null ? new String[]{} : this.getColumnMappingnames(jetUDatabase.getQueriableByResourceName(string2));
    }

    String[] getColumnMappingnames(JetUQueriable jetUQueriable) {
        if (jetUQueriable != null) {
            Vector vector = jetUQueriable.getFields();
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)vector.elementAt(i);
                stringArray[i] = jetUResourceEntity.getResourceName();
            }
            return stringArray;
        }
        this.setError("getColumnMappingnames(): void qryName");
        return new String[0];
    }

    public QueryTableInfo getColumnsCanBeGroupedBy(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        return this.getColumnsCanBeGroupedBy(this.cat.getDatabase().getQueriableByResourceName(string));
    }

    public QueryTableInfo getColumnsCanBeGroupedBy(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        return jetUDatabase == null ? new QueryTableInfo(0) : this.getColumnsCanBeGroupedBy(jetUDatabase.getQueriableByResourceName(string2));
    }

    QueryTableInfo getColumnsCanBeGroupedBy(JetUQueriable jetUQueriable) {
        QueryTableInfo queryTableInfo = new QueryTableInfo(8);
        if (jetUQueriable != null) {
            Vector vector = jetUQueriable.getFields();
            int n = vector == null ? 0 : vector.size();
            for (int i = 0; i < n; ++i) {
                TableInfo tableInfo;
                int n2;
                String string;
                String string2;
                JetUQueriableField jetUQueriableField = (JetUQueriableField)vector.elementAt(i);
                if (jetUQueriableField instanceof JetUFldQueryField) {
                    string2 = ((JetUFldQueryField)jetUQueriableField).getTableShowName();
                    string = ((JetUDBTreeNode)((Object)jetUQueriableField)).getResourceName();
                    n2 = queryTableInfo.indexOf(string2);
                    if (n2 == -1) {
                        tableInfo = new TableInfo(string2, 16);
                        tableInfo.add(string);
                        queryTableInfo.add(tableInfo);
                        continue;
                    }
                    tableInfo = queryTableInfo.getTableInfo(n2);
                    tableInfo.add(string);
                    continue;
                }
                if (jetUQueriableField instanceof JetUFileQueryField) {
                    string2 = jetUQueriable.getResourceName();
                    string = ((JetUDBTreeNode)((Object)jetUQueriableField)).getResourceName();
                    n2 = queryTableInfo.indexOf(string2);
                    if (n2 == -1) {
                        tableInfo = new TableInfo(string2, 16);
                        tableInfo.add(string);
                        queryTableInfo.add(tableInfo);
                        continue;
                    }
                    tableInfo = queryTableInfo.getTableInfo(n2);
                    tableInfo.add(string);
                    continue;
                }
                if (jetUQueriableField instanceof JetUUDSField) {
                    string2 = jetUQueriable.getResourceName();
                    string = ((JetUDBTreeNode)((Object)jetUQueriableField)).getResourceName();
                    n2 = queryTableInfo.indexOf(string2);
                    if (n2 == -1) {
                        tableInfo = new TableInfo(string2, 16);
                        tableInfo.add(string);
                        queryTableInfo.add(tableInfo);
                        continue;
                    }
                    tableInfo = queryTableInfo.getTableInfo(n2);
                    tableInfo.add(string);
                    continue;
                }
                if (!(jetUQueriableField instanceof JetUProcField)) continue;
                string2 = jetUQueriable.getResourceName();
                string = ((JetUDBTreeNode)((Object)jetUQueriableField)).getResourceName();
                n2 = queryTableInfo.indexOf(string2);
                if (n2 == -1) {
                    tableInfo = new TableInfo(string2, 16);
                    tableInfo.add(string);
                    queryTableInfo.add(tableInfo);
                    continue;
                }
                tableInfo = queryTableInfo.getTableInfo(n2);
                tableInfo.add(string);
            }
        }
        return queryTableInfo;
    }

    public String[] getFormulaeForQuery(String string) {
        JetUUniverse.setUniverse(this.cat);
        return this.getFormulaeForQuery(this.cat.getDatabase().getQueriableByResourceName(string), this.cat, this.cat.getDatabase());
    }

    public String[] getFormulaeForQuery(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        return jetUDatabase == null ? new String[]{} : this.getFormulaeForQuery(jetUDatabase.getQueriableByResourceName(string2), this.cat, jetUDatabase);
    }

    String[] getFormulaeForQuery(JetUQueriable jetUQueriable, JetUUniverse jetUUniverse, JetUDatabase jetUDatabase) {
        int n = 0;
        Vector vector = jetUDatabase.getChildren();
        String[] stringArray = new String[vector.size()];
        if (jetUQueriable == null) {
            return new String[0];
        }
        for (int i = 0; i < vector.size(); ++i) {
            JetObject jetObject = (JetObject)vector.elementAt(i);
            try {
                if (!(jetObject instanceof JetUFormula) || !jetUQueriable.isFieldValidToQuery(jetUUniverse, (JetUResourceEntity)jetObject, jetUDatabase.getResourceName()) || jetObject instanceof JetUSummary) continue;
                stringArray[n++] = ((JetUFormula)jetObject).getResourceName();
                continue;
            }
            catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
                continue;
            }
            catch (FormulaHasGrammarError formulaHasGrammarError) {
                continue;
            }
            catch (CannotFindEntity cannotFindEntity) {
                // empty catch block
            }
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray = stringArray2;
        return stringArray;
    }

    public String[] getSummariesForQuery(String string) {
        JetUUniverse.setUniverse(this.cat);
        return this.getSummariesForQuery(this.cat.getDatabase().getQueriableByResourceName(string), this.cat, this.cat.getDatabase());
    }

    public String[] getSummariesForQuery(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        return jetUDatabase == null ? new String[]{} : this.getSummariesForQuery(jetUDatabase.getQueriableByResourceName(string2), this.cat, jetUDatabase);
    }

    String[] getSummariesForQuery(JetUQueriable jetUQueriable, JetUUniverse jetUUniverse, JetUDatabase jetUDatabase) {
        int n = 0;
        Vector vector = jetUDatabase.getChildren();
        String[] stringArray = new String[vector.size()];
        if (jetUQueriable == null) {
            return new String[0];
        }
        for (int i = 0; i < vector.size(); ++i) {
            JetObject jetObject = (JetObject)vector.elementAt(i);
            try {
                if (!(jetObject instanceof JetUSummary) || !jetUQueriable.isFieldValidToQuery(jetUUniverse, (JetUResourceEntity)jetObject, jetUDatabase.getResourceName())) continue;
                stringArray[n++] = ((JetUSummary)jetObject).getResourceName();
                continue;
            }
            catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
                continue;
            }
            catch (FormulaHasGrammarError formulaHasGrammarError) {
                continue;
            }
            catch (CannotFindEntity cannotFindEntity) {
                // empty catch block
            }
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray = stringArray2;
        return stringArray;
    }

    public String[] getFormulaeCanBeGroupedBy(String string) {
        JetUUniverse.setUniverse(this.cat);
        JetUQueriable jetUQueriable = this.cat.getDatabase().getQueriableByResourceName(string);
        return this.getFormulaeCanBeGroupedBy(jetUQueriable, this.cat, this.cat.getDatabase());
    }

    public String[] getFormulasCanBeGroupedBy(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQueriable jetUQueriable = null;
        if (jetUDatabase != null) {
            jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
        }
        return this.getFormulaeCanBeGroupedBy(jetUQueriable, this.cat, jetUDatabase);
    }

    String[] getFormulaeCanBeGroupedBy(JetUQueriable jetUQueriable, JetUUniverse jetUUniverse, JetUDatabase jetUDatabase) {
        int n = 0;
        Vector vector = jetUDatabase.getChildren();
        String[] stringArray = new String[vector.size()];
        if (jetUQueriable == null) {
            return new String[0];
        }
        for (int i = 0; i < vector.size(); ++i) {
            JetObject jetObject = (JetObject)vector.elementAt(i);
            try {
                if (!(jetObject instanceof JetUFormula) || !jetUQueriable.isFieldValidToQuery(jetUUniverse, (JetUResourceEntity)jetObject, jetUDatabase.getResourceName()) || !((JetUFormula)jetObject).canSummary()) continue;
                stringArray[n++] = ((JetUFormula)jetObject).getResourceName();
                continue;
            }
            catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
                continue;
            }
            catch (FormulaHasGrammarError formulaHasGrammarError) {
                continue;
            }
            catch (CannotFindEntity cannotFindEntity) {
                // empty catch block
            }
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray = stringArray2;
        return stringArray;
    }

    public String[] getFormulaeCanBeGroupedBy(String string, String string2) {
        return this.getFormulaeCanBeGroupedBy(this.getDefaultDataSourceName(), string, string2);
    }

    public String[] getFormulaeCanBeGroupedBy(String string, String string2, String string3) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQueriable jetUQueriable = null;
        if (jetUDatabase != null) {
            jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
            return this.getFormulaeCanBeGroupedBy(jetUQueriable, string3, jetUDatabase);
        }
        this.setError("getFormulaeCanBeGroupedBy(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"): invalid datasource name.");
        return new String[0];
    }

    String[] getFormulaeCanBeGroupedBy(JetUQueriable jetUQueriable, String string, JetUDatabase jetUDatabase) {
        int n = 0;
        Vector vector = jetUDatabase.getChildren();
        String[] stringArray = new String[vector.size()];
        if (jetUQueriable == null) {
            return new String[0];
        }
        for (int i = 0; i < vector.size(); ++i) {
            JetObject jetObject = (JetObject)vector.elementAt(i);
            try {
                if (!(jetObject instanceof JetUFormula) || !jetUQueriable.isFieldValidToQuery(this.cat, (JetUResourceEntity)jetObject, jetUDatabase.getResourceName()) || !((JetUFormula)jetObject).canSummary() || !((JetUFormula)jetObject).isGroupBy(string)) continue;
                stringArray[n++] = ((JetUFormula)jetObject).getResourceName();
                continue;
            }
            catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
                continue;
            }
            catch (FormulaHasGrammarError formulaHasGrammarError) {
                continue;
            }
            catch (CannotFindEntity cannotFindEntity) {
                // empty catch block
            }
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray = stringArray2;
        return stringArray;
    }

    public String[] getChartFunctions(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUQueriable jetUQueriable = this.cat.getDatabase().getQueriableByResourceName(string);
        return this.getChartFunctions(this.cat, jetUQueriable, string2);
    }

    public String[] getChartFunctions(String string, String string2, String string3) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQueriable jetUQueriable = null;
        if (jetUDatabase != null) {
            jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
        }
        return this.getChartFunctions(this.cat, jetUQueriable, string3);
    }

    String[] getChartFunctions(JetUUniverse jetUUniverse, JetUQueriable jetUQueriable, String string) {
        if (jetUQueriable == null) {
            return new String[0];
        }
        Vector vector = this.getGroupFormula(jetUUniverse, jetUQueriable, string);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    Vector getGroupFormula(JetUUniverse jetUUniverse, JetUQueriable jetUQueriable, String string) {
        Vector<String> vector = new Vector<String>(10);
        Vector vector2 = this.getGroupByFormula(jetUUniverse, string, jetUQueriable);
        int n = vector2.size();
        JetUFormula jetUFormula = null;
        block3: for (int i = 0; i < n; ++i) {
            jetUFormula = (JetUFormula)vector2.elementAt(i);
            DbColDesc dbColDesc = jetUFormula.getColDesc();
            if (dbColDesc == null) {
                return vector;
            }
            switch (dbColDesc.getSqlType()) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (jetUFormula.formulainfo.isGlobal) continue block3;
                    vector.addElement(((JetUFormula)vector2.elementAt(i)).getResourceName());
                }
            }
        }
        return vector;
    }

    Vector getGroupByFormula(JetUUniverse jetUUniverse, String string, JetUQueriable jetUQueriable) {
        Vector<JetUFormula> vector = new Vector<JetUFormula>();
        JetUDatabase jetUDatabase = jetUQueriable.getDatabase();
        Vector vector2 = jetUDatabase.getFormulasAndSummaries();
        int n = vector2.size();
        String string2 = jetUDatabase.getResourceName();
        try {
            for (int i = 0; i < n; ++i) {
                JetUFormula jetUFormula = (JetUFormula)vector2.elementAt(i);
                if (!jetUFormula.isGroupBy(string) || !jetUQueriable.isFieldValidToQuery(jetUUniverse, jetUFormula.getResourceName(), string2)) continue;
                vector.addElement(jetUFormula);
            }
        }
        catch (FormulaHasGrammarError formulaHasGrammarError) {
        }
        catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
        }
        catch (CannotFindEntity cannotFindEntity) {
            // empty catch block
        }
        return vector;
    }

    public String[] getParameterCanBeGroupedBy() {
        JetUUniverse.setUniverse(this.cat);
        int n = 0;
        Vector vector = this.cat.getDatabase().getParameters();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            JetObject jetObject = (JetObject)vector.elementAt(i);
            if (((JetUParameter)jetObject).getColDesc().getSqlType() != 12) continue;
            stringArray[n++] = ((JetUParameter)jetObject).getResourceName();
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray = stringArray2;
        return stringArray;
    }

    public String[] getParameterCanBeGroupedBy(String string) {
        JetUUniverse.setUniverse(this.cat);
        int n = 0;
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        Vector vector = new Vector();
        if (jetUDatabase != null) {
            vector = jetUDatabase.getParameters();
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            JetObject jetObject = (JetObject)vector.elementAt(i);
            if (((JetUParameter)jetObject).getColDesc().getSqlType() != 12) continue;
            stringArray[n++] = ((JetUParameter)jetObject).getResourceName();
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray = stringArray2;
        return stringArray;
    }

    public String[] getSummaryCanBeSortedBy(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUQueriable jetUQueriable = this.cat.getDatabase().getQueriableByResourceName(string);
        return this.getSummaryCanBeSortedBy(jetUQueriable, string2, this.cat);
    }

    public String[] getSummaryCanBeSortedBy(String string, String string2, String string3) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQueriable jetUQueriable = null;
        if (jetUDatabase != null) {
            jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
        }
        return this.getSummaryCanBeSortedBy(jetUQueriable, string3, this.cat);
    }

    String[] getSummaryCanBeSortedBy(JetUQueriable jetUQueriable, String string, JetUUniverse jetUUniverse) {
        JetUUniverse.setUniverse(jetUUniverse);
        int n = 0;
        if (jetUQueriable == null) {
            return new String[0];
        }
        JetUDatabase jetUDatabase = jetUQueriable.getDatabase();
        Vector vector = jetUDatabase.getSummaries();
        String[] stringArray = new String[vector.size()];
        String string2 = jetUDatabase.getResourceName();
        for (int i = 0; i < vector.size(); ++i) {
            JetObject jetObject = (JetObject)vector.elementAt(i);
            try {
                if (!(jetObject instanceof JetUSummary) || !jetUQueriable.isFieldValidToQuery(jetUUniverse, (JetUResourceEntity)jetObject, string2) || !((JetUSummary)jetObject).isGroupBy(string)) continue;
                stringArray[n++] = ((JetUSummary)jetObject).getResourceName();
                continue;
            }
            catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
                continue;
            }
            catch (FormulaHasGrammarError formulaHasGrammarError) {
                continue;
            }
            catch (CannotFindEntity cannotFindEntity) {
                // empty catch block
            }
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray = stringArray2;
        return stringArray;
    }

    public String[] getMappingnames(String string) {
        JetUUniverse.setUniverse(this.cat);
        JetUQueriable jetUQueriable = this.cat.getDatabase().getQueriableByResourceName(string);
        if (jetUQueriable != null) {
            Vector vector = jetUQueriable.getFields();
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)vector.elementAt(i);
                stringArray[i] = jetUResourceEntity.getResourceName();
            }
            return stringArray;
        }
        return null;
    }

    public String[] getMappingnames(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQueriable jetUQueriable = null;
        if (jetUDatabase != null) {
            jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
        }
        if (jetUQueriable != null) {
            Vector vector = jetUQueriable.getFields();
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)vector.elementAt(i);
                stringArray[i] = jetUResourceEntity.getResourceName();
            }
            return stringArray;
        }
        return null;
    }

    void addTables(String string, String string2, Connection connection, Vector vector, boolean bl, int n) {
        JetUUniverse.setUniverse(this.cat);
        Vector<PsqlTable> vector2 = new Vector<PsqlTable>();
        try {
            Object object;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string3 = null;
            String string4 = databaseMetaData.getDriverName();
            if (string4.equals("InterClient")) {
                string3 = "%";
            } else if (connection.getClass().getName().equals("oracle.jdbc.driver.OracleConnection") && Locale.getDefault().toString().startsWith("zh")) {
                object = connection.getClass();
                try {
                    Method method = ((Class)object).getDeclaredMethod("setDefaultRowPrefetch", Integer.TYPE);
                    method.invoke((Object)connection, new Integer(300));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            object = databaseMetaData.getTables(string, string2, string3, null);
            boolean bl2 = object.next();
            if (!bl2) {
                object.close();
                string3 = "%";
                object = databaseMetaData.getTables(string, string2, string3, null);
                bl2 = object.next();
            }
            while (bl2) {
                String string5 = object.getString(1);
                String string6 = object.getString(2);
                PsqlTable psqlTable = new PsqlTable(string5, string6, object.getString(3).trim(), object.getString(4));
                if (string == null || string2 == null) {
                    if (PsqlTable.getTableByName(vector2, psqlTable.getQualifier(), psqlTable.getOwner(), psqlTable.getName(), false) == null && (!psqlTable.isSystemTable() || bl)) {
                        vector2.addElement(psqlTable);
                        if (n == 2 && psqlTable.isTable() || n == 3 && psqlTable.isView() || n == 13 && psqlTable.isSynonym() || n == 14 && psqlTable.isAlias() || n == -1) {
                            vector.addElement(psqlTable.getName());
                        }
                    }
                } else {
                    vector2.addElement(psqlTable);
                    if (!psqlTable.isSystemTable() || bl) {
                        vector2.addElement(psqlTable);
                        if (n == 2 && psqlTable.isTable() || n == 3 && psqlTable.isView() || n == 13 && psqlTable.isSynonym() || n == 14 && psqlTable.isAlias() || n == -1) {
                            vector.addElement(psqlTable.getName());
                        }
                    }
                }
                bl2 = object.next();
            }
            object.close();
        }
        catch (SQLException sQLException) {
            this.setError(sQLException);
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    Vector getTablesInDatabase(String string, String string2, String string3, String string4, boolean bl, int n) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        JetUJDBCConnection jetUJDBCConnection = this.BuildDefaultUniverse(string, string2);
        Connection connection = null;
        if (jetUJDBCConnection == null) {
            this.setError("there is no connection in current universe");
        } else {
            try {
                connection = ConnectionToolkit.getConnection(jetUJDBCConnection);
                PsqlJdbcDSInfo psqlJdbcDSInfo = new PsqlJdbcDSInfo(connection, true);
                psqlJdbcDSInfo.getSupportInfo();
                if (psqlJdbcDSInfo.bSuppOwner) {
                    if (string4 == null) {
                        vector2 = this.getOwners(connection);
                    } else {
                        vector2.add(string4);
                    }
                }
                if (psqlJdbcDSInfo.bSuppQlf) {
                    if (string3 == null) {
                        vector = this.getQualifiers(connection);
                    } else {
                        vector.add(string3);
                    }
                }
                if (vector.size() == 0 && vector2.size() == 0) {
                    this.addTables(null, null, connection, vector3, bl, n);
                } else if (vector.size() == 0) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        this.addTables(null, (String)vector2.elementAt(i), connection, vector3, bl, n);
                    }
                } else if (vector2.size() == 0) {
                    for (int i = 0; i < vector.size(); ++i) {
                        this.addTables((String)vector.elementAt(i), null, connection, vector3, bl, n);
                    }
                } else {
                    for (int i = 0; i < vector.size(); ++i) {
                        for (int j = 0; j < vector2.size(); ++j) {
                            this.addTables((String)vector.elementAt(i), (String)vector2.elementAt(j), connection, vector3, bl, n);
                        }
                    }
                }
                ConnectionToolkit.freeConnection(connection);
            }
            catch (SQLException sQLException) {
                this.setError(sQLException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.setError(classNotFoundException);
            }
        }
        return vector3;
    }

    private JetUConnection IsMappingNameOK(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUConnection jetUConnection = null;
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase != null) {
            jetUConnection = string2 == null ? jetUDatabase.getConnection() : jetUDatabase.getConnectionByResourceName(string2);
        }
        return jetUConnection;
    }

    Vector getOwners(Connection connection) {
        Vector<String> vector = new Vector<String>();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getSchemas();
            boolean bl = resultSet.next();
            while (bl) {
                String string = resultSet.getString(1);
                if (string.trim().length() != 0 && !DbTools.hasTheStringInVector(string, vector)) {
                    vector.addElement(string);
                }
                bl = resultSet.next();
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    Vector getQualifiers(Connection connection) {
        Vector<String> vector = new Vector<String>();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getCatalogs();
            boolean bl = resultSet.next();
            while (bl) {
                String string = resultSet.getString(1);
                if (string.trim().length() != 0 && !DbTools.hasTheStringInVector(string, vector)) {
                    vector.addElement(string);
                }
                bl = resultSet.next();
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            this.setError(sQLException);
        }
        catch (Exception exception) {
            this.setError(exception);
        }
        return vector;
    }

    Vector getProcedures(String string) {
        JetUUniverse.setUniverse(this.cat);
        JetUConnection jetUConnection = this.cat.getDatabase(string).getConnection();
        return jetUConnection == null ? null : jetUConnection.getProcedures();
    }

    public String mapFunction(int n) {
        JetUUniverse.setUniverse(this.cat);
        String string = "";
        switch (n) {
            case 1: {
                string = "Count";
                break;
            }
            case 2: {
                string = "Sum";
                break;
            }
            case 6: {
                string = "Average";
                break;
            }
            case 4: {
                string = "Maximum";
                break;
            }
            case 3: {
                string = "Minimum";
                break;
            }
            case 8: {
                string = "PopulationStdDev";
                break;
            }
            case 9: {
                string = "PopulationVariance";
                break;
            }
            case 10: {
                string = "StdDev";
                break;
            }
            case 11: {
                string = "Variance";
                break;
            }
            case 5: {
                string = "DistinctCount";
                break;
            }
            case 16: {
                string = "RunningCount";
                break;
            }
            case 17: {
                string = "RunningsUM";
                break;
            }
            case 18: {
                string = "RunningMinimum";
                break;
            }
            case 19: {
                string = "RunningMaximum";
                break;
            }
            case 21: {
                string = "RunningAvg";
                break;
            }
            case 20: {
                string = "RunningDistinctCount";
                break;
            }
            default: {
                string = "error";
            }
        }
        return string;
    }

    boolean checkClass(String string) {
        JetUUniverse.setUniverse(this.cat);
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            if (obj instanceof JRResultSet) {
                bl = true;
            } else if (obj instanceof JRUserDataSource) {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.setError(exception);
        }
        return bl;
    }

    JetUUniverse getCatalog() {
        return this.cat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean runProcedure(String string, JdbcDatabase jdbcDatabase, ProcInfo procInfo, int n, DateTimeFormat dateTimeFormat) throws ParameterFormatInvalid, SQLException, ClassNotFoundException, JRStopEngineException {
        ResultSet resultSet;
        JetUUniverse.setUniverse(this.cat);
        boolean bl = true;
        DbProcedure dbProcedure = new DbProcedure(jdbcDatabase, procInfo, n, dateTimeFormat);
        dbProcedure.getSupportInfo(((JetUConnection)dateTimeFormat).getSupportInfo());
        try {
            resultSet = dbProcedure.getResultSet();
            if (resultSet != null) {
                procInfo.fetchProcColumns(resultSet);
            } else {
                bl = false;
            }
        }
        finally {
            resultSet = null;
            dbProcedure.close();
        }
        return bl;
    }

    void initProcParameterItems(JetUProcedure jetUProcedure) {
        JetUUniverse.setUniverse(this.cat);
        Vector vector = jetUProcedure.getParameters();
        int n = vector.size();
        JetUProcParameter jetUProcParameter = null;
        for (int i = 0; i < n; ++i) {
            jetUProcParameter = (JetUProcParameter)vector.elementAt(i);
            String string = jetUProcParameter.getResourceName();
            if (!jetUProcedure.getDatabase().IsMappingNameOK(string, new StringBuffer())) {
                string = jetUProcedure.getResourceName() + "_" + string;
            }
            String string2 = MappingSQLType.mapSQLTypeToString(jetUProcParameter.getSQLType());
            String string3 = JResource.getMessage("CAT_PROCEDURE_PARAMETER_1", new String[]{String.valueOf(jetUProcParameter.getIndex()), jetUProcParameter.getProcedureName(), jetUProcParameter.getSQLTypeName()});
            String string4 = jetUProcParameter.getValue();
            JetUParameter jetUParameter = new JetUParameter(string, "", string3, string2, string4);
            try {
                jetUParameter.checkParameter(Locale.getDefault());
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
            jetUProcedure.getDatabase().addParameter(jetUParameter);
        }
    }

    private String IsModified(JetUUniverse jetUUniverse, String string) {
        JetUUniverse.setUniverse(jetUUniverse);
        int n = 1;
        while (jetUUniverse.getDatabase(string).getFormulaByResourceName("Formula" + n) != null) {
            ++n;
        }
        return "Formula" + n;
    }

    private String IsTableNameOK(String string) {
        JetUUniverse.setUniverse(this.cat);
        int n = 1;
        while (this.cat.getQueriableByResourceName(string, "Query" + n) != null) {
            ++n;
        }
        return "Query" + n;
    }

    void lookForCurrentReportIndex(String string) {
        JetUUniverse.setUniverse(this.cat);
        File file = new File(string);
        String[] stringArray = file.list(new ReportFilter());
        if (stringArray != null) {
            int n = stringArray.length;
            while (--n >= 0) {
                int n2;
                if (stringArray[n].length() <= 6 || !stringArray[n].substring(0, 6).equalsIgnoreCase("Report")) continue;
                try {
                    n2 = Integer.parseInt(stringArray[n].substring(6, stringArray[n].toLowerCase().indexOf(".cls")));
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                this.reportidx = Math.max(n2, this.reportidx);
            }
        }
    }

    public boolean isModified() {
        JetUUniverse.setUniverse(this.cat);
        return this.cat.IsModified();
    }

    public void setModified(boolean bl) {
        JetUUniverse.setUniverse(this.cat);
        this.cat.setModified(bl);
    }

    private Vector JDBC(Vector vector, String string, String string2, String string3) {
        JetUUniverse.setUniverse(this.cat);
        Vector<PsqlTable> vector2 = new Vector<PsqlTable>();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        for (int i = 0; i < vector.size(); ++i) {
            PsqlTable psqlTable = (PsqlTable)vector.elementAt(i);
            if (!psqlTable.getName().equalsIgnoreCase(string3)) continue;
            String string4 = psqlTable.getQualifier();
            if (string4 == null || string4.trim().length() == 0) {
                string4 = "";
            }
            if (!string4.equals(string)) continue;
            String string5 = psqlTable.getOwner();
            if (string5 == null || string5.trim().length() == 0) {
                string5 = "";
            }
            if (!string5.equals(string2)) continue;
            vector2.addElement(psqlTable);
        }
        return vector2;
    }

    private boolean JDBC_ODBC_BRIDGE(PsqlColumn psqlColumn, PsqlColumn psqlColumn2) {
        JetUUniverse.setUniverse(this.cat);
        boolean bl = false;
        if (psqlColumn.getType() == psqlColumn2.getType()) {
            bl = this.isVarCharTypes(psqlColumn.getType()) ? psqlColumn.length == psqlColumn2.length : true;
        }
        return bl;
    }

    boolean isVarCharTypes(int n) {
        return n == 12 || n == 1 || n == -1;
    }

    private boolean LoadNoCache(Vector vector, PsqlJoin psqlJoin) {
        JetUUniverse.setUniverse(this.cat);
        boolean bl = false;
        int n = vector.size();
        while (--n >= 0) {
            PsqlJoin psqlJoin2 = (PsqlJoin)vector.elementAt(n);
            if (!psqlJoin2.getTableFrom().getName().equalsIgnoreCase(psqlJoin.getTableFrom().getName()) || !psqlJoin2.getColumnFrom().getName().equalsIgnoreCase(psqlJoin.getColumnFrom().getName()) || !psqlJoin2.getTableTo().getName().equalsIgnoreCase(psqlJoin.getTableTo().getName()) || !psqlJoin2.getColumnTo().getName().equalsIgnoreCase(psqlJoin.getColumnTo().getName()) || !psqlJoin2.getOperator().equalsIgnoreCase(psqlJoin.getOperator())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getQuoteChar() {
        String string;
        JetUUniverse.setUniverse(this.cat);
        JetUJDBCConnection jetUJDBCConnection = this.BuildDefaultUniverse(null, null);
        String string2 = DbTools.sQuoteChar;
        if (jetUJDBCConnection != null && (string = jetUJDBCConnection.getSupportInfo().getQuoteChar()) != null) {
            string2 = string;
        }
        return string2;
    }

    public String getQuoteChar(String string) {
        String string2;
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUJDBCConnection jetUJDBCConnection = null;
        if (jetUDatabase != null) {
            jetUJDBCConnection = this.BuildDefaultUniverse(string, null);
        }
        String string3 = DbTools.sQuoteChar;
        if (jetUJDBCConnection != null && (string2 = jetUJDBCConnection.getSupportInfo().getQuoteChar()) != null) {
            string3 = string2;
        }
        return string3;
    }

    public String getQuoteChar(String string, String string2) {
        String string3;
        JetUUniverse.setUniverse(this.cat);
        JetUJDBCConnection jetUJDBCConnection = this.BuildDefaultUniverse(string, string2);
        String string4 = DbTools.sQuoteChar;
        if (jetUJDBCConnection != null && (string3 = jetUJDBCConnection.getSupportInfo().getQuoteChar()) != null) {
            string4 = string3;
        }
        return string4;
    }

    private String P_VISIBLE(String string, String string2, int n, JetUUniverse jetUUniverse) {
        JetUUniverse.setUniverse(jetUUniverse);
        JetUDatabase jetUDatabase = this.getDatabase(string, jetUUniverse);
        if (jetUDatabase == null) {
            return null;
        }
        if (n == 15) {
            return jetUDatabase.getQualifyName();
        }
        switch (n) {
            case 1: {
                JetUConnection jetUConnection = jetUDatabase.getConnectionByResourceName(string2);
                return jetUConnection != null ? jetUConnection.getQualifyName() : null;
            }
            case 26: {
                JetUXMLConnection jetUXMLConnection = (JetUXMLConnection)jetUDatabase.getConnectionByResourceName(string2);
                return jetUXMLConnection != null ? jetUXMLConnection.getQualifyName() : null;
            }
            case 5: {
                JetUQuery jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
                return jetUQuery != null ? jetUQuery.getQualifyName() : null;
            }
            case 6: {
                JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
                return jetUQueriable != null && jetUQueriable instanceof JetUProcedure ? ((JetUProcedure)jetUQueriable).getQualifyName() : null;
            }
            case 8: {
                JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
                return jetUQueriable != null && jetUQueriable instanceof JetUUserDataSource ? ((JetUUserDataSource)jetUQueriable).getQualifyName() : null;
            }
            case 7: {
                JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
                return jetUQueriable != null && jetUQueriable instanceof JetUFileQuery ? ((JetUFileQuery)jetUQueriable).getQualifyName() : null;
            }
            case 10: {
                JetUSummary jetUSummary = jetUDatabase.getSummaryByResourceName(string2);
                return jetUSummary != null ? jetUSummary.getQualifyName() : null;
            }
            case 9: {
                JetUFormula jetUFormula = jetUDatabase.getFormulaByResourceName(string2);
                return jetUFormula != null ? jetUFormula.getQualifyName() : null;
            }
            case 11: {
                JetUParameter jetUParameter = jetUDatabase.getParameterByResourceName(string2);
                return jetUParameter != null ? jetUParameter.getQualifyName() : null;
            }
            case 12: {
                JetUWherePortion jetUWherePortion = jetUDatabase.getWherePortionByResourceName(string2);
                return jetUWherePortion != null ? jetUWherePortion.getQualifyName() : null;
            }
            case 3: {
                JetUTableView jetUTableView = jetUDatabase.getConnection().getTableViewsByResourceName(string2, 2);
                return jetUTableView != null ? jetUTableView.getQualifyName() : null;
            }
            case 2: {
                JetUTableView jetUTableView = jetUDatabase.getConnection().getTableViewsByResourceName(string2, 1);
                return jetUTableView != null ? jetUTableView.getQualifyName() : null;
            }
            case 32: {
                Vector vector = this.TYPE(jetUDatabase, true);
                for (int i = 0; i < vector.size(); ++i) {
                    if (!((JBusinessLogic)vector.get(i)).getName().equalsIgnoreCase(string2)) continue;
                    return ((JetObject)vector.get(i)).getQualifyName();
                }
                return null;
            }
            case 17: {
                Vector vector = this.Save(jetUDatabase);
                for (int i = 0; i < vector.size(); ++i) {
                    if (!((JBusinessLogic)vector.get(i)).getName().equalsIgnoreCase(string2)) continue;
                    return ((JetObject)vector.get(i)).getQualifyName();
                }
                return null;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return null;
            }
        }
        JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(string2);
        if (jetUResourceEntity != null) {
            return jetUResourceEntity.getQualifyName();
        }
        JetUResourceContainer jetUResourceContainer = (JetUResourceContainer)((Object)jetUDatabase.getQueriableByResourceName(string2));
        if (jetUResourceContainer != null) {
            return jetUResourceContainer.getQualifyName();
        }
        JetUConnection jetUConnection = jetUDatabase.getConnection();
        if (jetUConnection != null) {
            jetUResourceContainer = jetUConnection.GetTableOrViewByResourceName(string2);
        }
        if (jetUResourceContainer != null) {
            return jetUResourceContainer.getQualifyName();
        }
        return null;
    }

    public String getHandle(String string, int n) {
        return this.P_VISIBLE(this.getDefaultDataSourceName(), string, n, this.cat);
    }

    public String getHandle(String string, String string2, int n) {
        return this.P_VISIBLE(string, string2, n, this.cat);
    }

    public String[] getFunctions(String string) {
        JetUUniverse.setUniverse(this.cat);
        JetUResourceEntity jetUResourceEntity = this.cat.getDatabase().getResourceByName(string);
        if (jetUResourceEntity != null) {
            DbColDesc dbColDesc = jetUResourceEntity.getColDesc();
            int n = -1;
            if (dbColDesc != null) {
                n = dbColDesc.getSqlType();
            }
            return this.getFunctions(n);
        }
        return new String[0];
    }

    public String[] getFunctions(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUResourceEntity jetUResourceEntity = null;
        if (jetUDatabase != null) {
            jetUResourceEntity = jetUDatabase.getResourceByName(string2);
        }
        if (jetUResourceEntity != null && jetUResourceEntity.getColDesc() != null) {
            int n = jetUResourceEntity.getColDesc().getSqlType();
            return this.getFunctions(n);
        }
        return new String[0];
    }

    public String[] getFunctions(int n) {
        Vector<String> vector = new Vector<String>();
        if (SumaryFuncs.justify("COUNT", n)) {
            vector.add("Count");
            vector.add("DistinctCount");
        }
        if (SumaryFuncs.justify("SUM", n)) {
            vector.add("Sum");
        }
        if (SumaryFuncs.justify("AVERAGE", n)) {
            vector.add("Average");
        }
        if (SumaryFuncs.justify("MAXIMUM", n)) {
            vector.add("Maximum");
        }
        if (SumaryFuncs.justify("MINIMUM", n)) {
            vector.add("Minimum");
        }
        if (SumaryFuncs.justify("POPULATIONSTDDEV", n)) {
            vector.add("PopulationStdDev");
        }
        if (SumaryFuncs.justify("POPULATIONVARIANCE", n)) {
            vector.add("PopulationVariance");
        }
        if (SumaryFuncs.justify("STDDEV", n)) {
            vector.add("StdDev");
        }
        if (SumaryFuncs.justify("VARIANCE", n)) {
            vector.add("Variance");
        }
        if (SumaryFuncs.justify("RunningCount".toUpperCase(), n)) {
            vector.add("Aggregation.FUNC_NAME_RUNNING_COUNT");
        }
        if (SumaryFuncs.justify("RunningSum".toUpperCase(), n)) {
            vector.add("Aggregation.FUNC_NAME_RUNNING_SUMMARY");
        }
        if (SumaryFuncs.justify("RunningMaximum".toUpperCase(), n)) {
            vector.add("Aggregation.FUNC_NAME_RUNNING_MAXIMUM");
        }
        if (SumaryFuncs.justify("RunningMinimum".toUpperCase(), n)) {
            vector.add("Aggregation.FUNC_NAME_RUNNING_MINIMUM");
        }
        if (SumaryFuncs.justify("RunningAvg".toUpperCase(), n)) {
            vector.add("Aggregation.FUNC_NAME_RUNNING_AVERAGE");
        }
        if (SumaryFuncs.justify("RunningDistinctCount".toUpperCase(), n)) {
            vector.add("Aggregation.FUNC_NAME_RUNNING_DISTINCTCOUNT");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    String getMappingName(String string) {
        int n = string.indexOf(64);
        if (n == -1) {
            n = string.indexOf(58);
        }
        if (n != -1) {
            String string2 = " )";
            String string3 = string.substring(n + 1);
            if (string3.charAt(0) == '\"') {
                n = string3.lastIndexOf(34);
                if (n > 0) {
                    string3 = string3.substring(1, n);
                }
            } else {
                n = 0;
                while (string2.indexOf(string3.charAt(n)) == -1 && ++n < string3.length()) {
                }
                if (n < string3.length()) {
                    string3 = string3.substring(0, n);
                }
            }
            return string3;
        }
        return null;
    }

    public void rename(String string, String string2, int n) {
        this.clearMsg();
        JetUDBTreeNode jetUDBTreeNode = null;
        switch (n) {
            case 15: {
                jetUDBTreeNode = this.getDatabase(string, this.cat);
                break;
            }
            case 1: {
                jetUDBTreeNode = this.cat.getConnectionByResourceName(string);
                break;
            }
            case 5: {
                jetUDBTreeNode = this.cat.GetQueryByResourceName(string);
                break;
            }
            case 6: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)this.cat.getQueriableByResourceName(string));
                break;
            }
            case 8: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)this.cat.getQueriableByResourceName(string));
                break;
            }
            case 7: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)this.cat.getQueriableByResourceName(string));
                break;
            }
            case 10: {
                jetUDBTreeNode = this.cat.getDatabase().getSummaryByResourceName(string);
                break;
            }
            case 9: {
                jetUDBTreeNode = this.cat.getDatabase().getFormulaByResourceName(string);
                break;
            }
            case 11: {
                jetUDBTreeNode = this.cat.getDatabase().getParameterByResourceName(string);
                break;
            }
            case 12: {
                jetUDBTreeNode = this.cat.getDatabase().getWherePortionByResourceName(string);
                break;
            }
            case 3: {
                jetUDBTreeNode = (JetUView)this.cat.getDatabase().getConnection().getTableViewsByResourceName(string, 2);
                break;
            }
            case 2: {
                jetUDBTreeNode = (JetUTable)this.cat.getDatabase().getConnection().getTableViewsByResourceName(string, 2);
                break;
            }
            case 4: {
                jetUDBTreeNode = this.cat.getResourceByName(string);
            }
        }
        if (jetUDBTreeNode != null) {
            if (this.referResource != null) {
                try {
                    this.referResource.renameRefBeforeAction(jetUDBTreeNode, string2, true, new Hashtable(), false);
                }
                catch (RefResourceException refResourceException) {
                    this.setError("rename(\"" + string + "\",\"" + string2 + "\",\"" + n + "\"): rename resource name " + "[" + string + "] failed.");
                    this.setError(refResourceException);
                }
            }
            if (n == 15) {
                ((JetUDatabase)jetUDBTreeNode).rename(string2);
            } else {
                jetUDBTreeNode.setResourceName(string2);
            }
        } else {
            this.setError("rename(\"" + string + "\",\"" + string2 + "\",\"" + n + "\"): void resource name " + "[" + string + "]");
        }
    }

    public void rename(String string, String string2, String string3, int n) {
        this.clearMsg();
        JetUDBTreeNode jetUDBTreeNode = null;
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            return;
        }
        switch (n) {
            case 15: {
                jetUDBTreeNode = jetUDatabase;
                break;
            }
            case 1: {
                jetUDBTreeNode = jetUDatabase.getConnectionByResourceName(string2);
                break;
            }
            case 5: {
                jetUDBTreeNode = jetUDatabase.GetQueryByResourceName(string2);
                break;
            }
            case 6: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)jetUDatabase.getQueriableByResourceName(string2));
                break;
            }
            case 8: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)jetUDatabase.getQueriableByResourceName(string2));
                break;
            }
            case 7: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)jetUDatabase.getQueriableByResourceName(string2));
                break;
            }
            case 10: {
                jetUDBTreeNode = jetUDatabase.getSummaryByResourceName(string2);
                break;
            }
            case 9: {
                jetUDBTreeNode = jetUDatabase.getFormulaByResourceName(string2);
                break;
            }
            case 11: {
                jetUDBTreeNode = jetUDatabase.getParameterByResourceName(string2);
                break;
            }
            case 12: {
                jetUDBTreeNode = jetUDatabase.getWherePortionByResourceName(string2);
                break;
            }
            case 3: {
                jetUDBTreeNode = (JetUView)jetUDatabase.getConnection().getTableViewsByResourceName(string2, 2);
                break;
            }
            case 2: {
                jetUDBTreeNode = (JetUTable)jetUDatabase.getConnection().getTableViewsByResourceName(string2, 2);
                break;
            }
            case 4: {
                jetUDBTreeNode = jetUDatabase.getResourceByName(string2);
            }
        }
        if (jetUDBTreeNode != null) {
            try {
                this.referResource.renameRefBeforeAction(jetUDBTreeNode, string3, true, new Hashtable(), false);
            }
            catch (RefResourceException refResourceException) {
                this.setError("rename(\"" + string2 + "\",\"" + string3 + "\",\"" + n + "\"): rename resource name " + "[" + string2 + "] failed.");
                this.setError(refResourceException);
            }
            if (n == 15) {
                ((JetUDatabase)jetUDBTreeNode).rename(string3);
            } else {
                jetUDBTreeNode.setResourceName(string3);
            }
        } else {
            this.setError("rename(\"" + string2 + "\",\"" + string3 + "\",\"" + n + "\"): void resource name " + "[" + string2 + "]");
        }
    }

    public ObjectInfo getObjectInfo(String string, int n) {
        String string2 = this.getHandle(string, n);
        if (string2 != null) {
            return this.getObjectInfo(string2);
        }
        this.setError("getObjectInfo(" + string + "," + n + ") void resourceName or type.");
        return null;
    }

    public ObjectInfo getObjectInfo(String string, String string2, int n) {
        String string3 = this.getHandle(string, string2, n);
        if (string3 != null) {
            return this.getObjectInfo(string3);
        }
        this.setError("getObjectInfo(" + string2 + "," + n + ") void resourceName or type.");
        return null;
    }

    public ObjectInfo getObjectInfo(String string) {
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            Hashtable hashtable = jetObject.getProperties();
            ObjectInfo objectInfo = new ObjectInfo();
            objectInfo.setInfo(hashtable);
            return objectInfo;
        }
        this.setError("getObjectInfo(" + string + ") void handle.");
        return null;
    }

    public void setParseFmlFlag(boolean bl) {
        this.C = bl;
    }

    public boolean getParseFmlFlag() {
        return this.C;
    }

    public boolean needParse() {
        return this.CreateCatalog;
    }

    public boolean saveC() throws WriteFailureException {
        JetUUniverse.setUniverse(this.cat);
        try {
            return this.cat.Save();
        }
        catch (FMLFileException fMLFileException) {
            this.setError(fMLFileException);
            return false;
        }
    }

    public boolean parseFormula() {
        return this.parseFormula(this.getDefaultDataSourceName());
    }

    public boolean parseFormula(String string) {
        boolean bl = false;
        JetUDatabase jetUDatabase = this.cat.getDatabase(string);
        try {
            jetUDatabase.parseFormulas(true, true);
            bl = true;
        }
        catch (ParseFormulaFailedException parseFormulaFailedException) {
            bl = false;
        }
        this.CreateCatalog = false;
        return bl;
    }

    public String getDSNamewithConnection(String string) {
        String string2 = "NULL";
        Vector vector = this.cat.getAllDatabases();
        String string3 = BuildDefaultUniverse + string;
        for (int i = 0; i < vector.size(); ++i) {
            String string4;
            JetUDatabase jetUDatabase = (JetUDatabase)vector.elementAt(i);
            JetUConnection jetUConnection = jetUDatabase.getConnection();
            if (jetUConnection == null || !(jetUConnection instanceof JetUJDBCConnection) || !(string4 = ((JetUJDBCConnection)jetUConnection).getURL()).equalsIgnoreCase(string3)) continue;
            string2 = jetUDatabase.getResourceName();
            break;
        }
        if (string2.equals("NULL")) {
            string2 = this.SEDU(string);
        }
        return string2;
    }

    private String SEDU(String string) {
        String string2 = "NULL";
        Vector vector = this.cat.getAllDatabases();
        for (int i = 0; i < vector.size(); ++i) {
            JetUDatabase jetUDatabase = (JetUDatabase)vector.elementAt(i);
            if (jetUDatabase == null || !jetUDatabase.getResourceName().equalsIgnoreCase(string)) continue;
            string2 = string;
            break;
        }
        return string2;
    }

    public int getSQLType(String string, String string2) {
        return this.getSQLType(this.getDefaultDataSourceName(), string, string2);
    }

    public int getSQLType(String string, String string2, String string3) {
        return this.cat.getSQLType(string, string2, string3).getSqlType();
    }

    void parseSubquery(Vector vector, String[] stringArray, String string) {
        int n;
        String string2 = null;
        int n2 = n = string == null ? -1 : string.indexOf(64);
        while (n != -1) {
            int n3 = (string = string.substring(n)).indexOf(" ");
            string2 = n3 != -1 ? string.substring(0, n3) : string;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equalsIgnoreCase('@' + stringArray[i])) continue;
                if (vector.indexOf(string2) != -1) break;
                vector.addElement('@' + stringArray[i]);
                break;
            }
            if (n3 == -1) break;
            n = (string = string.substring(n3)).indexOf(64);
            if (n == -1) continue;
            string = string.substring(n);
            n = string.indexOf(64);
        }
    }

    public String getSQLString(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUQueriable jetUQueriable = this.cat.getQueriableByResourceName(string);
        String string2 = "";
        if (jetUQueriable != null) {
            string2 = this.getSQLString(jetUQueriable);
        } else {
            this.setError("getSQLString(" + string + "):void resource name");
        }
        return string2;
    }

    public String getSQLString(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        JetUQueriable jetUQueriable = null;
        if (jetUDatabase != null) {
            jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
        }
        String string3 = "";
        if (jetUQueriable != null) {
            string3 = this.getSQLString(jetUQueriable);
        } else {
            this.setError("getSQLString(" + string2 + "):void resource name");
        }
        return string3;
    }

    String getSQLString(JetUQueriable jetUQueriable) {
        return jetUQueriable.getSQLString();
    }

    JetUDatabase getDatabase(String string, JetUUniverse jetUUniverse) {
        JetUDatabase jetUDatabase;
        JetUDatabase jetUDatabase2 = jetUDatabase = string == null || string.length() == 0 ? jetUUniverse.getDatabase() : jetUUniverse.getDatabase(string);
        if (jetUDatabase == null) {
            this.setError("getDatabase(\"" + string + "\"): Invalid data source name.");
        }
        return jetUDatabase;
    }

    public String[] getDataSources() {
        int n;
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.cat.getChildren();
        Vector<String> vector2 = new Vector<String>();
        int n2 = vector.size();
        JetObject jetObject = null;
        for (n = 0; n < n2; ++n) {
            jetObject = (JetObject)vector.elementAt(n);
            if (!(jetObject instanceof JetUDatabase)) continue;
            vector2.add(((JetUDatabase)jetObject).name.get());
        }
        String[] stringArray = new String[vector2.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector2.elementAt(n);
        }
        return stringArray;
    }

    public static void updatePFKeys(Vector vector, JetUDatabase jetUDatabase) {
        try {
            Vector vector2;
            Object object;
            JetUConnection jetUConnection;
            if (vector == null || vector.size() == 0) {
                return;
            }
            PsqlTable psqlTable = null;
            boolean bl = false;
            int n = vector.size();
            Hashtable<JetUJDBCConnection, Vector<PsqlTable>> hashtable = new Hashtable<JetUJDBCConnection, Vector<PsqlTable>>();
            for (int i = 0; i < n; ++i) {
                psqlTable = (PsqlTable)vector.elementAt(i);
                jetUConnection = jetUDatabase.getConnectionByResourceName(psqlTable.getConnection());
                if (jetUConnection instanceof JetUJDBCConnection && (((JetUSupportInfo)(object = ((JetUJDBCConnection)jetUConnection).getJdbcSupportInfo())).isSupportPKey() || ((JetUSupportInfo)object).isSupportFKey())) {
                    vector2 = (Vector)hashtable.get((JetUJDBCConnection)jetUConnection);
                    if (vector2 == null) {
                        vector2 = new Vector();
                        hashtable.put((JetUJDBCConnection)jetUConnection, vector2);
                    }
                    vector2.add(psqlTable);
                }
                if (psqlTable.gotPFK) continue;
                bl = true;
            }
            if (!bl) {
                return;
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                jetUConnection = (JetUJDBCConnection)enumeration.nextElement();
                object = (Vector)hashtable.get(jetUConnection);
                vector2 = ConnectionToolkit.getConnection((JetUJDBCConnection)jetUConnection);
                PsqlJdbcDSInfo psqlJdbcDSInfo = new PsqlJdbcDSInfo((Connection)((Object)vector2), false);
                psqlJdbcDSInfo.updatePFKeysToPsqlTablesVector((Vector)object, true);
                ConnectionToolkit.freeConnection(vector2);
            }
        }
        catch (SQLException sQLException) {
            JDebug.WARNING(sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JDebug.WARNING(classNotFoundException);
        }
    }

    public static void updatePFKeys(RptPsqlQuery rptPsqlQuery) {
        CatalogAPI.updatePFKeys(rptPsqlQuery.getPsqlTables(), rptPsqlQuery.getDatabase());
    }

    public String getBLNodeQualifyName(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof BLNode) {
                return ((BLNode)((Object)jetObject)).getBLQualifyName();
            }
            this.setError("getBLNodeQualifyName(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLNodeQualifyName(" + string + "): invalid handle " + string);
        }
        return null;
    }

    private Vector Save(JetUDatabase jetUDatabase) {
        return this.TYPE(jetUDatabase, false);
    }

    private Vector TYPE(JetUDatabase jetUDatabase, boolean bl) {
        Vector vector = jetUDatabase.getQueriables();
        Vector<JBusinessLogic> vector2 = new Vector<JBusinessLogic>();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            JBusinessLogic jBusinessLogic = CatalogAPI.addDatabase((JetUQueriable)vector.elementAt(i), bl);
            if (jBusinessLogic == null) continue;
            vector2.add(jBusinessLogic);
        }
        return vector2;
    }

    private Vector UTableToPsqlTable(JetUDatabase jetUDatabase, String string, Permission permission) {
        return this.WARNING(jetUDatabase, string, permission, false);
    }

    private Vector WARNING(JetUDatabase jetUDatabase, String string, Permission permission, boolean bl) {
        Vector vector = jetUDatabase.getQueriables();
        Vector<JBusinessLogic> vector2 = new Vector<JBusinessLogic>();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            JBusinessLogic jBusinessLogic = CatalogAPI.addDatabase((JetUQueriable)vector.elementAt(i), bl);
            if (jBusinessLogic == null || !this.hasPermission(string, jBusinessLogic)) continue;
            vector2.add(jBusinessLogic);
        }
        return vector2;
    }

    private Vector add(JetUDatabase jetUDatabase, int n) {
        return this.addAggregation(jetUDatabase, n, false);
    }

    private Vector addAggregation(JetUDatabase jetUDatabase, int n, boolean bl) {
        Vector vector = jetUDatabase.getQueriables();
        Vector<JBusinessLogic> vector2 = new Vector<JBusinessLogic>();
        int n2 = -1;
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            JBusinessLogic jBusinessLogic = CatalogAPI.addDatabase((JetUQueriable)vector.elementAt(i), bl);
            if (jBusinessLogic == null || (n2 = this.getClassType(jBusinessLogic.getQuery())) != n) continue;
            vector2.add(jBusinessLogic);
        }
        return vector2;
    }

    private Vector addAll(JetUDatabase jetUDatabase, int n, String string, Permission permission) {
        Vector vector = jetUDatabase.getQueriables();
        Vector<JBusinessLogic> vector2 = new Vector<JBusinessLogic>();
        int n2 = -1;
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            JBusinessLogic jBusinessLogic = CatalogAPI.addDatabase((JetUQueriable)vector.elementAt(i), false);
            if (jBusinessLogic == null || (n2 = this.getClassType(jBusinessLogic.getQuery())) != n || !this.hasPermission(string, jBusinessLogic)) continue;
            vector2.add(jBusinessLogic);
        }
        return vector2;
    }

    public String[] getBLCategoryHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 3) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLCategoryHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLCategoryHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBusinesViewCategoryHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 3) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBusinesViewCategoryHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLCategoryHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBLHierarchyHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof BusinessLogic) {
                HierarchyContainer hierarchyContainer = ((BusinessLogic)jetObject).getHierarchyContainer();
                HierarchyInfo[] hierarchyInfoArray = hierarchyContainer.getAllHierarchies();
                String[] stringArray = new String[hierarchyInfoArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = ((JetObject)((Object)hierarchyInfoArray[i])).getQualifyName();
                }
                return stringArray;
            }
            this.setError("getBLHierarchyHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLHierarchyHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBLDetailHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo || jetObject instanceof DimensionInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 7) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLDetailHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLDetailHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBusinessViewDetailHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo || jetObject instanceof Group) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 7) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBusinessViewDetailHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBusinessViewDetailHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBLDimensionHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 4) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLDimensionHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLDimensionHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBusinessViewGroupHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 4) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBusinessViewGroupHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBusinessViewGroupHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBLMeasureHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 5) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLMeasureHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLMeasureHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBusinessViewAggregationHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 5) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBusinessViewAggregationHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBusinessViewAggregationHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBLViewHandles(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewHandles(\"" + string + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.Save(jetUDatabase);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JetObject)vector.get(i)).getQualifyName();
        }
        return stringArray;
    }

    public String[] getBusinessViewHandles(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBusinessViewHandles(\"" + string + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.TYPE(jetUDatabase, true);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JetObject)vector.get(i)).getQualifyName();
        }
        return stringArray;
    }

    public String[] getBLViewHandles(String string, int n) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewHandles(\"" + string + "," + n + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.add(jetUDatabase, n);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JetObject)vector.get(i)).getQualifyName();
        }
        return stringArray;
    }

    public String[] getBusinessViewHandles(String string, int n) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBusinessViewHandles(\"" + string + "," + n + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.addAggregation(jetUDatabase, n, true);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JetObject)vector.get(i)).getQualifyName();
        }
        return stringArray;
    }

    public String[] getBLViewNames(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewNames(\"" + string + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.Save(jetUDatabase);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JBusinessLogic)vector.get(i)).getName();
        }
        return stringArray;
    }

    public String[] getBusinessViewNames(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBusinessViewNames(\"" + string + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.TYPE(jetUDatabase, true);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JBusinessLogic)vector.get(i)).getName();
        }
        return stringArray;
    }

    public String[] getBLViewNames(String string, int n) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewNames(\"" + string + ", " + n + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.add(jetUDatabase, n);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JBusinessLogic)vector.get(i)).getName();
        }
        return stringArray;
    }

    public String[] getBusinessViewNames(String string, int n) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBusinessViewNamesViewNames(\"" + string + ", " + n + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.addAggregation(jetUDatabase, n, true);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JBusinessLogic)vector.get(i)).getName();
        }
        return stringArray;
    }

    public String[] getBusinessNodeNames(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        String[] stringArray = new String[]{};
        if (jetUDatabase == null) {
            this.setError("getBusinessNodeNames(\"" + string + "," + string2 + "\")Invalid data source name.");
            return stringArray;
        }
        Vector vector = this.Save(jetUDatabase);
        BLContainer bLContainer = null;
        for (int i = 0; i < vector.size(); ++i) {
            if (!((JBusinessLogic)vector.get(i)).getName().equalsIgnoreCase(string2)) continue;
            bLContainer = (JBusinessLogic)vector.get(i);
        }
        if (bLContainer != null) {
            BLNode[] bLNodeArray = bLContainer.getBLChildren();
            stringArray = new String[bLNodeArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = bLNodeArray[i].getName();
            }
        }
        return stringArray;
    }

    public String insertBusinessView(String string, String string2, String string3) {
        return this.insertBusinessView(string, string2, string3, true);
    }

    public String insertBusinessView(String string, String string2, String string3, boolean bl) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        String string4 = null;
        if (jetUDatabase == null) {
            this.setError("insertBusinessView(" + string + "," + string2 + " ," + string3 + "," + bl + "\")Invalid data source name.");
            return string4;
        }
        if (string2 == null) {
            string2 = string3;
        }
        JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
        if (bl) {
            if (jetUQueriable != null) {
                JBusinessLogic jBusinessLogic = this.addCategory(jetUQueriable, string3);
                if (jBusinessLogic != null) {
                    ((JetUResourceContainer)((Object)jetUQueriable)).add((BusinessLogic)jBusinessLogic);
                    string4 = ((BusinessLogic)jBusinessLogic).getQualifyName();
                    this.handles.put(string4, jBusinessLogic);
                } else {
                    this.setError("insertBusinessView(" + string + "," + string2 + " ," + string3 + "\"):Business View " + string3 + " already exists");
                }
            } else {
                JBusinessLogic jBusinessLogic = null;
                RptPsqlQuery rptPsqlQuery = new RptPsqlQuery();
                if (jetUDatabase.getConnection() instanceof JetUXMLConnection) {
                    rptPsqlQuery.bShowMappingName = true;
                }
                rptPsqlQuery.setMappingName(string2);
                rptPsqlQuery.setUniverse(this.cat, jetUDatabase.getResourceName());
                rptPsqlQuery.setUConnection(jetUDatabase.getConnection());
                JetUDemandQuery jetUDemandQuery = new JetUDemandQuery(string2, rptPsqlQuery.getCopy());
                boolean bl2 = jetUDatabase.addQuery(jetUDemandQuery);
                if (bl2) {
                    try {
                        jBusinessLogic = jetUDemandQuery.newBL(string3);
                        string4 = ((BusinessLogic)jBusinessLogic).getQualifyName();
                        this.handles.put(string4, jBusinessLogic);
                    }
                    catch (BLIlegalNameException bLIlegalNameException) {
                        this.setError(bLIlegalNameException);
                    }
                    catch (BLDupleNameException bLDupleNameException) {
                        this.setError(bLDupleNameException);
                    }
                }
            }
        } else if (jetUQueriable != null) {
            JBusinessView jBusinessView = this.addColumn(jetUQueriable, string3);
            if (jBusinessView != null) {
                ((JetUResourceContainer)((Object)jetUQueriable)).add((BusinessView)jBusinessView);
                string4 = ((BusinessLogic)((Object)jBusinessView)).getQualifyName();
                this.handles.put(string4, jBusinessView);
            } else {
                this.setError("insertBusinessView(" + string + "," + string2 + " ," + string3 + "\"):Business View already exists");
            }
        } else {
            this.setError("insertBusinessView(" + string + "," + string2 + " ," + string3 + "\"):void queriableName name " + string2);
        }
        return string4;
    }

    private JBusinessLogic addCategory(JetUQueriable jetUQueriable, String string) {
        block18: {
            if (jetUQueriable == null) {
                return null;
            }
            if (jetUQueriable instanceof JetUQuery) {
                try {
                    JBusinessLogic jBusinessLogic = ((JetUQuery)jetUQueriable).newBL(string);
                    return jBusinessLogic;
                }
                catch (BLIlegalNameException bLIlegalNameException) {
                    this.setError(bLIlegalNameException);
                }
                catch (BLDupleNameException bLDupleNameException) {
                    this.setError(bLDupleNameException);
                }
            } else {
                if (jetUQueriable instanceof JetUProcedure) {
                    try {
                        return ((JetUProcedure)jetUQueriable).newBL(string);
                    }
                    catch (BLIlegalNameException bLIlegalNameException) {
                        this.setError(bLIlegalNameException);
                        break block18;
                    }
                    catch (BLDupleNameException bLDupleNameException) {
                        this.setError(bLDupleNameException);
                        break block18;
                    }
                }
                if (jetUQueriable instanceof JetUFileQuery) {
                    try {
                        return ((JetUFileQuery)jetUQueriable).newBL(string);
                    }
                    catch (BLIlegalNameException bLIlegalNameException) {
                        this.setError(bLIlegalNameException);
                        break block18;
                    }
                    catch (BLDupleNameException bLDupleNameException) {
                        this.setError(bLDupleNameException);
                        break block18;
                    }
                }
                if (jetUQueriable instanceof JetUUserDataSource) {
                    try {
                        return ((JetUUserDataSource)jetUQueriable).newBL(string);
                    }
                    catch (BLIlegalNameException bLIlegalNameException) {
                        this.setError(bLIlegalNameException);
                    }
                    catch (BLDupleNameException bLDupleNameException) {
                        this.setError(bLDupleNameException);
                    }
                }
            }
        }
        return null;
    }

    private JBusinessView addColumn(JetUQueriable jetUQueriable, String string) {
        block18: {
            if (jetUQueriable == null) {
                return null;
            }
            if (jetUQueriable instanceof JetUQuery) {
                try {
                    JBusinessView jBusinessView = ((JetUQuery)jetUQueriable).newBV(string);
                    return jBusinessView;
                }
                catch (BLIlegalNameException bLIlegalNameException) {
                    this.setError(bLIlegalNameException);
                }
                catch (BLDupleNameException bLDupleNameException) {
                    this.setError(bLDupleNameException);
                }
            } else {
                if (jetUQueriable instanceof JetUProcedure) {
                    try {
                        return ((JetUProcedure)jetUQueriable).newBV(string);
                    }
                    catch (BLIlegalNameException bLIlegalNameException) {
                        this.setError(bLIlegalNameException);
                        break block18;
                    }
                    catch (BLDupleNameException bLDupleNameException) {
                        this.setError(bLDupleNameException);
                        break block18;
                    }
                }
                if (jetUQueriable instanceof JetUFileQuery) {
                    try {
                        return ((JetUFileQuery)jetUQueriable).newBV(string);
                    }
                    catch (BLIlegalNameException bLIlegalNameException) {
                        this.setError(bLIlegalNameException);
                        break block18;
                    }
                    catch (BLDupleNameException bLDupleNameException) {
                        this.setError(bLDupleNameException);
                        break block18;
                    }
                }
                if (jetUQueriable instanceof JetUUserDataSource) {
                    try {
                        return ((JetUUserDataSource)jetUQueriable).newBV(string);
                    }
                    catch (BLIlegalNameException bLIlegalNameException) {
                        this.setError(bLIlegalNameException);
                    }
                    catch (BLDupleNameException bLDupleNameException) {
                        this.setError(bLDupleNameException);
                    }
                }
            }
        }
        return null;
    }

    public String insertBLCategory(String string, BLCategoryInfo bLCategoryInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof CategoryInfo)) {
            this.setError("insertBLCategory(" + string + "," + bLCategoryInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Category category = this.createCategory(this.addConnection(jetObject), bLCategoryInfo);
            ((CategoryInfo)((Object)jetObject)).addCategory(category);
            this.createCategoryChildren(this.addConnection(jetObject), bLCategoryInfo, category);
            string2 = category.getQualifyName();
            this.handles.put(string2, category);
            this.createHandles(category, string2);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertBLCategory(" + string2 + "," + bLCategoryInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLCategory(" + string2 + "," + bLCategoryInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    public String insertBusinessViewCategory(String string, BLCategoryInfo bLCategoryInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof CategoryInfo)) {
            this.setError("insertBLCategory(" + string + "," + bLCategoryInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Category category = this.createCategory(this.addConnection(jetObject), bLCategoryInfo);
            ((CategoryInfo)((Object)jetObject)).addCategory(category);
            this.createCategoryChildren(this.addConnection(jetObject), bLCategoryInfo, category);
            string2 = category.getQualifyName();
            this.handles.put(string2, category);
            this.createHandles(category, string2);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertBLCategory(" + string2 + "," + bLCategoryInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLCategory(" + string2 + "," + bLCategoryInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    public String insertBusinessViewCategory(String string, BusinessViewCategoryInfo businessViewCategoryInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof CategoryInfo)) {
            this.setError("insertBLCategory(" + string + "," + businessViewCategoryInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Category category = this.createCategory(this.addConnection(jetObject), businessViewCategoryInfo);
            ((CategoryInfo)((Object)jetObject)).addCategory(category);
            this.createCategoryChildren(this.addConnection(jetObject), businessViewCategoryInfo, category);
            string2 = category.getQualifyName();
            this.handles.put(string2, category);
            this.createHandles(category, string2);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertBLCategory(" + string2 + "," + businessViewCategoryInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLCategory(" + string2 + "," + businessViewCategoryInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    void createCategoryChildren(JetUDatabase jetUDatabase, BLCategoryInfo bLCategoryInfo, Category category) throws BLDupleNameException, BLIlegalNameException {
        Vector vector = bLCategoryInfo.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            BLNodeImpl bLNodeImpl;
            Object e = vector.get(i);
            if (e instanceof BLCategoryInfo) {
                bLNodeImpl = this.createCategory(jetUDatabase, (BLCategoryInfo)e);
                category.addCategory((CategoryInfo)((Object)bLNodeImpl));
                this.createCategoryChildren(jetUDatabase, (BLCategoryInfo)e, (Category)bLNodeImpl);
                continue;
            }
            if (e instanceof BLDimensionInfo) {
                bLNodeImpl = this.createDimension((BLDimensionInfo)e);
                category.addDimension((DimensionInfo)((Object)bLNodeImpl));
                this.addRefTables((DataElement)bLNodeImpl);
                continue;
            }
            if (e instanceof BLMeasureInfo) {
                bLNodeImpl = this.createMeasure(jetUDatabase, (BLMeasureInfo)e);
                category.addMeasure((MeasureInfo)((Object)bLNodeImpl));
                this.addRefTables((DataElement)bLNodeImpl);
                continue;
            }
            if (!(e instanceof BLDetailInfo)) continue;
            bLNodeImpl = this.createDetail((BLDetailInfo)e);
            category.addDetailInformation((DetailInformation)((Object)bLNodeImpl));
            this.addRefTables((DataElement)bLNodeImpl);
        }
    }

    Category createCategory(JetUDatabase jetUDatabase, BLCategoryInfo bLCategoryInfo) throws BLDupleNameException, BLIlegalNameException {
        Category category = new Category();
        category.setDisplayName(bLCategoryInfo.getDisplayName() == null ? bLCategoryInfo.getName() : bLCategoryInfo.getDisplayName());
        category.setDescription(bLCategoryInfo.getDescription());
        category.setName(bLCategoryInfo.getName());
        return category;
    }

    Dimension createDimension(BLDimensionInfo bLDimensionInfo) throws BLDupleNameException, BLIlegalNameException {
        Dimension dimension = null;
        dimension = bLDimensionInfo instanceof BVGroupInfo ? new Group() : new Dimension();
        dimension.setDisplayName(bLDimensionInfo.getDisplayName() == null ? bLDimensionInfo.getName() : bLDimensionInfo.getDisplayName());
        dimension.setDescription(bLDimensionInfo.getDescription());
        dimension.setName(bLDimensionInfo.getName());
        dimension.setPrompt(bLDimensionInfo.getPrompt());
        dimension.setRefMappingName(bLDimensionInfo.getRefMappingName());
        return dimension;
    }

    Measure createMeasure(JetUDatabase jetUDatabase, BLMeasureInfo bLMeasureInfo) throws BLDupleNameException, BLIlegalNameException {
        Measure measure = null;
        measure = bLMeasureInfo instanceof BVAggregationInfo ? new Aggregation() : new Measure();
        measure.setDisplayName(bLMeasureInfo.getDisplayName() == null ? bLMeasureInfo.getName() : bLMeasureInfo.getDisplayName());
        measure.setDescription(bLMeasureInfo.getDescription());
        measure.setName(bLMeasureInfo.getName());
        measure.setPrompt(bLMeasureInfo.getPrompt());
        if (bLMeasureInfo.getRefMappingName() != null) {
            Vector vector = jetUDatabase.getSummaries();
            JetUSummary jetUSummary = null;
            int n = vector.size();
            while (--n >= 0) {
                jetUSummary = (JetUSummary)vector.elementAt(n);
                if (!jetUSummary.getResourceName().equalsIgnoreCase(bLMeasureInfo.getRefMappingName())) continue;
                measure.setRefMappingName(jetUSummary.fldName.get());
                measure.setAggFunction(jetUSummary.function.get());
                break;
            }
        } else {
            measure.setRefMappingName(bLMeasureInfo.getAggField());
            measure.setAggFunction(bLMeasureInfo.getAggFunction());
        }
        return measure;
    }

    DetailInfo createDetail(BLDetailInfo bLDetailInfo) throws BLDupleNameException, BLIlegalNameException {
        DetailInfo detailInfo = null;
        detailInfo = bLDetailInfo instanceof BVDetailInfo ? new Detail() : new DetailInfo();
        detailInfo.setDisplayName(bLDetailInfo.getDisplayName() == null ? bLDetailInfo.getName() : bLDetailInfo.getDisplayName());
        detailInfo.setDescription(bLDetailInfo.getDescription());
        detailInfo.setName(bLDetailInfo.getName());
        detailInfo.setPrompt(bLDetailInfo.getPrompt());
        detailInfo.setRefMappingName(bLDetailInfo.getRefMappingName());
        return detailInfo;
    }

    public String insertBLDetail(String string, BLDetailInfo bLDetailInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof BLContainer)) {
            this.setError("insertBLDetail(" + string + "," + bLDetailInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            DetailInfo detailInfo = this.createDetail(bLDetailInfo);
            if (jetObject instanceof Category) {
                ((Category)jetObject).addDetailInformation(detailInfo);
            } else {
                if (jetObject instanceof DimensionInfo) {
                    throw new DesignerErrorException("Detail can not be inserted into Dimension.");
                }
                if (jetObject instanceof MeasureInfo) {
                    throw new DesignerErrorException("Detail can not be inserted into Measure.");
                }
            }
            this.addRefTables(detailInfo);
            string2 = detailInfo.getQualifyName();
            this.handles.put(string2, detailInfo);
            this.notifyReference(detailInfo, 0);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertMeasure(" + string2 + "," + bLDetailInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLMeasure(" + string2 + "," + bLDetailInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    public String insertBusinessViewDetail(String string, BVDetailInfo bVDetailInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof BLContainer)) {
            this.setError("insertBusinessViewDetail(" + string + "," + bVDetailInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            DetailInfo detailInfo = this.createDetail(bVDetailInfo);
            if (jetObject instanceof Category) {
                ((Category)jetObject).addDetail((DTInformation)((Object)detailInfo));
            } else {
                if (jetObject instanceof Group) {
                    throw new DesignerErrorException("Detail can not be inserted into Group.");
                }
                if (jetObject instanceof Aggregation) {
                    throw new DesignerErrorException("Detail can not be inserted into Aggregation.");
                }
            }
            string2 = detailInfo.getQualifyName();
            this.handles.put(string2, detailInfo);
            this.notifyReference(detailInfo, 0);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertMeasure(" + string2 + "," + bVDetailInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLMeasure(" + string2 + "," + bVDetailInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    private JetUDatabase addConnection(JetObject jetObject) {
        JetContainable jetContainable = jetObject.getParent();
        while (jetContainable != null) {
            if (jetContainable instanceof BusinessLogic) {
                return ((JetUQueriable)((Object)((BusinessLogic)jetContainable).getQuery())).getDatabase();
            }
            if (jetContainable instanceof JetUDatabase) {
                return (JetUDatabase)jetContainable;
            }
            jetContainable = ((JetObject)((Object)jetContainable)).getParent();
        }
        return null;
    }

    public String insertBLMeasure(String string, BLMeasureInfo bLMeasureInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof CategoryInfo)) {
            this.setError("insertBLMeasure(" + string + "," + bLMeasureInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Measure measure = this.createMeasure(this.addConnection(jetObject), bLMeasureInfo);
            ((CategoryInfo)((Object)jetObject)).addMeasure(measure);
            this.addRefTables(measure);
            string2 = measure.getQualifyName();
            this.handles.put(string2, measure);
            this.notifyReference(measure, 0);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertMeasure(" + string2 + "," + bLMeasureInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLMeasure(" + string2 + "," + bLMeasureInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    public String insertBusinessViewAggregation(String string, BVAggregationInfo bVAggregationInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof CategoryInfo)) {
            this.setError("insertBLMeasure(" + string + "," + bVAggregationInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Measure measure = this.createMeasure(this.addConnection(jetObject), bVAggregationInfo);
            ((CategoryInfo)((Object)jetObject)).addAggregation((Aggregation)measure);
            string2 = measure.getQualifyName();
            this.handles.put(string2, measure);
            this.notifyReference(measure, 0);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertMeasure(" + string2 + "," + bVAggregationInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLMeasure(" + string2 + "," + bVAggregationInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    public String insertBLDimension(String string, BLDimensionInfo bLDimensionInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof CategoryInfo)) {
            this.setError("insertDimension(" + string + "," + bLDimensionInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Dimension dimension = this.createDimension(bLDimensionInfo);
            ((CategoryInfo)((Object)jetObject)).addDimension(dimension);
            this.addRefTables(dimension);
            string2 = dimension.getQualifyName();
            this.handles.put(string2, dimension);
            this.notifyReference(dimension, 0);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertBLDimension(" + string2 + "," + bLDimensionInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLDimension(" + string2 + "," + bLDimensionInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    void addRefTables(DataElement dataElement) {
        JBusinessLogic jBusinessLogic = dataElement.getBusinessLogic();
        JetObject jetObject = jBusinessLogic.getQuery();
        if (jetObject instanceof JetUDemandQuery) {
            JetUDatabase jetUDatabase = ((JetUDemandQuery)jetObject).getDatabase();
            RptPsqlQuery rptPsqlQuery = ((JetUDemandQuery)jetObject).getPsqlQuery();
            String string = dataElement.getRefMappingName();
            JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(string);
            JetUTableView jetUTableView = null;
            if (jetUResourceEntity != null) {
                if (jetUResourceEntity instanceof JetUFormula) {
                    Vector vector = RptPsqlTools.getRefTablesOfFormula(((JetUDemandQuery)jetObject).getUniverse(), (JetUFormula)jetUResourceEntity);
                    int n = vector.size();
                    for (int i = 0; i < n; ++i) {
                        JetUTableView jetUTableView2 = (JetUTableView)vector.elementAt(i);
                        if (jetUTableView2 == null) continue;
                        this.addRefTable((JetUDemandQuery)jetObject, jetUTableView2, null);
                    }
                } else if (jetUResourceEntity instanceof JetUField) {
                    jetUTableView = ((JetUField)jetUResourceEntity).getTable();
                    this.addRefTable((JetUDemandQuery)jetObject, jetUTableView, string);
                }
            }
            ((JetUDemandQuery)jetObject).setPsqlQuery(rptPsqlQuery);
        }
    }

    void addRefTable(JetUDemandQuery jetUDemandQuery, JetUTableView jetUTableView, String string) {
        RptPsqlQuery rptPsqlQuery = jetUDemandQuery.getPsqlQuery();
        PsqlTable psqlTable = RptPsqlTools.UTableToPsqlTable(jetUTableView, false);
        Vector vector = rptPsqlQuery.getPsqlTables();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.add(((PsqlTable)vector.get(i)).getMappingName());
        }
        if (!vector2.contains(psqlTable.getMappingName())) {
            rptPsqlQuery.addPsqlTable(psqlTable);
        }
        if (string != null) {
            Vector vector3 = jetUTableView.getFields();
            for (int i = 0; i < vector3.size(); ++i) {
                JetUField jetUField = (JetUField)vector3.elementAt(i);
                if (!string.equalsIgnoreCase(jetUField.getResourceName())) continue;
                rptPsqlQuery.addUFieldByName(string).setMappingName(string);
            }
        }
    }

    public String insertBusinessViewGroup(String string, BVGroupInfo bVGroupInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof CategoryInfo)) {
            this.setError("insertDimension(" + string + "," + bVGroupInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Dimension dimension = this.createDimension(bVGroupInfo);
            ((CategoryInfo)((Object)jetObject)).addGroup((Group)dimension);
            string2 = dimension.getQualifyName();
            this.handles.put(string2, dimension);
            this.notifyReference(dimension, 0);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertBLDimension(" + string2 + "," + bVGroupInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLDimension(" + string2 + "," + bVGroupInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    public String insertBLHierarchy(String string, BLHierarchyInfo bLHierarchyInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof BusinessLogic)) {
            this.setError("insertBLHierarchy(" + string + "," + bLHierarchyInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Hierarchy hierarchy = this.addDataSource(bLHierarchyInfo);
            ((BusinessLogic)jetObject).getHierarchyContainer().addHierarchy(hierarchy);
            string2 = hierarchy.getQualifyName();
            this.handles.put(string2, hierarchy);
            this.notifyReference(hierarchy, 0);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertBLHierarchy(" + string2 + "," + bLHierarchyInfo + "\"):Invalid Hierarchy info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLHierarchy(" + string2 + "," + bLHierarchyInfo + "\"):Invalid Hierarchy info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    private Hierarchy addDataSource(BLHierarchyInfo bLHierarchyInfo) throws BLDupleNameException, BLIlegalNameException {
        Hierarchy hierarchy = new Hierarchy();
        hierarchy.setDescription(bLHierarchyInfo.getDescription());
        hierarchy.setName(bLHierarchyInfo.getName());
        hierarchy.setDimensions(bLHierarchyInfo.getDimensionQualifyNames());
        return hierarchy;
    }

    @Override
    protected void createHandles(JetContainable jetContainable, String string) {
        String string2;
        JetObject jetObject;
        Vector vector = jetContainable.getChildren();
        string = string + '.';
        if (this.isquery) {
            Vector vector2 = ((JetUQuery)jetContainable).getFields();
            int n = vector2.size();
            while (--n >= 0) {
                jetObject = (JetObject)vector2.elementAt(n);
                if (!(jetObject instanceof JetUCompColQueryField)) continue;
                string2 = string + jetObject.getInstName();
                this.handles.put(string2, jetObject);
            }
            this.isquery = false;
        }
        int n = vector.size();
        while (--n >= 0) {
            jetObject = (JetObject)vector.elementAt(n);
            string2 = string + jetObject.getInstName();
            this.handles.put(string2, jetObject);
            if (!(jetObject instanceof JetContainable)) continue;
            if (jetObject instanceof JetUQuery) {
                this.isquery = true;
            }
            this.createHandles((JetContainable)((Object)jetObject), string2);
        }
    }

    public boolean updateUDS(String string) {
        return this.updateUDS(this.getDefaultDataSourceName(), string);
    }

    public boolean updateUDS(String string, String string2) {
        boolean bl = false;
        String string3 = null;
        string3 = string == null ? "" : this.SEDU(string);
        if (!string3.equals("NULL")) {
            Vector vector = this.cat.getDatabase(string3).getDataSources();
            JetUUserDataSource jetUUserDataSource = null;
            boolean bl2 = false;
            String string4 = null;
            String string5 = null;
            DataSourceInfo dataSourceInfo = null;
            Vector vector2 = null;
            Vector vector3 = null;
            ColumnInfo columnInfo = null;
            JetUUDSField jetUUDSField = null;
            boolean bl3 = false;
            boolean bl4 = false;
            String string6 = null;
            for (int i = 0; i < vector.size(); ++i) {
                jetUUserDataSource = (JetUUserDataSource)vector.get(i);
                if (!jetUUserDataSource.getUDSName().equalsIgnoreCase(string2)) continue;
                bl2 = true;
                string4 = jetUUserDataSource.getUDSClassName();
                string5 = jetUUserDataSource.getParameter();
                if (this.checkClass(string4)) {
                    dataSourceInfo = new DataSourceInfo(string2, string4, string5, new JRUDSHostVariableContainerAPI(this.cat));
                    try {
                        int n;
                        int n2;
                        dataSourceInfo.initialize();
                        vector2 = dataSourceInfo.getColumns();
                        vector3 = jetUUserDataSource.getColumns();
                        for (n2 = 0; n2 < vector2.size(); ++n2) {
                            columnInfo = (ColumnInfo)vector2.get(n2);
                            for (n = 0; n < vector3.size(); ++n) {
                                jetUUDSField = (JetUUDSField)vector3.get(n);
                                if (!jetUUDSField.getFldName().equalsIgnoreCase(columnInfo.getName())) continue;
                                bl3 = true;
                                break;
                            }
                            if (bl3) continue;
                            string6 = jetUUserDataSource.getMappingName(columnInfo.strName);
                            jetUUDSField = new JetUUDSField(string6, "", ColumnInfoTree.strRoot, columnInfo);
                            jetUUserDataSource.addColumn(jetUUDSField);
                        }
                        vector3 = jetUUserDataSource.getColumns();
                        for (n2 = 0; n2 < vector3.size(); ++n2) {
                            jetUUDSField = (JetUUDSField)vector3.get(n2);
                            for (n = 0; n < vector2.size(); ++n) {
                                columnInfo = (ColumnInfo)vector2.get(n);
                                if (!columnInfo.getName().equalsIgnoreCase(jetUUDSField.getFldName())) continue;
                                bl4 = true;
                                break;
                            }
                            if (bl4) continue;
                            vector3.remove(n2);
                        }
                        this.notifyReference(jetUUserDataSource, 2);
                        bl = true;
                    }
                    catch (LoadUserDataSourceException loadUserDataSourceException) {
                        this.setError("updateUDS(\"" + string + "\",\"" + string2 + "\"):" + loadUserDataSourceException.getMessage());
                    }
                    continue;
                }
                this.setError("updateUDS(\"" + string + "\",\"" + string2 + "\"):can not load class " + string4 + ".");
            }
            if (!bl2) {
                this.setError("updateUDS(\"" + string + "\",\"" + string2 + "\"): UserDataSource " + string2 + " is not exist in " + "DataSource " + string + ".");
            }
        } else {
            this.setError("updateUDS(\"" + string + "\",\"" + string2 + "\"): DataSource " + string + " does not exist in current catalog.");
        }
        return bl;
    }

    boolean hasPermission(String string, BLNode bLNode) {
        JBusinessLogic jBusinessLogic = bLNode.getBusinessLogic();
        MemberSecurityEntry memberSecurityEntry = jBusinessLogic.getMemberSecurityEntry();
        boolean bl = false;
        MemberSecurityEntry memberSecurityEntry2 = null;
        if (this.securityProvider != null) {
            // empty if block
        }
        if (secData != null || memberSecurityEntry2 != null) {
            bl = memberSecurityEntry.checkPermission_visible(secData, string, bLNode.getBLQualifyName(), memberSecurityEntry2);
        }
        return bl;
    }

    private static JBusinessLogic addDatabase(JetUQueriable jetUQueriable, boolean bl) {
        JBusinessLogic jBusinessLogic = null;
        if (jetUQueriable != null) {
            if (jetUQueriable instanceof JetUQuery) {
                jBusinessLogic = bl ? ((JetUQuery)jetUQueriable).getBV() : ((JetUQuery)jetUQueriable).getBL();
            } else if (jetUQueriable instanceof JetUProcedure) {
                jBusinessLogic = bl ? ((JetUProcedure)jetUQueriable).getBV() : ((JetUProcedure)jetUQueriable).getBL();
            } else if (jetUQueriable instanceof JetUFileQuery) {
                jBusinessLogic = bl ? ((JetUFileQuery)jetUQueriable).getBV() : ((JetUFileQuery)jetUQueriable).getBL();
            } else if (jetUQueriable instanceof JetUUserDataSource) {
                jBusinessLogic = bl ? ((JetUUserDataSource)jetUQueriable).getBV() : ((JetUUserDataSource)jetUQueriable).getBL();
            }
        }
        return jBusinessLogic;
    }

    public String[] getBLCategoryHandles(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 3 || !this.hasPermission(string2, bLNodeArray[i])) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLCategoryHandles(" + string + "," + string2 + "): invalid handle " + string);
        } else {
            this.setError("getBLCategoryHandles(" + string + "," + string2 + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBLDetailHandles(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo || jetObject instanceof DimensionInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 7 || !this.hasPermission(string2, bLNodeArray[i])) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLDetailHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLDetailHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBLMeasureHandles(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 5 || !this.hasPermission(string2, bLNodeArray[i])) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLMeasureHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLMeasureHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    public String[] getBLViewHandles(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewHandles(\"" + string + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.UTableToPsqlTable(jetUDatabase, string2, Permissions.P_VISIBLE);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JetObject)vector.get(i)).getQualifyName();
        }
        return stringArray;
    }

    public String[] getBusinessViewHandles(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewHandles(\"" + string + "\"," + "\"" + string2 + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.WARNING(jetUDatabase, string2, Permissions.P_VISIBLE, true);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JetObject)vector.get(i)).getQualifyName();
        }
        return stringArray;
    }

    public String getBusinessLogicHandle(String string, String string2, boolean bl, String string3) {
        JBusinessLogic jBusinessLogic;
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBusinessLogicHandle(\"" + string + "," + string2 + "," + bl + "," + string3 + "\")Invalid data source name.");
            return null;
        }
        JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
        if (jetUQueriable != null && (jBusinessLogic = CatalogAPI.addDatabase(jetUQueriable, bl)) != null) {
            if (this.hasPermission(string3, jBusinessLogic)) {
                return ((JetObject)((Object)jBusinessLogic)).getQualifyName();
            }
            this.setError("getBusinessLogicHandle(\"" + string + "," + string2 + "," + bl + "," + string3 + "\")Invalid UserId.");
        }
        this.setError("getBusinessLogicHandle(\"" + string + "," + string2 + "," + bl + "," + string3 + "\")Invalid query name.");
        return null;
    }

    public String[] getBLViewHandles(String string, int n, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewHandles(\"" + string + "," + n + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.addAll(jetUDatabase, n, string2, Permissions.P_VISIBLE);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JetObject)vector.get(i)).getQualifyName();
        }
        return stringArray;
    }

    public String[] getBLViewNames(String string, int n, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewNames(\"" + string + ", " + n + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.addAll(jetUDatabase, n, string2, Permissions.P_VISIBLE);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JBusinessLogic)vector.get(i)).getName();
        }
        return stringArray;
    }

    public String[] getBLViewNames(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewNames(\"" + string + ", " + string2 + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.UTableToPsqlTable(jetUDatabase, string2, Permissions.P_VISIBLE);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JBusinessLogic)vector.get(i)).getName();
        }
        return stringArray;
    }

    public String[] getBusinessNodeNames(String string, String string2, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        String[] stringArray = new String[]{};
        if (jetUDatabase == null) {
            this.setError("getBusinessNodeNames(\"" + string + "," + string2 + "\")Invalid data source name.");
            return stringArray;
        }
        Vector vector = this.UTableToPsqlTable(jetUDatabase, string3, Permissions.P_VISIBLE);
        BLContainer bLContainer = null;
        for (int i = 0; i < vector.size(); ++i) {
            if (!((JBusinessLogic)vector.get(i)).getName().equalsIgnoreCase(string2)) continue;
            bLContainer = (JBusinessLogic)vector.get(i);
        }
        if (bLContainer != null) {
            BLNode[] bLNodeArray = bLContainer.getBLChildren();
            String[] stringArray2 = new String[bLNodeArray.length];
            stringArray = new String[bLNodeArray.length];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.hasPermission(string3, bLNodeArray[i])) continue;
                stringArray2[n] = bLNodeArray[i].getName();
                ++n;
            }
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
        }
        return stringArray;
    }

    public String[] getBLDimensionHandles(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 4 || !this.hasPermission(string2, bLNodeArray[i])) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLDimensionHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLDimensionHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    JetUResourceEntity getRefObj(DataElement dataElement) {
        JetContainable jetContainable = dataElement.getParent();
        while (jetContainable != null && !((JetObject)((Object)jetContainable) instanceof JetUDatabase)) {
            jetContainable = ((JetObject)((Object)jetContainable)).getParent();
        }
        if (jetContainable == null) {
            return null;
        }
        JetUResourceEntity jetUResourceEntity = ((JetUDatabase)jetContainable).getResourceByName(dataElement.getRefMappingName());
        return jetUResourceEntity;
    }

    public BLNodeInformation getBLNodeInformation(String string) {
        JetObject jetObject = (JetObject)this.handles.get(string);
        BLNodeInformation bLNodeInformation = null;
        if (jetObject != null) {
            return this.addDetail(jetObject);
        }
        return bLNodeInformation;
    }

    public BLNodeInformation[] getBLNodeInformations(String string, String string2) {
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject instanceof BLContainer) {
            BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
            BLNodeInformation[] bLNodeInformationArray = new BLNodeInformation[bLNodeArray.length];
            int n = 0;
            for (int i = 0; i < bLNodeArray.length; ++i) {
                if (!this.hasPermission(string2, bLNodeArray[i])) continue;
                bLNodeInformationArray[n] = this.addDetail((JetObject)((Object)bLNodeArray[i]));
                ++n;
            }
            BLNodeInformation[] bLNodeInformationArray2 = new BLNodeInformation[n];
            System.arraycopy(bLNodeInformationArray, 0, bLNodeInformationArray2, 0, n);
            return bLNodeInformationArray2;
        }
        return null;
    }

    private BLNodeInformation addDetail(JetObject jetObject) {
        BLNodeInformation bLNodeInformation = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty("Description");
            if (jetObject instanceof BLNode) {
                BLNode bLNode = (BLNode)((Object)jetObject);
                if (jetObject instanceof CategoryInfo) {
                    string = bLNode.getBLQualifyName();
                    string2 = bLNode.getDisplayName();
                    string4 = bLNode.getQualifyDisplayName();
                    string3 = ((JetString)jetProperty).get();
                    n2 = 18;
                } else if (jetObject instanceof DimensionInfo) {
                    string = bLNode.getBLQualifyName();
                    string2 = bLNode.getDisplayName();
                    string4 = bLNode.getQualifyDisplayName();
                    string3 = ((JetString)jetProperty).get();
                    n = this.addDetailInformation((DataElement)jetObject);
                    JetUResourceEntity jetUResourceEntity = this.getRefObj((DataElement)jetObject);
                    if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormula) {
                        bl = true;
                    }
                    n2 = jetObject instanceof Group ? 28 : 19;
                } else if (jetObject instanceof MeasureInfo) {
                    string = bLNode.getBLQualifyName();
                    string2 = bLNode.getDisplayName();
                    string4 = bLNode.getQualifyDisplayName();
                    string3 = ((JetString)jetProperty).get();
                    n = this.addDetailInformation((DataElement)jetObject);
                    n2 = jetObject instanceof Aggregation ? 29 : 20;
                } else if (jetObject instanceof DetailInformation) {
                    string = bLNode.getBLQualifyName();
                    string2 = bLNode.getDisplayName();
                    string4 = bLNode.getQualifyDisplayName();
                    string3 = ((JetString)jetProperty).get();
                    n = this.addDetailInformation((DataElement)jetObject);
                    JetUResourceEntity jetUResourceEntity = this.getRefObj((DataElement)jetObject);
                    if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormula) {
                        bl = true;
                    }
                    n2 = jetObject instanceof Detail ? 30 : 22;
                }
            }
            bLNodeInformation = new BLNodeInformation(string, string2, string3, n);
            bLNodeInformation.setIsFormula(bl);
            bLNodeInformation.setElementType(n2);
            bLNodeInformation.setHandle(jetObject.getQualifyName());
        }
        return bLNodeInformation;
    }

    private int addDetailInformation(DataElement dataElement) {
        JetContainable jetContainable = dataElement.getParent();
        int n = -1;
        while (jetContainable != null && !((JetObject)((Object)jetContainable) instanceof JetUDatabase)) {
            jetContainable = ((JetObject)((Object)jetContainable)).getParent();
        }
        if (jetContainable == null) {
            return n;
        }
        JetUResourceEntity jetUResourceEntity = ((JetUDatabase)jetContainable).getResourceByName(dataElement.getRefMappingName());
        if (jetUResourceEntity != null) {
            DbColDesc dbColDesc = jetUResourceEntity.getColDesc();
            if (dbColDesc != null) {
                n = dbColDesc.getSqlType();
            }
            if (dataElement instanceof MeasureInfo) {
                n = Types.getFuncSqlType(((MeasureInfo)((Object)dataElement)).getAggFunction(), n);
            }
        }
        return n;
    }

    public boolean refreshReference() {
        return this.refreshReference(new CrossReferenceConfigure(this.cat.getAllDatabaseNames(), CrossReferenceConfigure.getDefaultTypes()));
    }

    boolean refreshReference(CrossReferenceConfigure crossReferenceConfigure) {
        if (this.referResource == null) {
            try {
                this.referResource = ReferenceResource.getInstance(this.cat);
            }
            catch (RefResourceException refResourceException) {
                this.setError("Failed to refresh cross reference.");
                this.setError(refResourceException);
                return false;
            }
        }
        if (this.referResource != null && this.referResource.isCreated()) {
            Vector vector = this.referResource.getCfgDsNames();
            Vector vector2 = this.referResource.getCfgTypes();
            Vector vector3 = crossReferenceConfigure.getDatasourceNames();
            Vector vector4 = crossReferenceConfigure.getTypes();
            if (vector.equals(vector3) && vector2.equals(vector4)) {
                return true;
            }
        }
        try {
            this.referResource = ReferenceResource.getInstance(this.cat);
            this.referResource.CreateCatalog(crossReferenceConfigure.getDatasourceNames(), crossReferenceConfigure.getTypes());
        }
        catch (Exception exception) {
            this.setError("Failed to config refresh reference.");
            this.setError(exception);
            return false;
        }
        return true;
    }

    public boolean setDefaultDataSource(String string) {
        return this.cat.setDefaultDatasource(string);
    }

    public void setDefaultConnection(String string, String string2) {
        JetUDatabase jetUDatabase = this.cat.getDatabase(string);
        if (jetUDatabase != null) {
            JetUConnection jetUConnection = jetUDatabase.getConnectionByResourceName(string2);
            if (jetUConnection != null) {
                jetUConnection.setDefault();
            } else {
                this.setError("setDefaultConnection(\"" + string + "\",\"" + string2 + "\"), " + string2 + " is invalid.");
            }
        } else {
            this.setError("setDefaultConnection(\"" + string + "\",\"" + string2 + "\"), " + string + " is invalid.");
        }
    }

    public String getDefaultConnectionName(String string) {
        String string2 = null;
        JetUDatabase jetUDatabase = this.cat.getDatabase(string);
        if (jetUDatabase != null) {
            JetUConnection jetUConnection = jetUDatabase.getConnection();
            if (jetUConnection != null) {
                string2 = jetUConnection.getResourceName();
            }
        } else {
            this.setError("getDefaultConnectionName(\"" + string + "\"), " + string + " is invalid.");
        }
        return string2;
    }

    public String getDefaultDataSourceName() {
        String string = null;
        JetUDatabase jetUDatabase = this.cat.getDatabase();
        if (jetUDatabase != null) {
            string = jetUDatabase.getResourceName();
        }
        return string;
    }

    void notifyReference(JetObject jetObject, int n) {
        if (this.referResource != null) {
            switch (n) {
                case 0: {
                    try {
                        this.referResource.insert(jetObject);
                    }
                    catch (RefResourceException refResourceException) {
                        this.setError("Failed to notify cross reference.");
                        this.setError(refResourceException);
                    }
                    break;
                }
                case 1: {
                    try {
                        this.referResource.remove(jetObject);
                    }
                    catch (RefResourceException refResourceException) {
                        this.setError("Failed to notify cross reference.");
                        this.setError(refResourceException);
                    }
                    break;
                }
                case 2: {
                    try {
                        this.referResource.modify(jetObject);
                        break;
                    }
                    catch (RefResourceException refResourceException) {
                        this.setError("Failed to notify cross reference.");
                        this.setError(refResourceException);
                    }
                }
            }
        }
    }

    public BLFilterInformation[] getBLFilterInfos(String string) {
        FilterInfo[] filterInfoArray;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null && jetObject instanceof JBusinessLogic && (filterInfoArray = ((JBusinessLogic)((Object)jetObject)).getPrefilterInfo()) != null) {
            BLFilterInformation[] bLFilterInformationArray = new BLFilterInformation[filterInfoArray.length];
            BLFilterInformation bLFilterInformation = null;
            for (int i = 0; i < filterInfoArray.length; ++i) {
                bLFilterInformationArray[i] = bLFilterInformation = this.getBLFilterInfo(filterInfoArray[i]);
            }
            return bLFilterInformationArray;
        }
        return null;
    }

    public BLFilterInformation getBLFilterInfo(String string) {
        BLFilterInformation bLFilterInformation = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null && jetObject instanceof FilterInfo) {
            FilterInfo filterInfo = (FilterInfo)((Object)jetObject);
            bLFilterInformation = this.getBLFilterInfo(filterInfo);
        }
        return bLFilterInformation;
    }

    public String insertPredefinedBLFilterInfo(String string, BLFilterInformation bLFilterInformation) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null && jetObject instanceof JBusinessLogic) {
            IExpression iExpression = null;
            ExpressionNode expressionNode = bLFilterInformation.getExpression();
            String string3 = bLFilterInformation.getDisplayName();
            try {
                if (expressionNode instanceof ExpressionGroupInfo) {
                    iExpression = this.buildConditionExpression((ExpressionGroupInfo)expressionNode);
                } else if (expressionNode instanceof ExpressionInfo) {
                    iExpression = this.buildConditionExpression((ExpressionInfo)expressionNode);
                }
                if (iExpression != null) {
                    Prefilter prefilter = new Prefilter();
                    prefilter.setTitle(string3);
                    prefilter.setDesc(bLFilterInformation.getDescription());
                    prefilter.setFilter(iExpression);
                    FilterInfo filterInfo = ((JBusinessLogic)((Object)jetObject)).addPrefilter(prefilter);
                    string2 = prefilter.getQualifyName();
                    this.handles.put(string2, filterInfo);
                    return string2;
                }
            }
            catch (Exception exception) {
                throw new DesignerErrorException(exception);
            }
        }
        return null;
    }

    public String[] getPredifinedFilterHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof JBusinessLogic) {
                FilterInfo[] filterInfoArray = ((JBusinessLogic)((Object)jetObject)).getPrefilterInfo();
                int n = filterInfoArray == null ? 0 : filterInfoArray.length;
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = ((JetObject)((Object)filterInfoArray[i])).getQualifyName();
                }
                return stringArray;
            }
            this.setError("getPredifinedFilterHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getPredifinedFilterHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    BLFilterInformation getBLFilterInfo(FilterInfo filterInfo) {
        BLFilterInformation bLFilterInformation = new BLFilterInformation();
        if (filterInfo != null) {
            try {
                bLFilterInformation.setDisplayName(filterInfo.getTitle());
                bLFilterInformation.setName(filterInfo.getBLQualifyName());
                bLFilterInformation.setDescription(filterInfo.getComment());
                IExpression iExpression = filterInfo.getFilter();
                bLFilterInformation.setIExpression(iExpression);
                ExpressionNode expressionNode = this.getExpressionInfo(iExpression);
                bLFilterInformation.setExpressionNode(expressionNode);
            }
            catch (ConditionException conditionException) {
                bLFilterInformation.setException(conditionException);
                this.setError(conditionException);
            }
        }
        return bLFilterInformation;
    }

    IConditionExpression buildConditionExpression(ExpressionInfo expressionInfo) throws ConditionException {
        IConditionExpression iConditionExpression = null;
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        IOperatorFactory iOperatorFactory = ExpressionFactoryCreator.getIOperatorFactory();
        ExpressionFieldInfo expressionFieldInfo = expressionInfo.get1stExpression();
        ExpressionFieldInfo expressionFieldInfo2 = expressionInfo.get2ndExpression();
        ExpressionFieldInfo expressionFieldInfo3 = expressionInfo.get3rdExpression();
        if (ExpressionInfo.isBinaryConditionOperator(expressionInfo.getOperatorType())) {
            IVariableExpression iVariableExpression = expressionFieldInfo.getExpressionValueType() == 32770 ? iExpressionFactory.createConstant(expressionFieldInfo.getExpressionValue()) : iExpressionFactory.createReference(expressionFieldInfo.getExpressionValue(), !expressionFieldInfo.isMappingName());
            IVariableExpression iVariableExpression2 = expressionFieldInfo2.getExpressionValueType() == 32770 ? iExpressionFactory.createConstant(expressionFieldInfo2.getExpressionValue()) : iExpressionFactory.createReference(expressionFieldInfo2.getExpressionValue(), !expressionFieldInfo.isMappingName());
            IBinaryConditionOperator iBinaryConditionOperator = iOperatorFactory.createBinaryConditionOp(expressionInfo.getOperatorType());
            iConditionExpression = iExpressionFactory.createBinaryConditionExp(iBinaryConditionOperator, iVariableExpression, iVariableExpression2);
        } else if (ExpressionInfo.isSingleConditionOperator(expressionInfo.getOperatorType())) {
            if (expressionFieldInfo.getExpressionValueType() == 32769) {
                IReference iReference = iExpressionFactory.createReference(expressionFieldInfo.getExpressionValue(), !expressionFieldInfo.isMappingName());
                ISingleConditionOperator iSingleConditionOperator = iOperatorFactory.createSingleConsitionOp(expressionInfo.getOperatorType());
                iConditionExpression = iExpressionFactory.createSingleConditionExp(iSingleConditionOperator, iReference);
            }
        } else if (ExpressionInfo.isTripleConditionOperator(expressionInfo.getOperatorType())) {
            IVariableExpression iVariableExpression = expressionFieldInfo.getExpressionValueType() == 32770 ? iExpressionFactory.createConstant(expressionFieldInfo.getExpressionValue()) : iExpressionFactory.createReference(expressionFieldInfo.getExpressionValue(), !expressionFieldInfo.isMappingName());
            IVariableExpression iVariableExpression3 = expressionFieldInfo2.getExpressionValueType() == 32770 ? iExpressionFactory.createConstant(expressionFieldInfo2.getExpressionValue()) : iExpressionFactory.createReference(expressionFieldInfo2.getExpressionValue(), !expressionFieldInfo.isMappingName());
            IVariableExpression iVariableExpression4 = expressionFieldInfo3.getExpressionValueType() == 32770 ? iExpressionFactory.createConstant(expressionFieldInfo2.getExpressionValue()) : iExpressionFactory.createReference(expressionFieldInfo2.getExpressionValue(), !expressionFieldInfo.isMappingName());
            ITripleConditionOperator iTripleConditionOperator = iOperatorFactory.createTripleConditionOp(expressionInfo.getOperatorType());
            iConditionExpression = iExpressionFactory.createTripleConditionExp(iTripleConditionOperator, iVariableExpression, iVariableExpression3, iVariableExpression4);
        }
        return iConditionExpression;
    }

    IExpression buildConditionExpression(ExpressionGroupInfo expressionGroupInfo) {
        IMultiLogicExpression iMultiLogicExpression = null;
        List list = expressionGroupInfo.getExpressions();
        try {
            IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
            IOperatorFactory iOperatorFactory = ExpressionFactoryCreator.getIOperatorFactory();
            IExpression[] iExpressionArray = new IExpression[list.size()];
            ExpressionNode expressionNode = null;
            for (int i = 0; i < list.size(); ++i) {
                expressionNode = (ExpressionNode)list.get(i);
                iExpressionArray[i] = expressionNode instanceof ExpressionInfo ? this.buildConditionExpression((ExpressionInfo)expressionNode) : this.buildConditionExpression((ExpressionGroupInfo)expressionNode);
            }
            IMultiLogicOperator iMultiLogicOperator = iOperatorFactory.createMultiLogicOp(expressionGroupInfo.getExpressionLogicType());
            iMultiLogicExpression = iExpressionFactory.createMultiLogicExp(iMultiLogicOperator, iExpressionArray);
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
        return iMultiLogicExpression;
    }

    ExpressionFieldInfo getExpressionFieldInfo(IExpression iExpression) {
        ExpressionFieldInfo expressionFieldInfo = null;
        int n = iExpression.expressionType();
        try {
            if (ExpressionToolKit.isReference(n)) {
                expressionFieldInfo = new ExpressionFieldInfo(iExpression.getStringValue(iExpression.isParenthesized()), 32769, false);
            } else if (ExpressionToolKit.isConstant(n)) {
                expressionFieldInfo = new ExpressionFieldInfo(iExpression.getStringValue(iExpression.isParenthesized()), 32770, false);
            }
        }
        catch (Exception exception) {
            this.setError(exception);
        }
        return expressionFieldInfo;
    }

    ExpressionNode getExpressionInfo(IExpression iExpression) {
        int n = iExpression.expressionType();
        ExpressionNode expressionNode = null;
        if (ExpressionToolKit.isMultiLogicExp(n)) {
            if (ExpressionToolKit.isTupleExp(n)) {
                ITupleOperator iTupleOperator = ((ITupleExpression)iExpression).getOperator();
                ExpressionGroupInfo expressionGroupInfo = new ExpressionGroupInfo();
                expressionGroupInfo.setExpressionLogicType(iTupleOperator.operatorType());
                IExpression[] iExpressionArray = ((IMulti)((Object)iExpression)).getExpressions();
                int n2 = iExpressionArray == null ? 0 : iExpressionArray.length;
                for (int i = 0; i < n2; ++i) {
                    ExpressionNode expressionNode2 = this.getExpressionInfo(iExpressionArray[i]);
                    if (expressionNode2 == null) continue;
                    expressionGroupInfo.addExpression(expressionNode2);
                }
                expressionNode = expressionGroupInfo;
            }
        } else if (ExpressionToolKit.isTupleExp(n)) {
            ITupleOperator iTupleOperator = ((ITupleExpression)iExpression).getOperator();
            ExpressionFieldInfo expressionFieldInfo = null;
            ExpressionFieldInfo expressionFieldInfo2 = null;
            ExpressionFieldInfo expressionFieldInfo3 = null;
            if (ExpressionToolKit.isSingleConditionExp(n)) {
                expressionFieldInfo = this.getExpressionFieldInfo(((ISingle)((Object)iExpression)).getExpression());
                if (expressionFieldInfo != null) {
                    expressionNode = new ExpressionInfo(expressionFieldInfo, iTupleOperator.operatorType());
                }
            } else if (ExpressionToolKit.isBinaryConditionExp(n)) {
                expressionFieldInfo = this.getExpressionFieldInfo(((IBinary)((Object)iExpression)).getExpression1());
                expressionFieldInfo2 = this.getExpressionFieldInfo(((IBinary)((Object)iExpression)).getExpression2());
                if (expressionFieldInfo != null && expressionFieldInfo2 != null) {
                    expressionNode = new ExpressionInfo(expressionFieldInfo, expressionFieldInfo2, iTupleOperator.operatorType());
                }
            } else if (ExpressionToolKit.isTripleConditonExp(n)) {
                expressionFieldInfo = this.getExpressionFieldInfo(((ITriple)((Object)iExpression)).getExpression1());
                expressionFieldInfo2 = this.getExpressionFieldInfo(((ITriple)((Object)iExpression)).getExpression2());
                expressionFieldInfo3 = this.getExpressionFieldInfo(((ITriple)((Object)iExpression)).getExpression3());
                if (expressionFieldInfo != null && expressionFieldInfo2 != null && expressionFieldInfo3 != null) {
                    expressionNode = new ExpressionInfo(expressionFieldInfo, expressionFieldInfo2, expressionFieldInfo3, iTupleOperator.operatorType());
                }
            }
        }
        return expressionNode;
    }

    static {
        JDBC_ODBC_BRIDGE = JdbcDatabase.JDBC_ODBC_BRIDGE;
        JDBC = JdbcDatabase.JDBC;
        CLASSNAME = new String[]{"CATALOG", "CONNECTION", "TABLE", "VIEW", "COLUMN", "QUERY", "PROCEDER", "FILESQL", "UDS", "FORMULA", "SUMMARY", "PARAMETER", "WHEREPORTION", "SYNONYM", "ALIAS", "DATABASE"};
    }

    class ReportFilter
    implements FilenameFilter {
        private final String SEDU = ".cls";

        ReportFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".cls");
        }
    }
}

